/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.cbb.proxy.protocol.rest.RestClient;
import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class HvsRestConnection
extends RestConnection {
    private static final Log LOGGER = LogFactory.getInstance(HvsRestConnection.class);
    private static final long UNAUTH_ERROR_CODE = -401L;
    private static final long RESPONSE_OK = 0L;
    private CloseableHttpClient httpClient = null;
    private CloseableHttpAsyncClient httpAsyncClient = null;
    private String authCookie;
    private String contextPath = ResourceHelper.getValue("hvs.contextpath");
    private int userScope = 0;

    public HvsRestConnection(String ipAddress, int port, String userName, String password) {
        super(ipAddress, port, userName, password);
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.port")));
        }
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.protocol")));
    }

    @Override
    public void init(Map<String, String> properties) {
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.protocol")));
        this.contextPath = ResourceHelper.getValue("hvs.contextpath");
        this.setPort(NumberUtil.parseInteger((Object)properties.get("PORT")));
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.port")));
        }
        this.setIpAddress(properties.get("IPADDRESS"));
        this.setUserName(properties.get("USERNAME"));
        this.setPassword(properties.get("PASSWORD"));
    }

    @Override
    public void authenticate() {
        Optional<RestResponseData> responseDataOptional = this.getRestResponseData();
        if (!responseDataOptional.isPresent()) {
            LOGGER.error((Object)"response data is empty, check remote host is normal or not. Forcing logout.");
            this.releaseClientResource();
            throw new LegoCheckedException(0x300001L);
        }
        RestResponseData response = responseDataOptional.get();
        if (response.getHeaders() == null) {
            LOGGER.error((Object)"response body is empty!");
            this.releaseClientResource();
            throw new LegoCheckedException(0x300001L);
        }
        List<String> cookies = response.getHeaders().get("Set-Cookie");
        if (!VerifyUtil.isEmpty(cookies)) {
            this.authCookie = cookies.get(0);
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
        JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
        long errorCode = error.getLong("code");
        String ipAddress = this.getIpAddress();
        String deviceId = this.getDeviceId();
        if (errorCode != 0L) {
            LOGGER.error((Object)"ErrorCode = %s, ip = %s , devSn = %s", new Object[]{errorCode, ipAddress, deviceId});
            this.releaseClientResource();
            throw new LegoCheckedException(errorCode, error.getString("description"));
        }
        JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data"));
        deviceId = data.getString("deviceid");
        this.setDeviceId(deviceId);
        LOGGER.info((Object)"Establish rest connection, devSn = %s, IP = %s", new Object[]{deviceId, ipAddress});
        try {
            this.setToken(data.getString("iBaseToken"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Getting iBaseToken failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        if (!this.isValid()) {
            LOGGER.error((Object)"connection is not valid. ip = %s, devSn = %s", new Object[]{ipAddress, deviceId});
            this.logout();
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Optional<RestResponseData> getRestResponseData() {
        RestResponseData response;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("username", this.getUserName());
        paramMap.put("password", this.getPassword());
        paramMap.put("scope", String.valueOf(this.userScope));
        try {
            response = this.postAndGetResponseData("/rest/${deviceID}/sessions", paramMap);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("authenticate for session is error" + ExceptionUtil.getErrorMessage((Throwable)ex)));
            return Optional.empty();
        }
        return Optional.of(response);
    }

    @Override
    public Map<String, String> post(String url, Map<String, String> paramMap) {
        RestResponseData response = this.postAndGetResponseData(url, paramMap);
        return this.parseResponseData(response);
    }

    @Override
    public Map<String, String> postByPipe(String url, Map<String, Object> paramMap, boolean fullPath) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("POST");
        this.buildRestRequestData(url, paramMap, request, fullPath);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public String postForObject(String url, Object object) {
        RestResponseData response = this.postAndGetResponseData(url, object);
        Map<String, String> resultData = this.parseResponseData(response);
        return JSONObject.fromObject(resultData).toString();
    }

    @Override
    public Map<String, String> put(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    private RestResponseData postAndGetResponseData(String url, Object requestData) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("POST");
        this.buildRestRequestData(url, requestData, request);
        return RestClient.processRequest(this.getHttpClient(), request);
    }

    @Override
    public Map<String, String> get(String url, Map<String, String> paramMap) {
        List<Map<String, String>> resultDatas = this.getBatch(url, paramMap, false, false);
        if (!VerifyUtil.isEmpty(resultDatas)) {
            return resultDatas.get(0);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap, boolean pagingQuery) {
        return this.getBatch(url, paramMap, pagingQuery, false);
    }

    @Override
    public List<Map<String, String>> getBatchByPipeQuery(String url, Map<String, Object> paramMap) {
        return this.getBatch(url, paramMap, true, true);
    }

    public List<Map<String, String>> getBatch(String url, Object paramMap, boolean page, boolean isPipeQuery) {
        LOGGER.debug((Object)String.format("begin to send page query request for url(%s)", url));
        ArrayList<Map<String, String>> resultDatas = new ArrayList<Map<String, String>>();
        if (!page || !this.isPagingQuery(url)) {
            RestRequestData request = new RestRequestData();
            String requestMethod = isPipeQuery ? "POST" : "GET";
            request.setRequestMethod(requestMethod);
            this.buildRestRequestData(url, paramMap, request, isPipeQuery);
            RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            if (jsonObject.isEmpty()) {
                LOGGER.warn((Object)"response body is empty!");
                return resultDatas;
            }
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = null;
            if (!error.isEmpty()) {
                errorCode = error.getLong("code");
            }
            if (null != errorCode && 0L != errorCode) {
                if (errorCode == -401L) {
                    LOGGER.error((Object)"[%s] auth failed. re-authenticating..", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    LOGGER.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)"data")) {
                this.retrieveResultData(resultDatas, jsonObject);
            }
            LOGGER.debug((Object)String.format("send page query request for url(%s)", url));
        } else {
            this.queryByPage(url, paramMap, resultDatas);
        }
        return resultDatas;
    }

    private void queryByPage(String url, Object paramMap, List<Map<String, String>> resultDatas) {
        int pageSize = 100;
        List<Map<String, String>> tempResultDatas = null;
        int s = 0;
        do {
            int e = s + pageSize;
            String a = url.replaceAll("([?&]range=\\[)\\d+-\\d+(\\](&|$))", String.format("$1%s-%s$2", s, e));
            s += pageSize;
            try {
                tempResultDatas = this.getBatch(a, paramMap, false, false);
            }
            catch (LegoCheckedException ee) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute paging query failed, error code is ");
                sb.append(ee.getErrorCode());
                sb.append(", error message is ");
                sb.append(ee.getMessage());
                sb.append(" May be the device does not support the rest interface.");
                LOGGER.warn((Object)sb.toString());
                LOGGER.warn((Object)("The rest url is " + a));
                break;
            }
            LOGGER.info((Object)("url=" + a));
            if (VerifyUtil.isEmpty(tempResultDatas)) break;
            LOGGER.info((Object)("record size is " + tempResultDatas.size()));
            resultDatas.addAll(tempResultDatas);
        } while (tempResultDatas.size() == pageSize);
    }

    @Override
    public Map<String, String> putForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, JSONObject.fromObject((Object)object), request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap) {
        return this.getBatch(url, paramMap, true, false);
    }

    @Override
    public void delete(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        this.parseResponseData(response);
    }

    @Override
    public Map<String, String> deleteForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, this.convertJSONObject2Map(JSONObject.fromObject((Object)object)), request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = RestClient.buildHttpClient(this.getIpAddress(), String.valueOf(this.getPort()));
        }
        return this.httpClient;
    }

    @Override
    public void logout() {
        String deviceId = this.getDeviceId();
        String token = this.getToken();
        LOGGER.info((Object)"Rest connection logout, devSn = %s", new Object[]{deviceId});
        if (token != null && !token.isEmpty()) {
            this.delete("/rest/${deviceID}/sessions", null);
        }
        this.releaseClientResource();
        LOGGER.info((Object)"Logout, devSn = %s, ip = %s", new Object[]{this.getDeviceId(), this.getIpAddress()});
    }

    private void releaseClientResource() {
        LOGGER.debug((Object)"release http client resource");
        this.closeHttpClient();
        this.closeHttpAsyncClient();
    }

    private void closeHttpClient() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Close httpClient error.", (Throwable)ex);
            }
            this.httpClient = null;
        }
    }

    private void closeHttpAsyncClient() {
        if (this.httpAsyncClient != null) {
            try {
                this.httpAsyncClient.close();
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Close httpAsyncClient error.", (Throwable)ex);
            }
        }
        this.httpAsyncClient = null;
    }

    public void buildRestRequestData(String url, Object requestData, RestRequestData request) {
        this.buildRestRequestData(url, requestData, request, false);
    }

    public void buildRestRequestData(String url, Object requestData, RestRequestData request, boolean isFullPath) {
        if (url == null) {
            LOGGER.error((Object)"Context is null");
            throw new LegoCheckedException(1073947393L);
        }
        String ip = this.getIpAddress();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        request.setProtocol(this.getProtocol());
        request.setHostName(ip);
        request.setPort(this.getPort());
        String uri = isFullPath ? (this.getProtocol() == 0 ? "http://" : "https://") + ip + ":" + this.getPort() + url : (this.getProtocol() == 0 ? "http://" : "https://") + ip + ":" + this.getPort() + this.contextPath + url.replace("${deviceID}", this.getDeviceId());
        request.setUri(uri);
        if (!VerifyUtil.isEmpty((Object)requestData)) {
            JSONObject paramObject = JSONObject.fromObject((Object)requestData);
            request.setBody(paramObject.toString());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Cookie", this.authCookie);
        String token = this.getToken();
        if (!VerifyUtil.isEmpty((String)token)) {
            headerMap.put("iBaseToken", token);
        }
        request.setHeaders(headerMap);
    }

    private Map<String, String> parseResponseData(RestResponseData response) {
        LOGGER.debug((Object)"enter parseResponseData");
        Map<String, String> resultData = Collections.emptyMap();
        if (null != response) {
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = error.getLong("code");
            if (null != errorCode && 0L != errorCode) {
                String errorParam;
                if (errorCode == -401L) {
                    LOGGER.error((Object)"[%s] auth failed. re-authenticating...", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    LOGGER.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                if (error.containsKey((Object)"errorParam") && !VerifyUtil.isEmpty((String)(errorParam = error.getString("errorParam")))) {
                    LOGGER.error((Object)error.getString("description"));
                    String[] errParams = errorParam.split(",");
                    throw new LegoCheckedException(errorCode.longValue(), StringUtil.getErrorCodeParams((String[])errParams));
                }
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)"data")) {
                JSONObject data = JSONObject.fromObject((Object)jsonObject.get("data"));
                resultData = this.convertJSONObject2Map(data);
            }
        }
        return resultData;
    }

    private void retrieveResultData(List<Map<String, String>> resultDatas, JSONObject jsonObject) {
        LOGGER.debug((Object)"enter retrieveResultData");
        Object data = jsonObject.get("data");
        this.extractResultData(resultDatas, data);
    }

    public String getAuthCookie() {
        return this.authCookie;
    }

    public void setAuthCookie(String authCookie) {
        this.authCookie = authCookie;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public int getUserScope() {
        return this.userScope;
    }

    public void setUserScope(int userScope) {
        this.userScope = userScope;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = false;
        String deviceId = this.getDeviceId();
        String ipAddress = this.getIpAddress();
        try {
            Map<String, String> resultMap = this.get("/rest/${deviceID}/storagepool/count", null);
            if (!VerifyUtil.isEmpty(resultMap)) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Testing connection failed, devSn=" + deviceId + ", ip=" + ipAddress + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return isConnected;
    }

    @Override
    public boolean isValid() {
        return this.isConnected();
    }

    @Override
    public List<Map<String, String>> pagingQuery(String url, int start, int end) {
        if (url == null) {
            LOGGER.error((Object)"Request url is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        return this.getBatch(url, null, false);
    }

    private boolean isPagingQuery(String url) {
        if (null == url) {
            return false;
        }
        try {
            Pattern urlRegex = Pattern.compile("[^?]*\\?([^=]+=(&amp;|[^&]*))*&?range=\\[(\\d+)-(\\d+)\\]([^=]+=(&amp;|[^&]*))*");
            Matcher matcher = urlRegex.matcher(url);
            return matcher.find();
        }
        catch (NumberFormatException exception) {
            LOGGER.error((Object)("match paging query failed. " + ExceptionUtil.getErrorMessage((Throwable)exception)));
            return false;
        }
        catch (IllegalStateException exception) {
            LOGGER.error((Object)("match paging query failed.. " + ExceptionUtil.getErrorMessage((Throwable)exception)));
            return false;
        }
    }
}

