/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.google.common.collect.ImmutableMap;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.proxy.protocol.rest.RestClient;
import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class OceanProtectConnection
extends RestConnection {
    public static final String BATCH_RESULT_KEY = "PMBatchResultKey";
    public static final String SINGLE_RESULT_SET = "singleResultSet";
    private static final Log LOGGER = LogFactory.getInstance(OceanProtectConnection.class);
    private static final Map<Integer, String> protocolsMap = ImmutableMap.of((Object)0, (Object)"http://", (Object)1, (Object)"https://");
    private static final String AUTH_URL = "/v1/auth/token";
    private static final long UN_AUTH_ERROR_CODE = 401L;
    private static final int EXPIRE_DAY_LIMIT = 5;
    private static final int EXPIRE_DAY_CNT = 0;
    private static final String DEFAULT_BATCH_RESULT_KEY = "records";
    private static final String ALARM_ID_OCEAN_PROTECT_PASSWORD_WILL_EXPIRE = "0x3230069";
    private static final long SUCCESS_ERROR_CODE = 0L;
    private static final String SUCCESS_ERROR_MESSAGE = "OK";
    private CloseableHttpClient httpClient;
    private NetworkEntity networkEntity;

    public OceanProtectConnection(String ipAddress, int port, String userName, String password) {
        super(ipAddress, port, userName, password);
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("op.port")));
        }
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("op.protocol")));
    }

    @Override
    public void init(Map<String, String> properties) {
    }

    @Override
    public void authenticate() {
        Map<String, String> responseMap;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userName", this.getUserName());
        paramMap.put("password", this.getPassword());
        try {
            responseMap = this.post(AUTH_URL, paramMap);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Authentication error(Ip = %s, devSn = %s), failed to get token. Error Msg: %s", new Object[]{this.getIpAddress(), this.getDeviceId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            this.releaseClientResource();
            throw e;
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Authentication error(Ip = %s, devSn = %s), failed to get token. Error Msg: %s", new Object[]{this.getIpAddress(), this.getDeviceId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            this.releaseClientResource();
            throw new LegoCheckedException(1073948488L, new String[]{this.getIpAddress()});
        }
        int expireDay = Optional.ofNullable(responseMap.get("expireDay")).map(Integer::parseInt).orElse(0);
        if (Boolean.parseBoolean(responseMap.get("modifyPassword")) || expireDay <= 0) {
            LOGGER.error((Object)"Authentication error by must modify password. Ip = %s, devSn = %s", new Object[]{this.getIpAddress(), this.getDeviceId()});
            this.releaseClientResource();
            throw new LegoCheckedException(1073948487L, new String[]{this.getIpAddress(), this.getUserName()});
        }
        if (VerifyUtil.isEmpty((String)responseMap.get("token"))) {
            LOGGER.error((Object)"Authentication error, token is empty. Ip = %s, devSn = %s", new Object[]{this.getIpAddress(), this.getDeviceId()});
            this.releaseClientResource();
            throw new LegoCheckedException(1073948488L, new String[]{this.getIpAddress()});
        }
        if (expireDay <= 5) {
            LOGGER.warn((Object)"Password validity is less than 5 days. Ip = %s, devSn = %s", new Object[]{this.getIpAddress(), this.getDeviceId()});
            this.sendModifyPasswordPromptAlarm(expireDay);
        }
        this.setToken(responseMap.get("token"));
        if (!this.isValid()) {
            LOGGER.error((Object)"Connection is not valid. ip = %s, devSn = %s", new Object[]{this.getIpAddress(), this.getDeviceId()});
            this.logout();
            throw new LegoCheckedException(1073948494L);
        }
    }

    @Override
    public void logout() {
        LOGGER.info((Object)"ProtectManager rest connection logout, devSn = %s, ip = %s", new Object[]{this.getDeviceId(), this.getIpAddress()});
        this.releaseClientResource();
    }

    @Override
    public boolean isConnected() {
        return this.isValid();
    }

    @Override
    public boolean isValid() {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put(BATCH_RESULT_KEY, SINGLE_RESULT_SET);
            Map<String, String> resultMap = this.get("/v1/users/login-user", paramMap);
            boolean isAdmin = Optional.ofNullable(resultMap.get("sysAdmin")).map(Boolean::parseBoolean).orElse(false);
            if (!isAdmin) {
                LOGGER.error((Object)"User's role is not a administrator, username: %s, dev Sn: %s", new Object[]{this.getUserName(), this.getDeviceId()});
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Test connection failed, devSn=%s, ip=%s, error msg: %s", new Object[]{this.getDeviceId(), this.getIpAddress(), ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> post(String url, Map<String, String> paramMap) {
        RestRequestData request = this.buildRestRequestData(url, paramMap);
        request.setRequestMethod("POST");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public String postForObject(String url, Object obj) {
        RestRequestData request = this.buildRestRequestData(url, obj);
        request.setRequestMethod("POST");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return JSONObject.fromObject(this.parseResponseData(response)).toString();
    }

    @Override
    public RestResponseData postResponseData(String url, Object obj) {
        RestRequestData request = this.buildRestRequestData(url, obj);
        request.setRequestMethod("POST");
        return RestClient.processRequest(this.getHttpClient(), request);
    }

    @Override
    public Map<String, String> get(String url, Map<String, String> paramMap) {
        List<Map<String, String>> resultItems = this.getBatch(url, paramMap);
        if (!VerifyUtil.isEmpty(resultItems)) {
            return (Map)resultItems.stream().findFirst().get();
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap) {
        String batchResultKey;
        if (VerifyUtil.isEmpty(paramMap) || VerifyUtil.isEmpty((String)(batchResultKey = paramMap.remove(BATCH_RESULT_KEY)))) {
            batchResultKey = DEFAULT_BATCH_RESULT_KEY;
            LOGGER.info((Object)"Use the default batch result key: '%s'.", new Object[]{DEFAULT_BATCH_RESULT_KEY});
        }
        ArrayList<Map<String, String>> resultItems = new ArrayList<Map<String, String>>();
        RestRequestData request = this.buildRestRequestData(url, paramMap);
        request.setRequestMethod("GET");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        this.checkErrorCode(response, batchResultKey);
        JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
        if (jsonObject.isEmpty()) {
            LOGGER.warn((Object)"Response body is empty!");
            return resultItems;
        }
        JSONObject data = SINGLE_RESULT_SET.equals(batchResultKey) ? jsonObject : JSONArray.fromObject((Object)jsonObject.get(batchResultKey));
        this.extractResultData(resultItems, data);
        return resultItems;
    }

    @Override
    public void delete(String url, Map<String, String> paramMap) {
        RestRequestData request = this.buildRestRequestData(url, paramMap);
        request.setRequestMethod("DELETE");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        this.parseResponseData(response);
    }

    @Override
    public Map<String, String> deleteForObject(String url, Object object) {
        RestRequestData request = this.buildRestRequestData(url, object);
        request.setRequestMethod("DELETE");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public Map<String, String> putForObject(String url, Object object) {
        RestRequestData request = this.buildRestRequestData(url, JSONObject.fromObject((Object)object));
        request.setRequestMethod("PUT");
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    public void setNetworkEntity(NetworkEntity networkEntity) {
        if (VerifyUtil.isEmpty((Object)networkEntity)) {
            LOGGER.error((Object)"Network entity is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.networkEntity = networkEntity;
    }

    private RestRequestData buildRestRequestData(String uri, Object requestData) {
        if (VerifyUtil.isEmpty((String)uri)) {
            LOGGER.error((Object)"Uri is null");
            throw new LegoCheckedException(1073947393L);
        }
        RestRequestData request = new RestRequestData();
        request.setProtocol(this.getProtocol());
        request.setHostName(this.getIpAddress());
        request.setPort(this.getPort());
        String ip = this.getIpAddress();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        String url = protocolsMap.get(this.getProtocol()) + ip + ":" + this.getPort() + uri;
        request.setUri(url);
        if (!VerifyUtil.isEmpty((Object)requestData)) {
            JSONObject paramObject = JSONObject.fromObject((Object)requestData);
            request.setBody(paramObject.toString());
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        String token = this.getToken();
        if (!VerifyUtil.isEmpty((String)token)) {
            headerMap.put("X-Auth-Token", token);
        }
        request.setHeaders(headerMap);
        request.setPlatformToRequest("Ocean Protect");
        return request;
    }

    private Map<String, String> parseResponseData(RestResponseData response) {
        Map<String, String> resultData = Collections.emptyMap();
        if (!VerifyUtil.isEmpty((Object)response)) {
            this.checkErrorCode(response, "");
            if (this.checkBodyIsEmpty(response)) {
                return resultData;
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            resultData = this.convertJSONObject2Map(jsonObject);
        }
        return resultData;
    }

    private void checkErrorCode(RestResponseData response, String batchResultKey) {
        if ((long)response.getHttpStatusCode() == 401L) {
            LOGGER.error((Object)"ProtectManager(ip: %s) auth failed. re-authenticating...", new Object[]{this.getIpAddress()});
            this.authenticate();
            LOGGER.info((Object)"ProtectManager(ip: %s) re-auth success.", new Object[]{this.getIpAddress()});
            throw new LegoCheckedException(1073948488L, new String[]{this.getIpAddress()});
        }
        if (this.checkBodyIsEmpty(response)) {
            LOGGER.info((Object)"The response body is empty, no need to check.");
            return;
        }
        JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
        if (!VerifyUtil.isEmpty((String)batchResultKey) && this.checkSpecialErrorCode(jsonObject, batchResultKey)) {
            LOGGER.info((Object)"The response body is correct, no need to check.");
            return;
        }
        if (jsonObject.containsKey((Object)"errorCode")) {
            JSONArray errorParam;
            long errorCode = jsonObject.getLong("errorCode");
            if (errorCode == 0L && SUCCESS_ERROR_MESSAGE.equals(jsonObject.getString("errorMessage", ""))) {
                LOGGER.info((Object)"The errorMessage is OK and errorCode is 0, response is correct.");
                return;
            }
            if (jsonObject.containsKey((Object)"parameters") && !VerifyUtil.isEmpty((Collection)(errorParam = jsonObject.getJSONArray("parameters")))) {
                LOGGER.error((Object)String.format("Error msg: %s, error param: %s", jsonObject.getString("errorMessage"), errorParam));
                throw new LegoCheckedException(errorCode, jsonObject.getString("errorMessage"));
            }
            LOGGER.error((Object)jsonObject.getString("errorMessage"));
            throw new LegoCheckedException(errorCode, jsonObject.getString("errorMessage"));
        }
    }

    private boolean checkSpecialErrorCode(JSONObject body, String batchResultKey) {
        JSONArray records;
        if (body.containsKey((Object)"totalCount") && body.getInt("totalCount", 0) > 0) {
            LOGGER.info((Object)"The totalCount is not 0, response is correct.");
            return true;
        }
        if (body.containsKey((Object)batchResultKey) && !VerifyUtil.isEmpty((Collection)(records = body.getJSONArray(batchResultKey))) && records.size() > 0) {
            LOGGER.info((Object)"The response records is not empty, response is correct.");
            return true;
        }
        return false;
    }

    private CloseableHttpClient getHttpClient() {
        if (VerifyUtil.isEmpty((Object)this.httpClient)) {
            this.httpClient = RestClient.buildHttpClient(this.getIpAddress(), String.valueOf(this.getPort()));
        }
        return this.httpClient;
    }

    private void releaseClientResource() {
        if (!VerifyUtil.isEmpty((Object)this.httpClient)) {
            try {
                this.httpClient.close();
                LOGGER.debug((Object)"Release http client resource successfully.");
            }
            catch (IOException ex) {
                LOGGER.error((Object)"Close httpClient error.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
            this.httpClient = null;
        }
    }

    private void sendModifyPasswordPromptAlarm(int expireDay) {
        String[] alarmParams = new String[]{this.getIpAddress(), this.getDeviceId(), this.getUserName(), String.valueOf(expireDay)};
        LOGGER.error((Object)"Alarm: the password of ProtectManager(ip: %s) expires in %d days.", new Object[]{this.getIpAddress(), expireDay});
        AlarmUtil.sendNetworkEntityAlarm((String)ALARM_ID_OCEAN_PROTECT_PASSWORD_WILL_EXPIRE, (String)this.getIpAddress(), (String)(VerifyUtil.isEmpty((Object)this.networkEntity) ? this.getDeviceId() : String.valueOf(this.networkEntity.getMoId())), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])alarmParams);
    }

    private boolean checkBodyIsEmpty(RestResponseData response) {
        if (VerifyUtil.isEmpty((String)response.getBody())) {
            return true;
        }
        String body = response.getBody().replaceAll("\\n", "").replaceAll("\"", "");
        return VerifyUtil.isEmpty((String)body) || "null".equals(body);
    }
}

