/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.OceanProtectConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.ext.Nullable;

public final class RestConnectionManager {
    public static final String OCEAN_PROTECT_CONNECTION_TYPE = "oceanProtectConnection";
    private static final Set<String> connectionTypeSet = ImmutableSet.of((Object)"oceanProtectConnection");
    private static final Log LOGGER = LogFactory.getInstance(RestConnectionManager.class);
    private static final RestConnectionManager INSTANCE = new RestConnectionManager();
    private final Map<String, RestConnection> connMap = new ConcurrentHashMap<String, RestConnection>();

    public static RestConnectionManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestConnection getConnection(String key) {
        this.setUncaughtExceptionHandler();
        if (this.connMap.containsKey(key)) {
            return this.connMap.get(key);
        }
        Class<RestConnectionManager> clazz = RestConnectionManager.class;
        synchronized (RestConnectionManager.class) {
            String[] strings;
            if (this.connMap.containsKey(key)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.connMap.get(key);
            }
            INeMgrProtocolExtendService src = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend protocolExtend = src.findBySn((strings = this.extractDevSnAndConnectionType(key))[0]);
            if (!VerifyUtil.isEmpty((Object)protocolExtend)) {
                RestConnection connection = this.buildConnection(protocolExtend, strings[1]);
                connection.authenticate();
                this.addConnection(key, connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return connection;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public RestConnection removeConnection(String key) {
        this.setUncaughtExceptionHandler();
        if (!this.connMap.containsKey(key)) {
            LOGGER.info((Object)"Rest connection not exist, key=%s", new Object[]{key});
            return null;
        }
        try {
            LOGGER.info((Object)"Begin logout rest connection, key=%s", new Object[]{key});
            this.connMap.get(key).logout();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Fail to logout rest connection. Error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return this.connMap.remove(key);
    }

    public void addConnection(String key, RestConnection conn) {
        if (VerifyUtil.isEmpty((String)key) || VerifyUtil.isEmpty((Object)conn)) {
            return;
        }
        this.setUncaughtExceptionHandler();
        String[] strings = this.extractDevSnAndConnectionType(key);
        String devSn = strings[0];
        LOGGER.info((Object)"Rest connection added, devSn=%s", new Object[]{devSn});
        conn.setDeviceId(devSn);
        this.connMap.put(key, conn);
    }

    public RestConnection buildConnection(NeMgrProtocolExtend neMgrProtocolExtend, @Nullable String type) {
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtend)) {
            LOGGER.error((Object)"Protocol info is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (OCEAN_PROTECT_CONNECTION_TYPE.equals(type)) {
            return this.buildOceanProtectConnection(neMgrProtocolExtend);
        }
        return this.buildHvsRestConnection(neMgrProtocolExtend);
    }

    public void setConnection(String key, RestConnection connection) {
        this.setUncaughtExceptionHandler();
        if (VerifyUtil.isEmpty((String)key)) {
            LOGGER.error((Object)"DevSn is empty, value=%s", new Object[]{key});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)connection)) {
            LOGGER.error((Object)"Connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!connection.isValid()) {
            LOGGER.error((Object)"Connection is not valid.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection oldConnection = null;
        try {
            oldConnection = this.getConnection(key);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred when get FusionStorage Rest Connection.", (Throwable)e);
        }
        if (!VerifyUtil.isEmpty((Object)oldConnection)) {
            this.removeConnection(key);
        }
        this.addConnection(key, connection);
    }

    public boolean containsConnection(String key) {
        return this.connMap.containsKey(key);
    }

    private RestConnection buildHvsRestConnection(NeMgrProtocolExtend neMgrProtocolExtend) {
        String ipAddress = neMgrProtocolExtend.getNetworkIpAddress();
        int port = NumberUtil.parseInteger(neMgrProtocolExtend.getExtendParams().get("port"));
        String userName = neMgrProtocolExtend.getNetworkUserName();
        String password = neMgrProtocolExtend.getNetworkPassword();
        return new HvsRestConnection(ipAddress, port, userName, password);
    }

    private RestConnection buildOceanProtectConnection(NeMgrProtocolExtend neMgrProtocolExtend) {
        OceanProtectConnection restConnection = null;
        Map extendParams = neMgrProtocolExtend.getExtendParams();
        if (VerifyUtil.isEmpty((Map)extendParams)) {
            LOGGER.info((Object)"Param is empty.");
            return restConnection;
        }
        String ipAddress = neMgrProtocolExtend.getNetworkIpAddress();
        int port = NumberUtil.parseInteger(extendParams.get("OceanProtectPort"));
        String userName = (String)extendParams.get("OceanProtectUsername");
        String password = (String)extendParams.get("OceanProtectPassword");
        restConnection = new OceanProtectConnection(ipAddress, port, userName, password);
        INeMgrProtocolExtendService protocolExtendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        Optional storageNEOptional = protocolExtendService.getStorage(neMgrProtocolExtend);
        if (storageNEOptional.isPresent()) {
            restConnection.setDeviceId(((StorageNE)storageNEOptional.get()).getSn());
            restConnection.setNetworkEntity((NetworkEntity)storageNEOptional.get());
        }
        return restConnection;
    }

    private void setUncaughtExceptionHandler() {
        Thread.UncaughtExceptionHandler exceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
        if (VerifyUtil.isEmpty((Object)exceptionHandler) || exceptionHandler instanceof ThreadGroup) {
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
        }
    }

    private String[] extractDevSnAndConnectionType(String rawStr) {
        String[] strings = new String[2];
        if (VerifyUtil.isEmpty((String)rawStr)) {
            LOGGER.info((Object)"Param is empty.");
            return strings;
        }
        for (String connectionType : connectionTypeSet) {
            if (!rawStr.endsWith(connectionType)) continue;
            strings[0] = rawStr.substring(0, rawStr.length() - connectionType.length());
            strings[1] = connectionType;
            return strings;
        }
        strings[0] = rawStr;
        return strings;
    }
}

