/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.snmp;

import com.huawei.lego.core.base.service.IRegistryPointManager;
import com.huawei.lego.core.sdk.base.IBundleHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class OIDLauncher
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance(OIDLauncher.class);
    private static OIDLauncher sInstance = null;
    private Properties oidConfig = new Properties();
    private Properties extensionPoints;
    private IRegistryPointManager registerManager;
    private IBundleHelper bundleHelper;

    public static synchronized OIDLauncher getInstance() {
        if (null == sInstance) {
            sInstance = new OIDLauncher();
        }
        return sInstance;
    }

    public String getProperty(String key) {
        return this.oidConfig.getProperty(key);
    }

    public void afterPropertiesSet() throws IOException {
        this.refreshOIDDefine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshOIDDefine() {
        this.oidConfig.clear();
        String[] olds = new String[]{"common-oid.properties", "event-oid.properties"};
        ClassLoader classLoader = OIDLauncher.class.getClassLoader();
        if (classLoader == null) {
            LOGGER.error((Object)"load oid file from bundle: error. because loader is null");
            return;
        }
        for (String faultFileName : olds) {
            URL faultFileURL = classLoader.getResource(faultFileName);
            if (null == faultFileURL) {
                LOGGER.warn((Object)"faultFileURL is null.");
                continue;
            }
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = faultFileURL.openStream();
                props.load(is);
            }
            catch (IOException e) {
                LOGGER.error((Object)("load oid file from bundle: " + faultFileName + " error."));
            }
            finally {
                CommonUtil.close((Closeable)is);
            }
            this.oidConfig.putAll((Map<?, ?>)props);
        }
    }

    public Properties getExtensionPoints() {
        return this.extensionPoints;
    }

    public void setExtensionPoints(Properties extensionPoints) {
        this.extensionPoints = extensionPoints;
    }

    public IRegistryPointManager getRegisterManager() {
        return this.registerManager;
    }

    public void setRegisterManager(IRegistryPointManager registerManager) {
        this.registerManager = registerManager;
    }

    public IBundleHelper getBundleHelper() {
        return this.bundleHelper;
    }

    public void setBundleHelper(IBundleHelper bundleHelper) {
        this.bundleHelper = bundleHelper;
    }
}

