/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.connection;

import com.huawei.ism.cbb.proxy.protocol.tlv.connection.IConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.BitUtils;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.NetUtil;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.TLV;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.TLVUtils;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.DataPackage;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.TLVMOMsg;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.digest.Sha2Crypt;

public class TLVConnectionImpl
extends TLVConnection {
    public static final int MSG_HEAD_LENGTH = 28;
    private static final Log logger = LogFactory.getInstance(TLVConnectionImpl.class);
    private BufferedInputStream bis = null;
    private BufferedOutputStream bos = null;
    private Socket socket = null;
    private String ip = null;
    private String userName = null;
    private String password;
    private int userScope = 0;
    private String sessionKey = null;
    private String deviceId = null;
    private int port;
    private int defaultTimeOut;
    private boolean passwordRetryFlag = true;
    private boolean isEncryption = true;
    private byte[] lock = new byte[0];

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public boolean init(Properties properties) {
        boolean checkParam;
        logger.info((Object)"into init", 90160777658373L);
        this.userName = properties.getProperty("USER_NAME");
        this.password = properties.getProperty("PASSWORD");
        this.userScope = NumberUtil.convertToInteger((Object)properties.getProperty("USERSCOPE"));
        this.ip = properties.getProperty("IP_OR_NAME");
        this.port = NumberUtil.convertToInteger((Object)properties.getProperty("PORT"));
        this.defaultTimeOut = 30;
        if (properties.getProperty("TIME_OUT_PROPERTY") != null) {
            this.defaultTimeOut = NumberUtil.convertToInteger((Object)properties.getProperty("TIME_OUT_PROPERTY"));
        }
        if (properties.getProperty("VERSION") != null) {
            this.isEncryption = false;
        }
        boolean bl = checkParam = VerifyUtil.isEmpty((String)this.userName) || VerifyUtil.isEmpty((String)this.password) || VerifyUtil.isEmpty((String)this.ip) || this.port < 0;
        if (checkParam) {
            throw new IllegalArgumentException();
        }
        logger.info((Object)"out init", 90160777658373L);
        return true;
    }

    @Override
    public Record authenticate() {
        DataPackage returnData;
        logger.info((Object)"into authenticate", 90160777658373L);
        String localIP = NetUtil.queryLocalIP(this.ip, this.port);
        String loginPassword = this.getPasswordForLogin(this.isEncryption);
        List<Param> list = Arrays.asList(new Param(TLV.USER.NAME.getParamIndex(), TLV.USER.NAME.getParamType(), this.userName), new Param(TLV.USER.PASSWORD.getParamIndex(), TLV.USER.PASSWORD.getParamType(), loginPassword), new Param(TLV.USER.ADDRESSINFO.getParamIndex(), TLV.USER.ADDRESSINFO.getParamType(), localIP), new Param(TLV.USER.SCOPE.getParamIndex(), TLV.USER.SCOPE.getParamType(), new UnsignedInt32(this.userScope)));
        DataPackage sendData = TLVUtils.param2DP(55847813121L, "0", list);
        try {
            returnData = this.sendAndReceive(sendData, 30);
        }
        catch (TLVException ex) {
            if (1077949061L == ex.getErrorId() && this.passwordRetryFlag) {
                logger.error((Object)"username or password error ,retry again:", (Throwable)ex, 90160777658373L);
                this.passwordRetryFlag = false;
                return this.authenticate();
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new TLVException(0x100000001L, (Throwable)ex);
        }
        List<Record> datas = returnData.getRecordset();
        this.validateDataEmpty(datas);
        Record record = datas.get(0);
        Object paramValue = record.getParamValue(TLV.USER.SESSIONKEY.getParamIndex());
        if (null == paramValue) {
            throw new LegoCheckedException(0x5000509L);
        }
        this.sessionKey = "" + ((UnsignedInt32)paramValue).intValue();
        logger.info((Object)"out authenticate", 90160777658373L);
        return record;
    }

    private String getPasswordForLogin(boolean isEncryption) {
        String loginPassword = this.password;
        if (isEncryption) {
            if (this.userScope == XveEuumDefineParent.USER_SCOPE_E.LOCAL.getValue() && this.passwordRetryFlag) {
                String uniqueSalt = LegoConfig.getInstance().getKeyValue("unique.salt");
                loginPassword = Sha2Crypt.sha256Crypt((byte[])this.password.getBytes(Charset.defaultCharset()), (String)WccEncryptor.decrypt((String)uniqueSalt));
            } else if (this.userScope == XveEuumDefineParent.USER_SCOPE_E.LOCAL.getValue() && !this.passwordRetryFlag) {
                logger.error((Object)"not support MD5 for encryption.");
                throw new LegoCheckedException(1073947393L);
            }
        }
        return loginPassword;
    }

    private void validateDataEmpty(List<Record> datas) {
        if (datas.isEmpty()) {
            throw new TLVException(16797698L);
        }
    }

    @Override
    public String getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    @Override
    public void close() {
        logger.info((Object)("Close, devSn=" + this.deviceId + ", ip=" + this.getUrl()), 90160758784000L);
        try {
            this.logout();
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160777658902L);
        }
        finally {
            this.clean();
        }
    }

    public void logout() {
        if (null == this.sessionKey || null == this.userName) {
            return;
        }
        try {
            Param idParam = new Param(TLV.USER.ID.getParamIndex(), TLV.USER.ID.getParamType(), this.userName);
            DataPackage sendData = TLVUtils.param2DP(55847813122L, this.sessionKey, Arrays.asList(idParam));
            this.sendAndReceive(sendData, 30);
        }
        catch (TLVException e) {
            logger.error((Object)("tlv logout error, ip=" + this.ip + ", sn=" + this.deviceId), (Throwable)e);
        }
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams) {
        this.sendCMD(cmdWord, tlvParams, 30);
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams, int timeout) {
        this.invoke(cmdWord, tlvParams, timeout);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams) {
        return this.invoke(cmdWord, tlvParams, 30);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout) {
        List<Record> datas = this.getBatch(cmdWord, tlvParams, timeout);
        return datas.isEmpty() ? null : datas.get(0);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams) {
        return this.getBatch(cmdWord, tlvParams, 30);
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout) {
        DataPackage returnData;
        try {
            DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams);
            returnData = this.sendAndReceive(sendData, timeout);
        }
        catch (TLVException exception) {
            if (this.isAuthenticateFail(exception.getErrorId())) {
                this.authenticate();
                DataPackage sendData = TLVUtils.param2DP(cmdWord, this.sessionKey, tlvParams);
                returnData = this.sendAndReceive(sendData, timeout);
            }
            throw exception;
        }
        return returnData.getRecordset();
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param) {
        return this.getNext(cmdWord, param, 30);
    }

    @Override
    public List<Record> getNext(long cmdWord, Param param, int timeOut) {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> tmpDatas = this.getBatch(cmdWord, TLVUtils.singleItemList(param), timeOut);
        while (!tmpDatas.isEmpty()) {
            for (int i = 0; i < tmpDatas.size() - 1; ++i) {
                dataList.add(tmpDatas.get(i));
            }
            Record lastRecord = tmpDatas.get(tmpDatas.size() - 1);
            if (TLVUtils.containTag(lastRecord, 4095)) {
                Object paramValue = lastRecord.getParamValue(4095);
                if (null == paramValue) {
                    throw new LegoCheckedException(102L);
                }
                long errorcode = ((IsmInteger)paramValue).longValue();
                if (errorcode == 1L) break;
                throw new TLVException(errorcode);
            }
            dataList.add(lastRecord);
            tmpDatas = this.getBatch(cmdWord, TLVUtils.singleItemList(param.getIndex(), param.getType(), lastRecord.getParamValue(param.getIndex())), timeOut);
        }
        return dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataPackage sendAndReceive(DataPackage sendData, int timeout) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            byte[] result;
            if (this.socket == null) {
                try {
                    this.socket = NetUtil.connect(this.ip, this.port, null);
                    this.socket.setReceiveBufferSize(0x100000);
                    if (this.defaultTimeOut > 0) {
                        this.socket.setSoTimeout(this.defaultTimeOut * 1000);
                    }
                    this.bos = new BufferedOutputStream(this.socket.getOutputStream());
                    this.bis = new BufferedInputStream(this.socket.getInputStream());
                    this.notifyStateChanged(IConnection.ConnectionState.Connected);
                }
                catch (IOException e) {
                    logger.error((Object)"sendAndReceive IOException", (Throwable)e, 90160777658373L);
                    this.clean();
                    this.notifyStateChanged(IConnection.ConnectionState.Disconnected);
                    throw new TLVException(0x100000001L, (Throwable)e);
                }
            }
            try {
                this.socket.setSoTimeout(timeout * 1000);
                this.bos.write(sendData.toByteArray());
                this.bos.flush();
            }
            catch (IOException e) {
                this.clean();
                throw new TLVException(0x1005001L, (Throwable)e);
            }
            catch (Exception e) {
                this.clean();
                throw new TLVException(0x1005001L, (Throwable)e);
            }
            try {
                byte[] receiveDataHead = new byte[28];
                this.fillBuffer(receiveDataHead);
                byte[] tmp4Byte = new byte[4];
                System.arraycopy(receiveDataHead, 8, tmp4Byte, 0, 4);
                System.arraycopy(receiveDataHead, 24, tmp4Byte, 0, 4);
                int bufferLength = BitUtils.bytes2int(tmp4Byte, false);
                result = new byte[28 + bufferLength];
                byte[] receiveDataBuf = new byte[bufferLength];
                this.fillBuffer(receiveDataBuf);
                System.arraycopy(receiveDataHead, 0, result, 0, 28);
                System.arraycopy(receiveDataBuf, 0, result, 28, receiveDataBuf.length);
            }
            catch (IOException e) {
                this.clean();
                throw new TLVException(16797698L, (Throwable)e);
            }
            catch (Exception e) {
                this.clean();
                throw new TLVException(16797698L, (Throwable)e);
            }
            DataPackage receivedData = TLVUtils.decode(result);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return receivedData;
        }
    }

    private void clean() {
        CommonUtil.close((Closeable)this.socket);
        this.socket = null;
    }

    private void fillBuffer(byte[] receiveDataBuf) throws IOException, InterruptedException {
        int bufferLength = receiveDataBuf.length;
        int lengthBuf = 0;
        for (int i = 0; i < 1000; ++i) {
            int lengthOfOnceRead = this.bis.read(receiveDataBuf, lengthBuf, bufferLength - lengthBuf);
            if (lengthOfOnceRead > -1) {
                lengthBuf += lengthOfOnceRead;
            }
            if (lengthBuf == bufferLength) break;
        }
        if (lengthBuf < bufferLength) {
            throw new TLVException(16797698L);
        }
    }

    @Override
    public IConnection.ConnectionState getConnectionState() {
        if (null == this.socket) {
            return IConnection.ConnectionState.Disconnected;
        }
        return IConnection.ConnectionState.Connected;
    }

    @Override
    public String getUrl() {
        return this.ip;
    }

    @Override
    public Record pmCreate(int moType, List<Param> tlvParams, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        return this.invoke(0xD00004000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
    }

    @Override
    public void pmDelete(int moType, String moid, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        this.sendCMD(0xD00006000L, TLVUtils.addParam(Collections.EMPTY_LIST, moTypeParam, moidParam), timeout);
    }

    @Override
    public void pmModify(int moType, String moid, List<Param> tlvParams, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        this.sendCMD(0xD00002000L, TLVUtils.addParam(tlvParams, moTypeParam, moidParam), timeout);
    }

    @Override
    public Record pmGet(int moType, String moid, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), moid);
        return this.invoke(0xD00000000L, TLVUtils.addParam(Collections.EMPTY_LIST, moTypeParam, moidParam), timeout);
    }

    @Override
    public List<Record> pmGetBacthNext(int moType, List<Param> tlvParams, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        return this.bacthNext(0xD0000C000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
    }

    @Override
    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout) {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> datas = this.getBatch(cmd, tlvParams, timeout);
        while (!datas.isEmpty()) {
            for (int i = 0; i < datas.size() - 1; ++i) {
                dataList.add(datas.get(i));
            }
            Record lastRecord = datas.get(datas.size() - 1);
            if (TLVUtils.containTag(lastRecord, 4095)) {
                Object paramValue = lastRecord.getParamValue(4095);
                if (null == paramValue) {
                    throw new LegoCheckedException(102L);
                }
                long errorcode = ((IsmInteger)paramValue).longValue();
                if (errorcode == 1L) break;
                throw new TLVException(errorcode);
            }
            dataList.add(lastRecord);
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), lastRecord.getParamStrValue(TLVMOMsg.ID.getParamIndex()));
            datas = this.getBatch(cmd, TLVUtils.addParam(tlvParams, moidParam), timeout);
        }
        return dataList;
    }

    @Override
    public int pmCount(int moType, List<Param> tlvParams, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(moType));
        Record record = this.invoke(0xD0000E000L, TLVUtils.addParam(tlvParams, moTypeParam), timeout);
        if (null == record) {
            logger.error((Object)"record is null.");
            return -1;
        }
        Object obj = record.getParamValue(TLVMOMsg.COUNT.getParamIndex());
        if (obj == null || !(obj instanceof IsmInteger)) {
            throw new TLVException(33L);
        }
        return ((IsmInteger)obj).intValue();
    }

    @Override
    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID, int timeout) {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(srcMOType));
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.bacthNext(0xD0000A000L, TLVUtils.addParam(Collections.EMPTY_LIST, srcmoTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    @Override
    public Record pmCreateAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(srcMOType));
        Param srcmoidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        return this.invoke(0xD00005000L, TLVUtils.addParam(tlvParams, srcmoTypeParam, srcmoidTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    @Override
    public void pmRemoveAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), TLVMOMsg.TYPE.getParamType(), new UnsignedInt32(srcMOType));
        Param moidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), TLVMOMsg.ID.getParamType(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), TLVMOMsg.ASSOCIATEOBJTYPE.getParamType(), new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), TLVMOMsg.ASSOCIATEOBJID.getParamType(), associateMOID);
        this.sendCMD(0xD00007000L, TLVUtils.addParam(tlvParams, moTypeParam, moidTypeParam, associateMOTypeParam, associateMOIDParam), timeout);
    }

    private boolean isAuthenticateFail(Long errorId) {
        return errorId == 16797700L || errorId == 16806404L || errorId == 0x5000504L || errorId == 83887382L || errorId == 1077949069L;
    }
}

