/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.constant;

import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.util.VerifyUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class BitUtils {
    public static final int HEX_FF = 255;
    public static final long HEX_FFL = 255L;
    public static final long HEX_FFFFFFFFL = 0xFFFFFFFFL;

    public static boolean getBoolean(byte[] b, int off) {
        if (b == null || b.length <= off) {
            return false;
        }
        return b[off] != 0;
    }

    public static char getChar(byte[] b, int off) {
        if (b == null || b.length <= off + 1) {
            return '\u0000';
        }
        return (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] b, int off) {
        if (b == null || b.length <= off + 1) {
            return 0;
        }
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b, int off) {
        if (b == null || b.length <= off + 3) {
            return 0;
        }
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static float getFloat(byte[] b, int off) {
        if (b == null || b.length <= off + 3) {
            return 0.0f;
        }
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, int off) {
        if (b == null || b.length <= off + 7) {
            return 0L;
        }
        return BitUtils.getLongTmp(b, off) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    private static long getLongTmp(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24);
    }

    public static double getDouble(byte[] b, int off) {
        if (b == null || b.length <= off + 7) {
            return 0.0;
        }
        long j = BitUtils.getDoubleTmp(b, off) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(j);
    }

    private static long getDoubleTmp(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24);
    }

    public static short getUsignByte(byte[] b, int off) {
        if (b == null || b.length <= off) {
            return 0;
        }
        return (short)(b[off] & 0xFF);
    }

    public static int getUsignShort(byte[] b, int off) {
        if (b == null || b.length <= off + 1) {
            return 0;
        }
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public static long getUsignInt(byte[] b, int off) {
        if (b == null || b.length <= off + 3) {
            return 0L;
        }
        return BitUtils.getUsignIntTmp(b, off) + (long)((b[off + 2] & 0xFF) << 16) + (long)((b[off + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    private static long getUsignIntTmp(byte[] b, int off) {
        return ((b[off + 0] & 0xFF) << 0) + ((b[off + 1] & 0xFF) << 8);
    }

    public static byte[] boolean2ByteArray(boolean val) {
        byte[] b = new byte[]{(byte)(val ? 1 : 0)};
        return b;
    }

    public static byte[] char2ByteArray(char val) {
        byte[] b = new byte[2];
        b[1] = (byte)(val >>> 0);
        b[0] = (byte)(val >>> 8);
        return b;
    }

    public static byte[] short2ByteArray(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)(val >>> 0);
        b[0] = (byte)(val >>> 8);
        return b;
    }

    public static byte[] int2ByteArray(int val) {
        byte[] b = new byte[4];
        b[3] = (byte)(val >>> 0);
        b[2] = (byte)(val >>> 8);
        b[1] = (byte)(val >>> 16);
        b[0] = (byte)(val >>> 24);
        return b;
    }

    public static byte[] float2ByteArray(float val) {
        byte[] b = new byte[4];
        int i = Float.floatToIntBits(val);
        b[3] = (byte)(i >>> 0);
        b[2] = (byte)(i >>> 8);
        b[1] = (byte)(i >>> 16);
        b[0] = (byte)(i >>> 24);
        return b;
    }

    public static byte[] long2ByteArray(long val) {
        byte[] b = new byte[8];
        b[7] = (byte)(val >>> 0);
        b[6] = (byte)(val >>> 8);
        b[5] = (byte)(val >>> 16);
        b[4] = (byte)(val >>> 24);
        b[3] = (byte)(val >>> 32);
        b[2] = (byte)(val >>> 40);
        b[1] = (byte)(val >>> 48);
        b[0] = (byte)(val >>> 56);
        return b;
    }

    public static byte[] double2ByteArray(double val) {
        byte[] b = new byte[8];
        long j = Double.doubleToLongBits(val);
        b[7] = (byte)(j >>> 0);
        b[6] = (byte)(j >>> 8);
        b[5] = (byte)(j >>> 16);
        b[4] = (byte)(j >>> 24);
        b[3] = (byte)(j >>> 32);
        b[2] = (byte)(j >>> 40);
        b[1] = (byte)(j >>> 48);
        b[0] = (byte)(j >>> 56);
        return b;
    }

    public static int orderInt(int input) {
        return Integer.reverseBytes(input);
    }

    public static short orderShort(short input) {
        return Short.reverseBytes(input);
    }

    public static long orderLong(long input) {
        return Long.reverseBytes(input);
    }

    public static byte[] stringToByteArray(String str, int length) {
        if (str == null) {
            return new byte[length];
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = i < str.length() ? (byte)str.charAt(i) : (byte)0;
        }
        return bytes;
    }

    public static byte[] stringToUtf8ByteArray(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            byte[] originalArray = str.getBytes("utf-8");
            if (VerifyUtil.isEmpty((Object)originalArray)) {
                return new byte[0];
            }
            byte[] newArray = Arrays.copyOf(originalArray, originalArray.length + 1);
            newArray[originalArray.length] = 0;
            return newArray;
        }
        catch (UnsupportedEncodingException e) {
            throw new TLVException("EncodingException", (Throwable)e);
        }
    }

    public static String byteArrayToString(byte[] b, int length, int offset) {
        StringBuffer sb = new StringBuffer();
        if (VerifyUtil.isEmpty((Object)b)) {
            return sb.toString();
        }
        int bSize = b.length;
        for (int i = 0; i < length; ++i) {
            if (i >= bSize) continue;
            if (b[offset] == 0) break;
            sb.append((char)b[offset]);
            ++offset;
        }
        return sb.toString();
    }

    public static String utf8ByteArrayToString(byte[] b, int length, int offset) {
        try {
            return new String(b, offset, length - 1, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TLVException("EncodingException", (Throwable)e);
        }
    }

    public static int bytes2int(byte[] b, boolean isHighFirst) {
        return (int)BitUtils.bytes2long(b, isHighFirst);
    }

    private static long bytes2long(byte[] b, boolean isHighFirst) {
        long result;
        block4: {
            result = 0L;
            if (b == null || b.length > 8) break block4;
            if (isHighFirst) {
                int i = b.length - 1;
                int j = 0;
                while (i >= 0) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = 0;
                while (i < b.length - 1) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    ++i;
                    ++j;
                }
            }
        }
        return result;
    }
}

