/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.convert;

import com.huawei.ism.cbb.proxy.protocol.tlv.convert.IValueConvert;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.bean.RunningState;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.entity.State;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tlv.lang.IsmUnsignedInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.util.Unit;
import com.huawei.ism.util.log.LogManager;

public class ValueConverts {

    public static class OSTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int os = ((UnsignedInt32)srcValue).intValue();
            return TypeEnum.OperationSystemType.getOperationSystem((int)os);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return TypeEnum.OperationSystemType.getDescription((TypeEnum.OperationSystemType)((TypeEnum.OperationSystemType)srcValue));
        }

        @Override
        public Object moValue2Original(Object srcValue) {
            return TypeEnum.OperationSystemType.getValue((TypeEnum.OperationSystemType)((TypeEnum.OperationSystemType)srcValue));
        }
    }

    public static class DeviceStateConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iLevel = ((UnsignedInt32)srcValue).intValue();
            HealthState state = State.getInstance().getHealthState("Array", iLevel);
            return state;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((HealthState)srcValue).getDescription();
        }
    }

    public static class LunWritePolicyConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("LunWritePolicyConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            int nType = NumberUtil.convertToInteger((Object)srcValue.toString());
            TypeEnum.WritePolicyType type = TypeEnum.WritePolicyType.getWritePolicy((int)nType);
            return TypeEnum.WritePolicyType.getDiscription((TypeEnum.WritePolicyType)type);
        }
    }

    public static class LunReadPolicyConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("LunReadPolicyConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            int nType = NumberUtil.convertToInteger((Object)srcValue.toString());
            TypeEnum.PrefetchPolicyType type = TypeEnum.PrefetchPolicyType.getPrefetchType((int)nType);
            return TypeEnum.PrefetchPolicyType.getDescription((TypeEnum.PrefetchPolicyType)type);
        }
    }

    public static class FCPortSpeedConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("FCPortSpeedConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            String csStr = "--";
            if (0 == NumberUtil.convertToInteger((Object)srcValue.toString())) {
                csStr = ResourceManager.getString((String)"FC_PORT_SPEED_ZERO");
            } else if (NumberUtil.convertToInteger((Object)srcValue.toString()) > 0) {
                csStr = srcValue.toString();
            }
            return csStr;
        }
    }

    public static class PortStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("PortStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("Port", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class ControllerStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("ControllerStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            HealthState healthState = State.getInstance().getHealthState("Controller", String.valueOf(srcValue));
            return healthState.getDescription();
        }
    }

    public static class BBUChargeStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("BBUChargeStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.BBUChargeState.getChargeState((int)NumberUtil.convertToInteger((Object)srcValue.toString())).getDescription();
        }
    }

    public static class BBURunningStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("BBURunningStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("BBU", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class BBUHealthStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("BBUHealthStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.getInstance().getHealthState("BBU", String.valueOf(srcValue)).getDescription();
        }
    }

    public static class FanRunningLevelConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("FanRunningLevelConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return TypeEnum.FanRunLevel.getFanRunLevel((int)NumberUtil.convertToInteger((Object)srcValue.toString())).getDescription();
        }
    }

    public static class FanStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("FanStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            HealthState healthState = State.getInstance().getHealthState("Fan", String.valueOf(srcValue));
            return healthState.getDescription();
        }
    }

    public static class PowerTemperatureStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("PowerTemperatureStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.PowerTemperatureState.getTemperatureState((int)NumberUtil.convertToInteger((Object)srcValue.toString())).toString();
        }
    }

    public static class PowerStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("PowerStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("PowerSupply", String.valueOf(srcValue));
            return runningState.getDescription();
        }
    }

    public static class ChassisLogicTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("ChassisLogicTypeConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return TypeEnum.LogicalChassisType.getDescription((int)NumberUtil.convertToInteger((Object)String.valueOf(srcValue)));
        }
    }

    public static class ChassisPhysicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("ChassisPhysicalTypeConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return TypeEnum.PhysicalChassisType.getPhysicalChassisType((int)NumberUtil.convertToInteger((Object)String.valueOf(srcValue))).getDescription();
        }
    }

    public static class ChassisStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("ChassisStatusConvert convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return State.getInstance().getRunningState("ControllerChassis", String.valueOf(srcValue)).getDescription();
        }
    }

    public static class DiskStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("value convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            RunningState runningState = State.getInstance().getRunningState("Drive", NumberUtil.convertToInteger((Object)srcValue.toString()).intValue());
            return runningState.getDescription();
        }
    }

    public static class DiskOwonedGroupConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = Integer.MAX_VALUE;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("value convert error:" + srcValue));
            }
            return iValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            Integer intValue = (Integer)srcValue;
            if (intValue == Integer.MAX_VALUE) {
                return "--";
            }
            return srcValue.toString();
        }
    }

    public static class CapacityConvert
    extends DefaultValueConvert {
        private Unit.DataUnit srcUnit = Unit.DataUnit.MB;

        public CapacityConvert(Unit.DataUnit tmpSrcUnit) {
            this.srcUnit = tmpSrcUnit;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            if (srcValue instanceof Number) {
                Number size = (Number)srcValue;
                return new IsmTableCell.NumberCell(size, this.srcUnit);
            }
            return null;
        }
    }

    public static class DiskLogicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("value convert error:" + srcValue));
            }
            return TypeEnum.DiskLogicalType.getDiskLogicalType((int)iValue);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((TypeEnum.DiskLogicalType)srcValue).getDescription();
        }
    }

    public static class DiskPhysicalTypeConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("value convert error:" + srcValue));
            }
            return TypeEnum.DiskPhysicalType.getPhysicalType((int)iValue);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((TypeEnum.DiskPhysicalType)srcValue).getDescription();
        }
    }

    public static class UserStatusConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iValue = 0;
            try {
                iValue = Integer.parseInt(srcValue.toString());
            }
            catch (Exception e) {
                LogManager.error((Object)("value convert error:" + srcValue));
            }
            if (iValue == 0) {
                return User.Status.Online;
            }
            return User.Status.Offline;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            if (null == srcValue) {
                return "--";
            }
            return ((User.Status)srcValue).getDescription();
        }
    }

    public static class UserLevelConvert
    extends DefaultValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            int iLevel = ((IsmUnsignedInteger)srcValue).intValue();
            return User.Level.valueOf((int)iLevel);
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return ((User.Level)srcValue).getDescription();
        }
    }

    public static class DefaultValueConvert
    implements IValueConvert {
        @Override
        public Object original2MOValue(Object srcValue) {
            return srcValue;
        }

        @Override
        public Object moValue2UIValue(Object srcValue) {
            return srcValue;
        }

        @Override
        public Object moValue2Original(Object srcValue) {
            return srcValue;
        }
    }
}

