/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.SignedInt8;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt32;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt8;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;

public final class IsmIntegerFactory {
    private static IsmIntegerFactory instacne;

    private IsmIntegerFactory() {
    }

    public static synchronized IsmIntegerFactory getInstance() {
        if (null == instacne) {
            instacne = new IsmIntegerFactory();
        }
        return instacne;
    }

    public IsmInteger newIsmInteger(ParamType dataType, byte[] value, int byteLength) {
        if (VerifyUtil.isEmpty((Object)value)) {
            return null;
        }
        IsmInteger result = null;
        if (dataType == ParamType.UNSIGN_INT || ParamType.BOOL == dataType || ParamType.ENUM == dataType) {
            if (1 == byteLength) {
                result = new UnsignedInt8(value[0]);
            } else if (2 == byteLength) {
                result = new UnsignedInt16(value);
            } else if (4 == byteLength) {
                result = new UnsignedInt32(value);
            } else if (8 == byteLength) {
                result = new UnsignedInt64(value);
            }
        } else if (ParamType.SIGN_INT == dataType || ParamType.TIME == dataType) {
            if (1 == byteLength) {
                result = new SignedInt8(value[0]);
            } else if (2 == byteLength) {
                result = new SignedInt16(value);
            } else if (4 == byteLength) {
                result = new SignedInt32(value);
            } else if (8 == byteLength) {
                result = new SignedInt64(value);
            }
        }
        return result;
    }

    public IsmInteger newIsmInteger(ParamType dataType, String value) {
        if (dataType == ParamType.UNSIGN_INT || ParamType.BOOL == dataType || ParamType.ENUM == dataType) {
            return new UnsignedInt32(NumberUtil.convertToLong((Object)value));
        }
        if (ParamType.SIGN_INT == dataType) {
            return new SignedInt32(NumberUtil.convertToInteger((Object)value));
        }
        if (ParamType.TIME == dataType) {
            return new SignedInt64(NumberUtil.convertToLong((Object)value));
        }
        return null;
    }
}

