/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmSignedInteger;

public class SignedInt16
extends IsmSignedInteger {
    private static final long serialVersionUID = -5515600014843234939L;
    private static final int LOGIC_NUMBER_CONSTANT = 255;
    private int value;

    public SignedInt16(int value) {
        this.value = value;
    }

    public SignedInt16(short value) {
        this.value = value;
    }

    public SignedInt16(byte[] bytes) {
        this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt16(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 2) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(bytes, offset, tmp, 0, 2);
        this.fromByteArray(tmp, tmp.length);
    }

    @Override
    protected void fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 2 ? 2 : bytesToRead;
        this.value = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            this.value <<= 8;
            this.value |= abyte0[arrayLength - count] & 0xFF;
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[2];
        returnArray[1] = (byte)(this.value >>> 8 & 0xFF);
        returnArray[0] = (byte)this.value;
        return returnArray;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt16 other = (SignedInt16)obj;
        return this.value == other.value;
    }
}

