/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmSignedInteger;

public class SignedInt32
extends IsmSignedInteger {
    private static final long serialVersionUID = -2733221903214554338L;
    private static final int LOGIC_HEX_CONSTANT = 255;
    private int value;

    public SignedInt32(byte[] bytes) {
        this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt32(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 4) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[4];
        System.arraycopy(bytes, offset, tmp, 0, 4);
        this.fromByteArray(tmp, tmp.length);
    }

    public SignedInt32(int value) {
        this.value = value;
    }

    @Override
    protected void fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 4 ? 4 : bytesToRead;
        this.value = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            this.value <<= 8;
            this.value |= abyte0[arrayLength - i] & 0xFF;
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] b = new byte[]{(byte)(this.value >>> 0), (byte)(this.value >>> 8), (byte)(this.value >>> 16), (byte)(this.value >>> 24)};
        return b;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt32 other = (SignedInt32)obj;
        return this.value == other.value;
    }
}

