/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmSignedInteger;

public class SignedInt64
extends IsmSignedInteger {
    public static final int HEX_FF = 255;
    private static final long serialVersionUID = 8609076005066461957L;
    private long value;

    public SignedInt64(long value) {
        this.value = value;
    }

    public SignedInt64(byte[] bytes) {
        this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt64(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 8) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[8];
        System.arraycopy(bytes, offset, tmp, 0, 8);
        this.fromByteArray(tmp, tmp.length);
    }

    @Override
    protected void fromByteArray(byte[] values, int bytesToRead) {
        if (values.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        this.value = 0L;
        int arrayLength = values.length;
        int count = bytesToRead >= 8 ? 8 : bytesToRead;
        this.value = values[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            this.value <<= 8;
            this.value |= (long)(values[arrayLength - i] & 0xFF);
        }
    }

    @Override
    public byte[] toByteArray() {
        byte[] b = new byte[]{(byte)(this.value >>> 0), (byte)(this.value >>> 8), (byte)(this.value >>> 16), (byte)(this.value >>> 24), (byte)(this.value >>> 32), (byte)(this.value >>> 40), (byte)(this.value >>> 48), (byte)(this.value >>> 56)};
        return b;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt64 other = (SignedInt64)obj;
        return this.value == other.value;
    }
}

