/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.lang;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmUnsignedInteger;

public class UnsignedInt32
extends IsmUnsignedInteger {
    public static final UnsignedInt32 ALL_FFFF = new UnsignedInt32(0xFFFFFFFFL);
    private static final int LOGIC_NUMBER_CONSTANT = 255;
    private static final long serialVersionUID = -2015847967253501020L;
    private long value;

    public UnsignedInt32(byte[] bytes) {
        this.fromByteArray(bytes, bytes.length);
    }

    public UnsignedInt32(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 4) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[4];
        System.arraycopy(bytes, offset, tmp, 0, 4);
        this.fromByteArray(tmp, tmp.length);
    }

    public UnsignedInt32(int value) {
        this.value = value;
    }

    public UnsignedInt32(long value) {
        this.value = value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt32 other = (UnsignedInt32)obj;
        return this.value == other.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public void fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 4 ? 4 : bytesToRead;
        this.value = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            this.value <<= 8;
            this.value |= (long)(abyte0[arrayLength - i] & 0xFF);
        }
    }

    @Override
    public ParamType getType() {
        return ParamType.UNSIGN_INT;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[4];
        returnArray[3] = (byte)(this.value >>> 24);
        returnArray[2] = (byte)(this.value >>> 16 & 0xFFL);
        returnArray[1] = (byte)(this.value >>> 8 & 0xFFL);
        returnArray[0] = (byte)this.value;
        return returnArray;
    }
}

