/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.msg;

import com.huawei.ism.cbb.proxy.protocol.tlv.msg.MessageHead;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DataPackage {
    private static final Log logger = LogFactory.getInstance(DataPackage.class);
    private MessageHead head;
    private List<Record> recordset = new ArrayList<Record>();

    public void addRecord(Record record) {
        this.recordset.add(record);
    }

    public int getRecordCount() {
        return this.recordset.size();
    }

    public void addRecord(int index, Record record) {
        this.recordset.add(index, record);
    }

    public MessageHead getHead() {
        return this.head;
    }

    public void setHead(MessageHead head) {
        this.head = head;
    }

    public List<Record> getRecordset() {
        return this.recordset;
    }

    public void setRecordset(List<Record> recordset) {
        this.recordset = recordset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        byte[] result;
        if (null == this.head) {
            throw new IOException("Message Head is null");
        }
        int version = this.head.getVersion();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.head.setDataLength(this.getDataLength(version));
        try {
            out.write(this.head.toByteArray());
            if (null != this.recordset) {
                for (Record record : this.recordset) {
                    byte[] recordDatas = record.toByteArray(version);
                    if (null == recordDatas) {
                        logger.error((Object)("version is not match, recordDatas is null , version:" + version));
                        throw new LegoCheckedException(2117645L);
                    }
                    out.write(recordDatas);
                }
            }
            result = bos.toByteArray();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)"stream close error!", (Throwable)e, 1L);
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)"stream close error!", (Throwable)e, 1L);
            }
        }
        return result;
    }

    private int getDataLength(int msgVersion) {
        int dataLength = 0;
        if (null == this.recordset) {
            return dataLength;
        }
        for (Record record : this.recordset) {
            try {
                byte[] recordDatas = record.toByteArray(msgVersion);
                if (null == recordDatas) continue;
                dataLength += recordDatas.length;
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e, 90160777658902L);
            }
        }
        return dataLength;
    }

    public String toString() {
        return "DataPackage [head=" + this.head + ", recordset=" + this.recordset + "]";
    }
}

