/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service;

import com.huawei.ism.cbb.proxy.service.IConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultConvertor
implements IConvertor {
    private static Log logger = LogFactory.getInstance(DefaultConvertor.class);
    private static DefaultConvertor instance = null;
    private Set<ITransition> transitions = Collections.synchronizedSet(new HashSet());

    public static final DefaultConvertor getInstance() {
        if (null == instance) {
            instance = new DefaultConvertor();
        }
        return instance;
    }

    public Set<ITransition> getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Set<ITransition> transitions) {
        if (transitions == null) {
            logger.error((Object)"The transitions can not be null ! ", 90160758784004L);
            return;
        }
        this.transitions = transitions;
    }

    public void addTransition(ITransition transition) {
        if (transition == null) {
            logger.error((Object)"The transition can not be null ! ", 90160758784004L);
            return;
        }
        this.transitions.add(transition);
    }

    public void removeTransition(ITransition transition) {
        this.transitions.remove(transition);
    }

    public void clearTransition() {
        this.transitions.clear();
    }

    @Override
    public ITransition getTransitionBySmis(String smisType) {
        if (smisType == null) {
            return null;
        }
        for (ITransition trs : this.transitions) {
            if (!smisType.equalsIgnoreCase(trs.getSmisType())) continue;
            return trs;
        }
        return null;
    }

    @Override
    public ITransition getTransitionByV1(Class<?> v1Type) {
        if (v1Type == null) {
            return null;
        }
        List<Class<?>> types = DefaultConvertor.getAllTypes(v1Type);
        for (Class<?> clazz : types) {
            for (ITransition trs : this.transitions) {
                if (clazz != trs.getV1Type()) continue;
                return trs;
            }
        }
        return null;
    }

    @Override
    public ITransition getTransitionByV2(Class<?> v2Type) {
        if (v2Type == null) {
            return null;
        }
        List<Class<?>> types = DefaultConvertor.getAllTypes(v2Type);
        for (Class<?> clazz : types) {
            for (ITransition trs : this.transitions) {
                if (clazz != trs.getV2Type()) continue;
                return trs;
            }
        }
        return null;
    }

    private static List<Class<?>> getAllTypes(Class<?> type) {
        ArrayList classes = new ArrayList();
        while (type != Object.class) {
            classes.add(type);
            type = type.getSuperclass();
        }
        return classes;
    }
}

