/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service.impl;

import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.ism.cbb.proxy.service.impl.DevProtocolListener;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class DevProtocolCollectTask
implements Callable<String> {
    private static final Log LOGGER = LogFactory.getInstance(DevProtocolCollectTask.class);
    private IDevProtocolCollect protocolCollect;
    private DiscoveryPolicy discoveryPolicy;
    private DevProtocolListener listener;

    public DevProtocolCollectTask(DiscoveryPolicy discoveryPolicy, IDevProtocolCollect collect, DevProtocolListener listener) {
        this.protocolCollect = collect;
        this.discoveryPolicy = discoveryPolicy;
        this.listener = listener;
    }

    @Override
    public String call() {
        String protocolName = this.protocolCollect.getProtocolName();
        LOGGER.info((Object)("begin CollectTask, protocol=" + protocolName));
        HashMap<String, String> extendParam = new HashMap<String, String>();
        boolean success = false;
        try {
            success = this.protocolCollect.collectInfo(this.discoveryPolicy, extendParam);
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception while run CollectTask." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        String result = success ? protocolName : null;
        this.listener.handleResult(success, protocolName, extendParam);
        LOGGER.info((Object)("end CollectTask, success=" + success + ", protocol=" + protocolName));
        return result;
    }
}

