/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.Map;

public class RestProtocolCollect
implements IDevProtocolCollect {
    private static final String SYS_OID_REST = "hvs-storage";
    private static final String MANAGEMENT_PROTOCOL_TYPE_REST = "REST";
    private static final Log LOGGER = LogFactory.getInstance(RestProtocolCollect.class);

    @Override
    public String getProtocolName() {
        return MANAGEMENT_PROTOCOL_TYPE_REST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean collectInfo(DiscoveryPolicy discoveryPolicy, Map<String, String> extendParam) {
        RestConnection connection = null;
        try {
            connection = this.initConnection(discoveryPolicy);
            Map<String, String> record = connection.get("/rest/${deviceID}/system/201", null);
            if (!VerifyUtil.isEmpty(record)) {
                this.updateExtendParam(extendParam);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("storage protocol rest try failed." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
        }
        finally {
            if (null != connection) {
                connection.logout();
            }
        }
        return false;
    }

    private RestConnection initConnection(DiscoveryPolicy discoveryPolicy) {
        Map paramMap = discoveryPolicy.getParamMap();
        String name = (String)paramMap.get("name");
        name = DiscParamValidator.decodeByLength((String)name);
        String password = (String)paramMap.get("password");
        password = DiscParamValidator.decodeByLength((String)password);
        String port = (String)paramMap.get("port");
        if (VerifyUtil.isEmpty((String)port)) {
            port = ResourceHelper.getValue("hvs.port");
        }
        int iPort = NumberUtil.parseInteger((Object)port);
        HvsRestConnection connection = new HvsRestConnection(discoveryPolicy.getStartIP(), iPort, name, password);
        ((RestConnection)connection).authenticate();
        return connection;
    }

    private void updateExtendParam(Map<String, String> extendParam) {
        extendParam.put("sysOid", SYS_OID_REST);
        extendParam.put("managementProtocol", MANAGEMENT_PROTOCOL_TYPE_REST);
        extendParam.put("protocol", MANAGEMENT_PROTOCOL_TYPE_REST);
    }
}

