/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.constant.IsmErrorCodeConstant;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.com.south.sdk.constant.ProtocolConstant;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.snmp.SnmpAPI;
import com.huawei.lego.com.south.snmp.exception.SnmpException;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class SnmpCommandUtil {
    private static final Log LOGGER = LogFactory.getInstance(SnmpCommandUtil.class);
    private static final long SNMP_ERROR_OPEN_FAILED = 256L;
    private static final long SNMP_ERROR_NOT_OPEN = 257L;
    private static final long SNMP_ERROR_INDEX_WRONG_TYPE = 258L;
    private static final long SNMP_ERROR_INDEX_ALREADY_ALLOCATED = 259L;
    private static final long SNMP_ERROR_INDEX_NONE_AVAILABLE = 260L;
    private static final long SNMP_ERROR_INDEX_NOT_ALLOCATED = 261L;
    private static final long SNMP_ERROR_UNSUPPORTED_CONTEXT = 262L;
    private static final long SNMP_ERROR_DUPLICATE_REGISTERATION = 263L;
    private static final long SNMP_ERROR_UNKNOWN_REGISTERATION = 264L;
    private static final long SNMP_ERROR_UNKNOWN_AGENT_CAPS = 265L;
    private static final long SNMP_ERROR_PARSE_ERROR = 266L;
    private static final long SNMP_ERROR_REQUEST_DENIED = 267L;
    private static final long SNMP_ERROR_PROCESSING_ERROR = 268L;
    private static final Set<Long> SNMP_ERROR_SET = new LinkedHashSet<Long>();
    private static final long SNMP_DEFAULT_ERR_CODE = 120L;
    private static final long SNMP_MAX_ERROR_CODE = 130L;

    private SnmpCommandUtil() {
    }

    public static SnmpAPI buildSnmpAPI(NetworkEntity networkEntity) {
        Map map = networkEntity.getManagementProtocolMap();
        if (VerifyUtil.isEmpty((Map)map)) {
            LOGGER.info((Object)"No management protocol found", 90160777658901L);
            throw new LegoCheckedException(1073947393L);
        }
        SnmpPara snmpPara = (SnmpPara)map.get(ProtocolConstant.SNMP_PARA);
        if (snmpPara == null) {
            LOGGER.info((Object)("No management protocol found on this device : " + networkEntity), 90160777658901L);
            throw new LegoCheckedException(1073947393L);
        }
        return SnmpCommandUtil.buildSnmpAPI(snmpPara, networkEntity.getLinkIp());
    }

    public static SnmpAPI buildSnmpAPI(SnmpAPI snmp) {
        SnmpEnum.SnmpVersion version = snmp.getSnmpVersion();
        SnmpAPI temp = new SnmpAPI(snmp.getTargetHost(), snmp.getTargetPort(), snmp.getSnmpVersion());
        if (version.equals((Object)SnmpEnum.SnmpVersion.VERSION3)) {
            temp.setSecurityName(snmp.getSecurityName());
            temp.setContextName(snmp.getContextName());
            temp.setAuthProtocol(snmp.getAuthProtocol());
            temp.setAuthPassword(snmp.getAuthPassword());
            temp.setPrivProtocol(snmp.getPrivProtocol());
            temp.setPrivPassword(snmp.getPrivPassword());
            temp.createV3Table();
        } else {
            temp.setCommunity(snmp.getCommunity());
            temp.setWriteCommunity(snmp.getWriteCommunity());
        }
        temp.setRetries(snmp.getRetries());
        temp.setTimeout(snmp.getTimeout());
        return temp;
    }

    public static SnmpAPI buildSnmpAPI(SynchronizeParameter param) {
        Map map = param.getManagementProtocolMap();
        SnmpPara snmpPara = (SnmpPara)map.get(ProtocolConstant.SNMP_PARA);
        SnmpAPI snmp = SnmpCommandUtil.buildSnmpAPI(snmpPara, param.getDeviceIp());
        return snmp;
    }

    public static SnmpAPI buildSnmpAPI(SnmpPara snmpPara, String linkIp) {
        int port = snmpPara.getPort();
        int version = snmpPara.getVersion();
        SnmpEnum.SnmpVersion snmpVersion = SnmpEnum.SnmpVersion.getSnmpVersion((int)version);
        SnmpAPI snmpAPI = new SnmpAPI(linkIp, port, snmpVersion);
        if (snmpVersion.equals((Object)SnmpEnum.SnmpVersion.VERSION3)) {
            snmpAPI.setSecurityName(snmpPara.getSecurityName());
            snmpAPI.setContextName(snmpPara.getContextName());
            snmpAPI.setAuthProtocol(SnmpEnum.AuthProtocol.getAuthProtocol((int)snmpPara.getAuthProtocolNum()));
            snmpAPI.setAuthPassword(snmpPara.getAuthPwd());
            snmpAPI.setPrivProtocol(SnmpEnum.PrivProtocol.getPrivProtocol((int)snmpPara.getEncryptProtocolNum()));
            snmpAPI.setPrivPassword(snmpPara.getEncryptPwd());
            snmpAPI.createV3Table();
        } else {
            snmpAPI.setCommunity(snmpPara.getReadComm());
            snmpAPI.setWriteCommunity(snmpPara.getWriteComm());
        }
        snmpAPI.setRetries(snmpPara.getRetries());
        snmpAPI.setTimeout(snmpPara.getTimeout());
        return snmpAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSnmpSetCommand(String commandName, NetworkEntity agentNE, Map<String, Map<String, String>> oidParameters) {
        if (VerifyUtil.isEmpty(oidParameters)) {
            LOGGER.info((Object)"ERROR : oidParameters is empty.", 90160758784004L);
            return;
        }
        SnmpAPI snmpAPI = null;
        try {
            snmpAPI = SnmpCommandUtil.buildSnmpAPI(agentNE);
            int paraSize = oidParameters.size();
            String[] oids = new String[paraSize];
            String[] values = new String[paraSize];
            SnmpEnum.SnmpType[] types = new SnmpEnum.SnmpType[paraSize];
            int index = 0;
            for (Map.Entry<String, Map<String, String>> paraEntry : oidParameters.entrySet()) {
                Map<String, String> map = paraEntry.getValue();
                oids[index] = map.get("oid");
                values[index] = map.get("value");
                types[index] = SnmpEnum.SnmpType.getSnmpType((byte)((byte)NumberUtil.convertToInteger((Object)map.get("type")).intValue()));
                ++index;
            }
            LOGGER.info((Object)SnmpCommandUtil.buildCommandLogStr(oids, values, types), 90160758784000L);
            LOGGER.info((Object)("Command begin :" + commandName), 90160758784024L);
            snmpAPI.snmpSetBatchList(oids, values, types);
            LOGGER.info((Object)("Command ended :" + commandName), 90160758784025L);
        }
        catch (SnmpException ex) {
            long errorCode = ex.getErrorCode();
            if (IsmErrorCodeConstant.TIMEOUT_ERROR.equals(errorCode)) {
                throw new LegoCheckedException(IsmErrorCodeConstant.TIMEOUT_ERROR.longValue(), (Throwable)ex);
            }
            boolean isSnmpException = SnmpCommandUtil.isSnmpError(errorCode);
            if (isSnmpException) {
                throw new LegoCheckedException(120L, (Throwable)ex);
            }
            throw new LegoCheckedException(errorCode, (Throwable)ex);
        }
        catch (LegoCheckedException ex) {
            Long errorCodeNum = ex.getErrorCode();
            if (errorCodeNum == null || 0L == errorCodeNum) {
                String message = ex.getMessage();
                int strIndex = message.indexOf("errorCode:");
                int strIndex2 = message.indexOf("errorStr:");
                String subStr = message.substring(strIndex, strIndex2 - 2);
                String[] subStrs = subStr.split(":", subStr.length());
                Long errorCode = Long.parseLong(subStrs[1].trim());
                throw new LegoCheckedException(errorCode.longValue(), (Throwable)ex);
            }
            throw new LegoCheckedException(errorCodeNum.longValue(), (Throwable)ex);
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"", (long)102402L, (String[])new String[0], (Log)LOGGER);
        }
        finally {
            if (snmpAPI != null) {
                snmpAPI.releaseResources();
            }
        }
    }

    private static boolean isSnmpError(long errorCode) {
        return errorCode > 0L && errorCode <= 130L || SNMP_ERROR_SET.contains(errorCode);
    }

    private static String buildCommandLogStr(String[] oids, String[] values, SnmpEnum.SnmpType[] types) {
        if (oids == null || values == null || types == null) {
            return "Failure: arguments NULL !" + StringUtil.arrayToString((Object[])oids) + " " + StringUtil.arrayToString((Object[])values) + " " + StringUtil.arrayToString((Object[])types);
        }
        int size = oids.length;
        StringBuilder sb = new StringBuilder("-> Send Snmp Command :");
        for (int i = 0; i < size; ++i) {
            sb.append("oid :").append(oids[i]).append("; value :" + values[i]).append("; type :").append(types[i].getValue());
        }
        return sb.toString();
    }

    static {
        SNMP_ERROR_SET.add(256L);
        SNMP_ERROR_SET.add(257L);
        SNMP_ERROR_SET.add(258L);
        SNMP_ERROR_SET.add(259L);
        SNMP_ERROR_SET.add(260L);
        SNMP_ERROR_SET.add(261L);
        SNMP_ERROR_SET.add(262L);
        SNMP_ERROR_SET.add(263L);
        SNMP_ERROR_SET.add(264L);
        SNMP_ERROR_SET.add(265L);
        SNMP_ERROR_SET.add(266L);
        SNMP_ERROR_SET.add(267L);
        SNMP_ERROR_SET.add(268L);
    }
}

