/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.exception;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.exception.ErrorResponse;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class InvokeFaultExceptionMapper
implements ExceptionMapper<Exception> {
    private static CodeLog log = LogFactory.getInstance(InvokeFaultExceptionMapper.class, (long)-1L);
    @Context
    private HttpServletRequest request;

    protected String getCurrentUser() {
        if (this.request == null) {
            return null;
        }
        User user = (User)this.request.getAttribute("currentUser");
        if (user != null) {
            return user.getUserName();
        }
        user = (User)this.request.getSession().getAttribute("currentUser");
        if (user != null) {
            return user.getUserName();
        }
        String userName = this.request.getHeader("x-auth-user");
        if (!UserRestServiceValidator.checkUserName(userName).booleanValue()) {
            userName = "--";
        }
        return userName;
    }

    public Response toResponse(Exception ex) {
        LegoCheckedException e;
        if (null == ex) {
            return Response.ok().build();
        }
        Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        rb.type("application/json;charset=UTF-8");
        ErrorResponse rsp = new ErrorResponse();
        if (ex instanceof LegoCheckedException) {
            e = (LegoCheckedException)ex;
            rsp.setErrorCode(e.getErrorCode());
            rsp.setDetailParam(e.getParameters());
        } else if (ex instanceof LegoUncheckedException) {
            e = (LegoUncheckedException)ex;
            rsp.setErrorCode(e.getErrorCode());
        } else if (ex instanceof WebApplicationException) {
            rsp.setErrorCode(1073947395L);
        } else {
            rsp.setErrorCode(-1L);
        }
        long errorCode = rsp.getErrorCode();
        String errorMessage = rsp.getErrorMessage();
        if (1073947393L == errorCode || 1073947394L == errorCode || "systemTimeout".equals(errorMessage)) {
            rsp.setErrorMessage(ex.getMessage());
        } else {
            Locale locale = RequestUtil.getLocale(this.request);
            String i18nErrorMsg = ResourceUtil.getInstance().getText(String.valueOf(errorCode), locale, rsp.getDetailParam());
            rsp.setErrorMessage(i18nErrorMsg);
        }
        log.error((Object)("rest replication get or post error. UserName: " + this.getCurrentUser() + ", ClientIP: " + RequestUtil.getClientIpAddress(this.request) + ExceptionUtil.getErrorMessage((Throwable)ex)));
        JSONObject jsonObject = JSONObject.fromObject((Object)rsp);
        if (!VerifyUtil.isEmpty((Map)jsonObject)) {
            rb.entity((Object)jsonObject.toString());
        }
        rb.language(Locale.SIMPLIFIED_CHINESE);
        Response response = rb.build();
        return response;
    }
}

