/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.interceptor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.exception.RestException;
import com.huawei.ism.drm.rest.interceptor.OutExceptionInterceptor;
import com.huawei.ism.drm.rest.interceptor.RemoveSessionInterceptor;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.ISecurityService;
import com.huawei.ism.drm.web.listener.SessionDesListnerSer;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class RestSecurityInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final int LOGIN_ERROR_MAX_NUMBER = 10;
    private static final long LOGIN_ERROR_OVERTIME = 1800000L;
    private static final String ENABLE_ALL_ACCOUNT_AUTH_KEY = "enable.all.account.api.auth";
    private static final CodeLog LOGGER = LogFactory.getInstance(RestSecurityInterceptor.class, (long)-1L);
    private static final OutExceptionInterceptor OUT_EXCEPTION_INTERCEPTOR = new OutExceptionInterceptor();
    private static final RemoveSessionInterceptor REMOVE_SESSION_INTERCEPTOR = new RemoveSessionInterceptor();
    private static Map<String, Long[]> loginControl = new ConcurrentHashMap<String, Long[]>();
    private static Map<String, Set<String>> loginControlPassword = new ConcurrentHashMap<String, Set<String>>();

    public RestSecurityInterceptor() {
        super("pre-invoke");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken(InputStream is) {
        String token = null;
        char[] bytes = new char[600];
        try {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(is, "UTF-8"), 600);
            int numRead = buffer.read(bytes);
            token = new String(bytes).substring(0, numRead);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("new InputStreamReader exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        catch (IOException e) {
            LOGGER.error((Object)("readLine stream exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            CommUtils.closeInputStream(is);
        }
        if (null != token && !token.trim().isEmpty()) {
            token = token.replace("{", "").replace("}", "").split(":")[1].replaceAll("\"", "");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareImportToken(Message message) throws IOException {
        String randomStr;
        String clientToken = "";
        InputStream stream = null;
        HttpServletRequest req = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        Collection list = message.getAttachments();
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (Attachment attachment : list) {
                try {
                    stream = attachment.getDataHandler().getDataSource().getInputStream();
                    clientToken = this.getToken(stream);
                }
                catch (IOException e) {
                    try {
                        LOGGER.error((Object)("read stream failed" + ExceptionUtil.getErrorMessage((Throwable)e)));
                    }
                    catch (Throwable throwable) {
                        CommUtils.closeInputStream(stream);
                        throw throwable;
                    }
                    CommUtils.closeInputStream(stream);
                    continue;
                }
                CommUtils.closeInputStream(stream);
            }
        }
        if (VerifyUtil.isEmpty((String)(randomStr = (String)req.getSession().getAttribute("rd_randomStr_HW"))) || !randomStr.equals(clientToken)) {
            Fault fault = new Fault((Throwable)new RestException(1073947420L));
            fault.setFaultCode(Fault.FAULT_CODE_CLIENT);
            throw fault;
        }
    }

    public void handleMessage(Message message) {
        this.checkMessage(message);
        String clientIp = RequestUtil.getClientIpAddress(message);
        this.recordAccessLog(message);
        this.checkAccess(clientIp);
        this.addOutIntercepter(message);
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
            HttpSession session = request.getSession(false);
            if (session != null) {
                this.checkSession(clientIp, session, request);
                String requestUri = UriUtil.getNormalizeRequestServletUri(request);
                if ("/ws/license/action/import".equals(requestUri) || "/ws/fusionsphere/action/importnetworkadapters".equals(requestUri)) {
                    this.compareImportToken(message);
                }
            } else {
                this.verifyIdentification(request, message);
            }
        }
        catch (Fault fault) {
            if (request != null) {
                String xforwardedIp = request.getHeader("X-Forwarded-For");
                if (!clientIp.equals(xforwardedIp)) {
                    LOGGER.error((Object)"User name or password is invalid.", (Throwable)fault);
                }
            } else {
                LOGGER.error((Object)"User name or password is invalid.", (Throwable)fault);
            }
            throw fault;
        }
        catch (Exception ex) {
            this.dealException(ex);
        }
    }

    private void checkMessage(Message message) {
        if (VerifyUtil.isEmpty((Map)message)) {
            LOGGER.error((Object)"Message is empty!");
            throw this.constructDefaultFault();
        }
    }

    private void dealException(Exception ex) {
        Fault ftServer = this.constructDefaultFault();
        ftServer.setStackTrace(ex.getStackTrace());
        LOGGER.error((Object)("User verify is error." + ExceptionUtil.getErrorMessage((Throwable)ex)));
        throw ftServer;
    }

    private Fault constructDefaultFault() {
        RestException uhmExceptionServer = new RestException(1073947395L, "server is error.");
        Fault ftServer = new Fault((Throwable)uhmExceptionServer);
        ftServer.setFaultCode(Fault.FAULT_CODE_SERVER);
        return ftServer;
    }

    private void checkSession(String clientIp, HttpSession session, HttpServletRequest request) {
        if (null != session.getAttribute("currentUser")) {
            this.doSession(session, request);
            this.afterLoginHandlder(clientIp, true);
            this.afterLoginHandlder(clientIp, "", true);
            return;
        }
        Fault fault = new Fault((Throwable)new RestException(300L, "systemTimeout"));
        fault.setFaultCode(Fault.FAULT_CODE_CLIENT);
        throw fault;
    }

    public void checkAccess(String ip) {
        if (!loginControl.containsKey(ip)) {
            loginControl.put(ip, new Long[]{0L, System.currentTimeMillis()});
            loginControlPassword.put(ip, new HashSet());
            return;
        }
        Long[] timeCount = loginControl.get(ip);
        Set<String> invalidPwd = loginControlPassword.get(ip);
        if (VerifyUtil.isEmpty(invalidPwd) || 1800000L < System.currentTimeMillis() - timeCount[1]) {
            loginControl.remove(ip);
            loginControlPassword.remove(ip);
            this.checkAccess(ip);
            return;
        }
        if (10 <= invalidPwd.size()) {
            LOGGER.error((Object)("Exceed the max times. ip:" + ip));
            RestException exception = new RestException(1073947395L, "403 Forbidden");
            Fault ftVerify = new Fault((Throwable)exception);
            ftVerify.setFaultCode(Fault.FAULT_CODE_CLIENT);
            throw ftVerify;
        }
    }

    public void afterLoginHandlder(String ip, boolean isOk) {
        if (isOk) {
            loginControl.remove(ip);
            return;
        }
        Object[] timeCount = loginControl.get(ip);
        long currentTimeMillis = System.currentTimeMillis();
        if (VerifyUtil.isEmpty((Object[])timeCount)) {
            timeCount = new Long[]{0L, currentTimeMillis};
        }
        Object[] objectArray = timeCount;
        Long.valueOf((Long)objectArray[0] + 1L);
        timeCount[1] = currentTimeMillis;
        loginControl.put(ip, (Long[])timeCount);
    }

    private void afterLoginHandlder(String ip, String pwd, boolean isOk) {
        if (isOk) {
            loginControlPassword.remove(ip);
            return;
        }
        Set<String> timeCount = loginControlPassword.get(ip);
        if (VerifyUtil.isEmpty(timeCount)) {
            timeCount = new HashSet<String>();
        }
        timeCount.add(pwd);
        loginControlPassword.put(ip, timeCount);
    }

    private void verifyIdentification(HttpServletRequest request, Message message) {
        boolean isOk;
        Fault ftVerify;
        block7: {
            ftVerify = this.initFault();
            User user = this.constructUser(message, ftVerify);
            boolean isEnableAuth = LegoConfig.getInstance((String)(PathUtil.getInstallPath() + "/LegoRuntime/conf/lego.properties")).getBoolean(ENABLE_ALL_ACCOUNT_AUTH_KEY, Boolean.valueOf(true));
            boolean isMachineAccount = user.isSyncAdmin();
            if (!isEnableAuth && !isMachineAccount) {
                LOGGER.error((Object)"Only support machine account.");
                throw ftVerify;
            }
            LOGGER.debug((Object)"Start verify...");
            ISecurityService service = this.getSecurityServiceService(ftVerify);
            try {
                service.checkLock(user.getUserName(), user.getUserPassword());
                this.checkUserAclByIpAddress(user.getUserName(), user.getIpAdr());
                isOk = true;
                if (!isMachineAccount) {
                    SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog("user_login_operateName", user.getUserName(), 1, null, user.getUserName(), user.getIpAdr());
                    SysOpLogBuilder.writeOperateLog(sysOptLog);
                }
            }
            catch (LegoCheckedException e) {
                ftVerify = this.dealError(e);
                isOk = false;
                LOGGER.error((Object)String.format(Locale.ROOT, "Verify failed: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_login_operateName", user.getUserName(), 2, "lego.err." + e.getErrorCode(), user.getUserName(), user.getIpAdr());
                sysOptLog.setDetailPara(e.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
            }
            try {
                this.controlLoginAction(request, message, user, isOk);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 206L) break block7;
                throw e;
            }
        }
        if (!isOk) {
            throw ftVerify;
        }
    }

    private void controlLoginAction(HttpServletRequest request, Message message, User user, boolean isOk) {
        this.afterLoginHandlder(user.getIpAdr(), isOk);
        this.afterLoginHandlder(user.getIpAdr(), "" + user.getUserName() + ";" + user.getUserPassword(), isOk);
        this.addUserToSession(user.getUserName(), message);
        HttpSession session = request.getSession();
        if (null == session) {
            return;
        }
        session.setAttribute("IS_MACHINE_TO_MACHINE", (Object)true);
        if (!message.getExchange().getEndpoint().getOutInterceptors().contains((Object)REMOVE_SESSION_INTERCEPTOR)) {
            message.getExchange().getEndpoint().getOutInterceptors().add(REMOVE_SESSION_INTERCEPTOR);
        }
        REMOVE_SESSION_INTERCEPTOR.setRequest(request);
    }

    private Fault initFault() {
        RestException exception = new RestException(1073947659L, "403 Forbidden");
        Fault ftVerify = new Fault((Throwable)exception);
        ftVerify.setFaultCode(Fault.FAULT_CODE_CLIENT);
        return ftVerify;
    }

    private Fault dealError(LegoCheckedException e) {
        RestException exception = new RestException(e.getErrorCode(), "403 Forbidden");
        Fault fault = new Fault((Throwable)exception);
        fault.setFaultCode(Fault.FAULT_CODE_CLIENT);
        return fault;
    }

    private User constructUser(Message message, Fault ftVerify) {
        Map<String, Object> headers = this.getHeaders(message);
        String userName = this.getUserName(ftVerify, headers);
        String password = this.getPwd(ftVerify, headers);
        User user = new User();
        user.setUserName(userName);
        user.setUserPassword(password);
        String clientIpWhole = RequestUtil.getClientIpAddress(message);
        LOGGER.debug((Object)("clientIpWhole: " + clientIpWhole));
        String clientIp = AddressUtil.getStrWithoutPrecent((String)clientIpWhole);
        LOGGER.debug((Object)("clientIp: " + clientIp));
        user.setIpAdr(clientIp);
        this.checkUserObj(user, ftVerify);
        return user;
    }

    private String getPwd(Fault ftVerify, Map<String, Object> headers) {
        List tmp = (List)headers.get("x-auth-key");
        if (VerifyUtil.isEmpty((Collection)tmp)) {
            LOGGER.error((Object)"the X-Auth-Key is empty");
            throw ftVerify;
        }
        String password = (String)tmp.get(0);
        return password;
    }

    private String getUserName(Fault ftVerify, Map<String, Object> headers) {
        List account = (List)headers.get("x-auth-user");
        if (VerifyUtil.isEmpty((Collection)account)) {
            LOGGER.error((Object)"the X-Auth-User is empty");
            throw ftVerify;
        }
        String userName = (String)account.get(0);
        return userName;
    }

    private void checkUserObj(User userObj, Fault ftVerify) {
        if (!(UserRestServiceValidator.checkUserName(userObj.getUserName()).booleanValue() && UserRestServiceValidator.checkPassword(userObj.getUserPassword()).booleanValue() && UserRestServiceValidator.checkIp(userObj.getIpAdr()).booleanValue())) {
            LOGGER.error((Object)"check user parameters failed!");
            throw ftVerify;
        }
    }

    private void checkLoginIpIsCurrent(User currentUser, HttpServletRequest request) {
        if (currentUser != null && !Objects.equals(currentUser.getIpAdr(), request.getRemoteAddr())) {
            LOGGER.error((Object)"The request ip is not equal to the current login ip.");
            throw new LegoCheckedException(1073947400L);
        }
    }

    private void doSession(HttpSession session, HttpServletRequest request) {
        User currentUser = (User)session.getAttribute("currentUser");
        String sessId = currentUser.getSession();
        this.checkLoginIpIsCurrent(currentUser, request);
        if (this.getUserInfoServiceService().checkTimeOut(sessId, true).booleanValue()) {
            LOGGER.info((Object)("Exit system time:" + currentUser.getLoginDate()));
            SessionDesListnerSer.executeSessionDestroyed(session.getId());
            throw new Fault((Throwable)new RestException(1073947659L, "user timeout"));
        }
        String passState = (String)session.getAttribute("passState");
        if (passState != null && passState.equals("unknow")) {
            throw new Fault((Throwable)new RestException(1073947659L, "status unknow"));
        }
    }

    private ISecurityService getSecurityServiceService(Fault ftVerify) {
        return this.getService("DRM_Base/ISecurityService", ISecurityService.class, ftVerify);
    }

    private <T> T getService(String name, Class<T> type, Fault fault) {
        Object service = ServiceContext.getInstance().lookup(name);
        if (service == null) {
            LOGGER.error((Object)("Can not find the service. Service name: " + name));
            if (fault != null) {
                throw fault;
            }
        }
        if (!type.isInstance(service)) {
            LOGGER.error((Object)("The type of service is incorrect. Service name: " + name));
            if (fault != null) {
                throw fault;
            }
        }
        return type.cast(service);
    }

    private IUserMgr getUserInfoServiceService() {
        return this.getService("user/usermgr", IUserMgr.class, null);
    }

    private void recordAccessLog(Message message) {
        Message mess = message.getExchange().getInMessage();
        String userNmae = "--";
        List account = (List)this.getHeaders(message).get("x-auth-user");
        if (!VerifyUtil.isEmpty((Collection)account) && !VerifyUtil.isEmpty((String)((String)account.get(0)))) {
            userNmae = (String)account.get(0);
        }
        String clientIPAddress = RequestUtil.getClientIpAddress(message);
        String requestMethod = (String)mess.get((Object)"org.apache.cxf.request.method");
        String operationMethod = (String)message.getContextualProperty("org.apache.cxf.resource.operation.name");
        StringBuilder sblog = new StringBuilder("client:");
        sblog.append(clientIPAddress);
        sblog.append(", user:");
        sblog.append(userNmae);
        sblog.append(", request method:");
        sblog.append(requestMethod);
        sblog.append(", operation method:");
        sblog.append(operationMethod);
        LOGGER.info((Object)sblog.toString());
        LOGGER.info((Object)String.format("client: %s, user: %s, request method: %s, operation method: %s", clientIPAddress, userNmae, requestMethod, operationMethod));
    }

    private void addOutIntercepter(Message message) {
        Message mess = message.getExchange().getInMessage();
        if (!mess.getExchange().getEndpoint().getOutFaultInterceptors().contains((Object)OUT_EXCEPTION_INTERCEPTOR)) {
            mess.getExchange().getEndpoint().getOutFaultInterceptors().add(OUT_EXCEPTION_INTERCEPTOR);
        }
    }

    private Map<String, Object> getHeaders(Message message) {
        Message mess = message.getExchange().getInMessage();
        return (TreeMap)mess.get((Object)Message.PROTOCOL_HEADERS);
    }

    private void addUserToSession(String userName, Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        HttpSession session = request.getSession();
        ServiceContext context = ServiceContext.getInstance();
        IUserMgr mgr = (IUserMgr)context.lookup("user/usermgr");
        User user = mgr.getUserBaseInfoByName(userName);
        session.setAttribute("currentUser", (Object)user);
        if (VerifyUtil.isEmpty((Object)user)) {
            LegoCheckedException e = new LegoCheckedException(1073947400L);
            throw e;
        }
    }

    private void checkUserAclByIpAddress(String userName, String ipAddress) {
        IUserMgr userMgr = this.getUserInfoServiceService();
        boolean validAddress = userMgr.checkAclIpAddress(userName, ipAddress);
        if (!validAddress) {
            throw new LegoCheckedException(265L);
        }
    }
}

