/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.base;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.web.service.logging.LoggingParams;
import com.huawei.ism.drm.web.service.logging.LoggingService;
import com.huawei.ism.drm.web.service.session.SessionService;
import com.huawei.ism.drm.web.service.tunnel.BundleService;
import com.huawei.ism.drm.web.util.RequestUtil;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRestService {
    private static final String COMM_SERVICE_TYPE = "";
    private static final String MACHINE_TO_MACHINE_FLAG = "machine_to_machine_flag";
    private static final String IS_EXPORT_PRE_CHECK = "is_export_pre_check";
    private final transient Log log = LogFactory.getInstance((Object)this);
    private BundleService bundleService;
    private LoggingService loggingService;
    private SessionService sessionService;

    public static String getRemoteAddr(HttpServletRequest req) {
        return RequestUtil.getClientIpAddress(req);
    }

    public static boolean isIPValid(String strIP) {
        if (VerifyUtil.isEmpty((String)strIP) || strIP.endsWith(".0") || strIP.startsWith("0")) {
            return false;
        }
        return AddressUtil.isIpAddress((String)strIP);
    }

    public BundleService getBundleService() {
        return this.bundleService;
    }

    @Autowired
    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    @Autowired
    public void setLoggingService(LoggingService loggingService) {
        this.loggingService = loggingService;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    protected HttpServletRequest getRequest() {
        return this.sessionService.getHttpServletRequest();
    }

    protected HttpServletResponse getResponse() {
        return this.sessionService.getHttpServletResponse();
    }

    protected HttpSession getSession() {
        return this.getRequest().getSession(false);
    }

    protected boolean isMachineToMachineReq() {
        String machineFlag = this.getRequest().getHeader(MACHINE_TO_MACHINE_FLAG);
        return !VerifyUtil.isEmpty((String)machineFlag);
    }

    public Locale getLocale() {
        return RequestUtil.getLocale(this.getRequest());
    }

    @Deprecated
    protected Object getBundleService(String bundle, String service) {
        return this.bundleService.getBundleService(bundle, service);
    }

    public <T> T getBundleService(String bundleName, String serviceName, Class<T> serviceClass) {
        return this.bundleService.getBundleService(bundleName, serviceName, serviceClass);
    }

    public <T> T getBundleService(String serviceName, Class<T> serviceClass) {
        return this.bundleService.getBundleService(serviceName, serviceClass);
    }

    public <T> T getBundleService(Class<T> serviceClass) {
        return this.bundleService.getBundleService(serviceClass);
    }

    public Long getCurrentUserId() {
        User user = this.getCurrentUser();
        return user.getUserId();
    }

    public User getCurrentUser() {
        return this.sessionService.getCurrentUser();
    }

    protected Map<String, Object> getExtParamInQueryParam() {
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        Map parameterMap = this.getRequest().getParameterMap();
        if (VerifyUtil.isEmpty((Map)parameterMap)) {
            return queryParam;
        }
        for (Map.Entry values : parameterMap.entrySet()) {
            String[] keys;
            String key = (String)values.getKey();
            Object[] value = (String[])values.getValue();
            if (VerifyUtil.isEmpty((Object[])value) || !key.contains(".") || (keys = key.split("\\.")).length != 2) continue;
            String key1 = keys[1];
            Object value1 = value[0];
            if (VerifyUtil.isEmpty((String)key1) || VerifyUtil.isEmpty((String)value1)) continue;
            queryParam.put(key1, value1);
        }
        return queryParam;
    }

    protected void checkSiteIdExisted(String siteId) {
        ISiteService siteService = this.getBundleService(ISiteService.class.getName(), ISiteService.class);
        if (VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void checkDrResourceExisted(String hostSn) {
        IResourceService resourceService = this.getBundleService(IResourceService.class.getName(), IResourceService.class);
        if (null == resourceService) {
            throw new LegoCheckedException(1073947395L);
        }
        if (VerifyUtil.isEmpty((String)hostSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource dr = resourceService.getDrResourceBySn(hostSn);
        if (VerifyUtil.isEmpty((Object)dr)) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected void checkUserAuthority(String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
    }

    protected void checkUserAuthorityByMoIds(long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedMOObject(this.getCurrentUserId(), moIds);
    }

    protected void checkUserAuthorityByMoSN(String objectSn) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        scope.checkUserGrantedMOObject(this.getCurrentUserId(), objectSn);
    }

    protected void checkUserOperationAuthority(String operationName, int level, String i18nKey) {
        Long userId = this.getCurrentUserId();
        if (userId == null) {
            this.log.error((Object)"Cannot get current user.");
            throw new LegoCheckedException(1073947400L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        boolean hasRight = mgr.checkUserRight(userId.longValue(), i18nKey);
        if (!hasRight) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", COMM_SERVICE_TYPE, AbstractRestService.getRemoteAddr(this.getRequest()));
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw new LegoCheckedException(1073947400L);
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, long ... moIds) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (long moId : moIds) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), new long[]{moId});
            }
            catch (LegoCheckedException e) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", moId + COMM_SERVICE_TYPE, AbstractRestService.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(e.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
                throw e;
            }
        }
    }

    protected void checkUserMoAuthority(String operationName, int level, String ... devSn) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        for (String sn : devSn) {
            try {
                scope.checkUserGrantedMOObject(this.getCurrentUserId(), sn);
            }
            catch (LegoCheckedException e) {
                SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", sn, AbstractRestService.getRemoteAddr(this.getRequest()));
                sysOptLog.setDetailPara(e.getParameters());
                SysOpLogBuilder.writeOperateLog(sysOptLog);
                throw e;
            }
        }
    }

    protected void checkUserBizObjAuthority(String operationName, int level, String objectId) {
        IBizScopeManager scope = this.getBundleService("IBizScopeManager", IBizScopeManager.class);
        try {
            scope.checkUserGrantedObject(this.getCurrentUserId(), objectId);
        }
        catch (LegoCheckedException e) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err." + e.getErrorCode(), objectId, AbstractRestService.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(e.getParameters());
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw e;
        }
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLog(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLog(String operationName, int level, String objectName, Exception ix, String serviceType) {
        this.loggingService.writeFailedOperationLog(new LoggingParams(operationName, level, objectName, serviceType), ix);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix) {
        this.writeFailedOperationLogNoException(operationName, level, objectName, ix, COMM_SERVICE_TYPE);
    }

    protected void writeFailedOperationLogNoException(String operationName, int level, String objectName, Exception ix, String serviceType) {
        this.loggingService.writeFailedOperationLogNoException(new LoggingParams(operationName, level, objectName, serviceType), ix);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters) {
        this.writeSucOperationLog(operationName, level, objectName, detail, parameters, COMM_SERVICE_TYPE);
    }

    protected void writeSucOperationLog(String operationName, int level, String objectName, String detail, String[] parameters, String serviceType) {
        this.loggingService.writeSucOperationLog(new LoggingParams(operationName, level, objectName, serviceType), detail, parameters);
    }

    protected BatchOperationResult getBatchResult(String logKey, String[] logPara, long erroCode, String strMotionKey) {
        if (VerifyUtil.isEmpty((String)logKey) || VerifyUtil.isEmpty((Object[])logPara)) {
            return null;
        }
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> bos = new ArrayList<BatchOperation>();
        BatchOperation bo = new BatchOperation();
        bo.setOptDetail(logKey);
        bo.setDetailParam(logPara);
        bo.setErrorCode(erroCode);
        bo.setTargetName(logKey);
        String[] trgParam = new String[]{strMotionKey};
        bo.setTargetNameParam(trgParam);
        bos.add(bo);
        result.setResult(bos);
        result.setFailCount(1);
        result.setSucceedCount(0);
        result.setTotalCount(1);
        return result;
    }

    public String getText(String key) {
        Locale locale = RequestUtil.getLocale(this.getRequest());
        return ResourceUtil.getInstance().getText(key, locale);
    }

    public String getText(String key, String[] args) {
        return ResourceUtil.getInstance().getText(key, this.getLocale(), args);
    }

    protected boolean checkIsRemoteSite(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAuthority(siteId);
        ISiteService siteService = (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
        Site site = siteService.getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947394L);
        }
        return false;
    }

    protected PageParameter getPageParameter() {
        PageParameter pageParameter = new PageParameter();
        HttpServletRequest req = this.getRequest();
        String startPage = req.getParameter("startPage");
        String pageSize = req.getParameter("pageSize");
        String orderBy = req.getParameter("orderBy");
        String orderType = req.getParameter("orderType");
        try {
            if (!VerifyUtil.isEmpty((String)startPage)) {
                pageParameter.setStartPage(Integer.parseInt(startPage));
            }
            if (!VerifyUtil.isEmpty((String)pageSize)) {
                pageParameter.setPageSize(Integer.parseInt(pageSize));
            }
            if (!VerifyUtil.isEmpty((String)orderBy)) {
                pageParameter.setOrderBy(orderBy);
            }
            if (!VerifyUtil.isEmpty((String)orderType)) {
                pageParameter.setOrderType(orderType);
            }
        }
        catch (NumberFormatException e) {
            this.log.error((Object)"NumberFormatException", (Throwable)e);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return pageParameter;
    }

    protected Boolean isExportChecked() {
        HttpServletRequest request = this.getRequest();
        String isChecked = request.getParameter("isChecked");
        request.setAttribute(IS_EXPORT_PRE_CHECK, (Object)"false".equalsIgnoreCase(isChecked));
        return !"false".equalsIgnoreCase(isChecked);
    }

    protected Response exportCheckOk() {
        HttpServletRequest request = this.getRequest();
        request.setAttribute(IS_EXPORT_PRE_CHECK, (Object)Boolean.TRUE);
        return Response.ok().build();
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level) {
        this.batchOptLog(batchOperationResult, operateName, level, COMM_SERVICE_TYPE);
    }

    protected void batchOptLog(BatchOperationResult batchOperationResult, String operateName, int level, String serviceType) {
        this.loggingService.batchOptLog(batchOperationResult, operateName, level, serviceType);
    }

    public String calcExecuteTime(String startTimeStr, String endTimeStr) {
        if (VerifyUtil.isEmpty((String)startTimeStr) || VerifyUtil.isEmpty((String)endTimeStr)) {
            return "--";
        }
        Long startTime = this.getTime(startTimeStr);
        Long endTime = this.getTime(endTimeStr);
        if (null == startTime || startTime == 0L || null == endTime || endTime == 0L) {
            return "--";
        }
        long executeTime = endTime / 1000L - startTime / 1000L;
        if (executeTime < 0L) {
            return "--";
        }
        long temp = 3600L;
        long hour = executeTime / temp;
        long minutes = (executeTime %= temp) / 60L;
        long seconds = executeTime % 60L;
        if (hour > 0L) {
            String[] param = new String[]{COMM_SERVICE_TYPE + hour, COMM_SERVICE_TYPE + minutes, COMM_SERVICE_TYPE + seconds};
            return this.getText("common_time_hour_min_second", param);
        }
        if (minutes > 0L) {
            String[] param = new String[]{COMM_SERVICE_TYPE + minutes, COMM_SERVICE_TYPE + seconds};
            return this.getText("common_time_min_second", param);
        }
        String[] param = new String[]{COMM_SERVICE_TYPE + seconds};
        return this.getText("common_time_second", param);
    }

    private Long getTime(String timeStr) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(timeStr);
            return date.getTime();
        }
        catch (ParseException e) {
            return NumberUtil.convertToLong((Object)timeStr, (long)0L);
        }
    }
}

