/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmDetailVO;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmPageVo;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmTransferStorageConfigVo;
import com.huawei.ism.drm.rest.service.framework.alarm.model.AlarmVO;
import com.huawei.ism.drm.rest.service.framework.alarm.model.ThirdAlarmVo;
import com.huawei.ism.drm.rest.service.framework.alarm.service.AlarmExtend;
import com.huawei.ism.drm.rest.service.framework.alarm.service.AlarmRestSerivceValidator;
import com.huawei.ism.drm.rest.service.framework.alarm.service.IAlarmRestService;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FaultActionUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FaultExportUtil;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FileFactory;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.ism.drm.rest.service.framework.audio.model.AlertAudioSettingInput;
import com.huawei.ism.drm.rest.service.framework.log.service.LogRestServiceImpl;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.annotation.Permissions;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.model.TaskResult;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.cbb.task.sdk.service.TaskCategory;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.huawei.lego.nem.fault.sdk.model.AlertExperience;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.OverAllStatistic;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IAlarmStatistic;
import com.huawei.lego.nem.fault.sdk.service.IAlertExperienceService;
import com.huawei.lego.nem.fault.sdk.service.IAlertNotifyService;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

public class AlarmRestServiceImpl
extends AbstractRestService
implements IAlarmRestService {
    private static final int TWO = 2;
    private static final Integer DEFAULT_CYCLE_DATE = 30;
    private static final Integer DEFAULT_RESER_DATE = 90;
    private static final Integer RESTOREALARM = 2;
    private static final Integer GENERALARM = 1;
    private static final Long ADMIN_ID = 1L;
    private static Log logger = FELogFactory.getInstance((String)"ui");
    private String defaultTime = "02:00:00";
    private int defaultFilestyle = 1;
    private String eventType = "alarm_bk";
    @Autowired
    private PermissionService permissionService;

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.scan"})
    public String getAlarmStatisticAndAudio() {
        User currentUser = this.getCurrentUser();
        long userId = -1L;
        if (!"true".equalsIgnoreCase(currentUser.getIsAdmin())) {
            userId = currentUser.getUserId();
        }
        IAlarmStatistic service = (IAlarmStatistic)this.getBundleService("fault", "statisticService");
        IAlertNotifyService audioService = (IAlertNotifyService)this.getBundleService("fault", "alertNotifyService");
        JSONObject resultObject = new JSONObject();
        if (null != service && null != audioService) {
            OverAllStatistic overallStatistic = service.getStatisticBySeverity(userId);
            AlertAudioSetting setting = audioService.getAudioSetting(currentUser.getUserId().longValue());
            resultObject.put((Object)FaultEnum.AlarmSeverity.WARNING.toString().toLowerCase(Locale.getDefault()), (Object)String.valueOf(overallStatistic.getUnClearedCount(FaultEnum.AlarmSeverity.WARNING)));
            resultObject.put((Object)FaultEnum.AlarmSeverity.MINOR.toString().toLowerCase(Locale.getDefault()), (Object)String.valueOf(overallStatistic.getUnClearedCount(FaultEnum.AlarmSeverity.MINOR)));
            resultObject.put((Object)FaultEnum.AlarmSeverity.MAJOR.toString().toLowerCase(Locale.getDefault()), (Object)String.valueOf(overallStatistic.getUnClearedCount(FaultEnum.AlarmSeverity.MAJOR)));
            resultObject.put((Object)FaultEnum.AlarmSeverity.CRITICAL.toString().toLowerCase(Locale.getDefault()), (Object)String.valueOf(overallStatistic.getUnClearedCount(FaultEnum.AlarmSeverity.CRITICAL)));
            resultObject.put((Object)(FaultEnum.AlarmSeverity.WARNING.toString().toLowerCase(Locale.getDefault()) + "Unconfirm"), (Object)String.valueOf(overallStatistic.getUnConfirmedCount(FaultEnum.AlarmSeverity.WARNING)));
            resultObject.put((Object)(FaultEnum.AlarmSeverity.MINOR.toString().toLowerCase(Locale.getDefault()) + "Unconfirm"), (Object)String.valueOf(overallStatistic.getUnConfirmedCount(FaultEnum.AlarmSeverity.MINOR)));
            resultObject.put((Object)(FaultEnum.AlarmSeverity.MAJOR.toString().toLowerCase(Locale.getDefault()) + "Unconfirm"), (Object)String.valueOf(overallStatistic.getUnConfirmedCount(FaultEnum.AlarmSeverity.MAJOR)));
            resultObject.put((Object)(FaultEnum.AlarmSeverity.CRITICAL.toString().toLowerCase(Locale.getDefault()) + "Unconfirm"), (Object)String.valueOf(overallStatistic.getUnConfirmedCount(FaultEnum.AlarmSeverity.CRITICAL)));
            AlertAudioSettingInput.constructJSONObjectResult(resultObject, setting);
        }
        return resultObject.toString();
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.scan"})
    public String getAlarmList(Set<Integer> severities, Integer confirmStatus, String alarmSource, Integer alarmType, String location) {
        PageParameter parameter = this.getPageParameter();
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(alarmSource);
        alarmVoInfo.setAlarmType(alarmType);
        alarmVoInfo.setConfirmStatus(confirmStatus);
        Long[] createTime = this.getCreateTimeFromReq();
        alarmVoInfo.setCreateTimeEnd(createTime[1]);
        alarmVoInfo.setCreateTimeStart(createTime[0]);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(location);
        alarmVoInfo.setPageSize(parameter.getPageSize());
        alarmVoInfo.setSeverities(severities);
        alarmVoInfo.setOrderBy(parameter.getOrderBy());
        alarmVoInfo.setOrderType(parameter.getOrderType());
        alarmVoInfo.setStartPage(parameter.getStartPage());
        alarmVoInfo.setIsHistorySearch(false);
        return this.getAlarmInfoList(alarmVoInfo);
    }

    private String getAlarmInfoList(AlarmPageVo alarmVoInfo) {
        Paging paging = this.getAlarmInfoListPaging(alarmVoInfo);
        List<AlarmVO> currentAlarmList = FaultActionUtil.convertAlarmPO2VO(paging.getData(), this.getLocale());
        int total = paging.getiCount();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        resultObject.put((Object)"records", currentAlarmList);
        return resultObject.toString();
    }

    private Paging getAlarmInfoListPaging(AlarmPageVo alarmPageVo) {
        String alarmSource = alarmPageVo.getAlarmSource();
        Integer alarmType = alarmPageVo.getAlarmType();
        Integer confirmStatus = alarmPageVo.getConfirmStatus();
        Boolean isHistorySearch = alarmPageVo.getIsHistorySearch();
        String location = alarmPageVo.getLocation();
        int pageSize = alarmPageVo.getPageSize();
        Set<Integer> severities = alarmPageVo.getSeverities();
        String orderBy = alarmPageVo.getOrderBy();
        String orderType = alarmPageVo.getOrderType();
        int startPage = alarmPageVo.getStartPage();
        IAlarmService service = (IAlarmService)this.getBundleService("fault", "alarmService");
        if (VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "modTime";
        }
        Validator.canOrderBy(orderBy);
        boolean orderByAscend = false;
        Map<String, String> map = this.setQueryCondition(severities, confirmStatus, alarmSource, alarmType, location);
        if (orderType != null && orderType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        long userId = -1L;
        User user = this.getCurrentUser();
        if (!"true".equalsIgnoreCase(user.getIsAdmin())) {
            userId = user.getUserId();
        }
        FaultQueryInfo queryInfo = new FaultQueryInfo();
        queryInfo.setFirstRowIndex(startPage * pageSize);
        queryInfo.setTotalRow(pageSize);
        queryInfo.setOrderByField(orderBy);
        queryInfo.setOrderByAscend(orderByAscend);
        Paging paging = service.getAlarmsAndCount(isHistorySearch != false ? FaultEnum.ClearState.CLEARED : FaultEnum.ClearState.UNCLEARED, map, queryInfo, userId);
        return paging;
    }

    private Map<String, String> setQueryCondition(Set<Integer> severities, Integer confirmStatus, String alarmSource, Integer alarmType, String location) {
        Long[] createTime = this.getCreateTimeFromReq();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty((String)alarmSource)) {
            if (!Validator.checkStringLength(FaultActionUtil.decode(alarmSource), 32)) {
                logger.error((Object)("alarmType:" + alarmType));
                throw new LegoCheckedException(250L);
            }
            map.put("moName", HtmlStringConverter.decode(alarmSource));
        }
        this.checkTimeParam(createTime[0], createTime[1], map);
        this.setAlarmSeverity(severities, map);
        if (!VerifyUtil.isEmpty((Object)confirmStatus) && confirmStatus != 0) {
            map.put("confirmStatus", String.valueOf(confirmStatus));
        }
        this.setAlarmType(alarmType, location, map);
        return map;
    }

    private void setAlarmType(Integer alarmType, String location, Map<String, String> map) {
        if (!VerifyUtil.isEmpty((Object)alarmType) && alarmType != 0) {
            map.put("alarmType", String.valueOf(alarmType));
        }
        if (!VerifyUtil.isEmpty((String)location)) {
            if (!Validator.checkStringLength(FaultActionUtil.decode(location), 32)) {
                logger.error((Object)("enter setAlarmType.location:" + location));
                throw new LegoCheckedException(250L);
            }
            map.put("location", location.trim());
        }
    }

    private void setAlarmSeverity(Set<Integer> severities, Map<String, String> map) {
        if (!VerifyUtil.isEmpty(severities)) {
            StringBuilder sb = new StringBuilder();
            Boolean flag = true;
            for (Integer severity : severities) {
                if (severity == 0 || !this.checkSeverity(severity)) {
                    flag = false;
                    break;
                }
                sb.append(severity);
            }
            if (flag.booleanValue() && !VerifyUtil.isEmpty((String)sb.toString())) {
                map.put("severity", sb.toString());
            }
        }
    }

    private void checkTimeParam(Long createTimeStart, Long createTimeEnd, Map<String, String> map) {
        int number = 0;
        if (!VerifyUtil.isEmpty((Object)createTimeStart) && createTimeStart != 0L) {
            Validator.checkLongTime(createTimeStart);
            map.put("createTimeStart", String.valueOf(createTimeStart));
            ++number;
        }
        if (!VerifyUtil.isEmpty((Object)createTimeEnd) && createTimeEnd != 0L) {
            Validator.checkLongTime(createTimeEnd);
            map.put("createTimeEnd", String.valueOf(createTimeEnd));
            ++number;
        }
        if (number == 2 && createTimeStart > createTimeEnd) {
            logger.error((Object)("enter checkTimeParam.number:" + number));
            throw new LegoCheckedException(250L);
        }
    }

    private boolean checkSeverity(Integer severity) {
        List<Integer> severities = Arrays.asList(1, 2, 3, 4);
        return severities.contains(severity);
    }

    private void checkPageQueryParam(AlarmPageVo alarmVo) {
        if (!Validator.checkPageQueryParams(alarmVo.getPageSize(), alarmVo.getStartPage())) {
            logger.error((Object)"alarm params is invalid: pageSize=%s,startPage=%s", new Object[]{alarmVo.getPageSize(), alarmVo.getStartPage()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.confirm"})
    @Logging(name="alarm_confirmAlarm_operateName", rank=3)
    public BatchOperationResult confirmAlarm(Set<BatchOperation> batchOperations) {
        Object object = this.getBundleService("fault", "alarmService");
        IAlarmService service = (IAlarmService)object;
        User currentUser = this.getCurrentUser();
        String usrName = currentUser.getUserName();
        CommUtils.verifyParameterSet(batchOperations);
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : batchOperations) {
            Object extTargetId = batchOperation.getExtTargetId();
            CommUtils.checkParamEmpty(extTargetId);
            String entity = this.decodeByBase64(extTargetId.toString());
            batchOperation.setExtTargetId((Object)entity);
            LegoAlarm legoAlarm = service.getAlarm(entity);
            if (VerifyUtil.isEmpty((Object)legoAlarm)) {
                throw new LegoCheckedException(250L);
            }
            this.checkAlarmPermission(legoAlarm.getSourceId(), legoAlarm.getSourceType());
            batchOperation.setTargetNameParam(legoAlarm.getAlarmParam());
            batchOperation.setTargetName(legoAlarm.getAlarmName());
            bathOprLst.add(batchOperation);
        }
        return service.affirmAlarms(bathOprLst, usrName, true);
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.confirm"})
    @Logging(name="alarm_cancelConfirmAlarm_operateName", rank=3)
    public BatchOperationResult cancelConfirmAlarm(Set<BatchOperation> batchOperations) {
        Object serviceObject = this.getBundleService("fault", "alarmService");
        IAlarmService service = (IAlarmService)serviceObject;
        CommUtils.verifyParameterSet(batchOperations);
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : batchOperations) {
            Object extTargetId = batchOperation.getExtTargetId();
            CommUtils.checkParamEmpty(extTargetId);
            String entity = this.decodeByBase64(extTargetId.toString());
            batchOperation.setExtTargetId((Object)entity);
            LegoAlarm legoAlarm = service.getAlarm(entity);
            if (VerifyUtil.isEmpty((Object)legoAlarm)) {
                logger.error((Object)"enter cancelConfirmAlarm");
                throw new LegoCheckedException(250L);
            }
            this.checkAlarmPermission(legoAlarm.getSourceId(), legoAlarm.getSourceType());
            batchOperation.setTargetNameParam(legoAlarm.getAlarmParam());
            batchOperation.setTargetName(legoAlarm.getAlarmName());
            bathOprLst.add(batchOperation);
        }
        return service.affirmAlarms(bathOprLst, null, false);
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.clear"})
    @Logging(name="alarm_delAlarm_operateName", rank=2)
    public BatchOperationResult clearAlarms(Set<BatchOperation> batchOperations) {
        Object object = this.getBundleService("fault", "alarmService");
        IAlarmService service = (IAlarmService)object;
        User currentUser = this.getCurrentUser();
        String usrName = currentUser.getUserName();
        CommUtils.verifyParameterSet(batchOperations);
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (BatchOperation batchOperation : batchOperations) {
            Object extTargetId = batchOperation.getExtTargetId();
            CommUtils.checkParamEmpty(extTargetId);
            String entity = this.decodeByBase64(extTargetId.toString());
            batchOperation.setExtTargetId((Object)entity);
            LegoAlarm legoAlarm = service.getAlarm(entity);
            if (VerifyUtil.isEmpty((Object)legoAlarm)) {
                logger.error((Object)"enter clearAlarms");
                throw new LegoCheckedException(250L);
            }
            this.checkAlarmPermission(legoAlarm.getSourceId(), legoAlarm.getSourceType());
            batchOperation.setTargetNameParam(legoAlarm.getAlarmParam());
            batchOperation.setTargetName(legoAlarm.getAlarmName());
            bathOprLst.add(batchOperation);
        }
        return service.manualClearAlarms(bathOprLst, usrName);
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.export"})
    @Logging(name="alarm_exportCurrentAlarm_operateName", object="=currentAlarm_objectName", detail="alarm_exportCurrentAlarm_operateDetail_2")
    public Response exportSelectedAlarms(Set<String> alarmIdSet, String orderBy, String orderType) {
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(null);
        alarmVoInfo.setAlarmType(null);
        alarmVoInfo.setConfirmStatus(null);
        alarmVoInfo.setCreateTimeEnd(null);
        alarmVoInfo.setCreateTimeStart(null);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(null);
        alarmVoInfo.setPageSize(0);
        alarmVoInfo.setSeverities(null);
        alarmVoInfo.setOrderBy(orderBy);
        alarmVoInfo.setOrderType(orderType);
        alarmVoInfo.setStartPage(Integer.MAX_VALUE);
        List<LegoAlarm> alarmList = this.getAlarmList(alarmIdSet, alarmVoInfo);
        if (alarmList.size() > 20000) {
            throw new LegoCheckedException(1574L);
        }
        for (LegoAlarm legoAlarm : alarmList) {
            this.checkAlarmPermission(legoAlarm.getSourceId(), legoAlarm.getSourceType());
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportAlarm(alarmList, alarmVoInfo);
        return Response.ok().build();
    }

    private boolean exportAlarm(List<LegoAlarm> alarmList, AlarmPageVo alarmPageVo) {
        boolean ret;
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        File file = new File(downloadPath);
        if (!file.exists() && !(ret = file.mkdir())) {
            return false;
        }
        Long dateTime = System.currentTimeMillis();
        String fileNamePrefix = alarmPageVo.getIsHistorySearch() != false ? "exportHistoryAlarms_" : "exportCurrentAlarms_";
        String fileNameTmp = fileNamePrefix + dateTime + UUIDGenerator.getUUID();
        downloadPath = downloadPath + File.separator + fileNameTmp;
        this.export(downloadPath, alarmList, alarmPageVo);
        return true;
    }

    private List<LegoAlarm> getAlarmList(Set<String> alarmIdSet, AlarmPageVo alarmVoInfo) {
        if (VerifyUtil.isEmpty(alarmIdSet)) {
            Paging paging = this.getAlarmInfoListPaging(alarmVoInfo);
            List alarmList = paging.getData();
            return alarmList;
        }
        ArrayList<String> alarmIds = new ArrayList<String>();
        for (String alarmId : alarmIdSet) {
            String entity = this.decodeByBase64(alarmId);
            alarmIds.add(entity);
        }
        List<LegoAlarm> alarmList = this.getAlarmListForSelected(alarmIds, alarmVoInfo);
        return alarmList;
    }

    private void export(String downloadPath, List<LegoAlarm> alarmList, AlarmPageVo alarmPageVo) {
        HttpServletRequest request = this.getRequest();
        String type = "excel";
        String parameter = request.getParameter("type");
        if (parameter != null) {
            type = parameter;
        }
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("lego.lab.fault.alarmLevel"));
        column.add(this.getText("lego.dic.confirmstatus"));
        column.add(this.getText("lego.lab.fault.saveAlarm.name"));
        column.add(this.getText("lego.dic.warningtype"));
        column.add(this.getText("lego.lab.fault.alarmCount"));
        column.add(this.getText("lego.lab.fault.saveAlarm.alarmSource"));
        column.add(this.getText("lego.lab.fault.firstTime"));
        column.add(this.getText("lego.lab.fault.lastTime"));
        if (alarmPageVo.getIsHistorySearch().booleanValue()) {
            column.add(this.getText("lego.lab.fault.clearTime"));
        }
        FileUtil fileUtil = FileFactory.getFileUtil(type);
        fileUtil.fileSet("", column, downloadPath);
        if (Locale.SIMPLIFIED_CHINESE.equals(this.getRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            fileUtil.setStrChar("GBK");
        }
        User currentUser = this.getCurrentUser();
        fileUtil.setStrUsrName(currentUser.getUserName());
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String data = df.format(System.currentTimeMillis());
        String fileNamePrefix = alarmPageVo.getIsHistorySearch() != false ? "HistoryAlarms_" : "CurrentAlarms_";
        fileUtil.setDownFileName(fileNamePrefix + data);
        fileUtil.writeFile(this.alarmToStr(alarmList, alarmPageVo));
        try {
            fileUtil.closeFile();
        }
        catch (IOException e) {
            logger.error((Object)"close file failed", 90160758787071L);
        }
        fileUtil.downloadFile(this.getResponse());
    }

    private List<LegoAlarm> getAlarmListForSelected(List<String> alarmIds, AlarmPageVo alarmVoInfo) {
        String orderBy = alarmVoInfo.getOrderBy();
        String orderType = alarmVoInfo.getOrderType();
        IAlarmService service = (IAlarmService)this.getBundleService("fault", "alarmService");
        ArrayList<String> ids = new ArrayList<String>();
        if (VerifyUtil.isEmpty(alarmIds)) {
            return new ArrayList<LegoAlarm>();
        }
        for (String id : alarmIds) {
            ids.add(id);
        }
        boolean orderByAscend = false;
        if (orderType != null && orderType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        String orderByField = AlarmExtend.resetOrderField(orderBy);
        Validator.canOrderBy(orderBy);
        return service.getAlarmsByIds(ids, orderByField, orderByAscend);
    }

    public List<List<String>> alarmToStr(List<LegoAlarm> allAlarmList, AlarmPageVo alarmPageVo) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        if (null == allAlarmList) {
            return lstStr;
        }
        for (LegoAlarm legoAlarm : allAlarmList) {
            if (null == legoAlarm) continue;
            String[] param = new String[]{};
            if (null != legoAlarm.getAlarmParam()) {
                param = legoAlarm.getAlarmParam();
            }
            String[] paramLocal = this.addLocalParam(param);
            ArrayList<String> tempLst = new ArrayList<String>();
            FaultExportUtil.convertAlarmLevel(legoAlarm.getAlarmLevel().getValue(), tempLst, this);
            FaultExportUtil.convertConfirmStatus(legoAlarm.getConfirmStatus().getValue(), tempLst, legoAlarm.getConfirmUser(), this);
            tempLst.add(this.getText(legoAlarm.getAlarmName(), paramLocal));
            FaultExportUtil.convertAlarmType(legoAlarm.getAlarmType(), tempLst, this);
            tempLst.add(String.valueOf(legoAlarm.getAlarmCount()));
            tempLst.add(legoAlarm.getMoName());
            tempLst.add(FaultActionUtil.formateTime(legoAlarm.getGmt(), legoAlarm.getFirstTime()));
            tempLst.add(FaultActionUtil.formateTime(legoAlarm.getGmt(), legoAlarm.getAlarmTime()));
            if (null != alarmPageVo && alarmPageVo.getIsHistorySearch().booleanValue()) {
                tempLst.add(FaultActionUtil.formateTime(legoAlarm.getGmt(), legoAlarm.getClearTime()));
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private String[] addLocalParam(String[] param) {
        String[] paramLocal = new String[]{};
        if (null != param) {
            int paramLength = param.length;
            paramLocal = new String[paramLength];
            for (int i = 0; i < paramLength; ++i) {
                try {
                    paramLocal[i] = this.getText(FaultActionUtil.replaceParam(param[i]));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"There is a Exception.", 90160758787071L);
                    paramLocal[i] = param[i];
                }
            }
        }
        return paramLocal;
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.export"})
    @Logging(name="alarm_exportCurrentAlarm_operateName", object="=currentAlarm_objectName", detail="alarm_exportCurrentAlarm_operateDetail_1")
    public Response exportAllAlarms(Set<Integer> severities, Integer confirmStatus, String alarmSource, Integer alarmType, String location) {
        PageParameter parameter = this.getPageParameter();
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(alarmSource);
        alarmVoInfo.setAlarmType(alarmType);
        alarmVoInfo.setConfirmStatus(confirmStatus);
        Long[] createTime = this.getCreateTimeFromReq();
        alarmVoInfo.setCreateTimeEnd(createTime[1]);
        alarmVoInfo.setCreateTimeStart(createTime[0]);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(location);
        alarmVoInfo.setPageSize(Integer.MAX_VALUE);
        alarmVoInfo.setSeverities(severities);
        alarmVoInfo.setOrderBy(parameter.getOrderBy());
        alarmVoInfo.setOrderType(parameter.getOrderType());
        alarmVoInfo.setStartPage(parameter.getStartPage());
        alarmVoInfo.setIsHistorySearch(false);
        List<LegoAlarm> alarmList = this.getAlarmList(null, alarmVoInfo);
        if (alarmList.size() > 20000) {
            throw new LegoCheckedException(1574L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportAlarm(alarmList, alarmVoInfo);
        return Response.ok().build();
    }

    Long[] getCreateTimeFromReq() {
        HttpServletRequest req = this.getRequest();
        String createTimeStart = req.getParameter("createTimeStart");
        String createTimeEnd = req.getParameter("createTimeEnd");
        Long[] createTimeArray = new Long[]{VerifyUtil.isEmpty((String)createTimeStart) ? Long.valueOf(0L) : NumberUtil.convertToLong((Object)createTimeStart), VerifyUtil.isEmpty((String)createTimeEnd) ? Long.valueOf(0L) : NumberUtil.convertToLong((Object)createTimeEnd)};
        return createTimeArray;
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.event.scan"})
    public AlarmTransferStorageConfigVo queryAlarmTransferStorageCfg() {
        AlarmTransferStorageConfigVo vo = new AlarmTransferStorageConfigVo();
        Object obj = this.getBundleService("task", "task");
        ITaskService taskService = (ITaskService)obj;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.eventType);
        List taskList = taskService.queryTasks(condition);
        vo.setLanguageType(1);
        vo.setTransferStartTime(this.defaultTime);
        if (null == taskList || taskList.isEmpty()) {
            vo.setPeriod(DEFAULT_CYCLE_DATE);
            vo.setDataSavedTime(DEFAULT_RESER_DATE);
            vo.setFileType(this.defaultFilestyle);
            vo.setLanguageType(1);
            Date firstStorageTime = this.getFirstStorageTime(vo);
            if (firstStorageTime != null) {
                vo.setBaseTime(firstStorageTime.getTime());
            }
        } else {
            this.parseParameters(taskList, vo);
        }
        return vo;
    }

    private Date getFirstStorageTime(AlarmTransferStorageConfigVo vo) {
        Date fristRunTime = null;
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Date nextDay = cal.getTime();
        try {
            fristRunTime = dateFormat.parse(formatDay.format(nextDay) + " " + vo.getTransferStartTime());
        }
        catch (ParseException e) {
            logger.error((Object)"StorageAction getFirstStorageTime:", (Throwable)e, 250L);
        }
        return fristRunTime;
    }

    private void parseParameters(List<Task> taskList, AlarmTransferStorageConfigVo vo) {
        vo.constructVOParametersFromTaskList(taskList);
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.event.modify"})
    @Logging(name="dataMaintainence_setAlarmDump_operateName", rank=3, object="=alarmDump_objectName")
    public Response modfiyAlarmTransferStorageCfg(AlarmTransferStorageConfigVo vo) {
        AlarmRestSerivceValidator.checkParameters(vo);
        ITaskService taskService = (ITaskService)this.getBundleService("task", "task");
        String time = vo.getTransferStartTime();
        String[] timeList = time.split(":");
        StringBuffer middleTime = new StringBuffer();
        for (int i = 0; i < timeList.length; ++i) {
            String setTime = timeList[i];
            if (setTime.length() < 2) {
                middleTime.append('0').append(setTime);
            } else {
                middleTime.append(setTime);
            }
            if (i == 2) continue;
            middleTime.append(':');
        }
        time = middleTime.toString();
        vo.setTransferStartTime(time);
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.eventType);
        List taskList = taskService.queryTasks(condition);
        this.updateSystemLogTransferCfg(taskList, taskService, vo);
        return Response.ok().build();
    }

    private void updateSystemLogTransferCfg(List<Task> taskList, ITaskService taskService, AlarmTransferStorageConfigVo vo) {
        logger.debug((Object)"enter updateSystemLogTransferCfg");
        if (VerifyUtil.isEmpty(taskList)) {
            this.generateNewTask(taskService, vo);
        } else {
            Task task = taskList.get(0);
            this.resetTaskParameter(taskService, vo, task);
        }
    }

    private void resetTaskParameter(ITaskService taskService, AlarmTransferStorageConfigVo vo, Task task) {
        AlarmExtend.setBaseTimeAndNextTime(task, vo.getPeriod(), vo.getTransferStartTime());
        TaskParameter taskParameter = task.getParameter();
        taskParameter.setParameter1(String.valueOf(vo.getFileType()));
        taskParameter.setParameter4(vo.getTransferStartTime());
        taskParameter.setParameter2(String.valueOf(vo.getDataSavedTime()));
        taskParameter.setParameter3(String.valueOf(vo.getLanguageType()));
        task.setParameter(taskParameter);
        task.setLastModifyTime(new Date());
        try {
            taskService.updateTask(task);
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(601L, (Throwable)e);
        }
    }

    private void generateNewTask(ITaskService taskService, AlarmTransferStorageConfigVo vo) {
        Task task = new Task();
        task.setTaskName("EventOptStorage");
        TaskType taskTypeTemp = taskService.readTaskType(this.eventType);
        Date currentDate = new Date();
        Date date = this.getFirstStorageTime(vo);
        task.setBaseTime(date);
        task.setCreateTime(currentDate);
        task.setExecuteType(Integer.valueOf(2));
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setPeriod(vo.getPeriod());
        task.setPeriodtimes(Integer.valueOf(-1));
        task.setPeriodType(Integer.valueOf(TaskPeriodType.date.getValue()));
        task.setLastModifyTime(currentDate);
        task.setTaskType(taskTypeTemp);
        task.setCreateUser(Long.valueOf(1L));
        task.setTaskCategory(Integer.valueOf(TaskCategory.system.getValue()));
        task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
        TaskParameter taskParameter = new TaskParameter();
        taskParameter.setParameter1(String.valueOf(vo.getFileType()));
        taskParameter.setParameter2(String.valueOf(vo.getDataSavedTime()));
        taskParameter.setParameter3(String.valueOf(vo.getLanguageType()));
        taskParameter.setParameter4(vo.getTransferStartTime());
        task.setParameter(taskParameter);
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setIsNotifySuccess(Boolean.valueOf(false));
        task.setIsSendMail(Boolean.valueOf(false));
        task.setIsSendNote(Boolean.valueOf(false));
        taskParameter.setTask(task);
        taskService.addTask(task);
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.event.scan"})
    public String queryAlarmTransferStorageTaskList(int startPage, int pageSize) {
        if (startPage < 0 || pageSize < 0) {
            throw new LegoCheckedException(250L);
        }
        Object obj = this.getBundleService("task", "task");
        ITaskService taskService = (ITaskService)obj;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.eventType);
        List taskList = taskService.queryTasks(condition);
        if (VerifyUtil.isEmpty((Collection)taskList)) {
            return "";
        }
        Task task = (Task)taskList.get(0);
        long taskId = task.getTaskId();
        Paging paging = taskService.queryTaskResultList(Long.valueOf(taskId), startPage * pageSize, pageSize);
        List taskRecordList = paging.getData();
        int total = paging.getiCount();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        resultObject.put((Object)"records", this.taskResultListToJsonStr(taskRecordList));
        return resultObject.toString();
    }

    private Object taskResultListToJsonStr(List<TaskResult> taskRecordList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(taskRecordList)) {
            return jsonArray;
        }
        for (TaskResult taskResult : taskRecordList) {
            jsonArray.add(this.taskResultToJsonStr(taskResult));
        }
        return jsonArray;
    }

    private Object taskResultToJsonStr(TaskResult taskResult) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)taskResult)) {
            return jsonObject;
        }
        Date startTime = taskResult.getStartTime();
        jsonObject.put((Object)"startTime", (Object)(startTime != null ? CommUtils.formatDate(new Date(startTime.getTime())) : "--"));
        Date endTime = taskResult.getEndTime();
        jsonObject.put((Object)"endTime", (Object)(endTime != null ? CommUtils.formatDate(new Date(endTime.getTime())) : "--"));
        jsonObject.put((Object)"result", (Object)taskResult.getResult());
        jsonObject.put((Object)"resultInfo", (Object)taskResult.getResultInfo());
        jsonObject.put((Object)"resultId", (Object)taskResult.getResultId());
        jsonObject.put((Object)"resultLink", (Object)taskResult.getResultLink());
        return jsonObject;
    }

    @Override
    @Permission(name={"lego.evtMgr.hisAlarm.scan"})
    public String getHistoryAlarmList(Set<Integer> severities, Integer confirmStatus, String alarmSource, Integer alarmType, String location) {
        PageParameter parameter = this.getPageParameter();
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(alarmSource);
        alarmVoInfo.setAlarmType(alarmType);
        alarmVoInfo.setConfirmStatus(confirmStatus);
        Long[] createTime = this.getCreateTimeFromReq();
        alarmVoInfo.setCreateTimeEnd(createTime[1]);
        alarmVoInfo.setCreateTimeStart(createTime[0]);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(location);
        alarmVoInfo.setPageSize(parameter.getPageSize());
        alarmVoInfo.setSeverities(severities);
        alarmVoInfo.setOrderBy(parameter.getOrderBy());
        alarmVoInfo.setOrderType(parameter.getOrderType());
        alarmVoInfo.setStartPage(parameter.getStartPage());
        alarmVoInfo.setIsHistorySearch(true);
        this.checkPageQueryParam(alarmVoInfo);
        return this.getAlarmInfoList(alarmVoInfo);
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.scan"})
    public String getAlarmTypes(String mainType, String subType, Set<Integer> severities) {
        String moMainType = HtmlStringConverter.decode(mainType);
        String moSubType = HtmlStringConverter.decode(subType);
        if (VerifyUtil.isEmpty((String)moMainType) || VerifyUtil.isEmpty((String)moSubType)) {
            throw new LegoCheckedException(250L);
        }
        FaultEnum.AlarmSeverity[] severityArr = null;
        if (!VerifyUtil.isEmpty(severities)) {
            Iterator<Integer> iterator = severities.iterator();
            severityArr = new FaultEnum.AlarmSeverity[severities.size()];
            int i = 0;
            while (iterator.hasNext()) {
                Integer severity = iterator.next();
                CommUtils.checkParamEmpty(severity);
                if (!this.checkSeverity(severity)) continue;
                severityArr[i++] = FaultEnum.AlarmSeverity.getSeverity((int)severity);
            }
        }
        FaultEnum.TrapType[] trapTypeArr = new FaultEnum.TrapType[]{FaultEnum.TrapType.FAULT, FaultEnum.TrapType.RESTORE};
        IFaultDefineService service = (IFaultDefineService)this.getBundleService("fault", "faultDefineService");
        if (service == null) {
            throw new LegoCheckedException(1073947395L);
        }
        List typeList = service.getFaultDefineList(moMainType, moSubType, severityArr, trapTypeArr);
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)typeList.size());
        resultObject.put((Object)"records", (Object)CommUtils.responseJsonArrayResult(typeList));
        return resultObject.toString();
    }

    @Override
    @Permission(name={"lego.evtMgr.hisAlarm.export"})
    @Logging(name="alarm_exportHistoryAlarm_operateName", object="=historialAlarm_objectName", detail="alarm_exportHistoryAlarm_operateDetail_2")
    public Response exportSelectedHistoryAlarms(Set<String> alarmIdSet, String orderBy, String orderType) {
        PageParameter parameter = this.getPageParameter();
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(null);
        alarmVoInfo.setAlarmType(null);
        alarmVoInfo.setConfirmStatus(null);
        alarmVoInfo.setCreateTimeEnd(null);
        alarmVoInfo.setCreateTimeStart(null);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(null);
        alarmVoInfo.setPageSize(Integer.MAX_VALUE);
        alarmVoInfo.setSeverities(null);
        alarmVoInfo.setOrderBy(parameter.getOrderBy());
        alarmVoInfo.setOrderType(parameter.getOrderType());
        alarmVoInfo.setStartPage(0);
        alarmVoInfo.setIsHistorySearch(true);
        List<LegoAlarm> alarmList = this.getAlarmList(alarmIdSet, alarmVoInfo);
        if (alarmList.size() > 20000) {
            throw new LegoCheckedException(1575L);
        }
        for (LegoAlarm legoAlarm : alarmList) {
            this.checkAlarmPermission(legoAlarm.getSourceId(), legoAlarm.getSourceType());
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportAlarm(alarmList, alarmVoInfo);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.evtMgr.hisAlarm.export"})
    @Logging(name="alarm_exportHistoryAlarm_operateName", object="=historialAlarm_objectName", detail="alarm_exportHistoryAlarm_operateDetail_1")
    public Response exportAllHistoryAlarms(Set<Integer> severities, Integer confirmStatus, String alarmSource, Integer alarmType, String location) {
        PageParameter parameter = this.getPageParameter();
        AlarmPageVo alarmVoInfo = new AlarmPageVo();
        alarmVoInfo.setAlarmSource(alarmSource);
        alarmVoInfo.setAlarmType(alarmType);
        alarmVoInfo.setConfirmStatus(confirmStatus);
        Long[] createTime = this.getCreateTimeFromReq();
        alarmVoInfo.setCreateTimeEnd(createTime[1]);
        alarmVoInfo.setCreateTimeStart(createTime[0]);
        alarmVoInfo.setIsHistorySearch(false);
        alarmVoInfo.setLocation(location);
        alarmVoInfo.setPageSize(Integer.MAX_VALUE);
        alarmVoInfo.setSeverities(severities);
        alarmVoInfo.setOrderBy(parameter.getOrderBy());
        alarmVoInfo.setOrderType(parameter.getOrderType());
        alarmVoInfo.setStartPage(parameter.getStartPage());
        alarmVoInfo.setIsHistorySearch(true);
        this.checkPageQueryParam(alarmVoInfo);
        List<LegoAlarm> alarmList = this.getAlarmList(null, alarmVoInfo);
        if (alarmList.size() > 20000) {
            throw new LegoCheckedException(1575L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportAlarm(alarmList, alarmVoInfo);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.scan", "lego.evtMgr.hisAlarm.scan"})
    public AlarmVO getAlarm(String alarmId) {
        if (VerifyUtil.isEmpty((String)alarmId)) {
            logger.error((Object)"alarmId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String entity = this.decodeByBase64(alarmId);
        CommUtils.checkParamEmpty(entity);
        IAlarmService alarmService = (IAlarmService)this.getBundleService("fault", "alarmService");
        LegoAlarm alarm = alarmService.getAlarm(entity);
        CommUtils.checkObjectExists(alarm);
        FaultEnum.ClearState clearStatus = alarm.getClearStatus();
        String operationName = "alarm_queryCurrentAlarm_operateName";
        int level = 2;
        if (clearStatus.getValue() == 1) {
            operationName = "alarm_queryHistoryAlarm_operateName";
            level = 2;
        }
        CommUtils.checkObjectExists(alarm);
        this.checkAlarmMoAuthority(alarm.getSourceId(), alarm.getSourceType(), operationName, level);
        return FaultActionUtil.convertAlarmPO2VO(alarm, null, this.getLocale());
    }

    private void checkAlarmMoAuthority(String entity, String operateName, int level) {
        IAlarmService service = (IAlarmService)this.getBundleService("fault", "alarmService");
        LegoAlarm alarm = service.getAlarm(entity);
        CommUtils.checkObjectExists(alarm);
        this.checkAlarmMoAuthority(alarm.getSourceId(), alarm.getSourceType(), operateName, level);
    }

    private void checkAlarmMoAuthority(String sourceId, String sourceType, String operateName, int level) {
        if (ADMIN_ID.equals(this.getCurrentUserId())) {
            return;
        }
        if (VerifyUtil.isEmpty((String)sourceId) || VerifyUtil.isEmpty((String)sourceType) || FaultEnum.AlarmResourceType.UNDEFINED.getValue().equals(sourceType)) {
            return;
        }
        if (FaultEnum.AlarmResourceType.NETWORKENTITY.getValue().equals(sourceType)) {
            this.checkUserMoAuthority(operateName, level, sourceId);
        } else {
            this.checkUserBizObjAuthority(operateName, level, sourceId);
        }
    }

    private void checkAlarmPermission(String sourceId, String sourceType) {
        if (ADMIN_ID.equals(this.getCurrentUserId())) {
            return;
        }
        if (VerifyUtil.isEmpty((String)sourceId) || VerifyUtil.isEmpty((String)sourceType) || FaultEnum.AlarmResourceType.UNDEFINED.getValue().equals(sourceType)) {
            return;
        }
        if (FaultEnum.AlarmResourceType.NETWORKENTITY.getValue().equals(sourceType)) {
            this.permissionService.checkUserMoAuthority(sourceId);
        } else {
            this.permissionService.checkUserGrantedObject(sourceId);
        }
    }

    private String decodeByBase64(String alarmId) {
        byte[] alarmIdBytes = Base64.base64ToByteArray((String)alarmId);
        String entity = new String(alarmIdBytes, Charset.defaultCharset());
        logger.info((Object)("decodeByBase64:" + entity), 90160758786816L);
        return entity;
    }

    @Override
    @Permissions(value={@Permission(name={"lego.evtMgr.curtAlarm.scan"}), @Permission(name={"lego.evtMgr.hisAlarm.scan"})})
    public List<AlertExperience> getAdviseList(String alarmId) {
        String entity = this.decodeByBase64(alarmId);
        CommUtils.checkParamEmpty(entity);
        IAlarmService alarmService = (IAlarmService)this.getBundleService("fault", "alarmService");
        LegoAlarm alarm = alarmService.getAlarm(entity);
        CommUtils.checkObjectExists(alarm);
        FaultEnum.ClearState clearStatus = alarm.getClearStatus();
        String operationName = "alarm_queryCurrentAlarm_operateName";
        int level = 2;
        if (clearStatus.getValue() == 1) {
            operationName = "alarm_queryHistoryAlarm_operateName";
            level = 2;
        }
        IAlertExperienceService service = (IAlertExperienceService)this.getBundleService("fault", "alertExperienceService");
        this.checkAlarmMoAuthority(entity, operationName, level);
        return service.getAlertExperiences(alarm.getAlarmName());
    }

    private void writeOperationLog(String operationName, int level) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog(operationName, this.getCurrentUser().getUserName(), level, "lego.err.1073947400", "", AlarmRestServiceImpl.getRemoteAddr(this.getRequest()));
        SysOpLogBuilder.writeOperateLog(sysOptLog);
        throw new LegoCheckedException(1073947400L);
    }

    private Boolean hasRight(String i18nKey) {
        Long userId = this.getCurrentUserId();
        if (userId == null) {
            logger.error((Object)"Cannot get current user.", 653110170615808L);
            return false;
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        return mgr.checkUserRight(userId.longValue(), i18nKey);
    }

    @Override
    @Context(name="alarm")
    @Permission(name={"lego.evtMgr.curtAlarm.experiences"})
    @Logging(name="remoteMaintainence_addMaitainExperience_operateName", object="$alarm")
    public Response addAlertExperience(String alarmId, AlertExperience experience) {
        String entity = this.decodeByBase64(alarmId);
        AlarmRestSerivceValidator.addAlertExperienceCheck(entity, experience);
        IAlarmService alarmService = (IAlarmService)this.getBundleService("fault", "alarmService");
        LegoAlarm alarm = alarmService.getAlarm(entity);
        CommUtils.checkObjectExists(alarm);
        this.checkAlarmPermission(alarm.getSourceId(), alarm.getSourceType());
        Context.Variable.set((String)"alarm", (Object)alarm.getAlarmName());
        IAlertExperienceService service = (IAlertExperienceService)this.getBundleService("fault", "alertExperienceService");
        User currentUser = this.getCurrentUser();
        String usrName = currentUser.getUserName();
        service.addAlertExperience(alarm.getAlarmName(), usrName, experience.getExperience());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.experiences"})
    @Logging(name="remoteMaintainence_delMaitainExperience_operateName")
    public BatchOperationResult deleteExperience(Set<Long> ids) {
        AlarmRestSerivceValidator.deleteExperienceCheck(ids);
        Object object = this.getBundleService("fault", "alertExperienceService");
        IAlertExperienceService experienceService = (IAlertExperienceService)object;
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            AlertExperience experience = experienceService.getAlertExperience(id.longValue());
            CommUtils.checkObjectExists(experience);
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id.longValue());
            tempBatch.setTargetName(experience.getAlertId());
            bathOprLst.add(tempBatch);
        }
        return experienceService.deleteAlertExperiences(bathOprLst);
    }

    @Override
    @Permission(name={"lego.evtMgr.curtAlarm.scan"})
    public String getAlarmCountDetail(String alarmId, int startPage, String orderBy, String orderType, int pageSize) {
        String entity = this.decodeByBase64(alarmId);
        this.checkAlarmMoAuthority(entity, "alarm_queryCurrentAlarm_operateName", 2);
        IAlarmService service = (IAlarmService)this.getBundleService("fault", "alarmService");
        String orderField = "";
        boolean orderByAscend = true;
        if (orderBy != null) {
            orderField = orderBy;
            if (orderType.equalsIgnoreCase("desc")) {
                orderByAscend = false;
            }
            if (orderBy.equals("modTime")) {
                orderField = "modTime";
            }
            if (orderBy.equals("confirmTime")) {
                orderField = "confirmTime";
            }
            if (orderBy.equals("clearTime")) {
                orderField = "clearTime";
            }
        }
        User currentUser = this.getCurrentUser();
        long userId = -1L;
        if (!"true".equalsIgnoreCase(currentUser.getIsAdmin())) {
            userId = currentUser.getUserId();
        }
        Paging paging = service.getAlarmDetails(entity, orderField, orderByAscend, startPage * pageSize, pageSize, userId);
        List<AlarmDetailVO> alarmDetails = FaultActionUtil.convertAlarmDetailVO(paging.getData());
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)paging.getiCount());
        resultObject.put((Object)"records", alarmDetails);
        return resultObject.toString();
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.event.delete"})
    @Logging(name="dataMaintainence_deleteAlarmDumpFile_operateName", rank=2)
    public BatchOperationResult deleteTaskResults(Set<Long> ids) {
        ITaskService mgr = (ITaskService)this.getBundleService("task", "task");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        if (VerifyUtil.isEmpty(ids)) {
            throw new LegoCheckedException(250L);
        }
        ArrayList<String> resultLinkList = new ArrayList<String>();
        for (long id : ids) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id);
            TaskResult taskResult = mgr.readTaskResult(id);
            CommUtils.checkObjectExists(taskResult);
            tempBatch.setTargetName(taskResult.getResultLink());
            resultLinkList.add(taskResult.getResultLink());
            bathOprLst.add(tempBatch);
        }
        this.deleteTaskResultsFile(2, resultLinkList);
        return mgr.deleteTaskResultList(bathOprLst);
    }

    private void deleteTaskResultsFile(int taskType, List<String> boxNames) {
        if (VerifyUtil.isEmpty(boxNames)) {
            return;
        }
        ITaskService mgr = (ITaskService)this.getBundleService("task", "task");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (int i = 0; i < boxNames.size(); ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetName(boxNames.get(i));
            bathOprLst.add(tempBatch);
        }
        mgr.deleteFile(taskType, bathOprLst);
    }

    @Override
    @Context(name="object")
    @Permission(name={"lego.sys.dataStorage.event.scan"})
    @Logging(name="dataMaintainence_downloadAlarmDumpFile_operateName", object="$object")
    public Response exportAlarmTransferStorage(long fileId) {
        int taskType = 2;
        ITaskService taskService = (ITaskService)this.getBundleService("task", "task");
        logger.info((Object)("exportOptLogTransferStorage fileId:" + fileId));
        TaskResult result = taskService.readTaskResult(fileId);
        if (result == null) {
            throw new LegoCheckedException(1291L);
        }
        String downloadFileName = result.getResultLink();
        Context.Variable.set((String)"object", (Object)downloadFileName);
        if (!taskService.checkFile(2, downloadFileName).booleanValue()) {
            throw new LegoCheckedException(1291L);
        }
        if (!taskService.checkFileSize(2, downloadFileName).booleanValue()) {
            throw new LegoCheckedException(1297L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        new LogRestServiceImpl().downloadFile(2, downloadFileName, taskService, this.getResponse());
        return Response.ok().build();
    }

    @Override
    public Response sendAlarm(ThirdAlarmVo alarmVo) {
        User user = this.getCurrentUser();
        if (null == user || !user.isSyncAdmin()) {
            logger.info((Object)"send alarm failed, user name is null or not SyncAdmin.");
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)("recive a third alarm, alarmId=" + alarmVo.getAlarmId() + ", alarm source: " + alarmVo.getMoName()));
        this.checkParams(alarmVo);
        LegoAlarm legoAlarm = AlarmExtend.convertAlarmVoToLegoAlarm(alarmVo);
        try {
            IAlarmService service = this.getBundleService("fault", "alarmService", IAlarmService.class);
            service.dealWithThirdAlarm(legoAlarm, alarmVo.getType().intValue());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"sendAlarm failed.", (Throwable)e);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return Response.ok().build();
    }

    private void checkParams(ThirdAlarmVo alarmVo) {
        if (null == alarmVo.getAlarmId()) {
            logger.error((Object)"sendAlarm failed, alarmId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == alarmVo.getSeverity() || FaultEnum.AlarmSeverity.ILLEGAL == FaultEnum.AlarmSeverity.getSeverity((int)alarmVo.getSeverity())) {
            logger.error((Object)("sendAlarm failed, alarm serverity is illegal: " + alarmVo.getSeverity()));
            throw new LegoCheckedException(1073947393L);
        }
        if (null == alarmVo.getType() || !GENERALARM.equals(alarmVo.getType()) && !RESTOREALARM.equals(alarmVo.getType())) {
            logger.error((Object)("sendAlarm failed, alarm type is illegal: " + alarmVo.getType()));
            throw new LegoCheckedException(1073947393L);
        }
        if (null == alarmVo.getCreateTime()) {
            logger.error((Object)"sendAlarm failed, alarm createtime is illegal");
            throw new LegoCheckedException(1073947393L);
        }
        if (alarmVo.getMoName() != null && alarmVo.getMoName().length() > 1024) {
            logger.error((Object)"SendAlarm failed, length of alarm moName is illegal");
            throw new LegoCheckedException(1073947393L);
        }
        if (alarmVo.getMoIp() != null && alarmVo.getMoIp().length() > 256) {
            logger.error((Object)"SendAlarm failed, length of alarm moIp is illegal");
            throw new LegoCheckedException(1073947393L);
        }
        if (alarmVo.getParam() != null && alarmVo.getParam().length() > 10240) {
            logger.error((Object)"SendAlarm failed, length of alarm params is illegal");
            throw new LegoCheckedException(1073947393L);
        }
    }
}

