/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.alarm.util;

import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 2;
    private static final int NUM_2 = 1;
    private static final int COLUMNWIDTH = 8000;
    private final transient Log LOGGER = FELogFactory.getInstance((String)"ui");
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            this.LOGGER.info((Object)"Do not find the file");
            return;
        }
        this.writeExcelString(dataLst);
    }

    private void writeExcelString(List<List<String>> dataLst) {
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowColUsr = sheet.createRow(0);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(1);
        for (int i = 0; i < num; ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.HSSFColorPredefined.GREEN.getIndex());
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 2;
        if (null == dataLst) {
            return;
        }
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); ++cellNumOfRow) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(CellType.STRING);
                sheet.setColumnWidth(cellNumOfRow, 8000);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(lstStr.get(cellNumOfRow));
                    continue;
                }
                cell.setCellValue("");
            }
            ++rowNumOfSheet;
        }
    }

    @Override
    public void closeFile() throws IOException {
        this.workbook.write((OutputStream)this.getWriteFileOut());
        this.getWriteFileOut().flush();
        this.getWriteFileOut().close();
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailLink) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            this.LOGGER.error((Object)"Write file catch exception.");
            return;
        }
        this.writeExcelWithDetail(dataLst, detailLink);
    }

    private void writeExcelWithDetail(List<List<String>> dataLst, String detailLink) {
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowColUsr = sheet.createRow(0);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(1);
        for (int i = 0; i < num; ++i) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(CellType.STRING);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        VerifyUtil.checkObject((Object)this.workbook);
        short defaultDataFmt = this.workbook.createDataFormat().getFormat("text");
        int rowNumOfSheet = 2;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size() - 1; ++cellNumOfRow) {
                sheet.setColumnWidth(cellNumOfRow, 8000);
                this.writeCell(detailLink, lstStr, row, cellNumOfRow, defaultDataFmt);
            }
            ++rowNumOfSheet;
        }
    }

    private void writeCell(String detailLink, List<String> lstStr, HSSFRow row, int cellNumOfRow, short dataFmt) {
        HSSFCell cell = row.createCell(cellNumOfRow);
        cell.setCellType(CellType.STRING);
        HSSFCellStyle cellStyle = cell.getCellStyle();
        cellStyle.setDataFormat(dataFmt);
        if (null != lstStr.get(cellNumOfRow)) {
            cell.setCellValue(lstStr.get(cellNumOfRow));
        } else {
            cell.setCellValue("");
        }
        String logId = lstStr.get(lstStr.size() - 1);
        if (!logId.equals("-1") && cellNumOfRow == lstStr.size() - 2) {
            HSSFCellStyle linkStyle = this.workbook.createCellStyle();
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Arial");
            font.setUnderline((byte)1);
            font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
            linkStyle.setFont(font);
            String strVal = "";
            if (null != lstStr.get(cellNumOfRow)) {
                strVal = lstStr.get(cellNumOfRow);
            }
            cell.setCellStyle(linkStyle);
            cell.setCellFormula("HYPERLINK(\"" + detailLink + logId + ".txt\",\"" + strVal + "\")");
        }
    }

    public static XSSFCellStyle formatLogCellStyle(XSSFSheet sheet) {
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        short defaultDataFmt = sheet.getWorkbook().createDataFormat().getFormat("text");
        cs.setDataFormat(defaultDataFmt);
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
        return cs;
    }

    public static XSSFCellStyle formatDetailCellStyle(XSSFSheet sheet) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        short defaultDataFmt = sheet.getWorkbook().createDataFormat().getFormat("text");
        cs.setDataFormat(defaultDataFmt);
        cs.setAlignment(HorizontalAlignment.LEFT);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setWrapText(true);
        return cs;
    }
}

