/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.backtask.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.backtask.service.IBackTaskRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class BackTaskRestServiceImpl
extends AbstractRestService
implements IBackTaskRestService {
    private static final Log LOGGER = LogFactory.getInstance(BackTaskRestServiceImpl.class);
    private static final int DEFAULT_TASK_RESULT = -2;
    private static final int FAILED_TASK_RESULT = 1;

    @Override
    @Permission(name={"ism.drm.task.mgt.operateID"})
    public String queryTasks(int taskResult, String taskName, String targetName, int startPage, String orderBy, String orderType, int pageSize) {
        IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
        JSONObject resultObject = new JSONObject();
        if (taskResult > 1) {
            taskResult = -2;
        }
        if (service != null) {
            Map<String, Object> condition = this.getCondition(taskResult, taskName, targetName, orderType, orderBy);
            User user = this.getCurrentUser();
            if (BaseRestUtils.isQuerySelfOnly(user.getUserId())) {
                LOGGER.info((Object)"Need to add username: %s to query task condition.", new Object[]{user.getUserName()});
                condition.put("createUser", user.getUserName());
            }
            Paging paging = service.queryTasks(condition, startPage * pageSize, pageSize);
            List taskList = paging.getData();
            resultObject.put((Object)"totalCount", (Object)paging.getiCount());
            resultObject.put((Object)"records", (Object)this.backTaskListToJsonStr(taskList));
        }
        return resultObject.toString();
    }

    private JSONArray backTaskListToJsonStr(List<BackTask> taskList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(taskList)) {
            return jsonArray;
        }
        for (BackTask backTask : taskList) {
            jsonArray.add((Object)this.backTaskToJsonStr(backTask));
        }
        return jsonArray;
    }

    private JSONObject backTaskToJsonStr(BackTask backTask) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)backTask)) {
            LOGGER.error((Object)"Input backTask is empty.");
            return jsonObject;
        }
        jsonObject.put((Object)"taskId", (Object)backTask.getTaskId());
        jsonObject.put((Object)"taskName", (Object)backTask.getTaskName());
        jsonObject.put((Object)"targetName", (Object)backTask.getTargetName());
        jsonObject.put((Object)"createUser", (Object)backTask.getCreateUser());
        jsonObject.put((Object)"createdTime", backTask.getCreatedTime() != null ? CommUtils.formatDate(backTask.getCreatedTime()) : null);
        jsonObject.put((Object)"startTime", backTask.getStartTime() != null ? CommUtils.formatDate(backTask.getStartTime()) : null);
        jsonObject.put((Object)"endTime", backTask.getEndTime() != null ? CommUtils.formatDate(backTask.getEndTime()) : null);
        jsonObject.put((Object)"taskProgress", (Object)backTask.getTaskProgress());
        jsonObject.put((Object)"taskResult", (Object)backTask.getTaskResult());
        String taskDetail = backTask.getTaskDetail();
        jsonObject.put((Object)"taskDetail", (Object)(taskDetail == null ? "" : taskDetail));
        String taskDetailPara = backTask.getTaskDetailPara();
        jsonObject.put((Object)"taskDetailPara", (Object)(taskDetailPara == null ? "" : taskDetailPara));
        String[] taskDetailParas = backTask.getTaskDetailParas();
        jsonObject.put((Object)"taskDetailParas", (Object)(taskDetailParas == null ? "" : taskDetailParas));
        JSONArray array = new JSONArray();
        Set taskResultSet = backTask.getTaskResultSet();
        if (!VerifyUtil.isEmpty((Collection)taskResultSet)) {
            for (TaskResultItem item : taskResultSet) {
                JSONObject jsonObjectItem = new JSONObject();
                jsonObjectItem.put((Object)"id", (Object)item.getId());
                jsonObjectItem.put((Object)"resName", (Object)item.getResName());
                jsonObjectItem.put((Object)"result", (Object)item.getResult());
                jsonObjectItem.put((Object)"resultItem", null);
                jsonObjectItem.put((Object)"detail", (Object)item.getDetail());
                jsonObjectItem.put((Object)"detailParas", (Object)(null == item.getParam() ? "" : item.getParam().split("\\|")));
                array.add((Object)jsonObjectItem);
            }
        }
        jsonObject.put((Object)"taskResultSet", (Object)array);
        if (null != backTask.getTaskLink() && "ism.drm.pg.export".equals(backTask.getTaskName())) {
            jsonObject.put((Object)"taskLink", (Object)backTask.getTaskLink());
        }
        return jsonObject;
    }

    private Map<String, Object> getCondition(int taskResult, String taskName, String targetName, String orderType, String orderBy) {
        User user;
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if (!VerifyUtil.isEmpty((String)taskName)) {
            condition.put("taskName", taskName);
        }
        if (!VerifyUtil.isEmpty((String)targetName)) {
            condition.put("targetName", targetName);
        }
        if (taskResult != -2) {
            condition.put("taskResult", taskResult);
        }
        if (orderBy != null) {
            if ("desc".equalsIgnoreCase(orderType)) {
                condition.put("DESC", orderBy);
            } else {
                condition.put("ASC", orderBy);
            }
        }
        if (BaseRestUtils.isQuerySelfOnly((user = this.getCurrentUser()).getUserId())) {
            condition.put("createUser", user.getUserName());
        }
        return condition;
    }

    @Override
    @Permission(name={"ism.drm.task.mgt.delete.operateID"})
    @Logging(name="backendTask_delete_operateName", rank=2)
    public BatchOperationResult deleteTasks(Set<Long> taskIds) {
        CommUtils.isNullCollection(taskIds);
        IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        ArrayList taskNameList = Lists.newArrayList();
        ArrayList detectionTaskList = Lists.newArrayList();
        ArrayList deleteReplicaTaskList = Lists.newArrayList();
        for (long taskId : taskIds) {
            BackTask backTask = service.readTask(taskId);
            if ("protectManager_snapshotDetect_operateName".equals(backTask.getTaskName())) {
                detectionTaskList.add(backTask);
            }
            if ("protectManager_snapshotDelete_operateName".equals(backTask.getTaskName())) {
                deleteReplicaTaskList.add(backTask);
            }
            CommUtils.checkObjectExists(backTask);
            taskNameList.add(backTask.getCreateUser());
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(taskId);
            tempBatch.setTargetName(backTask.getTargetName());
            tempBatch.setTaskName(backTask.getTaskName());
            bathOprLst.add(tempBatch);
        }
        this.checkDeletePermission(taskNameList);
        BatchOperationResult result = service.deleteTask(bathOprLst);
        this.cleanDetectionCache(result, detectionTaskList);
        this.cleanDeleteReplicaCache(result, deleteReplicaTaskList);
        return result;
    }

    private void cleanDetectionCache(BatchOperationResult result, List<BackTask> detectionTaskList) {
        if (VerifyUtil.isEmpty(detectionTaskList)) {
            LOGGER.info((Object)"Has no detection task to delete.");
            return;
        }
        if (result.getSucceedCount() == 0) {
            LOGGER.info((Object)"All task failed.");
            return;
        }
        Map<Long, BackTask> taskMap = detectionTaskList.stream().collect(Collectors.toMap(BackTask::getTaskId, e -> e));
        for (BatchOperation batchOperation : result.getResult()) {
            if (!taskMap.containsKey(batchOperation.getTargetId()) || batchOperation.getErrorCode() != 0L) {
                LOGGER.info((Object)"Not detection task or detection task failed.");
                continue;
            }
            BackTask backTask = taskMap.get(batchOperation.getTargetId());
            if (backTask.getTaskProgress() == 100) continue;
            this.getBundleService(IProtectionTaskService.class).cleanDetectionCacheAfterDeleteBackTask(backTask);
        }
    }

    private void cleanDeleteReplicaCache(BatchOperationResult result, List<BackTask> deleteReplicaTaskList) {
        if (VerifyUtil.isEmpty(deleteReplicaTaskList)) {
            LOGGER.info((Object)"Has no delete replica task to delete.");
            return;
        }
        if (result.getSucceedCount() == 0) {
            LOGGER.info((Object)"All task failed.");
            return;
        }
        Map<Long, BackTask> taskMap = deleteReplicaTaskList.stream().collect(Collectors.toMap(BackTask::getTaskId, e -> e));
        for (BatchOperation batchOperation : result.getResult()) {
            if (!taskMap.containsKey(batchOperation.getTargetId()) || batchOperation.getErrorCode() != 0L) {
                LOGGER.info((Object)"Not delete replica task or delete replica task failed.");
                continue;
            }
            BackTask backTask = taskMap.get(batchOperation.getTargetId());
            if (backTask.getTaskProgress() == 100) continue;
            this.getBundleService(IProtectionTaskService.class).cleanDeleteReplicaCacheAfterDeleteBackTask(backTask);
        }
    }

    private void checkDeletePermission(List<String> backTask) {
        User currentUser = this.getCurrentUser();
        long userId = currentUser.getUserId();
        if (VerifyUtil.isEmpty((Object)userId) || userId == -1L || StringUtils.equals((CharSequence)"true", (CharSequence)currentUser.getIsAdmin())) {
            return;
        }
        if (backTask.size() != 1 || !backTask.get(0).equals(currentUser.getUserName())) {
            LOGGER.error((Object)"The current user: %s does not have the delete permission.", new Object[]{currentUser.getUserName()});
            throw new LegoCheckedException(1073947400L);
        }
    }

    @Override
    @Permission(name={"ism.drm.task.mgt.operateID"})
    public String queryTask(long taskId) {
        if (taskId <= 0L) {
            throw new LegoCheckedException(1073947393L);
        }
        IBackTaskService service = (IBackTaskService)this.getBundleService("task", "backTask");
        BackTask backTask = service.readTask(taskId);
        if (backTask == null) {
            throw new LegoCheckedException(2117645L);
        }
        String taskCreateUser = backTask.getCreateUser();
        User user = this.getCurrentUser();
        String username = user.getUserName();
        if (BaseRestUtils.isQuerySelfOnly(user.getUserId()) && !username.equals(taskCreateUser)) {
            LOGGER.error((Object)"The current user: %s does not have the view permission.", new Object[]{username});
            throw new LegoCheckedException(1073948485L);
        }
        JSONObject resultObject = this.backTaskToJsonStr(backTask);
        return resultObject.toString();
    }
}

