/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.integration.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.integration.model.LegoToken;
import com.huawei.ism.drm.rest.service.framework.integration.service.IIntegrationService;
import com.huawei.ism.drm.rest.service.framework.integration.service.TokenMgr;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class IntegrationServiceImpl
extends AbstractRestService
implements IIntegrationService {
    private static final Log LOGGER = LogFactory.getInstance(IntegrationServiceImpl.class);
    private static final int PWD_NOT_EXPIRED = -1;
    private static final String COOKIE_PATH = "/src/";
    private static final int DAY_MS = 86400000;
    private static final int STR_PWD_USER_LEN = 2;

    @Override
    public void getToken() {
        HttpServletRequest request = this.getRequest();
        String rmoteAddr = request.getRemoteAddr();
        LOGGER.info((Object)("#### getToken begin rd: " + rmoteAddr), 653110170615808L);
        String account = null;
        String userPwd = null;
        StringBuilder paramsb = this.getRequestStr(request);
        if (paramsb == null) {
            return;
        }
        if (paramsb.toString().isEmpty()) {
            LOGGER.error((Object)"getToken param is null ", 653110170615808L);
            this.responseResult("");
            return;
        }
        String[] params = paramsb.toString().split("&");
        for (int i = 0; i < params.length; ++i) {
            String value;
            String[] param = params[i].split("=");
            if (param.length != 2) {
                LOGGER.error((Object)"wrong param", 653110170615808L);
                this.responseResult("");
                return;
            }
            try {
                value = URLDecoder.decode(param[1], "utf-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)"param can not be decode.", 653110170615808L);
                this.responseResult("");
                return;
            }
            if (param[0].equals("user")) {
                account = value;
                continue;
            }
            if (!param[0].equals("pwd")) continue;
            userPwd = value;
        }
        LOGGER.info((Object)("getToken param, user: " + account), 653110170615808L);
        if (!this.checkUserAndPassword(account, userPwd)) {
            LOGGER.error((Object)"the account info is invalid.", 653110170615808L);
            this.responseResult("");
            return;
        }
        User userObj = new User();
        userObj.setUserName(account);
        userObj.setUserPassword(userPwd);
        userObj.setIpAdr(IntegrationServiceImpl.getRemoteAddr(request));
        if (!this.checkUserPwd(userObj)) {
            LOGGER.error((Object)"the user name or password is not correct.", 653110170615808L);
            this.responseResult("");
            return;
        }
        String token = TokenMgr.generateToken(userObj);
        this.responseResult(token);
        LOGGER.info((Object)"Get token succ!", 653110170615808L);
        LOGGER.info((Object)("####\u3000getToken end rd: " + rmoteAddr), 653110170615808L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getRequestStr(HttpServletRequest request) {
        StringBuilder paramsb = new StringBuilder();
        SafeBufferedReader safeBufReader = null;
        try {
            String line;
            ServletInputStream sis = request.getInputStream();
            InputStreamReader isr = new InputStreamReader((InputStream)sis, StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            safeBufReader = new SafeBufferedReader((Reader)br);
            while ((line = safeBufReader.readLine()) != null) {
                paramsb.append(line);
            }
            CommonUtil.close((Closeable)safeBufReader);
        }
        catch (IOException e) {
            LOGGER.error((Object)"get param error", 653110170615808L);
            this.responseResult("");
            StringBuilder stringBuilder = null;
            return stringBuilder;
        }
        finally {
            CommonUtil.close(safeBufReader);
        }
        return paramsb;
    }

    private boolean checkUserPwd(User userObj) {
        User tempUser;
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        try {
            tempUser = mgr.login(userObj, true);
            LOGGER.info((Object)("user " + userObj.getUserName() + " login success."), 653110170615808L);
            this.buildLoginSucLog(userObj.getUserName());
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"get token catch lego excpetion:", (Throwable)le, 653110170615808L);
            this.buildLoginFailedLog(userObj.getUserName(), le);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("get token catch excpetion:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.buildLoginFailedLog(userObj.getUserName(), null);
            return false;
        }
        try {
            mgr.logout(tempUser.getSession());
            LOGGER.info((Object)("user " + userObj.getUserName() + " logout success."), 653110170615808L);
            SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog("user_logout_operateName", userObj.getUserName(), 1, null, userObj.getUserName(), IntegrationServiceImpl.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(null);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            return true;
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"logout catch lego excpetion:", (Throwable)le, 653110170615808L);
            this.buildLogoutFailedLog(userObj.getUserName(), le);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)("get token catch excpetion:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.buildLogoutFailedLog(userObj.getUserName(), null);
            return false;
        }
    }

    @Override
    public String loginWithToken(String token, String lang) {
        String clientIp = IntegrationServiceImpl.getRemoteAddr(this.getRequest());
        LegoToken legoToken = TokenMgr.validate(token, clientIp);
        if (null == legoToken) {
            SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_login_operateName", "", 2, "lego.err.1073947393", "", IntegrationServiceImpl.getRemoteAddr(this.getRequest()));
            sysOptLog.setDetailPara(null);
            SysOpLogBuilder.writeOperateLog(sysOptLog);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            String ret = this.doLoginWithToken(legoToken, lang);
            this.buildLoginSucLog(legoToken.getAccount());
            return ret;
        }
        catch (LegoCheckedException le) {
            LOGGER.error((Object)"login system catch lego excpetion:", (Throwable)le, 653110170615808L);
            this.buildLoginFailedLog(legoToken.getAccount(), le);
            return null;
        }
        catch (Exception e) {
            LOGGER.error((Object)("login system catch excpetion:" + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            this.buildLoginFailedLog(legoToken.getAccount(), null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseResult(String string) {
        try (PrintWriter writer = null;){
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store, must-revalidate");
            this.getResponse().setDateHeader("Expires", 0L);
            writer = this.getResponse().getWriter();
            writer.write(string);
            writer.flush();
        }
    }

    private boolean checkUserAndPassword(String userName, String userPwd) {
        if (!Validator.regExpCheck(userName, "^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-.]*$")) {
            return false;
        }
        return !Validator.stringNullTrim(userPwd);
    }

    private String doLoginWithToken(LegoToken legoToken, String lang) {
        HttpServletRequest request = this.getRequest();
        HttpSession oldSession = request.getSession();
        oldSession.removeAttribute("rd_randomStr_HW");
        oldSession.removeAttribute("LOGIN_NEED_LIC ");
        oldSession.removeAttribute("WW_TRANS_I18N_LOCALE");
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        String userName = legoToken.getAccount();
        String userPwd = legoToken.getAccountPwd();
        this.checkUserAndPassword(userName, userPwd);
        User userObj = new User();
        userObj.setUserName(userName);
        userObj.setUserPassword(userPwd);
        userObj.setIpAdr(IntegrationServiceImpl.getRemoteAddr(request));
        User currentUser = mgr.login(userObj, true);
        LOGGER.info((Object)("user " + userName + " login success."), 653110170615808L);
        Object locale = oldSession.getAttribute("WW_TRANS_I18N_LOCALE");
        oldSession.invalidate();
        currentUser.setLoginTime(new Date().getTime());
        currentUser.setIpAdr(IntegrationServiceImpl.getRemoteAddr(request));
        if (null == locale) {
            this.getRequest().getSession().setAttribute("WW_TRANS_I18N_LOCALE", (Object)this.setLocale(lang));
            Cookie languageCookie = new Cookie("rd_language", lang);
            languageCookie.setPath(COOKIE_PATH);
            languageCookie.setSecure(true);
            this.getResponse().addCookie(languageCookie);
        }
        Date date = new Date();
        currentUser.setLoginTime(date.getTime());
        currentUser.setLoginDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date));
        String randomToken = TokenGenerator.getToken(32);
        Cookie randomCookie = new Cookie("rd_randomStr_HW", randomToken);
        randomCookie.setPath(COOKIE_PATH);
        randomCookie.setSecure(true);
        this.getResponse().addCookie(randomCookie);
        this.getSession().setAttribute("rd_randomStr_HW", (Object)randomToken);
        this.getResponse().addHeader("rd_randomStr_HW", randomToken);
        JSONObject jsonObject = new JSONObject();
        this.getSession().setAttribute("passState", (Object)"unknow");
        this.checkUserIsExpire(mgr, jsonObject, currentUser, date);
        this.getSession().setAttribute("currentUser", (Object)currentUser);
        this.getSession().setAttribute("passState", (Object)"ok");
        Cookie userNameCookie = new Cookie("userName", currentUser.getUserName());
        Cookie isAdministratorCookie = new Cookie("isAdministrator", String.valueOf(this.checkIsAdministrator(currentUser.getUserId())));
        userNameCookie.setPath(COOKIE_PATH);
        isAdministratorCookie.setPath(COOKIE_PATH);
        userNameCookie.setSecure(true);
        isAdministratorCookie.setSecure(true);
        jsonObject.put((Object)"userName", (Object)currentUser.getUserName());
        jsonObject.put((Object)"isAdmin", (Object)currentUser.getIsAdmin());
        jsonObject.put((Object)"isAdministrator", (Object)this.checkIsAdministrator(currentUser.getUserId()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)currentUser.getRolesIdsSet());
        jsonObject.put((Object)"rolesIds", (Object)jsonArray);
        this.getResponse().addCookie(userNameCookie);
        this.getResponse().addCookie(isAdministratorCookie);
        try {
            this.getResponse().sendRedirect("../../src/index.html#/home/staticView");
        }
        catch (IOException e) {
            LOGGER.info((Object)"redirect to index page failed.", 653110170615808L);
            throw new LegoCheckedException(1077951770L, (Throwable)e);
        }
        return jsonObject.toString();
    }

    private void checkUserIsExpire(IUserMgr mgr, JSONObject jsonObject, User currentUser, Date date) {
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        jsonObject.put((Object)"expireDay", (Object)-1);
        if (this.checkChangePolicy(currentUser, usrPolicy)) {
            Date passChangeDate = new Date(currentUser.getSetTime());
            long betweenDate = (passChangeDate.getTime() - date.getTime()) / 86400000L + (long)usrPolicy.getUsefulLife().intValue();
            if (betweenDate <= 3L && betweenDate > 0L) {
                this.getSession().setAttribute("passState", (Object)"expiring");
                int iDay = (int)betweenDate + 1;
                jsonObject.put((Object)"expireDay", (Object)iDay);
            } else if (betweenDate <= 0L) {
                this.getSession().setAttribute("passState", (Object)"expired");
                LOGGER.info((Object)"passwordExpired", 653110170615808L);
                throw new LegoCheckedException(308L, "passwordExpired");
            }
        }
    }

    private Locale setLocale(String language) {
        Locale locale = Locale.ENGLISH;
        if (!"en".equalsIgnoreCase(language)) {
            locale = Locale.SIMPLIFIED_CHINESE;
        }
        return locale;
    }

    private boolean checkChangePolicy(User currentUser, UserSecPolicy usrPolicy) {
        return currentUser.getPasswordModel() == 0 && usrPolicy.getUnseal() == 1 && currentUser.getSetTime() > 0L;
    }

    private boolean checkIsAdministrator(long currentUserId) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Set curRoleSet = mgr.getUserBaseInfo(currentUserId).getRolesSet();
        curRoleSet = Optional.ofNullable(curRoleSet).orElseGet(HashSet::new);
        String adminRoleId = "1";
        for (Role tempRole : curRoleSet) {
            String tempRoleId = String.valueOf(tempRole.getRoleId());
            if (!adminRoleId.equals(tempRoleId) && !"administrator".equals(tempRole.getRoleName())) continue;
            return true;
        }
        return false;
    }

    private void buildLoginFailedLog(String userName, LegoCheckedException le) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_login_operateName", userName, 2, "lego.err." + (null == le ? -1L : le.getErrorCode()), userName, IntegrationServiceImpl.getRemoteAddr(this.getRequest()));
        sysOptLog.setDetailPara(null == le ? null : le.getParameters());
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }

    private void buildLogoutFailedLog(String userName, LegoCheckedException le) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeFailureSysOptLog("user_logout_operateName", userName, 2, "lego.err." + (null == le ? -1L : le.getErrorCode()), userName, IntegrationServiceImpl.getRemoteAddr(this.getRequest()));
        sysOptLog.setDetailPara(null == le ? null : le.getParameters());
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }

    private void buildLoginSucLog(String userName) {
        SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog("user_login_operateName", userName, 1, null, userName, IntegrationServiceImpl.getRemoteAddr(this.getRequest()));
        sysOptLog.setDetailPara(null);
        SysOpLogBuilder.writeOperateLog(sysOptLog);
    }
}

