/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.integration.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.integration.model.LegoToken;
import com.huawei.ism.drm.web.util.TokenGenerator;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TokenMgr {
    private static final Log LOG = LogFactory.getInstance(TokenMgr.class);
    private static List<LegoToken> tokens = Collections.synchronizedList(new ArrayList());
    private static final int TOKEN_TIMEOUT = 60000;
    private static final int MAX_TOKEN_NUM = 100;

    private static String generateTokenStr() {
        return TokenGenerator.getToken(32);
    }

    private static LegoToken getToken(User userObj) {
        String tokenStr = TokenMgr.generateTokenStr();
        LegoToken token = new LegoToken();
        token.setToken(tokenStr);
        long createTime = System.currentTimeMillis();
        token.setCreateTime(createTime);
        token.setExpireTime(createTime + 60000L);
        token.setAccount(userObj.getUserName());
        token.setAccountPwd(userObj.getUserPassword());
        token.setClientIp(userObj.getIpAdr());
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateToken(User userObj) {
        Class<TokenMgr> clazz = TokenMgr.class;
        synchronized (TokenMgr.class) {
            if (VerifyUtil.isEmpty((Object)userObj)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return "";
            }
            LegoToken token = TokenMgr.getToken(userObj);
            if (tokens.size() < 100) {
                tokens.add(token);
            } else {
                Collections.sort(tokens);
                LegoToken rtoken = tokens.remove(0);
                tokens.add(token);
                LOG.info((Object)("token cache is over threshold , remove token generate time is " + rtoken.getCreateTime() + ",expire time: " + rtoken.getExpireTime()), 653110170615808L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return token.getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LegoToken validate(String tokenStr, String clientIp) {
        LegoToken result = null;
        Class<TokenMgr> clazz = TokenMgr.class;
        synchronized (TokenMgr.class) {
            long currentTime = System.currentTimeMillis();
            int cleanNum = 0;
            Iterator<LegoToken> iterator = tokens.iterator();
            while (iterator.hasNext()) {
                LegoToken token = iterator.next();
                if (token.getToken().equals(tokenStr) && token.getClientIp().equals(clientIp)) {
                    if (currentTime <= token.getExpireTime()) {
                        result = token;
                        LOG.info((Object)"Token is matched", 653110170615808L);
                    } else {
                        LOG.info((Object)("Token is matched, but is expired. the expireTime is " + token.getExpireTime() + "\uff0c Current time is " + currentTime), 653110170615808L);
                    }
                    iterator.remove();
                    continue;
                }
                if (currentTime <= token.getExpireTime()) continue;
                iterator.remove();
                ++cleanNum;
            }
            LOG.info((Object)("Clean expired token [" + cleanNum + "], tokens size: " + tokens.size()), 653110170615808L);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public static String generateToken(User userObj, String host) {
        return null;
    }
}

