/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.license.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.license.sdk.LicenseCalcBean;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.license.model.FunctionItemVo;
import com.huawei.ism.drm.rest.service.framework.license.model.LicenseInfoVo;
import com.huawei.ism.drm.rest.service.framework.license.service.ILicenseBusiService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.ResourceUtil;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.CodeLog;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.activation.DataHandler;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

public class LicenseBusiServiceImpl
extends AbstractRestService
implements ILicenseBusiService {
    private static final CodeLog LOG = LogFactory.getInstance(LicenseBusiServiceImpl.class, (long)653110170615808L);
    private static final int LIC_SIZE_THRESHOLD = 204800;

    @Override
    @Permission(name={"ism.drm.license.mgt.scan.operateID"})
    public LicenseInfoVo queryBasicInfo() {
        LicenseInfoVo resultInfoVo;
        ILicenseInter mgr = this.getBundleService(ILicenseInter.class.getSimpleName(), ILicenseInter.class);
        List esnInfo = mgr.getEsnInfo();
        LicenseInfoBo bo = mgr.getLicense();
        if (bo == null) {
            resultInfoVo = mgr.isLicenseProbationTimeout() ? this.createBasicLicense() : new LicenseInfoVo();
        } else {
            Locale locale = this.getLocale();
            resultInfoVo = new LicenseInfoVo(bo, locale);
        }
        resultInfoVo.setEsn(esnInfo);
        return resultInfoVo;
    }

    private LicenseInfoVo createBasicLicense() {
        LicenseInfoVo licenseVo = new LicenseInfoVo();
        licenseVo.setFormatVersion("--");
        licenseVo.setLicenseSn("--");
        licenseVo.setActiveTime("--");
        Locale locale = this.getLocale();
        FunctionItemVo fvo = new FunctionItemVo();
        fvo.setFuncName(ResourceUtil.getInstance().getText("LSTQDPMH", locale));
        licenseVo.getFunList().add(fvo);
        return licenseVo;
    }

    @Override
    @Permission(name={"ism.drm.license.mgt.set.operateID"})
    @Logging(name="license_export_operateName", object="=licenseInfo_object_name")
    public Response exportLicense() {
        BufferedOutputStream bos = null;
        try {
            ILicenseInter mgr = this.getBundleService(ILicenseInter.class.getSimpleName(), ILicenseInter.class);
            LicenseInfoBo licenseBo = mgr.getLicenseNotUpdateUseNum();
            if (licenseBo == null) {
                if (mgr.isLicenseProbationTimeout()) {
                    throw new LegoCheckedException(1073947437L);
                }
                throw new LegoCheckedException(1073947419L);
            }
            if (!this.isExportChecked().booleanValue()) {
                Response response = Response.ok().build();
                return response;
            }
            String displayName = "license.xml";
            HttpServletResponse response = this.getResponse();
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-store, must-revalidate");
            response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = licenseBo.getFile();
            bos.write(buff, 0, buff.length);
            bos.flush();
            CommUtils.closeOutputStream(bos);
        }
        catch (IOException e) {
            LOG.error((Object)String.format(Locale.ROOT, "IO error: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(0x300001L, (Throwable)e);
        }
        finally {
            CommUtils.closeOutputStream(bos);
        }
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.license.mgt.set.operateID"})
    @Logging(name="license_import_operateName", rank=2, object="=licenseInfo_object_name")
    public Response importLicense(Attachment file) {
        InputStream is = null;
        try {
            if (VerifyUtil.isEmpty((Object)file)) {
                throw new LegoCheckedException(1073947393L);
            }
            DataHandler dh = file.getDataHandler();
            int length = this.getRequest().getContentLength();
            if (length >= 204800) {
                throw new LegoCheckedException(1073947421L);
            }
            byte[] bytes = new byte[204800];
            is = dh.getInputStream();
            if (is == null) {
                throw new LegoCheckedException(1073947420L);
            }
            int read = is.read(bytes);
            if (read == -1) {
                throw new LegoCheckedException(1073947420L);
            }
            byte[] licenseBytes = new byte[read];
            System.arraycopy(bytes, 0, licenseBytes, 0, read);
            ILicenseInter mgr = this.getBundleService(ILicenseInter.class.getSimpleName(), ILicenseInter.class);
            mgr.activateLic(licenseBytes);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)String.format(Locale.ROOT, "IO error: %s", ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(0x300001L);
            }
            catch (Throwable throwable) {
                CommUtils.closeInputStream(is);
                throw throwable;
            }
        }
        CommUtils.closeInputStream(is);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.license.mgt.scan.operateID"})
    public LicenseCalcBean calculateLicenseConsume(String calculatedSiteIds, String resTypes) {
        ILicenseInter mgr = this.getBundleService(ILicenseInter.class.getSimpleName(), ILicenseInter.class);
        try {
            List<String> siteList = this.parseJsonArray(calculatedSiteIds);
            List<String> resTypeList = this.parseJsonArray(resTypes);
            return mgr.calcLicenseConsume(siteList, resTypeList);
        }
        catch (LegoCheckedException legoEx) {
            LOG.error((Object)String.format(Locale.ROOT, "CalculateLicenseConsume failed: %s", ExceptionUtil.getErrorMessage((Throwable)legoEx)));
            throw legoEx;
        }
    }

    private List<String> parseJsonArray(String jsonArray) {
        JSONArray obj = JSONArray.fromObject((Object)jsonArray);
        return IntStream.range(0, obj.size()).mapToObj(arg_0 -> ((JSONArray)obj).getString(arg_0)).collect(Collectors.toList());
    }
}

