/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.log.service;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FileFactory;
import com.huawei.ism.drm.rest.service.framework.alarm.util.FileUtil;
import com.huawei.ism.drm.rest.service.framework.log.service.ILogRestService;
import com.huawei.ism.drm.rest.service.framework.log.service.model.HighLevelQueryPameter;
import com.huawei.ism.drm.rest.service.framework.log.service.model.SystemLogTransferStorageConfigVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.model.TaskResult;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.cbb.task.sdk.service.TaskCategory;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class LogRestServiceImpl
extends AbstractRestService
implements ILogRestService {
    private static Log log = FELogFactory.getInstance((String)"ui");
    private static final int TWO = 2;
    private static final Integer FILE_STYLE_CSV = 1;
    private static final Integer FILE_STYLE_EXCEL = 2;
    private static final Integer LANG_CHINESE = 2;
    private static final Integer LANG_ENGLISH = 1;
    private static final Integer DEFAULTCYCLEDATE = 30;
    private static final Integer DEFAULTRESERDATE = 90;
    private static final int NUM_3 = 3;
    private static final int DAY_MS = 86400000;
    private static String contentSecurityPolicy = "connect-src 'self';object-src 'self';frame-src 'self';media-src 'self';font-src 'self'";
    private static List<Integer> dangerLevels = Arrays.asList(SysoplogLevel.info.getValue(), SysoplogLevel.warning.getValue(), SysoplogLevel.normal.getValue(), SysoplogLevel.risk.getValue());
    private static final String EXPORT_FILE_PREFIX = "exportLogs_";
    private String defaultTime = "02:00:00";
    private int defaultFilestyle = 1;
    private String sysOptType = "log_bk";

    @Override
    @Permission(name={"lego.sys.sysLog.operLog.scan"})
    public String sysLogQueryList(Long dateFrom, Long dateTo, String cmbResult, Integer[] dangerlevel, Set<String> admins) {
        int startPage;
        PageParameter parameter = this.getPageParameter();
        HighLevelQueryPameter highLevelQueryPameter = new HighLevelQueryPameter(null, dateFrom, dateTo, cmbResult, dangerlevel, admins);
        int pageSize = parameter.getPageSize();
        if (!Validator.checkPageQueryParams(pageSize, startPage = parameter.getStartPage())) {
            log.error((Object)"invalid request pageSize or startPage.");
            throw new LegoCheckedException(1073947393L);
        }
        highLevelQueryPameter.setPageSize(pageSize);
        highLevelQueryPameter.setStartPage(startPage);
        highLevelQueryPameter.setOrderBy(parameter.getOrderBy());
        highLevelQueryPameter.setOrderType(parameter.getOrderType());
        Paging page = this.getPage(highLevelQueryPameter);
        int total = page.getiCount();
        List list = page.getData();
        for (SysOptLog s : list) {
            s.setGmt(CommUtils.formatDate(s.getDate()));
        }
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        resultObject.put((Object)"records", (Object)list);
        return resultObject.toString();
    }

    private boolean viewAllOperLog(long userId) {
        IUserMgr userMgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Boolean hasRightViewAllOperLog = Boolean.FALSE;
        if (null != userMgr) {
            hasRightViewAllOperLog = userMgr.checkUserIsViewAllOperLog(userId);
        }
        return hasRightViewAllOperLog;
    }

    private String viewAllOperLog() {
        User currentUser = this.getCurrentUser();
        IUserMgr userMgr = (IUserMgr)this.getBundleService("user", "usermgr");
        String hasRightViewAllOperLog = "false";
        if (null != userMgr && null != currentUser && userMgr.checkUserIsViewAllOperLog(currentUser.getUserId().longValue()).booleanValue()) {
            hasRightViewAllOperLog = "true";
        }
        return hasRightViewAllOperLog;
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.sysOptLog.scan"})
    public SystemLogTransferStorageConfigVo querySystemLogTransferStorageCfg() {
        SystemLogTransferStorageConfigVo vo = new SystemLogTransferStorageConfigVo();
        Object obj = this.getBundleService("task", "task");
        ITaskService taskService = (ITaskService)obj;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.sysOptType);
        List taskList = taskService.queryTasks(condition);
        vo.setLanguageType(1);
        vo.setTransferStartTime(this.defaultTime);
        if (null == taskList || taskList.isEmpty()) {
            vo.setPeriod(DEFAULTCYCLEDATE);
            vo.setDataSavedTime(DEFAULTRESERDATE);
            vo.setFileType(this.defaultFilestyle);
            vo.setLanguageType(1);
            Date firstStorageTime = this.getFirstStorageTime(vo);
            if (firstStorageTime != null) {
                vo.setBaseTime(firstStorageTime.getTime());
            }
        } else {
            this.parseParameters(taskList, vo);
        }
        return vo;
    }

    private Date getFirstStorageTime(SystemLogTransferStorageConfigVo vo) {
        Date fristRunTime = null;
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        Date nextDay = cal.getTime();
        try {
            fristRunTime = dateFormat.parse(formatDay.format(nextDay) + " " + vo.getTransferStartTime());
        }
        catch (ParseException e) {
            log.error((Object)"StorageAction getFirstStorageTime:", (Throwable)e, 653110170615808L);
        }
        return fristRunTime;
    }

    private void parseParameters(List<Task> taskList, SystemLogTransferStorageConfigVo vo) {
        vo.constructVOParametersFromTaskList(taskList);
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.sysOptLog.modify"})
    @Logging(name="dataMaintainence_setLogDump_operateName", rank=3, object="=logDump_objectName")
    public Response modfiySystemLogTransferStorageCfg(SystemLogTransferStorageConfigVo vo) {
        this.checkParameters(vo);
        ITaskService taskService = (ITaskService)this.getBundleService("task", "task");
        String time = vo.getTransferStartTime();
        String[] timeList = time.split(":");
        StringBuffer middleTime = new StringBuffer();
        for (int i = 0; i < timeList.length; ++i) {
            String setTime = timeList[i];
            int j = 2;
            if (setTime.length() < 2) {
                middleTime.append('0').append(setTime);
            } else {
                middleTime.append(setTime);
            }
            if (i == 2) continue;
            middleTime.append(':');
        }
        time = middleTime.toString();
        vo.setTransferStartTime(time);
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.sysOptType);
        List taskList = taskService.queryTasks(condition);
        this.updateSystemLogTransferCfg(taskList, taskService, vo);
        return Response.ok().build();
    }

    private void updateSystemLogTransferCfg(List<Task> taskList, ITaskService taskService, SystemLogTransferStorageConfigVo vo) {
        if (VerifyUtil.isEmpty(taskList)) {
            this.generateNewTask(taskService, vo);
        } else {
            Task task = taskList.get(0);
            this.resetTaskParameter(taskService, vo, task);
        }
    }

    private void resetTaskParameter(ITaskService taskService, SystemLogTransferStorageConfigVo vo, Task task) {
        int newtaskPeriod;
        Date baseTime = task.getBaseTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        if (null == task.getPeriod() || null == vo.getPeriod()) {
            log.error((Object)"task.getPeriod() is null or cycleDate is null", 653110170615808L);
            throw new LegoCheckedException(601L);
        }
        int taskPeriod = task.getPeriod();
        if (taskPeriod != (newtaskPeriod = vo.getPeriod().intValue())) {
            task.setPeriod(vo.getPeriod());
            Date latelyTime = new Date();
            task.setBaseTime(this.getBaseTime(latelyTime, vo.getTransferStartTime(), "0"));
            task.setNextTime(null);
        } else if (!vo.getTransferStartTime().equalsIgnoreCase(dateFormat.format(baseTime))) {
            this.setBaseTime(task, vo.getTransferStartTime());
        }
        this.setTaskParameter(vo.getFileType(), vo.getDataSavedTime(), vo.getLanguageType(), vo.getTransferStartTime(), task);
        task.setLastModifyTime(new Date());
        try {
            taskService.updateTask(task);
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(601L, (Throwable)e);
        }
    }

    private void generateNewTask(ITaskService taskService, SystemLogTransferStorageConfigVo vo) {
        Task task = new Task();
        TaskType taskTypeTemp = taskService.readTaskType(this.sysOptType);
        task.setTaskName("SystemOptStorage");
        Date currentDate = new Date();
        Date date = this.getFirstStorageTime(vo);
        task.setBaseTime(date);
        task.setCreateTime(currentDate);
        task.setExecuteType(Integer.valueOf(2));
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setPeriod(vo.getPeriod());
        task.setPeriodtimes(Integer.valueOf(-1));
        task.setPeriodType(Integer.valueOf(TaskPeriodType.date.getValue()));
        task.setLastModifyTime(currentDate);
        task.setTaskType(taskTypeTemp);
        task.setCreateUser(Long.valueOf(1L));
        task.setTaskCategory(Integer.valueOf(TaskCategory.system.getValue()));
        task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
        this.setTaskParameter(vo.getFileType(), vo.getDataSavedTime(), vo.getLanguageType(), vo.getTransferStartTime(), task);
        task.setIsNotifyFail(Boolean.valueOf(false));
        task.setIsNotifySuccess(Boolean.valueOf(false));
        task.setIsSendMail(Boolean.valueOf(false));
        task.setIsSendNote(Boolean.valueOf(false));
        taskService.addTask(task);
    }

    private void setTaskParameter(Integer filestyleValue, Integer reserDate, Integer langValue, String time, Task task) {
        TaskParameter taskParameter = task.getParameter();
        if (null == task.getParameter()) {
            taskParameter = new TaskParameter();
        }
        taskParameter.setParameter1(String.valueOf(filestyleValue));
        taskParameter.setParameter2(String.valueOf(reserDate));
        taskParameter.setParameter3(String.valueOf(langValue));
        taskParameter.setParameter4(time);
        task.setParameter(taskParameter);
        taskParameter.setTask(task);
    }

    private void setBaseTime(Task task, String time) {
        Date latelyTime = null != task.getNextTime() ? task.getNextTime() : task.getBaseTime();
        Date nextDate = this.getBaseTime(latelyTime, time);
        if (null != task.getNextTime()) {
            task.setNextTime(nextDate);
        }
        task.setBaseTime(nextDate);
    }

    private void checkParameters(SystemLogTransferStorageConfigVo vo) {
        if (VerifyUtil.isEmpty((Object)vo)) {
            log.error((Object)"Input vo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Integer filestyleValue = vo.getFileType();
        Integer langValue = vo.getLanguageType();
        String time = vo.getTransferStartTime();
        Integer cycleDate = vo.getPeriod();
        Integer reserDate = vo.getDataSavedTime();
        if (this.checkFileStyle(filestyleValue)) {
            throw new LegoCheckedException(250L);
        }
        if (this.checkLang(langValue)) {
            throw new LegoCheckedException(250L);
        }
        if (Validator.stringisNull(time) || !Validator.validateTime(time)) {
            throw new LegoCheckedException(250L);
        }
        int i = 7;
        int j = 120;
        if (this.checkDateRange(cycleDate, 7, 120)) {
            throw new LegoCheckedException(250L);
        }
        if (this.checkDateRange(reserDate, 7, 120)) {
            throw new LegoCheckedException(250L);
        }
    }

    private boolean checkDateRange(Integer cycleDate, int i, int j) {
        return VerifyUtil.isEmpty((Object)cycleDate) || cycleDate < i || cycleDate > j;
    }

    private boolean checkLang(Integer langValue) {
        return null == langValue || !LANG_ENGLISH.equals(langValue) && !LANG_CHINESE.equals(langValue);
    }

    private boolean checkFileStyle(Integer filestyleValue) {
        return null == filestyleValue || !FILE_STYLE_CSV.equals(filestyleValue) && !FILE_STYLE_EXCEL.equals(filestyleValue);
    }

    private Date getBaseTime(Date date, String time1, String cycle) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        if (date.before(new Date())) {
            nextCal.add(5, NumberUtil.convertToInteger((Object)cycle));
        }
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            log.error((Object)"StorageAction getBaseTime:", (Throwable)e, 653110170615808L);
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    private Date getBaseTime(Date date, String time1) {
        Calendar nextCal = Calendar.getInstance();
        nextCal.setTime(date);
        Date baseTime = nextCal.getTime();
        SimpleDateFormat formatDay = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            baseTime = dateFormat.parse(formatDay.format(baseTime) + " " + time1);
        }
        catch (ParseException e) {
            log.error((Object)"StorageAction getBaseTime:", (Throwable)e, 653110170615808L);
        }
        if (baseTime.before(new Date())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(baseTime);
            cal.add(5, 1);
            baseTime = cal.getTime();
        }
        return baseTime;
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.sysOptLog.scan"})
    public String querySystemLogTransferStorageTaskList(int startPage, int pageSize) {
        if (!Validator.checkPageQueryParams(pageSize, startPage)) {
            throw new LegoCheckedException(1073947393L);
        }
        Object obj = this.getBundleService("task", "task");
        ITaskService taskService = (ITaskService)obj;
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("taskType", this.sysOptType);
        List taskList = taskService.queryTasks(condition);
        if (VerifyUtil.isEmpty((Collection)taskList)) {
            return "";
        }
        Task task = (Task)taskList.get(0);
        long taskId = task.getTaskId();
        Paging paging = taskService.queryTaskResultList(Long.valueOf(taskId), startPage * pageSize, pageSize);
        List taskRecordList = paging.getData();
        int total = paging.getiCount();
        JSONObject resultObject = new JSONObject();
        resultObject.put((Object)"totalCount", (Object)total);
        resultObject.put((Object)"records", this.taskResultListToJsonStr(taskRecordList));
        return resultObject.toString();
    }

    private Object taskResultListToJsonStr(List<TaskResult> taskRecordList) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(taskRecordList)) {
            return jsonArray;
        }
        for (TaskResult taskResult : taskRecordList) {
            jsonArray.add(this.taskResultToJsonStr(taskResult));
        }
        return jsonArray;
    }

    private Object taskResultToJsonStr(TaskResult taskResult) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)taskResult)) {
            return jsonObject;
        }
        Date startTime = taskResult.getStartTime();
        jsonObject.put((Object)"startTime", startTime != null ? CommUtils.formatDate(new Date(startTime.getTime())) : null);
        Date endTime = taskResult.getEndTime();
        jsonObject.put((Object)"endTime", endTime != null ? CommUtils.formatDate(new Date(endTime.getTime())) : null);
        jsonObject.put((Object)"result", (Object)taskResult.getResult());
        jsonObject.put((Object)"resultInfo", (Object)taskResult.getResultInfo());
        jsonObject.put((Object)"resultId", (Object)taskResult.getResultId());
        jsonObject.put((Object)"resultLink", (Object)taskResult.getResultLink());
        return jsonObject;
    }

    @Override
    @Permission(name={"lego.sys.dataStorage.sysOptLog.delete"})
    @Logging(name="dataMaintainence_deleteLogDumpFile_operateName", rank=2)
    public BatchOperationResult deleteTaskResults(Set<Long> ids) {
        ITaskService mgr = (ITaskService)this.getBundleService("task", "task");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        if (VerifyUtil.isEmpty(ids)) {
            throw new LegoCheckedException(250L);
        }
        ArrayList<String> resultLinkList = new ArrayList<String>();
        for (long id : ids) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id);
            TaskResult taskResult = mgr.readTaskResult(id);
            CommUtils.checkObjectExists(taskResult);
            tempBatch.setTargetName(taskResult.getResultLink());
            resultLinkList.add(taskResult.getResultLink());
            bathOprLst.add(tempBatch);
        }
        this.deleteTaskResultsFile(1, resultLinkList);
        return mgr.deleteTaskResultList(bathOprLst);
    }

    private void deleteTaskResultsFile(int taskType, List<String> boxNames) {
        if (VerifyUtil.isEmpty(boxNames)) {
            return;
        }
        ITaskService mgr = (ITaskService)this.getBundleService("task", "task");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (String boxName : boxNames) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetName(boxName);
            bathOprLst.add(tempBatch);
        }
        mgr.deleteFile(taskType, bathOprLst);
    }

    @Override
    @Context(name="detail")
    @Permission(name={"lego.sys.sysLog.operLog.exportExl"})
    @Logging(name="dataMaintainence_OperateLog_operateName", rank=2, object="=operateLog_objectName", detail="#{$detail}")
    public Response exportOptLogs(String ids, Long dateFrom, Long dateTo, String cmbResult, Integer[] dangerlevel, Set<String> admins) {
        PageParameter parameter = this.getPageParameter();
        HighLevelQueryPameter highLevelQueryPameter = new HighLevelQueryPameter(ids, dateFrom, dateTo, cmbResult, dangerlevel, admins);
        highLevelQueryPameter.setPageSize(parameter.getPageSize());
        highLevelQueryPameter.setStartPage(parameter.getStartPage());
        highLevelQueryPameter.setOrderBy(parameter.getOrderBy());
        highLevelQueryPameter.setOrderType(parameter.getOrderType());
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        String type = "excel";
        String[] exportFile = this.getExportFilePath();
        ArrayList<SysOptLog> optLogList = new ArrayList<SysOptLog>();
        FileUtil fileUtil = FileFactory.getFileUtil(type);
        boolean isDetailExist = this.getData(optLogList, fileUtil, highLevelQueryPameter, exportFile);
        String operateLogDetail = VerifyUtil.isEmpty((String)ids) ? "dataMaintainence_OperateLog_operateDetail_1" : "dataMaintainence_OperateLog_operateDetail_2";
        Context.Variable.set((String)"detail", (Object)operateLogDetail);
        this.downloadFile(exportFile, optLogList, fileUtil, isDetailExist);
        return Response.ok().build();
    }

    private void downloadFile(String[] exportFile, List<SysOptLog> optLogList, FileUtil fileUtil, boolean isDetailExist) {
        boolean i = false;
        int j = 2;
        int k = 3;
        String downloadFile = exportFile[0];
        String zipPath = exportFile[2];
        String zipFile = exportFile[3];
        List<String> column = this.getExcelColumns();
        fileUtil.fileSet("", column, downloadFile);
        if (Locale.SIMPLIFIED_CHINESE.equals(this.getRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            fileUtil.setStrChar("GBK");
        }
        fileUtil.setStrUsrName(this.getCurrentUser().getUserName());
        fileUtil.writeFile(this.logToStr(optLogList), "detail" + File.separator);
        try {
            fileUtil.closeFile();
        }
        catch (IOException e) {
            log.error((Object)"downloadFile failed.", 653110170615808L);
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String data = df.format(new Date());
        String uuid = UUIDGenerator.getUUID();
        if (isDetailExist) {
            fileUtil.zipFile(zipPath, zipFile);
            fileUtil.deleteFile(new File(zipPath));
            fileUtil.setStrExtend("zip");
            fileUtil.setWriteFileName(zipFile);
            fileUtil.downloadNameFile(this.getResponse(), EXPORT_FILE_PREFIX + data + uuid);
        } else {
            fileUtil.downloadNameFile(this.getResponse(), EXPORT_FILE_PREFIX + data + uuid);
            fileUtil.deleteFile(new File(zipPath));
        }
    }

    private List<String> getExcelColumns() {
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("lego.lab.log.oprationname"));
        column.add(this.getText("lego.lab.log.dangerlevel"));
        column.add(this.getText("lego.lab.log.oprationuser"));
        column.add(this.getText("lego.lab.log.oprationtime"));
        column.add(this.getText("lego.lab.log.oprationresult"));
        column.add(this.getText("lego.lab.log.oprationip"));
        column.add(this.getText("lego.lab.log.oprationobj"));
        column.add(this.getText("lego.lab.log.oprationdetail"));
        return column;
    }

    private boolean getData(List<SysOptLog> optLogList, FileUtil fileUtil, HighLevelQueryPameter highLevelQueryPameter, String[] exportFile) {
        boolean isDetailExist;
        String detailPath = exportFile[1];
        ISysOptLog mgr = (ISysOptLog)this.getBundleService("system", "sysLogService");
        String tempStr = highLevelQueryPameter.getIds();
        List logidList = mgr.getLogidByUser(this.getCurrentUser());
        if (!VerifyUtil.isEmpty((String)tempStr)) {
            this.checkLogidList(tempStr, logidList);
            List tempLst = mgr.exportSelectedOpLog(tempStr);
            isDetailExist = this.writeSysLogDetail(optLogList, fileUtil, detailPath, tempLst, mgr);
        } else {
            highLevelQueryPameter.setPageSize(20001);
            Paging pageOne = this.getPage(highLevelQueryPameter);
            int total = pageOne.getiCount();
            if (total > 20000) {
                this.getResponse().setHeader("maxCount", "20000");
                throw new LegoCheckedException(1578L);
            }
            List tempLst = pageOne.getData();
            isDetailExist = this.writeSysLogDetail(optLogList, fileUtil, detailPath, tempLst, mgr);
        }
        return isDetailExist;
    }

    private void checkLogidList(String tempStr, List<String> logidList) {
        String[] tempid = tempStr.split(",");
        if ("false".equals(this.viewAllOperLog())) {
            for (int i = 0; i < tempid.length; ++i) {
                if (logidList.contains(tempid[i])) continue;
                throw new LegoCheckedException(250L);
            }
        }
    }

    private boolean writeSysLogDetail(List<SysOptLog> optLogList, FileUtil fileUtil, String detailPath, List<SysOptLog> tempLst, ISysOptLog mgr) {
        boolean isDetailExist = false;
        for (SysOptLog sysOpt : tempLst) {
            byte[] sysLogDetail;
            SysOptLog sysOptLog = this.plogLocale(sysOpt);
            optLogList.add(sysOptLog);
            if (sysOptLog.getHasDetail() != 1 || (sysLogDetail = mgr.queryLogDetail(sysOptLog.getId())) == null || sysLogDetail.length <= 0) continue;
            isDetailExist = true;
            fileUtil.writeDetailFile(detailPath + File.separator + sysOptLog.getId() + ".txt", sysLogDetail);
        }
        return isDetailExist;
    }

    private Paging getPage(HighLevelQueryPameter highLevelQueryPameter) {
        OptLogQCondition optLogq = new OptLogQCondition();
        optLogq.setiOptResult(-1);
        Long dateFrom1 = highLevelQueryPameter.getDateFrom();
        long dataFrom = dateFrom1 == null ? 0L : dateFrom1;
        Long dateTo2 = highLevelQueryPameter.getDateTo();
        long dateTo = dateTo2 == null ? 0L : dateTo2;
        int startPage = highLevelQueryPameter.getStartPage();
        int pageSize = highLevelQueryPameter.getPageSize();
        if (dataFrom > 0L) {
            optLogq.setDataBeginTime(new Date(dataFrom));
        }
        if (dateTo > 0L) {
            optLogq.setDataEndTime(new Date(dateTo));
        }
        this.genQuery(optLogq, highLevelQueryPameter);
        ISysOptLog mgr = (ISysOptLog)this.getBundleService("system", "sysLogService");
        User user = this.getCurrentUser();
        IUserMgr userMgr = (IUserMgr)this.getBundleService("user", "usermgr");
        boolean all = "true".equalsIgnoreCase(user.getIsAdmin());
        if (!all) {
            Set roles = userMgr.getUserBaseInfo(user.getUserId().longValue()).getRolesSet();
            all = roles.stream().map(Role::getRoleName).anyMatch("auditor"::equals);
        }
        if (!all) {
            optLogq.setIsOld("true");
        }
        return mgr.querySysOptLog(optLogq, startPage * pageSize, pageSize);
    }

    private void genQuery(OptLogQCondition optLogq, HighLevelQueryPameter highLevelQueryPameter) {
        long userId;
        boolean viewAllOperLogRight;
        String orderBy = highLevelQueryPameter.getOrderBy();
        String orderType = highLevelQueryPameter.getOrderType();
        User currentUser = this.getCurrentUser();
        if (null != currentUser && !(viewAllOperLogRight = this.viewAllOperLog(userId = currentUser.getUserId().longValue()))) {
            ArrayList<String> usrList = new ArrayList<String>();
            usrList.add(currentUser.getUserName());
            optLogq.setLstUserName(usrList);
        }
        this.subGenQuery(optLogq, highLevelQueryPameter);
        if (orderBy != null) {
            SortUnit su = new SortUnit();
            if (orderType == null || !"asc".equals(orderType)) {
                orderType = "desc";
            }
            if (!CommonUtil.isValidDbColumn((String)orderBy)) {
                throw new LegoCheckedException(250L);
            }
            su.setFieldName(orderBy);
            su.setSortType(orderType);
            optLogq.setSortunit(su);
        }
    }

    private void subGenQuery(OptLogQCondition optLogq, HighLevelQueryPameter highLevelQueryPameter) {
        String cmbResult = highLevelQueryPameter.getCmbResult();
        Set<String> admins = highLevelQueryPameter.getAdmins();
        Object[] dangerlevel = highLevelQueryPameter.getDangerlevel();
        if (!VerifyUtil.isEmpty((String)cmbResult) && !"-1".equals(cmbResult)) {
            optLogq.setiOptResult(NumberUtil.convertToInteger((Object)cmbResult).intValue());
        }
        if (!VerifyUtil.isEmpty((Object[])dangerlevel)) {
            ArrayList<Object> levList = new ArrayList<Object>();
            for (Object level : dangerlevel) {
                if ((Integer)level == -1 || !dangerLevels.contains(level)) continue;
                levList.add(level);
            }
            if (!levList.isEmpty()) {
                optLogq.setLstSecLevel(levList);
            }
        }
        this.setLstUserName(optLogq, admins);
    }

    private void setLstUserName(OptLogQCondition optLogq, Set<String> admins) {
        if (!VerifyUtil.isEmpty(admins)) {
            ArrayList<String> usrList = new ArrayList<String>();
            User currentUser = this.getCurrentUser();
            for (String str : admins) {
                if (VerifyUtil.isEmpty((String)str)) continue;
                if (this.checkLogParam(currentUser, str)) {
                    throw new LegoCheckedException(250L);
                }
                usrList.add(str);
            }
            if (!usrList.isEmpty()) {
                optLogq.setLstUserName(usrList);
            }
        }
    }

    private boolean checkLogParam(User currentUser, String str) {
        return "false".equals(this.viewAllOperLog()) && null != currentUser && !currentUser.getUserName().equals(str);
    }

    private String[] getExportFilePath() {
        log.info((Object)"Enter getExportFilePath");
        String[] filePaths = new String[4];
        long dateTime = System.currentTimeMillis();
        String uuid = UUIDGenerator.getUUID();
        String fileNameTmp = EXPORT_FILE_PREFIX + dateTime + uuid;
        String dictionaryPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        if (!this.isPathValid(dictionaryPath)) {
            log.error((Object)"Illegal file path: %s", new Object[]{dictionaryPath});
            throw new LegoCheckedException(-1L);
        }
        String zipPath = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR + File.separator + dateTime;
        String downloadFile = zipPath + File.separator + fileNameTmp;
        String detailPath = zipPath + File.separator + "detail";
        if (!this.isPathValid(detailPath)) {
            log.error((Object)"Illegal file path: %s", new Object[]{dictionaryPath});
            throw new LegoCheckedException(-1L);
        }
        String zipFile = this.getSession().getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR + File.separator + dateTime + uuid + "." + "zip";
        filePaths[0] = downloadFile;
        filePaths[1] = detailPath;
        filePaths[2] = zipPath;
        filePaths[3] = zipFile;
        return filePaths;
    }

    private boolean isPathValid(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    private SysOptLog plogLocale(SysOptLog log1) {
        String[] param;
        log1.setOperation(this.getIntelizeText(log1.getOperation()));
        log1.setModule(this.getIntelizeText(log1.getModule()));
        if (Boolean.TRUE.equals(log1.getTargetLocal())) {
            this.dealLocalLog(log1);
        } else {
            param = log1.getTargetPara();
            if (param != null && param.length > 0) {
                try {
                    log1.setTarget(this.getText(log1.getTarget(), this.appendEmptyPlaceHolder(param, 3)));
                }
                catch (Exception ex) {
                    log.error((Object)("log getText error" + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
                }
            }
        }
        param = log1.getDetailPara();
        if (null == param || param.length == 0) {
            log1.setDetail(this.getIntelizeText(log1.getDetail()));
        } else {
            this.dealDetailParam(log1, param);
        }
        return log1;
    }

    private void dealDetailParam(SysOptLog log1, String[] param) {
        int count = 0;
        for (int i = 0; i < 2; ++i) {
            if (null == this.getIntelizeText(log1.getDetail()) || !this.getIntelizeText(log1.getDetail()).contains("{" + i + "}")) continue;
            ++count;
        }
        this.setLogDetail(log1, param, count);
    }

    private void setLogDetail(SysOptLog log1, String[] param, int count) {
        if (count == 1 && param.length > 1) {
            StringBuilder tempstr = new StringBuilder("");
            int paramLength = param.length;
            for (int i = 0; i < paramLength - 1; ++i) {
                param[i] = this.getIntelizeText(param[i]);
                tempstr.append(param[i]).append(",");
            }
            tempstr.append(this.getIntelizeText(param[paramLength - 1]));
            try {
                String[] temp = new String[]{tempstr.toString()};
                String detail = this.getText(log1.getDetail(), temp);
                log1.setDetail(detail);
            }
            catch (Exception ex) {
                log.error((Object)("log getText error" + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
            }
        } else {
            this.setLogDetail(log1, param);
        }
    }

    private void setLogDetail(SysOptLog log1, String[] param) {
        int paramLength = param.length;
        if (paramLength > 0) {
            for (int i = 0; i < paramLength; ++i) {
                param[i] = this.getIntelizeText(param[i]);
            }
        }
        try {
            String detail = this.getText(log1.getDetail(), this.appendEmptyPlaceHolder(param, 3));
            log1.setDetail(detail);
        }
        catch (Exception ex) {
            log.error((Object)("log getText error" + ExceptionUtil.getErrorMessage((Throwable)ex)), 653110170615808L);
        }
    }

    private void dealLocalLog(SysOptLog log1) {
        String[] param = log1.getTargetPara();
        if (param == null || param.length == 0) {
            log1.setTarget(this.getIntelizeText(log1.getTarget()));
        } else {
            int paramLength = param.length;
            for (int i = 0; i < paramLength; ++i) {
                param[i] = this.getIntelizeText(param[i]);
            }
            log1.setTarget(this.getText(log1.getTarget(), this.appendEmptyPlaceHolder(param, 3)));
        }
    }

    private String[] appendEmptyPlaceHolder(String[] params, int count) {
        int originalCount = params.length;
        int resultCount = originalCount + count;
        String[] result = new String[resultCount];
        System.arraycopy(params, 0, result, 0, originalCount);
        for (int i = originalCount; i < resultCount; ++i) {
            result[i] = "--";
        }
        return result;
    }

    private String getIntelizeText(String strText) {
        if (strText == null) {
            return "";
        }
        if (!strText.contains("[") && !strText.contains("]")) {
            try {
                return this.getText(strText);
            }
            catch (Exception ex) {
                log.error((Object)"Log getText error, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            }
        } else {
            return strText;
        }
        return strText;
    }

    private List<List<String>> logToStr(List<SysOptLog> lstLog) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (SysOptLog sOptLog : lstLog) {
            ArrayList<String> tempLst = new ArrayList<String>();
            tempLst.add(sOptLog.getOperation());
            this.addLogLevel(sOptLog, tempLst);
            tempLst.add(sOptLog.getOperator());
            tempLst.add(CommUtils.formatDate(sOptLog.getDate()));
            this.addLogResult(sOptLog, tempLst);
            tempLst.add(sOptLog.getTerminalIp());
            tempLst.add(sOptLog.getTarget());
            String detail = sOptLog.getDetail();
            if (!VerifyUtil.isEmpty((String)detail)) {
                detail = detail.replaceAll("<br>", "");
            }
            tempLst.add(detail);
            if (sOptLog.getHasDetail() == 1) {
                tempLst.add(String.valueOf(sOptLog.getId()));
            } else {
                tempLst.add("-1");
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private void addLogResult(SysOptLog sOptLog, List<String> tempLst) {
        if (sOptLog.getResult() == 0) {
            tempLst.add(this.getText("lego.dic.resulttype.failure"));
        } else if (sOptLog.getResult() == 2) {
            tempLst.add(this.getText("lego.dic.resulttype.halfsuccess"));
        } else {
            tempLst.add(this.getText("lego.dic.resulttype.success"));
        }
    }

    private void addLogLevel(SysOptLog sOptLog, List<String> tempLst) {
        if (sOptLog.getLevel() == SysoplogLevel.risk.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.risk"));
        } else if (sOptLog.getLevel() == SysoplogLevel.normal.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.normal"));
        } else if (sOptLog.getLevel() == SysoplogLevel.warning.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.warn"));
        } else {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.info"));
        }
    }

    @Override
    @Context(name="object")
    @Permission(name={"lego.sys.dataStorage.sysOptLog.scan"})
    @Logging(name="dataMaintainence_downloadLogDumpFile_operateName", object="$object")
    public Response exportOptLogTransferStorage(long fileId) {
        boolean taskType = true;
        ITaskService taskService = (ITaskService)this.getBundleService("task", "task");
        log.info((Object)("exportOptLogTransferStorage fileId:" + fileId), 653110170615808L);
        TaskResult result = taskService.readTaskResult(fileId);
        if (result == null) {
            throw new LegoCheckedException(1291L);
        }
        String downloadFileName = result.getResultLink();
        Context.Variable.set((String)"object", (Object)downloadFileName);
        if (!taskService.checkFile(1, downloadFileName).booleanValue()) {
            throw new LegoCheckedException(1291L);
        }
        if (!taskService.checkFileSize(1, downloadFileName).booleanValue()) {
            throw new LegoCheckedException(1297L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.downloadFile(1, downloadFileName, taskService, this.getResponse());
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(int taskType, String downloadFileName, ITaskService taskService, HttpServletResponse response) {
        if (null == taskService) {
            throw new LegoCheckedException(1073947393L);
        }
        this.responseSet(downloadFileName, response);
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            List dataList = taskService.downLoadLarge(taskType, downloadFileName);
            for (byte[] data : dataList) {
                bos.write(data);
            }
            bos.flush();
        }
        catch (LegoCheckedException le) {
            log.error((Object)"downFile:", (Throwable)le, 653110170615808L);
            throw new LegoCheckedException(1297L, (Throwable)le);
        }
        catch (IOException e) {
            log.error((Object)"downFile:", 653110170615808L);
            throw new LegoCheckedException("download transfer storage error!", (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"download operation log transfer storage error!", (long)1053L, null, (Log)log);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    log.error((Object)"downFile:", 653110170615808L);
                }
            }
        }
    }

    private void responseSet(String tfileName, HttpServletResponse response) {
        response.reset();
        response.setContentType("application/x-download;charset=windows-1251");
        response.addHeader("Content-Disposition", "attachment;filename=" + tfileName);
        response.setHeader("Strict-Transport-Security", "max-age=14400");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("X-XSS-Protection", "1;mode=block");
        response.setHeader("Content-Security-Policy", contentSecurityPolicy);
        response.setHeader("Content-Security-Policy-Report-Only", "''");
        response.setHeader("X-Download-Options", "noopen");
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        response.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
    }
}

