/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.resource.service;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.DeviceVo;
import com.huawei.ism.drm.rest.service.framework.resource.model.NeMgrProtocolExtendVo;
import com.huawei.ism.drm.rest.service.framework.resource.model.ResourceVO;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.resource.service.IResourceRestService;
import com.huawei.ism.drm.rest.service.framework.resource.util.TreeNodeUtil;
import com.huawei.ism.drm.rest.util.PageParameter;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.tree.DataElement;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.lego.nem.fault.sdk.service.IAlarmDevTypeService;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceRestServiceImpl
extends AbstractRestService
implements IResourceRestService {
    private static final long CONERR = 51L;
    private static final Long TYPE_NODE = 0L;
    private static final Long TYPE_GROUP = 3L;
    private static final String TASK_ID = "taskId";
    private static Log log = FELogFactory.getInstance((String)"ui");
    @Autowired
    private PermissionService permissionService;

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, uuid={"$1?.![siteId]"})
    @Logging(name="site_sendAddResourceCmd_operateName", ward=true)
    public String autoDis(List<ResourceVO> autoDisVOList) {
        log.info((Object)"enter autoDis.");
        CommUtils.checkParamEmpty(autoDisVOList);
        IDiscoveryService service = this.getDiscoveryService();
        this.checkExistDeviceWhenDeleteForVasa(service);
        service.checkOverLimitResourceQuantity(autoDisVOList.size());
        Map typeMap = service.getDeviceTypeAndUrl().getMainSubTypeMap();
        JSONObject response = new JSONObject();
        JSONArray records = new JSONArray();
        int succeedCount = 0;
        for (ResourceVO autoDisVO : autoDisVOList) {
            String ip = autoDisVO.getIp();
            JSONObject record = new JSONObject();
            record.put((Object)"target", (Object)ip);
            try {
                this.checkParams(typeMap, autoDisVO, ip);
                ISiteService siteSvc = (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
                Site site = siteSvc.getSiteById(autoDisVO.getSiteId());
                if (site == null) {
                    throw new LegoCheckedException(2117645L);
                }
                DiscoveryPolicy policy = this.addDiscoveryTask(autoDisVO);
                String[] params = new String[]{ip, site.getName()};
                this.writeSucOperationLog("site_sendAddResourceCmd_operateName", 1, ip, "site_sendAddResourceCmd_operateDetail", params);
                record.put((Object)"errorCode", (Object)0);
                record.put((Object)TASK_ID, policy.getParamMap().get(TASK_ID));
                ++succeedCount;
            }
            catch (LegoCheckedException ex) {
                record.put((Object)"errorCode", (Object)ex.getErrorCode());
                record.put((Object)"detailParam", (Object)ex.getParameters());
                this.writeFailedOperationLogNoException("site_sendAddResourceCmd_operateName", 1, ip, (Exception)((Object)ex));
            }
            catch (Exception ex) {
                record.put((Object)"errorCode", (Object)-1L);
                this.writeFailedOperationLogNoException("site_sendAddResourceCmd_operateName", 1, ip, ex);
            }
            records.add((Object)record);
        }
        response.put((Object)"totalCount", (Object)autoDisVOList.size());
        response.put((Object)"succeedCount", (Object)succeedCount);
        response.put((Object)"failCount", (Object)(autoDisVOList.size() - succeedCount));
        response.put((Object)"result", (Object)records);
        return response.toString();
    }

    private void checkExistDeviceWhenDeleteForVasa(IDiscoveryService service) {
        boolean isVasa = LegoConfig.getInstance((String)"../conf/catalina.properties").getBoolean("VASA", Boolean.valueOf(false));
        if (!isVasa) {
            return;
        }
        Set deletingDevs = service.getLockedDeviceWhenDelete();
        if (!VerifyUtil.isEmpty((Collection)deletingDevs)) {
            log.error((Object)"some device is deleting, can not do discovery operation for vasa");
            throw new LegoCheckedException(1073947660L);
        }
    }

    private void checkParams(Map<String, Set<String>> typeMap, ResourceVO autoDisVO, String ip) {
        String deviceType = autoDisVO.getDeviceType();
        String deviceSubType = autoDisVO.getDeviceSubType();
        Map<String, String> paramMap = autoDisVO.getParamMap();
        String devicetype = paramMap.get("devicetype");
        if ("ism.drm.deviceType.fusionsphere.mainType".equals(deviceType) && "ism.drm.deviceType.fusionsphereopenstack.subType".contains(deviceSubType) && "FusionSphereOpenstack".equals(devicetype) ? !CommUtil.checkDrmIpParam((String)ip) && !CommUtil.checkDrmDomainParam((String)ip) : !CommUtil.checkDrmIpParam((String)ip)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkTypeAndManufacture(autoDisVO, typeMap);
        if (VerifyUtil.isEmpty((String)autoDisVO.getSiteId())) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private DiscoveryPolicy addDiscoveryTask(ResourceVO autoDisVO) {
        DiscoveryPolicy policy = new DiscoveryPolicy();
        policy.setLocation(autoDisVO.getSiteId());
        policy.setStartIP(autoDisVO.getIp());
        policy.setEndIP(autoDisVO.getIp());
        policy.setDeviceType(autoDisVO.getDeviceType());
        policy.setDeviceSubType(null == autoDisVO.getDeviceSubType() ? "" : autoDisVO.getDeviceSubType());
        policy.setParamMap(autoDisVO.getParamMap());
        policy.setOperatorId(this.getCurrentUserId());
        policy.setIsAirGapResource(autoDisVO.getIsAirGapSite());
        long taskId = this.getBundleService(IResourceService.class).discoveryResource(policy);
        policy.getParamMap().put(TASK_ID, taskId + "");
        return policy;
    }

    private void checkTypeAndManufacture(ResourceVO autoDisVO, Map<String, Set<String>> typeMap) {
        ArrayList<String> disTypeList = new ArrayList<String>();
        if (!VerifyUtil.isEmpty(typeMap)) {
            for (Map.Entry<String, Set<String>> entry : typeMap.entrySet()) {
                String typeKey = entry.getKey();
                disTypeList.add(typeKey);
            }
        }
        String deviceType = autoDisVO.getDeviceType();
        String deviceSubType = autoDisVO.getDeviceSubType();
        if (!disTypeList.contains(deviceType)) {
            throw new LegoCheckedException(1073947393L);
        }
        Set<String> subType = this.getFields(typeMap, deviceType);
        if (!VerifyUtil.isEmpty(subType) ? !subType.contains(deviceSubType) : null != deviceSubType && 0 != deviceSubType.length()) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private Set<String> getFields(Map<String, Set<String>> typeMap, String deviceType) {
        if (typeMap != null && !typeMap.isEmpty()) {
            return typeMap.get(deviceType);
        }
        return null;
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"})
    @Logging(name="site_removeResource_operateName", rank=2, detail="site_removeResource_operateDetail")
    public BatchOperationResult deleteResources(String sns) {
        HashMap<Long, String> idNameMap = new HashMap<Long, String>();
        HashMap<Long, DeviceVo> idVoMap = new HashMap<Long, DeviceVo>();
        List<DeviceVo> deviceVoList = this.getDeviceVos(sns, idNameMap, idVoMap);
        List moIds = deviceVoList.stream().map(DeviceVo::getMoId).collect(Collectors.toList());
        this.permissionService.checkUserMoAuthority(moIds);
        BatchOperationResult batchOperationResult = this.doDeleteResources(deviceVoList, idNameMap);
        for (BatchOperation result : batchOperationResult.getResult()) {
            String name = (String)(result.getTargetName() != null ? result.getTargetName() : result.getExtTargetId());
            DeviceVo vo = (DeviceVo)idVoMap.get(result.getTargetId());
            String ip = Optional.ofNullable(vo).map(DeviceVo::getIpAddress).orElse("--");
            result.setTargetNameParam(new String[]{name, ip});
        }
        return batchOperationResult;
    }

    private List<DeviceVo> getDeviceVos(String sns, Map<Long, String> idNameMap, Map<Long, DeviceVo> idVoMap) {
        List<DeviceVo> deviceVoList;
        try {
            CommUtils.checkParamEmpty(sns);
            deviceVoList = this.getIdAndNameMaps(sns, idNameMap, idVoMap);
        }
        catch (LegoCheckedException ex) {
            log.error((Object)"batch delete device is error.", (Throwable)ex, 90160758784001L);
            throw ex;
        }
        catch (Exception e) {
            log.error((Object)("batch delete device is error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return deviceVoList;
    }

    private BatchOperationResult doDeleteResources(List<DeviceVo> deviceVoList, Map<Long, String> idNameMap) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
        BatchOperationResult apmBathOprLst = this.checkResource(idNameMap, result, bathOprLst);
        log.info((Object)"Start to delete devices, the device's ids: %s", new Object[]{this.getDeviceIds(deviceVoList)});
        this.deleteDeviceCommand(bathOprLst);
        log.info((Object)"Delete devices finished.");
        return apmBathOprLst;
    }

    private String getDeviceIds(List<DeviceVo> deviceVoList) {
        StringBuilder sb = new StringBuilder();
        for (DeviceVo vo : deviceVoList) {
            sb.append(vo.getMoId()).append("\u3001");
        }
        return sb.toString();
    }

    private List<DeviceVo> getIdAndNameMaps(String sns, Map<Long, String> idNameMap, Map<Long, DeviceVo> idVoMap) {
        String[] snArray;
        ArrayList<DeviceVo> results = new ArrayList<DeviceVo>();
        for (String sn : snArray = sns.split(";")) {
            NetworkEntity mo = this.getNetworkEntity(sn);
            if (null == mo) {
                log.error((Object)("NetworkEntity not exsits, sn=" + sn), 90160758784000L);
                throw new LegoCheckedException(1073947394L);
            }
            String moName = mo.getName();
            Long moId = mo.getMoId();
            DeviceVo device = new DeviceVo();
            device.setMoId(moId);
            device.setName(moName);
            device.setIpAddress(mo.getIpAddress());
            device.setMainType(mo.getMainType());
            device.setSubType(mo.getSubType());
            idNameMap.put(moId, mo.getName());
            idVoMap.put(moId, device);
            results.add(device);
        }
        return results;
    }

    private BatchOperationResult checkResource(Map<Long, String> idNameMap, List<BatchOperation> result, List<BatchOperation> bathOprLst) {
        log.debug((Object)"enter checkResource");
        if (VerifyUtil.isEmpty(idNameMap) || null == result || null == bathOprLst) {
            return new BatchOperationResult();
        }
        ISiteService siteService = this.getBundleService(ISiteService.class.getName(), ISiteService.class);
        ArrayList<Long> modIds = new ArrayList<Long>(idNameMap.keySet());
        BatchOperationResult apmBathOprLst = siteService.checkResourceUsed(this.getCurrentUserId(), modIds);
        for (BatchOperation bo : apmBathOprLst.getResult()) {
            bo.setTargetName(idNameMap.get(bo.getTargetId()));
            if (0L == bo.getErrorCode()) {
                bathOprLst.add(bo);
                continue;
            }
            result.add(bo);
        }
        return apmBathOprLst;
    }

    private long deleteDeviceCommand(List<BatchOperation> bathOprLst) {
        log.debug((Object)"enter deleteDeviceCommand");
        IResourceService service = this.getBundleService(IResourceService.class.getName(), IResourceService.class);
        return service.deleteResources(bathOprLst);
    }

    private IDiscoveryService getDiscoveryService() {
        return (IDiscoveryService)this.getBundleService("discover", "DiscoveryServiceImpl");
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getInsDeviceList(String mainType, String id, String name, String ip) {
        PageParameter parameter = this.getPageParameter();
        int startPage = parameter.getStartPage();
        int pageSize = parameter.getPageSize();
        if (startPage < 0 || pageSize < 0) {
            throw new LegoCheckedException(250L);
        }
        String subType = id;
        if (!VerifyUtil.isEmpty((String)subType)) {
            subType = subType.replaceAll("'", "''");
        }
        IDataExplore deviceSrv = (IDataExplore)this.getBundleService("ResourceApplication", "DeviceDataExplore");
        TopoObjectQueryCondition condtion = this.constructQueryCondition(mainType, name, ip, subType);
        JSONObject resultObject = new JSONObject();
        try {
            List topoObjectList = deviceSrv.getDataList(startPage * pageSize, pageSize, condtion);
            long total = (int)deviceSrv.getTotalDataCount(condtion);
            resultObject.put((Object)"totalCount", (Object)total);
            JSONArray array = new JSONArray();
            for (TopoObject object : topoObjectList) {
                array.add((Object)this.topoObjectToJSonObject(object));
            }
            resultObject.put((Object)"records", (Object)array);
        }
        catch (Exception e) {
            log.error((Object)("Error while getInsDeviceList: " + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
        }
        return resultObject.toString();
    }

    private JSONObject topoObjectToJSonObject(TopoObject to) {
        JSONObject json = new JSONObject();
        json.put((Object)"moId", (Object)to.getMoId());
        json.put((Object)"uuid", (Object)to.getUuid());
        if (to instanceof NetworkEntity) {
            json.put((Object)"sn", (Object)((NetworkEntity)to).getSn());
        } else {
            json.put((Object)"sn", (Object)"");
        }
        json.put((Object)"status", (Object)to.getStatus());
        json.put((Object)"name", (Object)to.getName());
        json.put((Object)"ipAddress", (Object)to.getIpAddress());
        json.put((Object)"mainType", (Object)to.getMainType());
        json.put((Object)"subType", (Object)to.getSubType());
        if (to instanceof Node) {
            json.put((Object)"discoveredTimeStr", (Object)((Node)to).getDiscoveredTimeStr());
        } else {
            json.put((Object)"discoveredTimeStr", (Object)"");
        }
        json.put((Object)"timezoneFormat", (Object)to.getTimezoneFormat());
        return json;
    }

    private TopoObjectQueryCondition constructQueryCondition(String mainType, String name, String ip, String subType) {
        TopoObjectQueryCondition condtion = new TopoObjectQueryCondition();
        if (!VerifyUtil.isEmpty((String)StringUtil.trim((String)mainType))) {
            condtion.setMainDevTypeName(mainType);
            if (!mainType.equals(subType)) {
                condtion.setSubDevTypeName(subType);
            }
        } else {
            condtion.setSubDevTypeName(subType);
        }
        condtion.setDeviceNameLikeQuery(VerifyUtil.isEmpty((String)StringUtil.trim((String)name)) ? null : name);
        condtion.setDevIpAddressLikeQuery(VerifyUtil.isEmpty((String)StringUtil.trim((String)ip)) ? null : ip);
        User user = this.getCurrentUser();
        if (!"true".equalsIgnoreCase(user.getIsAdmin())) {
            condtion.setUserId(String.valueOf(user.getUserId()));
        }
        return condtion;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public List<TreeNodeVo> getResourceTree() {
        ServiceContext context = ServiceContext.getInstance();
        User currentUser = this.getCurrentUser();
        Locale locale = (Locale)this.getSession().getAttribute("WW_TRANS_I18N_LOCALE");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key.context.user", currentUser);
        map.put("key.context.localize", locale);
        Object obj = context.lookup("ResourceApplication/deviceTypeMgr", map);
        if (obj == null) {
            String[] parStrArr = new String[]{"lego.dic.module.ResourceApplication"};
            throw new LegoCheckedException(51L, parStrArr);
        }
        IDeviceTypeMgr topoMgr = (IDeviceTypeMgr)obj;
        RootDataElement treeRoot = currentUser.getIsAdmin().equals("true") ? topoMgr.getDeviceTypeTree(null, Boolean.valueOf(true)) : topoMgr.getDeviceTypeTree(currentUser.getUserId(), Boolean.valueOf(true));
        treeRoot.setDisName("lego.lab.res.devlists");
        ArrayList<TreeNodeVo> nodeList = new ArrayList<TreeNodeVo>();
        TreeNodeUtil.constructNodeList(treeRoot, nodeList);
        Collections.sort(nodeList, new CommonComparator("name", true));
        return nodeList;
    }

    @Override
    @Contexts(value={@Context(name="ne", statement="$this.loadNetworkEntity($1)", required=true), @Context(name="name", statement="$ne.name", required=true)})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$ne.moId"})
    @Logging(name="resource_modifyResProtocol_operateName", rank=3, detail="resource_modifyResProtocol_operateDetail_1", object="$name", parameters={"$name", "$2?.moName"})
    public Response modifyMoBaseInfo(String sn, ResourceVO resourceVo) {
        if (null == resourceVo) {
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = (NetworkEntity)Context.Variable.get((String)"ne", NetworkEntity.class);
        String newName = resourceVo.getMoName();
        ValidateUtil.validate((String)"^.{1,128}$", (String)newName);
        if (networkEntity.getName().equals(resourceVo.getMoName())) {
            return Response.ok().build();
        }
        networkEntity.setName(newName);
        this.getBundleService(IResourceService.class).updateMo((ManagedObject)networkEntity);
        return Response.ok().build();
    }

    private NetworkEntity getNetworkEntity(String sn) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sn", sn);
        List nes = this.getResourceService().query(NetworkEntity.class, params);
        if (VerifyUtil.isEmpty((Collection)nes)) {
            return null;
        }
        return (NetworkEntity)nes.get(0);
    }

    private IResourceService getResourceService() {
        return (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
    }

    @Override
    @Context(name="ne", statement="$this.loadNetworkEntity($1)", required=true)
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$ne.moId"})
    public String getMoBaseInfo(String sn) {
        NetworkEntity networkEntity = (NetworkEntity)Context.Variable.get((String)"ne", NetworkEntity.class);
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"sn", (Object)networkEntity.getSn());
        returnObject.put((Object)"moName", (Object)networkEntity.getName());
        return returnObject.toString();
    }

    public NetworkEntity loadNetworkEntity(String sn) {
        return this.getNetworkEntity(this.decode(sn));
    }

    @Override
    @Context(name="ne", statement="$this.loadNetworkEntity($1)", required=true)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$ne.moId"})
    @Logging(name="resource_modifyResProtocol_operateName", rank=3, object="$ne?.name", detail="resource_modifyResProtocol_operateDetail_2")
    public Response modifyMangementProtocol(String sn, NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        if (null == neMgrProtocolExtendVo) {
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity networkEntity = (NetworkEntity)Context.Variable.get((String)"ne", NetworkEntity.class);
        this.checkNeMgrProtocolExtendVo(neMgrProtocolExtendVo);
        this.doModifyMangementProtocol(networkEntity.getMoId(), neMgrProtocolExtendVo);
        neMgrProtocolExtendVo.setNetworkPassword(null);
        return Response.ok().build();
    }

    private void checkNeMgrProtocolExtendVo(NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtendVo)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getIsModifyPwd(), 10)) {
            log.error((Object)"Invalid param isModifyPwd.");
            throw new LegoCheckedException(1073947393L);
        }
        if (Boolean.parseBoolean(neMgrProtocolExtendVo.getIsModifyPwd())) {
            this.checkIdentifyInfo(neMgrProtocolExtendVo);
        }
        if (Boolean.parseBoolean(neMgrProtocolExtendVo.getIsModifyOceanProtectPwd())) {
            this.checkOceanProtectIdentifyInfo(neMgrProtocolExtendVo);
        }
        if (!VerifyUtil.isEmpty((String)neMgrProtocolExtendVo.getOtherParam()) && !Validator.checkStringLength(neMgrProtocolExtendVo.getOtherParam(), 1024)) {
            log.error((Object)"Invalid other param.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!(VerifyUtil.isEmpty((String)neMgrProtocolExtendVo.getSslValue()) || "0".equals(neMgrProtocolExtendVo.getSslValue()) || "1".equals(neMgrProtocolExtendVo.getSslValue()))) {
            log.error((Object)"Invalid ssl value.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!VerifyUtil.isEmpty(neMgrProtocolExtendVo.getExtendParams()) && !VerifyUtil.generalCheckLength(neMgrProtocolExtendVo.getExtendParams().entrySet())) {
            log.error((Object)"Invalid extend params.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkIdentifyInfo(NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        if (!Ipv4AddressUtil.isIPv4Address((String)neMgrProtocolExtendVo.getNetworkIpAddress())) {
            log.error((Object)"Invalid ip address.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getNetworkUserName(), 255)) {
            log.error((Object)"Invalid network user name.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getNetworkPassword(), 64)) {
            log.error((Object)"Invalid network password.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkOceanProtectIdentifyInfo(NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        if (!Ipv4AddressUtil.isIPv4Address((String)neMgrProtocolExtendVo.getNetworkIpAddress())) {
            log.error((Object)"Invalid ip address.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getExtendParams().get("OceanProtectUsername"), 64)) {
            log.error((Object)"Invalid ProtectManager username.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.checkStringLength(neMgrProtocolExtendVo.getExtendParams().get("OceanProtectPassword"), 64)) {
            log.error((Object)"Invalid ProtectManager password.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void doModifyMangementProtocol(Long moId, NeMgrProtocolExtendVo neMgrProtocolExtendVo) {
        NeMgrProtocolExtend neMgrProtocolExtend = new NeMgrProtocolExtend();
        neMgrProtocolExtend.setMoId(moId);
        neMgrProtocolExtend.setNetworkIpAddress(neMgrProtocolExtendVo.getNetworkIpAddress());
        neMgrProtocolExtendVo.setMoId(moId);
        if ("true".equals(neMgrProtocolExtendVo.getIsModifyPwd())) {
            neMgrProtocolExtend.setModifyAuthInfo(true);
            String networkPassword = neMgrProtocolExtendVo.getNetworkPassword();
            neMgrProtocolExtend.setNetworkPassword(HtmlStringConverter.decode(networkPassword));
        }
        neMgrProtocolExtend.setNetworkUserName(neMgrProtocolExtendVo.getNetworkUserName());
        Map<String, String> extendParams = neMgrProtocolExtendVo.getExtendParams();
        if (!VerifyUtil.isEmpty(extendParams)) {
            HashMap<String, String> decodeExtendParams = new HashMap<String, String>();
            for (Map.Entry<String, String> next : extendParams.entrySet()) {
                String key = next.getKey();
                String value = next.getValue();
                decodeExtendParams.put(key, HtmlStringConverter.decode(value));
            }
            neMgrProtocolExtend.setExtendParams(decodeExtendParams);
        }
        this.getBundleService(IResourceService.class).updateMgrProtocol(neMgrProtocolExtend);
        neMgrProtocolExtend.eraseSensitiveData();
    }

    @Override
    public String getSupportResource() {
        IResourceService resourceService = this.getBundleService(IResourceService.class);
        Map supportResources = resourceService.getSupportResource();
        if (VerifyUtil.isEmpty((Map)supportResources)) {
            throw new LegoCheckedException(-1L);
        }
        JSONArray responseData = new JSONArray();
        Set entrySet = supportResources.entrySet();
        for (Map.Entry entry : entrySet) {
            JSONObject supportResourceObj = new JSONObject();
            supportResourceObj.put((Object)"type", entry.getKey());
            supportResourceObj.put((Object)"description", entry.getValue());
            responseData.add((Object)supportResourceObj);
        }
        return responseData.toString();
    }

    @Override
    @Context(name="ne", statement="$this.loadNetworkEntity($1)", required=true)
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$ne.moId"})
    public NeMgrProtocolExtend queryProtocol(String sn) {
        NetworkEntity networkEntity = (NetworkEntity)Context.Variable.get((String)"ne", NetworkEntity.class);
        NeMgrProtocolExtend neMgrProtocolExtend = this.getBundleService(IResourceService.class).getMgrProtocol(networkEntity.getMoId());
        neMgrProtocolExtend.setNetworkPassword("");
        neMgrProtocolExtend.getExtendParams().put("OceanProtectPassword", "");
        return neMgrProtocolExtend;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public List<TreeNodeVo> getResourceTypeTree(Boolean systemMoShow) {
        Long userId = null;
        if (!"true".equalsIgnoreCase(this.getCurrentUser().getIsAdmin())) {
            userId = this.getCurrentUserId();
        }
        IDeviceTypeMgr service = (IDeviceTypeMgr)this.getBundleService("ResourceApplication", "deviceTypeMgr");
        RootDataElement treeRoot = service.getDeviceTypeTreeWithoutDev(userId, Boolean.valueOf(true), Boolean.valueOf(true));
        if (systemMoShow.booleanValue()) {
            IDataExplore deviceSrv = (IDataExplore)this.getBundleService("ResourceApplication", "DeviceDataExplore");
            TopoObject rootMo = deviceSrv.getRootMO();
            MainDeviceTypeState mainType = new MainDeviceTypeState();
            mainType.setDeviceCount(Long.valueOf(1L));
            mainType.setGroupId(0L);
            mainType.setMainDeviceTypeName(rootMo.getMainType());
            DataElement typeGroup = this.createMainTypeNode(mainType, 0);
            typeGroup.addChildEle((UIElement)this.createSubTypeNode(rootMo.getSubType(), 0));
            treeRoot.addChildEle((UIElement)typeGroup);
        }
        try {
            Locale locale = (Locale)this.getSession().getAttribute("WW_TRANS_I18N_LOCALE");
            IAlarmDevTypeService alarmDevTypeService = (IAlarmDevTypeService)this.getBundleService("fault", "alarmDevTypeService");
            treeRoot = alarmDevTypeService.getDeviceTypeTree(treeRoot, userId, locale);
        }
        catch (Exception t) {
            log.error((Object)("call product create device type tree exception." + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784000L);
        }
        ArrayList<TreeNodeVo> nodeList = new ArrayList<TreeNodeVo>();
        TreeNodeUtil.constructNodeList(treeRoot, nodeList);
        Collections.sort(nodeList, new CommonComparator("name", true));
        return nodeList;
    }

    private DataElement createMainTypeNode(MainDeviceTypeState mainType, int i) {
        DataElement typeGroup = new DataElement();
        typeGroup.setId(Long.valueOf(i));
        typeGroup.setEleType(TYPE_GROUP);
        typeGroup.setEntityId(mainType.getmainDeviceTypeName());
        typeGroup.setDisName(mainType.getmainDeviceTypeName());
        typeGroup.setToolTip(mainType.getmainDeviceTypeName());
        return typeGroup;
    }

    private DataElement createSubTypeNode(String subType, int i) {
        DataElement subTypeNode = new DataElement();
        subTypeNode.setId(Long.valueOf(i));
        subTypeNode.setEleType(TYPE_NODE);
        subTypeNode.setEntityId(subType);
        subTypeNode.setDisName(subType);
        subTypeNode.setToolTip(subType);
        return subTypeNode;
    }

    private String decode(String encryptedStr) {
        byte[] byteArray = Base64.decodeBase64((String)encryptedStr);
        if (null == byteArray) {
            log.error((Object)"bytes array is null.", 90160758784000L);
            throw new LegoCheckedException(1073947393L);
        }
        return new String(byteArray, Charset.defaultCharset());
    }

    @Override
    @Contexts(value={@Context(name="trgSite", statement="$this.loadSite($2?.siteId)", required=true), @Context(name="res", statement="$this.loadDrResourceBySn($1)", required=true), @Context(name="srcSite", statement="$this.loadSite($res?.siteId)", required=true)})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, uuid={"$2?.siteId", "$srcSite.siteId"}, validate={"$this.checkResourceAuthority($1)"})
    @Logging(name="topology_host_resetSite_operateName", object="$res?.name", detail="topology_host_resetSite_operateDetail", parameters={"$res?.name", "$srcSite?.name", "$trgSite?.name"})
    public Response modifyResourceSite(String resourceId, Map<String, String> siteId) {
        if (VerifyUtil.isEmpty((String)resourceId) || VerifyUtil.isEmpty(siteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String siteIdInfo = siteId.get("siteId");
        if (VerifyUtil.isEmpty((String)siteIdInfo)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site trgSite = (Site)Context.Variable.get((String)"trgSite", Site.class);
        if (0 != trgSite.getSiteType()) {
            throw new LegoCheckedException(1073947393L);
        }
        Site srcSite = (Site)Context.Variable.get((String)"srcSite", Site.class);
        if (0 != srcSite.getSiteType()) {
            throw new LegoCheckedException(1073947393L);
        }
        String srcSiteId = srcSite.getSiteId();
        if (siteIdInfo.equals(srcSiteId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.getResourceService().modifyResourceSite(resourceId, siteIdInfo);
        return Response.ok().build();
    }

    public Site loadSite(String siteId) {
        if (siteId == null) {
            return null;
        }
        ISiteService siteService = (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
        return siteService.getSiteById(siteId);
    }

    public DrResource loadDrResourceBySn(String sn) {
        return Optional.ofNullable(sn).map(arg_0 -> ((IResourceService)this.getResourceService()).getDrResourceBySn(arg_0)).orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkResourceAuthority(String resourceId) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("uuid", resourceId);
        List moLists = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (!VerifyUtil.isEmpty((Collection)moLists)) {
            ManagedObject mo = (ManagedObject)moLists.get(0);
            while (mo.getParentMo() != null) {
                mo = mo.getParentMo();
            }
            if (!(mo instanceof NetworkEntity)) throw new LegoCheckedException(2117645L);
            this.permissionService.checkUserMoAuthority(mo.getMoId());
            return;
        } else {
            NetworkEntity mo = this.getNetworkEntity(resourceId);
            if (null == mo) throw new LegoCheckedException(2117645L);
            this.permissionService.checkUserMoAuthority(mo.getMoId());
        }
    }
}

