/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.role.service;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.role.service.IRoleRestService;
import com.huawei.ism.drm.rest.service.framework.user.util.TreeNodeUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.comm.SortUnit;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public class RoleRestServiceImpl
extends AbstractRestService
implements IRoleRestService {
    private static final List<Integer> FOBIDDENPRIVILEGELIST = Arrays.asList(9352, 141, 143, 142, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 149, 147, 149, 202, 203, 204, 160, 161, 162, 163, 9373, 9378, 9374, 9385, 9386, 9387, 9318, 9319, 9320);
    private transient Log log = LogFactory.getInstance((Object)this);

    @Override
    @Permission(name={"lego.sys.role.add"})
    @Logging(name="user_createManagerGroup_operateName", object="$1?.roleName")
    public Response createRole(Role role) {
        if (VerifyUtil.isEmpty((Object)role)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!Validator.regExpCheck(role.getRoleName(), "^[a-zA-Z_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\\w-]*$")) {
            throw new LegoUncheckedException(250L);
        }
        int length = 100;
        int length2 = 64;
        if (!Validator.checkStringLength(role.getRoleDes(), 100) || !Validator.checkStringLength(role.getRoleName(), 64)) {
            throw new LegoCheckedException(250L);
        }
        Set privileIds = role.getOptIdsSet();
        CommUtils.isNullCollection(privileIds);
        privileIds.remove(0L);
        for (Integer authId : FOBIDDENPRIVILEGELIST) {
            Long id = (long)authId;
            if (!privileIds.contains(id)) continue;
            throw new LegoCheckedException(250L);
        }
        this.doCreateRole(role, privileIds);
        return Response.ok().build();
    }

    private void doCreateRole(Role role, Set<Long> privileIds) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        role.setCreateTime(dateFormat.format(date));
        this.log.info((Object)("add admin group:" + role.getRoleName()), 653110169894912L);
        ArrayList<Long> privilegesList = new ArrayList<Long>();
        privilegesList.addAll(privileIds);
        mgr.addRoleInfo(role, privilegesList);
    }

    @Override
    @Permission(name={"lego.sys.role.edit"})
    @Logging(name="user_modifyManagerGroup_operateName", rank=3, object="$2?.roleName ?: $1")
    public Response modifyRole(Long roleId, Role role) {
        role.setRoleId(roleId);
        int length = 100;
        if (!Validator.checkStringLength(role.getRoleDes(), 100)) {
            throw new LegoCheckedException(250L);
        }
        Set privileIds = role.getOptIdsSet();
        CommUtils.isNullCollection(privileIds);
        privileIds.remove(0L);
        for (Integer authId : FOBIDDENPRIVILEGELIST) {
            Long id = (long)authId;
            if (!privileIds.contains(id)) continue;
            throw new LegoCheckedException(250L);
        }
        this.doModifyRole(role, privileIds);
        return Response.ok().build();
    }

    private void doModifyRole(Role role, Set<Long> privileIds) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        role.setCreateTime(dateFormat.format(date));
        Role oldrole = mgr.getRoleInf(role.getRoleId().longValue());
        if (null != oldrole) {
            if ("true".equals(oldrole.getDefaultStr())) {
                this.log.error((Object)"can not edit the default role.");
                throw new LegoCheckedException(250L);
            }
            role.setRoleName(oldrole.getRoleName());
        }
        this.log.info((Object)("modify admin group:" + role.getRoleName()));
        ArrayList<Long> privilegesList = new ArrayList<Long>();
        privilegesList.addAll(privileIds);
        mgr.updataRole(role, privilegesList);
        Role ruRole = mgr.getRoleInfRelUser(role.getRoleId().longValue(), true);
        Set usrSet = ruRole.getUserSet();
        List userlist = mgr.getAllOnlineUser(null);
        for (User tempUsr : usrSet) {
            this.forceLogout(mgr, userlist, tempUsr);
        }
    }

    private void forceLogout(IUserMgr mgr, List<User> userlist, User tempUsr) {
        for (User u : userlist) {
            if (!tempUsr.getUserName().equals(u.getUserName())) continue;
            this.log.info((Object)("Force user logout. User: " + tempUsr.getUserName()));
            try {
                mgr.forceLogout(u.getSession());
                this.writeSucOperationLog("user_forceOffline_operateName", 2, tempUsr.getUserName(), null, null);
            }
            catch (Exception e) {
                this.writeFailedOperationLogNoException("user_forceOffline_operateName", 2, tempUsr.getUserName(), e);
            }
            break;
        }
    }

    @Override
    @Permission(name={"lego.sys.role.delete"})
    @Logging(name="user_deleteManagerGroup_operateName", rank=2)
    public BatchOperationResult deleteRoles(Set<Long> roleIds) {
        CommUtils.isNullCollection(roleIds);
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (long roleId : roleIds) {
            BatchOperation tempBatch = new BatchOperation();
            Role oldrole = mgr.getRoleInf(roleId);
            tempBatch.setTargetId(roleId);
            bathOprLst.add(tempBatch);
            if (oldrole == null) continue;
            tempBatch.setTargetName(oldrole.getRoleName());
            if (!"true".equals(oldrole.getDefaultStr())) continue;
            this.log.error((Object)"can not delete the default role.", 653110169894912L);
            throw new LegoCheckedException(250L);
        }
        StringBuffer sbf = new StringBuffer();
        for (long strTemp : roleIds) {
            sbf.append(strTemp).append(',');
        }
        this.log.warn((Object)("delete roles:" + sbf));
        return mgr.batchDelRoles(bathOprLst);
    }

    @Override
    @Permission(name={"lego.sys.role.scan"})
    public Role queryRole(Long roleId) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        Role role = mgr.getRoleInf(roleId.longValue());
        if (role == null) {
            return new Role();
        }
        this.dealRoleDesc(role);
        Role roleRelUser = mgr.getRoleInfRelUser(roleId.longValue(), true);
        role.setOptsSet(null);
        role.setUserSet(roleRelUser.getUserSet());
        Set userSet = role.getUserSet();
        if (!VerifyUtil.isEmpty((Collection)userSet)) {
            for (User user : userSet) {
                user.setRolesSet(null);
                user.setMoAutSeth(null);
                user.setUserAclSet(null);
                user.setUserPassword("");
                user.setUserPasswordSalt("");
            }
        }
        return role;
    }

    private void dealRoleDesc(Role role) {
        if (role.getRoleName().equals("administrator")) {
            role.setRoleDes(this.getText("lego.lab.defult.administrator"));
        } else if (role.getRoleName().equals("auditor")) {
            role.setRoleDes(this.getText("lego.lab.defult.auditor"));
        } else if (role.getRoleName().equals("operator")) {
            role.setRoleDes(this.getText("lego.lab.defult.operator"));
        } else if (role.getRoleName().equals("NBIRole")) {
            role.setRoleDes(this.getText("lego.lab.defult.nbirole"));
        } else if (role.getRoleId() == -1L) {
            role.setRoleDes(this.getText("lego.lab.defult.OCAdmin"));
        }
    }

    @Override
    @Permission(name={"lego.sys.role.scan"})
    public List<TreeNodeVo> getPrivilegeTree(Long roleId) {
        return this.getPrivilegeTree(roleId, true);
    }

    private List<TreeNodeVo> getPrivilegeTree(Long roleId, boolean removeHiddenEelement) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        RootDataElement optRetree = null;
        int i = -1;
        if (roleId != -1L) {
            Role role = mgr.getRoleInf(roleId.longValue());
            CommUtils.checkObjectExists(role);
            optRetree = mgr.getOptTree(role.getRoleId());
        } else {
            optRetree = mgr.getOptTree(Long.valueOf(-1L));
            if (removeHiddenEelement) {
                this.deleteHiddenEelement(optRetree);
            }
        }
        ArrayList<TreeNodeVo> treeNodes = new ArrayList<TreeNodeVo>();
        optRetree.setDisName("lego.lab.usr.operations");
        TreeNodeUtil.constructNodeList(optRetree, treeNodes);
        Collections.sort(treeNodes, new CommonComparator("sortId", true));
        return treeNodes;
    }

    private void deleteHiddenEelement(RootDataElement rootdata) {
        if (null != rootdata) {
            this.delAddResEle(rootdata);
            this.delLicenseEle(rootdata);
            this.delSysMgrEle(rootdata);
            this.delDataStorageEle(rootdata);
            this.delServersEle(rootdata);
        }
    }

    private void delServersEle(RootDataElement rootdata) {
        UIElement opeEle = rootdata.getUIElementById(9316L);
        if (null != opeEle) {
            UIElement addResEle = rootdata.getUIElementById(9318L);
            if (null != addResEle) {
                opeEle.removeChildEleUI(addResEle);
            }
            if (null != (addResEle = rootdata.getUIElementById(9319L))) {
                opeEle.removeChildEleUI(addResEle);
            }
            if (null != (addResEle = rootdata.getUIElementById(9320L))) {
                opeEle.removeChildEleUI(addResEle);
            }
        }
    }

    private void delDataStorageEle(RootDataElement rootdata) {
        UIElement debugEle;
        UIElement opeEle = rootdata.getUIElementById(159L);
        if (null != opeEle) {
            UIElement logDataEle = rootdata.getUIElementById(160L);
            opeEle.removeChildEleUI(logDataEle);
        }
        if (null != (debugEle = rootdata.getUIElementById(168L))) {
            UIElement debugLogDataEle = rootdata.getUIElementById(9373L);
            debugEle.removeChildEleUI(debugLogDataEle);
        }
    }

    private void delSysMgrEle(RootDataElement rootdata) {
        UIElement newOperatorEle;
        UIElement opeEle = rootdata.getUIElementById(130L);
        if (null != opeEle && null != (newOperatorEle = rootdata.getUIElementById(131L))) {
            opeEle.removeChildEleUI(newOperatorEle);
        }
    }

    private void delLicenseEle(RootDataElement rootdata) {
        UIElement addResEle;
        UIElement opeEle = rootdata.getUIElementById(130L);
        if (null != opeEle && null != (addResEle = rootdata.getUIElementById(9385L))) {
            opeEle.removeChildEleUI(addResEle);
        }
    }

    private void delAddResEle(RootDataElement rootdata) {
        UIElement addResEle;
        UIElement opeEle = rootdata.getUIElementById(9350L);
        if (null != opeEle && null != (addResEle = rootdata.getUIElementById(9352L))) {
            opeEle.removeChildEleUI(addResEle);
        }
    }

    @Override
    @Permission(name={"lego.sys.role.scan"})
    public String getAllRoles(String orderBy, String orderType, int start, int pageSize) {
        if (!Validator.checkPageQueryParams(pageSize, start)) {
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        if (VerifyUtil.isEmpty((String)orderBy)) {
            orderBy = "iRoleID";
        }
        SortUnit su = new SortUnit();
        su.setFieldName(orderBy);
        orderType = VerifyUtil.isEmpty((String)orderType) || orderType.equals("asc") ? "asc" : "desc";
        su.setSortType(orderType);
        Paging page = mgr.getAllRole(start * pageSize, pageSize, su);
        int total = page.getiCount();
        List listRole = page.getData();
        for (Role role : listRole) {
            this.dealRoleDesc(role);
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"total", (Object)total);
        returnObject.put((Object)"roleList", (Object)listRole);
        return returnObject.toString();
    }
}

