/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.rollbacktask.service;

import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.service.IRollBackTaskService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.rollbacktask.service.IRollBackTaskRestService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.moment.bedstone.shield.annotation.Context;
import javax.ws.rs.core.Response;

public class RollBackTaskRestServiceImpl
extends AbstractRestService
implements IRollBackTaskRestService {
    private static final Log logger = LogFactory.getInstance(RollBackTaskRestServiceImpl.class);

    @Override
    @Context(name="taskName")
    @Permission(name={"ism.drm.protectgroup.auth.delete"})
    @Logging(name="backendTask_clear_VM_drconfig_operateName", rank=2, object="$taskName")
    public Response runTask(String taskInfo) {
        if (VerifyUtil.isEmpty((String)taskInfo)) {
            logger.error((Object)"the taskInfo is empty");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject taskInfoJson = JSONObject.fromObject((Object)taskInfo);
        String taskId = taskInfoJson.getString("taskId");
        if (VerifyUtil.isEmpty((String)taskId)) {
            logger.error((Object)"the taskId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IRollBackTaskService taskService = this.getBundleService(IRollBackTaskService.class);
        RollBackTaskInfo task = taskService.queryTask(taskId);
        if (VerifyUtil.isEmpty((Object)task)) {
            logger.error((Object)("task is not exist:taskId=" + taskId));
            throw new LegoCheckedException(2117645L);
        }
        String targetName = task.getTargetName();
        Context.Variable.set((String)"taskName", (Object)targetName);
        taskService.runTask(taskId);
        return Response.ok().build();
    }
}

