/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.service;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.system.model.DomainInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.ManageOneInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.model.OcAccessInfoVo;
import com.huawei.ism.drm.rest.service.framework.system.service.IThirdServiceRestService;
import com.huawei.ism.drm.system.thirdservice.sdk.model.CloudConfig;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.IDomainInfoService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import javax.ws.rs.core.Response;

public class ThirdServiceRestServiceImpl
extends AbstractRestService
implements IThirdServiceRestService {
    private static final Log logger = LogFactory.getInstance(ThirdServiceRestServiceImpl.class);
    private static final int MAX_PORT = 65535;

    public OcAccessInfoVo getOcAccessInfo() {
        this.checkUserOperationAuthority("thirdservie_queryOcParams_operateName", 1, "ism.drm.thirdservice.oc.scan");
        CloudConfig ocAccessInfo = this.getCloudConfigService().getCloudConfigBy("oc");
        OcAccessInfoVo vo = new OcAccessInfoVo();
        if (null != ocAccessInfo) {
            vo.setDomain((String)ocAccessInfo.getProps().get("oc_domain"));
            vo.setPort(NumberUtil.parseInteger(ocAccessInfo.getProps().get("oc_port")));
            vo.setUsername((String)ocAccessInfo.getProps().get("oc_username"));
        }
        return vo;
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.oc.modify"})
    @Logging(name="thirdservie_modifyManageOneParams_operateName", rank=3, object="=manageOneParam_objectName", detail="modifyManageOneParams_details", parameters={"$1?.domain", "$1?.port"})
    public Response saveManageOneInfo(ManageOneInfoVo vo) {
        if (null == vo) {
            logger.error((Object)"Param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        CloudConfig newInfo = new CloudConfig();
        newInfo.setConfigType("manageOne");
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("manageOne_port", String.valueOf(vo.getPort()));
        prop.put("manageOne_domain", vo.getDomain());
        newInfo.setProps(prop);
        this.getCloudConfigService().saveOrUpdateCloudConfig(newInfo);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.oc.scan"})
    public ManageOneInfoVo getManageOneInfo() {
        CloudConfig accessInfo = this.getCloudConfigService().getCloudConfigBy("manageOne");
        ManageOneInfoVo vo = new ManageOneInfoVo();
        if (null != accessInfo) {
            vo.setDomain((String)accessInfo.getProps().get("manageOne_domain"));
            vo.setPort(CommUtil.convertToInteger(accessInfo.getProps().get("manageOne_port")));
        }
        return vo;
    }

    private void checkParam(ManageOneInfoVo vo) {
        String domain = vo.getDomain();
        if (VerifyUtil.isEmpty((String)domain) || !CommUtil.checkDrmDomainParam((String)domain)) {
            logger.error((Object)"Param is error");
            throw new LegoCheckedException(1073947393L);
        }
        int port = vo.getPort();
        if (port <= 0 || port > 65535) {
            logger.error((Object)"Param is error");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ICloudConfigService getCloudConfigService() {
        return this.getBundleService(ICloudConfigService.class);
    }

    private IDomainInfoService getDomainInfoService() {
        return this.getBundleService(IDomainInfoService.class);
    }

    private void checkParam(DomainInfoVo vo) {
        if (VerifyUtil.isEmpty((String)vo.getBusinessDomain())) {
            logger.error((Object)"Param is error");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmIpParam((String)vo.getBusinessDomain()) && !CommUtil.checkDrmDomainParam((String)vo.getBusinessDomain())) {
            logger.error((Object)("domainForOS is not valid:" + vo.getBusinessDomain()));
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.sysnetwork.modify"})
    @Logging(name="thirdservie_modifySysNetworkParams_operateName", rank=3, object="=bcmNetworkParam_objectName", detail="modifySysNetworkParam_operateDetail", parameters={"$1?.businessDomain"})
    public Response saveDomainInfo(DomainInfoVo vo) {
        if (null == vo) {
            logger.error((Object)"Param is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkParam(vo);
        CloudConfig config = new CloudConfig();
        config.setConfigType("domain");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("domain_bussiness", vo.getBusinessDomain());
        config.setProps(props);
        this.getDomainInfoService().saveOrUpdateDomainInfo(config);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.thirdservice.sysnetwork.scan"})
    public DomainInfoVo getDomainInfo() {
        CloudConfig domainInfo = this.getDomainInfoService().getDomainInfo();
        DomainInfoVo vo = new DomainInfoVo();
        if (null != domainInfo) {
            vo.setBusinessDomain((String)domainInfo.getProps().get("domain_bussiness"));
        }
        return vo;
    }
}

