/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.system.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.cfgdata.sdk.service.IConfigDataBackupService;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public final class SystemFileUtil {
    private static Log log = FELogFactory.getInstance((String)"ui");
    private static final Set<String> lockedFile = new HashSet<String>();

    private SystemFileUtil() {
    }

    public static void downloadFile(HttpServletResponse response, File downloadFile, IConfigDataBackupService service, String displayName) {
        SystemFileUtil.downloadFile(response, downloadFile, service, displayName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadFile(HttpServletResponse response, File downloadFile, IConfigDataBackupService service, String displayName, boolean isDelFile) {
        FileInputStream fileInput;
        BufferedOutputStream bos;
        BufferedInputStream bis;
        String downloadFileName;
        block14: {
            block13: {
                downloadFileName = null;
                bis = null;
                bos = null;
                fileInput = null;
                try {
                    int bytesRead;
                    downloadFileName = downloadFile.getCanonicalPath();
                    if (!SystemFileUtil.lockFile(downloadFileName)) {
                        return;
                    }
                    if (VerifyUtil.isEmpty((String)downloadFileName)) {
                        log.error((Object)"Download filename is empty.");
                        return;
                    }
                    if (VerifyUtil.isEmpty((String)displayName)) {
                        displayName = downloadFileName.substring(downloadFileName.lastIndexOf(File.separator) + 1);
                    }
                    SystemFileUtil.setResponse(response, displayName);
                    if (!downloadFile.toPath().toRealPath(new LinkOption[0]).equals(downloadFile.toPath())) {
                        log.error((Object)"The file(%s) to be downloaded is a soft link. Delete the file and download it again.", new Object[]{displayName});
                        SystemFileUtil.close(bis, bos, fileInput);
                        break block13;
                    }
                    fileInput = new FileInputStream(downloadFileName);
                    bis = new BufferedInputStream(fileInput);
                    bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] buff = new byte[0x100000];
                    while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                        bos.write(buff, 0, bytesRead);
                    }
                    SystemFileUtil.close(bis, bos, fileInput);
                    break block14;
                }
                catch (IOException e) {
                    log.error((Object)"DownloadFile error", 653110170615808L);
                    return;
                }
            }
            SystemFileUtil.deleteAndReleaseFile(downloadFileName, downloadFile, service, isDelFile);
            return;
        }
        SystemFileUtil.deleteAndReleaseFile(downloadFileName, downloadFile, service, isDelFile);
        return;
        finally {
            SystemFileUtil.close(bis, bos, fileInput);
            SystemFileUtil.deleteAndReleaseFile(downloadFileName, downloadFile, service, isDelFile);
        }
    }

    private static void setResponse(HttpServletResponse response, String displayName) {
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                log.error((Object)"downloadFile", 653110170615808L);
            }
        }
    }

    public static void deleteFile(File file, IConfigDataBackupService service) {
        if (service != null) {
            service.deleteFile(file);
            log.info((Object)"delete file succ", 653110170615808L);
            return;
        }
        if (file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    log.error((Object)"delete file error", 653110170615808L);
                }
            } else if (file.isDirectory()) {
                SystemFileUtil.deleteDirectory(file);
            }
        } else {
            log.error((Object)"file is not exist", 653110170615808L);
        }
    }

    private static void deleteDirectory(File file) {
        Boolean result;
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                SystemFileUtil.deleteFile(files[i], null);
            }
        }
        if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
            log.error((Object)"delete file error", 653110170615808L);
        }
    }

    private static synchronized boolean lockFile(String fileName) {
        if (lockedFile.contains(fileName)) {
            log.error((Object)"Another thread already locked this file{%s} for downloading!", new Object[]{fileName});
            return false;
        }
        log.info((Object)"Lock file{%s} success for downloading.", new Object[]{fileName});
        lockedFile.add(fileName);
        return true;
    }

    private static synchronized void unlockFile(String fileName) {
        if (!VerifyUtil.isEmpty((String)fileName) && lockedFile.contains(fileName)) {
            lockedFile.remove(fileName);
            log.info((Object)"Unlock File{%S} success.", new Object[]{fileName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteAndReleaseFile(String downloadFileName, File downloadFile, IConfigDataBackupService service, boolean isDelFile) {
        try {
            if (isDelFile) {
                SystemFileUtil.deleteFile(downloadFile, service);
            }
        }
        catch (SecurityException e) {
            log.error((Object)"Delete File error.");
        }
        finally {
            SystemFileUtil.unlockFile(downloadFileName);
        }
    }
}

