/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.trapaddress.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.trapaddress.model.NorthNmsInfoVo;
import com.huawei.ism.drm.rest.service.framework.trapaddress.model.TrapSNMPV3VO;
import com.huawei.ism.drm.rest.service.framework.trapaddress.service.ITrapAddressRestService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.nms.north.sdk.model.NorthNmsInfo;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class TrapAddressRestServiceImpl
extends AbstractRestService
implements ITrapAddressRestService {
    private static transient Log logger = LogFactory.getInstance(TrapAddressRestServiceImpl.class);
    private static final int SNMPV3NORTHTYPE = 1;
    private static final long DEFAULT_SNMPV3_ID = 0L;
    private static final int MAX_PORT = 65535;
    private static final String SPECIAL_STR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String CHINESE_STR = "[^\\x00-\\xff]";
    private static final String CHAR_STR_LOWER = "[a-z]+";
    private static final String CHAR_STR_UPPER = "[A-Z]+";
    private static final String NUM_STR = "[0-9]+";
    private static final String COMPLEX_TWO = "2";
    private static final String COMPLEX_THREE = "3";
    private static final String COMPLEX_FOUR = "4";

    @Override
    @Permission(name={"lego.sys.grademgr.northnms.scan"})
    public List<NorthNmsInfoVo> queryTrapAddressList(String orderBy, String orderType) {
        INorthNmsService northService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        String orderField = "id";
        boolean orderByAscend = true;
        try {
            if (orderBy != null) {
                Validator.canOrderBy(orderBy);
                if ("desc".equalsIgnoreCase(orderType)) {
                    orderByAscend = false;
                }
                if (orderBy.equals("northIp")) {
                    orderField = "northIp";
                }
                if (orderBy.equals("port")) {
                    orderField = "port";
                }
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("OrderBy is error! OrderBy=" + orderBy), 653110170615808L);
            throw e;
        }
        List nmsNorthList = northService.getNorthNms(orderField, orderByAscend);
        ArrayList<NorthNmsInfoVo> northNmsInfoVos = new ArrayList<NorthNmsInfoVo>();
        if (VerifyUtil.isEmpty((Collection)nmsNorthList)) {
            return northNmsInfoVos;
        }
        for (NorthNmsInfo info : nmsNorthList) {
            northNmsInfoVos.add(this.northNmsToVo(info));
        }
        return northNmsInfoVos;
    }

    private NorthNmsInfoVo northNmsToVo(NorthNmsInfo info) {
        if (info == null) {
            return null;
        }
        NorthNmsInfoVo vo = new NorthNmsInfoVo();
        vo.setId(info.getId());
        vo.setIp(info.getNorthIp());
        vo.setPort(info.getPort());
        vo.setDescription(info.getDescription());
        vo.setStatus(info.getStatus());
        return vo;
    }

    @Override
    @Permission(name={"lego.sys.grademgr.northnms.add"})
    @Logging(name="northTrap_addTrapIPAddr_operateName", rank=3, object="$1?.ip +':' + $1?.port")
    public Response addTrapAddress(NorthNmsInfoVo vo) {
        if (VerifyUtil.isEmpty((Object)vo)) {
            throw new LegoCheckedException(1073947393L);
        }
        NorthNmsInfo info = new NorthNmsInfo();
        Object object = this.getBundleService("slave", "northNmsService");
        INorthNmsService northService = (INorthNmsService)object;
        if (!Ipv6AddressUtil.isIPv6Address((String)vo.getIp()) && !Validator.isProxyIp(vo.getIp())) {
            throw new LegoCheckedException(250L);
        }
        info.setNorthIp(vo.getIp());
        if (vo.getPort() <= 0 || vo.getPort() > 65535) {
            throw new LegoCheckedException(250L);
        }
        info.setPort(vo.getPort().intValue());
        this.validateAuthAndPrivPwd(vo);
        northService.addNorthNms(info);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"lego.sys.grademgr.northnms.scan"})
    public NorthNmsInfoVo queryTrapAddress(Long id) {
        Object obj = this.getBundleService("slave", "northNmsService");
        INorthNmsService nmsService = (INorthNmsService)obj;
        NorthNmsInfo nms = nmsService.getNorthNms(id.longValue());
        return this.northNmsToVo(nms);
    }

    @Override
    @Permission(name={"lego.sys.grademgr.northnms.delete"})
    @Logging(name="northTrap_deleteTrapIPAddr_operateName", rank=2)
    public BatchOperationResult deleteTrapAddress(Set<Long> ids) {
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        List<BatchOperation> bathOprLst = this.getBathOprLst(ids, nmsService);
        return nmsService.deleteNorthNms(bathOprLst);
    }

    private List<BatchOperation> getBathOprLst(Set<Long> ids, INorthNmsService nmsService) {
        if (nmsService == null) {
            throw new LegoCheckedException(1073947395L);
        }
        if (!VerifyUtil.isEmpty(ids)) {
            ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>(ids.size());
            for (long id : ids) {
                BatchOperation tempBatch = new BatchOperation();
                tempBatch.setTargetId(id);
                NorthNmsInfo nms = nmsService.getNorthNms(id);
                tempBatch.setTargetName(nms.getNorthIp() + ":" + nms.getPort());
                bathOprLst.add(tempBatch);
            }
            return bathOprLst;
        }
        throw new LegoCheckedException(250L);
    }

    @Override
    @Contexts(value={@Context(name="oldIp"), @Context(name="oldPort")})
    @Permission(name={"lego.sys.grademgr.northnms.modify"})
    @Logging(name="northTrap_modifyTrapIPAddr_operateName", rank=3, object="$oldIp + ':' + $oldPort", detail="northTrap_modifyTrapIPAddr_operateDetail", parameters={"$oldIp", "$oldPort", "$1?.ip", "$1?.port"})
    public Response modifyTrapAddress(NorthNmsInfoVo vo, Long id) {
        CommUtils.checkParamEmpty(vo, id);
        vo.setId(id);
        Object obj = this.getBundleService("slave", "northNmsService");
        INorthNmsService nmsService = (INorthNmsService)obj;
        NorthNmsInfo nms = nmsService.getNorthNms(id.longValue());
        String oldIp = nms.getNorthIp();
        String oldPort = String.valueOf(nms.getPort());
        Context.Variable.set((String)"oldIp", (Object)oldIp);
        Context.Variable.set((String)"oldPort", (Object)oldPort);
        if (VerifyUtil.isEmpty((String)vo.getIp())) {
            logger.error((Object)"Ip is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if ("IPV4".equals(AddressUtil.ipType((String)vo.getIp())) ? !Validator.isProxyIp(vo.getIp()) : !Ipv6AddressUtil.isIPv6Address((String)vo.getIp())) {
            throw new LegoCheckedException(250L);
        }
        if (vo.getPort() <= 0 || vo.getPort() > 65535) {
            throw new LegoCheckedException(250L);
        }
        this.validateAuthAndPrivPwd(vo);
        this.voToNorthNms(vo, nms);
        nmsService.modifyNorthNms(nms);
        return Response.ok().build();
    }

    private void voToNorthNms(NorthNmsInfoVo vo, NorthNmsInfo northNmsInfo) {
        northNmsInfo.setNorthIp(vo.getIp());
        northNmsInfo.setPort(vo.getPort().intValue());
    }

    @Override
    @Permission(name={"lego.sys.grademgr.nms.trapConfig.scan"})
    public TrapSNMPV3VO getTrapParamConfig() {
        TrapSNMPV3VO northTrapConfVO;
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        SnmpV3Param temptrapConf = nmsService.getTrapConfVo(1);
        if (null == temptrapConf) {
            TrapSNMPV3VO northTrapConfVO2 = new TrapSNMPV3VO();
            northTrapConfVO2.setId(0L);
            northTrapConfVO2.setAuthProtocol("");
            northTrapConfVO2.setAuthPwd("");
            northTrapConfVO2.setContextEngineId("");
            northTrapConfVO2.setContextName("");
            northTrapConfVO2.setEncryptProtocol("");
            northTrapConfVO2.setEncryptPwd("");
            northTrapConfVO2.setSecurityName("");
            northTrapConfVO2.setType(1);
            northTrapConfVO2.setVersion(SnmpEnum.SnmpVersion.VERSION3.getValue());
            return northTrapConfVO2;
        }
        if (temptrapConf.getVersion() == SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            northTrapConfVO = new TrapSNMPV3VO(temptrapConf);
            northTrapConfVO.setAuthPwd("");
            northTrapConfVO.setEncryptPwd("");
            northTrapConfVO.setType(temptrapConf.getType());
            northTrapConfVO.setVersion(temptrapConf.getVersion());
        } else {
            northTrapConfVO = new TrapSNMPV3VO();
            northTrapConfVO.setId(temptrapConf.getSnmpV3ParamId());
            northTrapConfVO.setType(temptrapConf.getType());
            northTrapConfVO.setVersion(temptrapConf.getVersion());
            northTrapConfVO.setReadCommunity("");
            northTrapConfVO.setWriteCommunity("");
        }
        return northTrapConfVO;
    }

    @Override
    @Permission(name={"lego.sys.grademgr.nms.trapConfig.modify"})
    @Logging(name="northTrap_modifyTrapParams_operateName", rank=3, object="=northTrapParams_objectName")
    public Response saveNorthTrapConfig(TrapSNMPV3VO northTrapConfVO) {
        SnmpV3Param snmpV3Obj;
        if (northTrapConfVO == null) {
            throw new LegoCheckedException(250L);
        }
        INorthNmsService nmsService = (INorthNmsService)this.getBundleService("slave", "northNmsService");
        SnmpV3Param snmpTemp = nmsService.getTrapConf(1);
        boolean reuseAuthPwd = false;
        boolean reuseEncryptPwd = false;
        if (northTrapConfVO.getVersion() == SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            snmpV3Obj = this.getSnmpV3Param(northTrapConfVO, snmpTemp);
            snmpV3Obj.setVersion(Integer.valueOf(northTrapConfVO.getVersion()));
            if (Validator.stringisNull(northTrapConfVO.getAuthPwd())) {
                reuseEncryptPwd = true;
            }
            if (Validator.stringisNull(northTrapConfVO.getEncryptPwd())) {
                reuseEncryptPwd = true;
            }
        } else {
            if (Validator.stringisNull(northTrapConfVO.getReadCommunity()) || Validator.stringisNull(northTrapConfVO.getWriteCommunity())) {
                throw new LegoCheckedException(250L);
            }
            snmpV3Obj = new SnmpV3Param();
            snmpV3Obj.setSnmpV3ParamId(northTrapConfVO.getId());
            snmpV3Obj.setVersion(Integer.valueOf(northTrapConfVO.getVersion()));
            snmpV3Obj.setReadCommunity(this.getEncryptComm(northTrapConfVO.getReadCommunity()));
            snmpV3Obj.setWriteCommunity(this.getEncryptComm(northTrapConfVO.getWriteCommunity()));
        }
        snmpV3Obj.setType(Integer.valueOf(1));
        if (null == snmpTemp) {
            snmpV3Obj.setSnmpV3ParamId(null);
        }
        nmsService.saveTrapConf(snmpV3Obj, reuseAuthPwd, reuseEncryptPwd);
        return Response.ok().build();
    }

    private String getEncryptComm(String comm) {
        if (!Validator.stringisNull(comm)) {
            return WccEncryptor.encrypt((String)comm);
        }
        return comm;
    }

    private SnmpV3Param getSnmpV3Param(TrapSNMPV3VO northTrapConfVO, SnmpV3Param snmpV3Param) {
        long id = northTrapConfVO.getId();
        if (snmpV3Param != null) {
            long idExist = snmpV3Param.getSnmpV3ParamId();
            this.checkNorthTrapConfVO(northTrapConfVO, id, idExist);
        } else {
            if (Validator.stringisNull(northTrapConfVO.getAuthPwd()) || Validator.stringisNull(northTrapConfVO.getEncryptPwd())) {
                throw new LegoCheckedException(250L);
            }
            this.checkNorthTrapConfVOPwdComplex(northTrapConfVO);
        }
        this.checkSnmpv3Para(northTrapConfVO);
        return this.trapVO2SNMPV3(northTrapConfVO);
    }

    private void checkNorthTrapConfVO(TrapSNMPV3VO northTrapConfVO, long id, long idExist) {
        if (id != idExist) {
            logger.error((Object)"not exist!", 653110169305088L);
            throw new LegoCheckedException(250L);
        }
        this.checkNorthTrapConfVOPwdComplex(northTrapConfVO);
    }

    private void checkNorthTrapConfVOPwdComplex(TrapSNMPV3VO northTrapConfVO) {
        if (!this.isPwdMatchComplex(northTrapConfVO.getAuthPwd())) {
            throw new LegoCheckedException(250L);
        }
        if (!this.isPwdMatchComplex(northTrapConfVO.getEncryptPwd())) {
            throw new LegoCheckedException(250L);
        }
    }

    private boolean isPwdMatchComplex(String password) {
        IUserMgr mgr = (IUserMgr)this.getBundleService("user", "usermgr");
        String complex = mgr.getSystemSecPolicy().getUserSecPolicy().getComplex();
        if (Validator.stringisNull(password)) {
            return true;
        }
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        if (Pattern.compile(CHINESE_STR).matcher(password).find()) {
            return false;
        }
        return !(COMPLEX_TWO.equalsIgnoreCase(complex.trim()) ? !this.isPwdMatchComplexSecond(password) : (COMPLEX_THREE.equalsIgnoreCase(complex.trim()) ? !Pattern.compile(SPECIAL_STR).matcher(password).find() : COMPLEX_FOUR.equalsIgnoreCase(complex.trim()) && this.checkPwdComplexFour(password) == false));
    }

    private boolean isPwdMatchComplexSecond(String password) {
        boolean flag3;
        boolean flag1 = !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean flag2 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean bl = flag3 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        return !flag1 || !flag2 || !flag3;
    }

    private Boolean checkPwdComplexFour(String password) {
        if (!(Pattern.compile(SPECIAL_STR).matcher(password).find() && Pattern.compile(CHAR_STR_LOWER).matcher(password).find() && Pattern.compile(CHAR_STR_UPPER).matcher(password).find() && Pattern.compile(NUM_STR).matcher(password).find())) {
            return false;
        }
        return true;
    }

    private SnmpV3Param trapVO2SNMPV3(TrapSNMPV3VO vo) {
        SnmpV3Param snmpv3 = new SnmpV3Param();
        snmpv3.setAuthPwd(vo.getAuthPwd());
        snmpv3.setPrivPwd(vo.getEncryptPwd());
        if ("HMACMD5".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.MD5_AUTH);
        } else if ("HMAC_SHA1".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.SHA1_AUTH);
        } else if ("HMAC_SHA2".equals(vo.getAuthProtocol())) {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.SHA2_AUTH);
        } else {
            snmpv3.setAuthProtocol(SnmpEnum.AuthProtocol.NO_AUTH);
            snmpv3.setAuthPwd("");
        }
        if ("DES".equals(vo.getEncryptProtocol())) {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.CBC_DES);
        } else if ("AES".equals(vo.getEncryptProtocol())) {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.CFB_AES_128);
        } else {
            snmpv3.setPrivProtocol(SnmpEnum.PrivProtocol.NO_PRIV);
            snmpv3.setPrivPwd("");
        }
        if (!VerifyUtil.isEmpty((String)vo.getContextName())) {
            snmpv3.setContextName(vo.getContextName());
        }
        if (!VerifyUtil.isEmpty((String)vo.getContextEngineId())) {
            snmpv3.setContextEngineId(vo.getContextEngineId());
        }
        snmpv3.setSecurityName(vo.getSecurityName());
        snmpv3.setSnmpV3ParamId(vo.getId());
        return snmpv3;
    }

    private void checkSnmpv3Para(TrapSNMPV3VO snmpv3) {
        ArrayList<String> authProtocolList = new ArrayList<String>();
        authProtocolList.add("HMACMD5");
        authProtocolList.add("HMAC_SHA1");
        authProtocolList.add("HMAC_SHA2");
        ArrayList<String> encryptProtocolList = new ArrayList<String>();
        encryptProtocolList.add("DES");
        encryptProtocolList.add("AES");
        if (Validator.stringisNull(snmpv3.getSecurityName()) || !Validator.checkStringLength(snmpv3.getSecurityName(), 64)) {
            throw new LegoCheckedException(250L);
        }
        if (!VerifyUtil.isEmpty((String)snmpv3.getContextName()) && !Validator.checkStringLength(snmpv3.getContextName(), 64)) {
            throw new LegoCheckedException(250L);
        }
        this.validateContextParams(snmpv3);
        this.checkSnmpv3Para2(snmpv3, authProtocolList, encryptProtocolList);
    }

    private void validateContextParams(TrapSNMPV3VO snmpv3) {
        if (!VerifyUtil.isEmpty((String)snmpv3.getContextEngineId())) {
            if (!Validator.checkStringLength(snmpv3.getContextEngineId(), 32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkMinStringLength(snmpv3.getContextEngineId(), 5)) {
                throw new LegoCheckedException(250L);
            }
        }
        if (Validator.stringisNull(snmpv3.getAuthProtocol()) && !Validator.stringisNull(snmpv3.getEncryptProtocol())) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkSnmpv3Para2(TrapSNMPV3VO snmpv3, List<String> authProtocolList, List<String> encryptProtocolList) {
        if (!Validator.stringisNull(snmpv3.getAuthProtocol())) {
            if (!authProtocolList.contains(snmpv3.getAuthProtocol())) {
                throw new LegoCheckedException(250L);
            }
            if (Validator.stringisNull(snmpv3.getAuthPwd())) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkStringLength(snmpv3.getAuthPwd(), 64)) {
                throw new LegoCheckedException(250L);
            }
        }
        this.validateEncryptProtocol(snmpv3, encryptProtocolList);
    }

    private void validateEncryptProtocol(TrapSNMPV3VO snmpv3, List<String> encryptProtocolList) {
        if (!Validator.stringisNull(snmpv3.getEncryptProtocol())) {
            if (!encryptProtocolList.contains(snmpv3.getEncryptProtocol())) {
                throw new LegoCheckedException(250L);
            }
            if (Validator.stringisNull(snmpv3.getEncryptPwd())) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.checkStringLength(snmpv3.getEncryptPwd(), 64)) {
                throw new LegoCheckedException(250L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAuthAndPrivPwd(NorthNmsInfoVo vo) {
        INorthNmsService nmsService = this.getBundleService("slave", "northNmsService", INorthNmsService.class);
        SnmpV3Param snmpTemp = new SnmpV3Param();
        try {
            snmpTemp.setAuthPwd(vo.getAuthPwd());
            snmpTemp.setPrivPwd(vo.getPrivPwd());
            this.doValidateAuthAndPrivPwd(snmpTemp);
        }
        finally {
            this.erasePwd(vo, snmpTemp);
        }
    }

    private void erasePwd(NorthNmsInfoVo vo, SnmpV3Param snmpTemp) {
        if (vo != null) {
            SecurityUtil.erasePwd((String)vo.getAuthPwd());
            SecurityUtil.erasePwd((String)vo.getPrivPwd());
        }
        SecurityUtil.erasePwd((String)snmpTemp.getPrivPwd());
        SecurityUtil.erasePwd((String)snmpTemp.getAuthPwd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidateAuthAndPrivPwd(SnmpV3Param snmpV3Param) {
        INorthNmsService nmsService = this.getBundleService("slave", "northNmsService", INorthNmsService.class);
        SnmpV3Param snmpTempFromDb = nmsService.getTrapConf(1);
        if (VerifyUtil.isEmpty((Object)snmpTempFromDb)) {
            logger.error((Object)"Trap param does not set, please add first.");
            throw new LegoCheckedException(1073948513L);
        }
        if (snmpTempFromDb.getVersion() != SnmpEnum.SnmpVersion.VERSION3.getValue()) {
            logger.info((Object)"Trap version is not v3, no need check.");
            return;
        }
        try {
            if (SnmpEnum.AuthProtocol.NO_AUTH.equals((Object)snmpTempFromDb.getAuthProtocol())) {
                logger.info((Object)"Do not config, no need to check.");
                return;
            }
            if (VerifyUtil.isEmpty((String)snmpV3Param.getAuthPwd()) || !StringUtils.equals((CharSequence)snmpV3Param.getAuthPwd(), (CharSequence)snmpTempFromDb.getAuthPwd())) {
                logger.error((Object)"Failed to validate, please check.");
                throw new LegoCheckedException(1073948514L);
            }
            if (SnmpEnum.PrivProtocol.NO_PRIV.equals((Object)snmpTempFromDb.getPrivProtocol())) {
                logger.info((Object)"Do not config, no need to check.");
                return;
            }
            if (VerifyUtil.isEmpty((String)snmpV3Param.getPrivPwd()) || !StringUtils.equals((CharSequence)snmpV3Param.getPrivPwd(), (CharSequence)snmpTempFromDb.getPrivPwd())) {
                logger.error((Object)"Failed to validate, please check.");
                throw new LegoCheckedException(1073948514L);
            }
        }
        finally {
            if (!VerifyUtil.isEmpty((Object)snmpTempFromDb)) {
                SecurityUtil.erasePwd((String)snmpTempFromDb.getAuthPwd());
                SecurityUtil.erasePwd((String)snmpTempFromDb.getPrivPwd());
            }
        }
    }
}

