/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.user.service;

import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.rest.service.framework.user.service.IUserRestService;
import com.huawei.ism.drm.rest.service.framework.user.service.UserRestServiceValidator;
import com.huawei.ism.drm.rest.service.framework.user.service.model.AdminPasswordModifyVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.PasswordModifyVo;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserVo;
import com.huawei.ism.drm.rest.service.framework.user.util.UserUtil;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.rest.util.RandCodeCheck;
import com.huawei.ism.drm.rest.util.SysOpLogBuilder;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.IThirdPartResourcesService;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.model.UserSecPolicy;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.SHA256Encryptor;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.nem.discover.sdk.service.IProductsCustomizeService;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class UserRestServiceImpl
extends AbstractRestService
implements IUserRestService {
    public static final long OC_ADMIN_ROLE = -1L;
    private static final Log LOG = FELogFactory.getInstance((String)"ui");
    private static final String ASG = "asg";
    private static final Long ADMIN_ID = 1L;
    private static final int MINUTE_MS = 60000;
    private static final String ADMIN_NAME = "admin";
    private static final String BIZ_OBJECT_TREE_ROOT_ID = "0";
    private static final String SITE_TREE_ROOT_ID = "1";
    private static final String PROTECTGROUP_TREE_ROOT_ID = "2";
    private static final String LOCAL_RECOVERYPLAN_TREE_ROOT_ID = "4";
    private static final String REMOTE_RECOVERYPLAN_TREE_ROOT_ID = "3";
    private static final Integer USER_MODIFY = 0;
    private static final Integer USER_ADD = 1;
    private static final String[] USER_CUSTOM_SETTING_WHITELIST = new String[]{"showQuickStart"};

    @Override
    @Permission(name={"lego.sys.onlineUserMgr.scan"})
    public String getAllOnlineUserInfo(String orderBy, String orderType, int startPage, int pageSize) {
        Paging page;
        if (startPage < 0 || pageSize < 0) {
            LOG.error((Object)"StartPage(%s) or pageSize(%s) < 0", new Object[]{String.valueOf(startPage), String.valueOf(pageSize)});
            throw new LegoCheckedException(1073947393L);
        }
        User user = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        int start = startPage * pageSize;
        if (orderBy == null || 0 == orderBy.length()) {
            page = mgr.getAllOnlineUser(user, "stayTime", "DESC", start, pageSize);
        } else {
            try {
                Validator.canOrderBy(orderBy);
                page = mgr.getAllOnlineUser(user, orderBy, orderType, start, pageSize);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"OrderBy is error! OrderBy=%s", new Object[]{orderBy});
                throw e;
            }
        }
        List usersList = page.getData();
        int total = page.getiCount();
        this.resetUserLoginDate(usersList);
        if (start >= total) {
            int lastRec = total % pageSize;
            start = lastRec == 0 ? total - start : total - lastRec;
            page = orderBy == null || 0 == orderBy.length() ? mgr.getAllOnlineUser(user, "stayTime", "DESC", start, pageSize) : mgr.getAllOnlineUser(user, orderBy, orderType, start, pageSize);
            usersList = page.getData();
            total = page.getiCount();
        }
        this.addAdminFlag(usersList);
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"totalCount", (Object)total);
        returnObject.put((Object)"records", (Object)usersList);
        return returnObject.toString();
    }

    private void resetUserLoginDate(List<User> usersList) {
        for (User u : usersList) {
            Date loginDate = CommUtils.parseDate(u.getLoginDate());
            if (null == loginDate) {
                u.setLoginDate("");
                continue;
            }
            u.setLoginDate(CommUtils.formatDate(loginDate));
        }
    }

    private void addAdminFlag(List<User> usersList) {
        for (User user : usersList) {
            long userId = user.getUserId();
            boolean isAdministrator = userId > 0L ? this.checkIsAdministrator(userId) : true;
            user.setIsAdministrator(Boolean.valueOf(isAdministrator).toString());
        }
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.scan"})
    public String getAllUserInfo(String orderBy, String orderType, int start, int pageSize) {
        if (!Validator.checkPageQueryParams(orderType, pageSize, start)) {
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgr mgr = this.getUserService();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        try {
            if (orderBy != null) {
                Validator.canOrderBy(orderBy);
                if (orderType.equalsIgnoreCase("DESC")) {
                    queryMap.put("DESC", orderBy);
                } else {
                    queryMap.put("DESC", orderBy);
                }
            } else {
                queryMap.put("DESC", "id");
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"OrderBy is error! OrderBy=%s", new Object[]{orderBy});
            throw e;
        }
        Paging page = mgr.getAllUser(queryMap, start * pageSize, pageSize);
        int total = page.getiCount();
        List userList = page.getData();
        for (User usr : userList) {
            if (UserRestServiceValidator.checkIsAdministrator(usr.getUserId())) {
                usr.setIsAdministrator("true");
            }
            usr.setMoAuthIdsSet(null);
            usr.setMoAutSeth(null);
            usr.setMoGroupIdsSet(null);
            usr.setRolesSet(null);
            usr.setRolesIdsSet(null);
            usr.setUserAclSet(null);
            usr.setUserPassword("");
            usr.setUserPasswordSalt("");
            if (null == usr.getDescription() || !usr.getDescription().equals("null")) continue;
            usr.setDescription("null ");
        }
        JSONObject returnObject = new JSONObject();
        returnObject.put((Object)"total", (Object)total);
        returnObject.put((Object)"userList", (Object)userList);
        return returnObject.toString();
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.scan"}, when="!('' + $this.getCurrentUserId()).equals($1)")
    public UserVo getUserInfoById(String userId) {
        long uId;
        if (VerifyUtil.isEmpty((String)userId)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            uId = Long.parseLong(userId);
        }
        catch (NumberFormatException e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        IUserMgr mgr = this.getUserService();
        User queryUsr = mgr.getUserBaseInfo(uId);
        String isAdministrator = "false";
        if (this.checkIsAdministrator(queryUsr.getUserId())) {
            isAdministrator = "true";
        }
        queryUsr.setIsAdministrator(isAdministrator);
        queryUsr.setUserPassword("");
        queryUsr.setUserPasswordSalt("");
        for (UserAcl userAcl : queryUsr.getUserAclSet()) {
            if (userAcl.getStartIpStr().contains(".") || userAcl.getStartIpStr().contains(":")) continue;
            userAcl.setStartIpStr(Ipv4AddressUtil.longToIPv4((long)NumberUtil.convertToLong((Object)userAcl.getStartIpStr())));
            userAcl.setEndIpStr(Ipv4AddressUtil.longToIPv4((long)NumberUtil.convertToLong((Object)userAcl.getEndIpStr())));
        }
        return UserUtil.convertUser2UserVo(queryUsr, this.loadUserGrantedObjects(queryUsr.getUserId()));
    }

    private String[] loadUserGrantedObjects(Long userId) {
        String[] bizObjs = null;
        IBizScopeManager manager = this.getBizScopeManager();
        List objList = manager.getUserGrantObject(userId);
        if (!VerifyUtil.isEmpty((Collection)objList)) {
            int size = objList.size();
            bizObjs = new String[size];
            for (int i = 0; i < size; ++i) {
                bizObjs[i] = ((DRMObject)objList.get(i)).getUuid();
            }
        }
        return bizObjs;
    }

    private IUserMgr getUserService() {
        return (IUserMgr)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.add"})
    @Logging(name="user_createUser_operateName", object="$1?.userName")
    public Response createUser(UserVo user, int byType) {
        IUserMgr mgr = this.getUserService();
        this.checkUser(user, mgr);
        Set roleSet = user.getRolesIdsSet();
        User currentUser = this.getCurrentUser();
        UserRestServiceValidator.checkCreateUserParam(user, mgr, roleSet, currentUser);
        if (roleSet.contains(-1L)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAcl(user, mgr);
        String projectName = "";
        IProductsCustomizeService pcs = (IProductsCustomizeService)ServiceLocator.getBundleService((String)"discover", (String)"ProductsCustomizeServiceImpl");
        if (pcs.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            projectName = (String)pcs.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        Set<Long> resIds = user.getResIds();
        List<Long> resourcesIds = this.dealResourceIds(user, currentUser, resIds, USER_ADD);
        this.doCreateUser(user, resIds, resourcesIds, projectName);
        return Response.ok().build();
    }

    private void checkUser(UserVo user, IUserMgr mgr) {
        if (VerifyUtil.isEmpty((Object)((Object)user))) {
            LOG.error((Object)"The input user is null.");
            throw new LegoCheckedException(1073947393L);
        }
        user.setPasswordModel(UserAuthorityType.local.getValue());
        boolean isValidate = this.validateSaveUser(user, mgr, true);
        if (!isValidate) {
            throw new LegoCheckedException(250L);
        }
        if (UserRestServiceValidator.checkComman(user.getUserName(), user.getConfirmPassword()).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
    }

    private void doCreateUser(UserVo user, Set<Long> resIds, List<Long> resourcesIds, String projectName) {
        IUserMgr mgr = this.getUserService();
        if (UserAuthorityType.local.getValue() == user.getPasswordModel()) {
            user.setMustModifyPwd(true);
        }
        long userId = mgr.addUserInfo(UserRestServiceValidator.convertUserVoToUser(user));
        if (null != projectName && projectName.equalsIgnoreCase(ASG) && resIds != null && !resIds.isEmpty()) {
            IThirdPartResourcesService tprService = (IThirdPartResourcesService)ServiceLocator.getBundleService((String)"asgResource", (String)"thirdPartResources");
            tprService.grandResourcesToUser(userId, resourcesIds);
        }
        this.forceLogout(user, mgr, this.getCurrentUser(), userId);
        this.dealScopeManager(user, mgr);
        user.setUserPassword(null);
        user.setConfirmPassword(null);
    }

    private void checkResourceExist(Collection<Long> resIds, boolean newUser) {
        if (VerifyUtil.isEmpty(resIds)) {
            return;
        }
        HashMap<String, Object[]> query = new HashMap<String, Object[]>();
        query.put("moId", resIds.toArray());
        List moList = this.getBundleService(IResourceService.class).queryMoList(ManagedObject.class, query);
        if (VerifyUtil.isEmpty((Collection)moList) || moList.size() < resIds.size()) {
            ArrayList<Long> wrongResource = new ArrayList<Long>(resIds);
            for (ManagedObject mo : moList) {
                wrongResource.remove(mo.getMoId());
            }
            StringBuilder sb = new StringBuilder();
            for (Long id : wrongResource) {
                if (sb.length() != 0) {
                    sb.append("; ");
                }
                sb.append(id);
            }
            if (newUser) {
                this.writeFailedOperationLog("user_createUser_operateName", 1, sb.toString(), (Exception)((Object)new LegoCheckedException(1073947394L)));
            } else {
                this.writeFailedOperationLog("user_modifyUser_operateName", 3, sb.toString(), (Exception)((Object)new LegoCheckedException(1073947394L)));
            }
        }
    }

    private List<Long> dealResourceIds(UserVo user, User currentUser, Set<Long> resIds, Integer modifyOrCreate) {
        ArrayList<Long> resourcesIds = new ArrayList<Long>();
        Set<Long> checkResIds = this.filterResources(resIds, user, currentUser, modifyOrCreate);
        this.checkMoAndAdministrator(checkResIds, modifyOrCreate);
        user.setMoAuthIdsSet(resIds);
        if (resIds != null) {
            resourcesIds.addAll(resIds);
        }
        if (!VerifyUtil.isEmpty(resIds)) {
            HashSet<Long> resIdset = new HashSet<Long>(resIds);
            resIdset.remove(0L);
            resIdset.remove(1L);
            this.checkResourceExist(resIdset, USER_ADD.equals(modifyOrCreate));
        }
        return resourcesIds;
    }

    private Set<Long> filterResources(Set<Long> resIds, UserVo user, User currentuser, Integer modifyOrCreate) {
        if (resIds == null) {
            resIds = new HashSet<Long>();
        }
        HashSet<Long> newResIds = new HashSet<Long>();
        if (USER_ADD.equals(modifyOrCreate)) {
            newResIds.addAll(resIds);
            newResIds.remove(0L);
            newResIds.remove(1L);
            return newResIds;
        }
        if (!"true".equals(currentuser.getIsAdmin())) {
            IUserMgr mgr = this.getUserService();
            User userInfo = mgr.getUserBaseInfo(user.getUserId().longValue());
            Set moIdSet = userInfo.getMoAuthIdsSet();
            if (VerifyUtil.isEmpty((Collection)moIdSet)) {
                newResIds.addAll(resIds);
            } else {
                for (Long resId : resIds) {
                    if (moIdSet.contains(resId)) continue;
                    newResIds.add(resId);
                }
                for (Long moId : moIdSet) {
                    if (resIds.contains(moId)) continue;
                    newResIds.add(moId);
                }
            }
        }
        newResIds.remove(0L);
        newResIds.remove(1L);
        return newResIds;
    }

    private void dealScopeManager(UserVo user, IUserMgr mgr) {
        User oUser = mgr.getUserBaseInfoByName(user.getUserName());
        String[] bizObjArray = user.getBizObjs();
        String bizObjs = UserUtil.bizObjsArrayToStr(bizObjArray);
        if (null != oUser) {
            Long oUserId = oUser.getUserId();
            IBizScopeManager scope = this.getBizScopeManager();
            try {
                scope.saveOrUpdateObject(bizObjs, oUserId);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"Save user business object error", (Throwable)e);
                throw e;
            }
        }
    }

    private void forceLogout(UserVo user, IUserMgr mgr, User currentuser, Long userId) {
        List users;
        if (!String.valueOf(currentuser.getUserId()).equals(String.valueOf(userId)) && null != (users = mgr.getAllOnlineUser(null))) {
            for (User u : users) {
                if (!user.getUserName().equals(u.getUserName())) continue;
                LOG.info((Object)"Force logout. User: %s", new Object[]{user.getUserName()});
                try {
                    mgr.forceLogout(u.getSession());
                    this.writeSucOperationLog("user_forceOffline_operateName", 2, user.getUserName(), null, null);
                }
                catch (Exception e) {
                    this.writeFailedOperationLogNoException("user_forceOffline_operateName", 2, user.getUserName(), e);
                }
            }
        }
    }

    private void checkUserAcl(UserVo user, IUserMgr mgr) {
        User aclusr;
        int selectType = 0;
        Iterator iteracl = null;
        Long userId = user.getUserId();
        if (null != userId && userId != 0L && null != (aclusr = mgr.getUserBaseInfo(user.getUserId().longValue()))) {
            iteracl = aclusr.getUserAclSet().iterator();
        }
        UserRestServiceValidator.subCheckUserAcl(user, iteracl);
        user.setSelectType(selectType);
    }

    private Boolean validateSaveUser(UserVo user, IUserMgr mgr, Boolean isNewUser) {
        if (user == null) {
            return false;
        }
        if (this.getCurrentUserId().equals(user.getUserId()) && !ADMIN_ID.equals(this.getCurrentUserId())) {
            return false;
        }
        this.checkBizObjAuth(user, isNewUser);
        User currentUser = this.getCurrentUser();
        if (ADMIN_ID.equals(user.getUserId()) && !ADMIN_ID.equals(currentUser.getUserId())) {
            return false;
        }
        if ("true".equalsIgnoreCase(user.getIsAdmin().trim()) && !ADMIN_ID.equals(user.getUserId()) && !user.isSyncAdmin()) {
            return false;
        }
        if (user.isSyncAdmin() && !ADMIN_ID.equals(this.getCurrentUserId())) {
            return false;
        }
        UserRestServiceValidator.checkUserLenth(user);
        UserRestServiceValidator.checkPwdModel(user, mgr, isNewUser);
        this.validSessionControl(user);
        return true;
    }

    private void validSessionControl(UserVo user) {
        if (null == user.getSessionControl() || !user.getSessionControl().booleanValue()) {
            return;
        }
        int sessionLimit = NumberUtil.getIntValue((Integer)user.getSessionLimit());
        if (0 >= sessionLimit || 8 < sessionLimit) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkBizObjAuth(UserVo user, Boolean isNewUser) {
        try {
            if (isNewUser.booleanValue()) {
                if (VerifyUtil.isEmpty((Object[])user.getBizObjs())) {
                    return;
                }
                for (String id : user.getBizObjs()) {
                    this.checkUserBizObjAuthority("user_createUser_operateName", 1, id);
                }
            } else {
                List<String> checkBizObjs = this.filterCheckBizObjs(user);
                for (String id : checkBizObjs) {
                    this.checkUserBizObjAuthority("user_modifyUser_operateName", 3, id);
                }
            }
        }
        catch (LegoCheckedException ex) {
            LOG.error((Object)"Check bizObj error!", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"check bizObj error!", (long)-1L, null, (Log)LOG);
        }
    }

    private List<String> filterCheckBizObjs(UserVo user) {
        ArrayList<String> checkBizObjs = new ArrayList<String>();
        Object[] bizObjsArray = user.getBizObjs();
        IBizScopeManager manager = this.getBizScopeManager();
        List objList = manager.getUserGrantObject(user.getUserId());
        ArrayList<String> bizObjs = null;
        if (!VerifyUtil.isEmpty((Collection)objList)) {
            bizObjs = new ArrayList<String>();
            for (DRMObject drmObject : objList) {
                bizObjs.add(drmObject.getUuid());
            }
        }
        if (!VerifyUtil.isEmpty(bizObjs)) {
            if (VerifyUtil.isEmpty((Object[])bizObjsArray)) {
                return bizObjs;
            }
            for (Object id : bizObjsArray) {
                if (bizObjs.contains(id)) continue;
                checkBizObjs.add((String)id);
            }
            List<Object> newBizObjs = Arrays.asList(bizObjsArray);
            for (String id : bizObjs) {
                if (newBizObjs.contains(id)) continue;
                checkBizObjs.add(id);
            }
            return checkBizObjs;
        }
        if (VerifyUtil.isEmpty((Object[])bizObjsArray)) {
            return checkBizObjs;
        }
        return Arrays.asList(bizObjsArray);
    }

    private void checkMoAndAdministrator(Set<Long> devSet, Integer modifyOrCreate) {
        if (VerifyUtil.isEmpty(devSet)) {
            return;
        }
        for (Long moId : devSet) {
            if (-1L == moId) continue;
            String operateName = "user_createUser_operateName";
            if (modifyOrCreate.equals(USER_MODIFY)) {
                operateName = "user_modifyUser_operateName";
            }
            this.checkUserMoAuthority(operateName, 1, moId);
        }
    }

    @Override
    @Context(name="userName")
    @Permission(name={"lego.sys.operatorMgr.operator.resetpassword"})
    @Logging(name="user_resetPWD_operateName", rank=2, object="$userName ?: $1?.userId")
    public Response modifyPasswordByAdmin(AdminPasswordModifyVo pwdModifyVo) {
        Object bundleService = ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        if (!(bundleService instanceof IUserMgr)) {
            LOG.error((Object)"Get bundleService of usermgr failed cause not cast to IUserMgr");
            throw new LegoCheckedException(-1L);
        }
        IUserMgr mgr = (IUserMgr)bundleService;
        if (VerifyUtil.isEmpty((Object)pwdModifyVo)) {
            LOG.error((Object)"Input value pwdModifyVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkAdminPassword(pwdModifyVo.getAdminUserName(), pwdModifyVo.getAdminPassword(), mgr);
        UserVo userVo = this.buildUserVo(pwdModifyVo);
        userVo.setPasswordModel(UserAuthorityType.local.getValue());
        int passwordModel = userVo.getPasswordModel();
        String password = userVo.getUserPassword();
        String confirmPassword = userVo.getConfirmPassword();
        this.checkPasswordModel(passwordModel, password, confirmPassword);
        long userId = userVo.getUserId();
        User currentUser = this.getCurrentUser();
        User editedUser = this.checkUserInfo(userId, mgr, currentUser);
        String userName = editedUser.getUserName();
        Context.Variable.set((String)"userName", (Object)userName);
        this.doModifyPasswordByAdmin(userVo, confirmPassword, mgr, editedUser);
        return Response.ok().build();
    }

    private UserVo buildUserVo(AdminPasswordModifyVo pwdModifyVo) {
        UserVo userVo = new UserVo();
        userVo.setUserId(pwdModifyVo.getUserId());
        userVo.setUserPassword(pwdModifyVo.getUserNewPassword());
        userVo.setConfirmPassword(pwdModifyVo.getUserConfirmPassword());
        return userVo;
    }

    private void checkAdminPassword(String userName, String password, IUserMgr mgr) {
        int maxPwdLength = 64;
        if (!ADMIN_NAME.equals(userName) || Validator.stringNullTrim(password) || !Validator.checkStringLength(password, maxPwdLength)) {
            LOG.error((Object)"CheckOldPassword failed cause param format error!");
            throw new LegoCheckedException(256L);
        }
        try {
            mgr.adminAuth(userName, password);
            this.writeSucOperationLog("auth_adminAuth_operateName", 2, this.getCurrentUser().getUserName(), null, null);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"CheckOldPassword failed cause User or secret error!");
            this.writeFailedOperationLog("auth_adminAuth_operateName", 2, this.getCurrentUser().getUserName(), (Exception)((Object)e));
        }
    }

    private void doModifyPasswordByAdmin(UserVo userVo, String confirmPassword, IUserMgr mgr, User editedUser) {
        long userId = userVo.getUserId();
        int passwordModel = userVo.getPasswordModel();
        String password = userVo.getUserPassword();
        if (passwordModel == UserAuthorityType.local.getValue()) {
            mgr.checkConfirmPassword(password, confirmPassword, editedUser.getUserId().longValue());
            this.checkPasswordComplex(password, mgr);
            mgr.updateUserPwdPModel(userId, password, 0, true);
        } else if (passwordModel == 1) {
            mgr.updateUserPwdPModel(userId, "", 1);
        } else {
            int i = 4;
            if (passwordModel == 4) {
                mgr.updateUserPwdPModel(userId, "", 4);
            } else {
                int paramInt = 2;
                mgr.updateUserPwdPModel(userId, "", 2);
            }
        }
    }

    private void checkPasswordComplex(String password, IUserMgr mgr) {
        if (!Validator.checkMinStringLength(password, mgr.getSystemSecPolicy().getUserSecPolicy().getPswLenth())) {
            throw new LegoCheckedException(1073947393L);
        }
        int length = 64;
        if (!Validator.checkStringLength(password, 64)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!UserRestServiceValidator.isPwdMatchComplex(password, mgr.getSystemSecPolicy().getUserSecPolicy().getComplex())) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkConfirmPassword(String password, String confirmPassword, User editedUser) {
        if (!password.equals(confirmPassword)) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if (UserRestServiceValidator.checkComman(editedUser.getUserName(), password).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
        if (SHA256Encryptor.encryptWithSalt((String)password, (String)editedUser.getUserPasswordSalt()).equals(editedUser.getUserPassword())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMEERROR.intValue());
        }
    }

    private User checkUserInfo(long userId, IUserMgr mgr, User currentUser) {
        User editedUser = mgr.getUserBaseInfo(userId);
        if (null == editedUser) {
            throw new LegoCheckedException(250L);
        }
        if ("true".equals(editedUser.getIsAdmin()) && !editedUser.isSyncAdmin()) {
            throw new LegoCheckedException(250L);
        }
        if ("true".equals(currentUser.getIsAdmin())) {
            return editedUser;
        }
        boolean isCurrentUserAdministrator = this.checkIsAdministrator(currentUser.getUserId());
        boolean isEditUserAdministrator = this.checkIsAdministrator(editedUser.getUserId());
        if (!isCurrentUserAdministrator || isEditUserAdministrator) {
            throw new LegoCheckedException(250L);
        }
        return editedUser;
    }

    private void checkPasswordModel(int passwordModel, String password, String confirmPassword) {
        if (passwordModel == 0) {
            CommUtils.checkParamEmpty(password, confirmPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Context(name="user")
    @Logging(name="user_modifyPWD_operateName", rank=3, object="$user?.userName")
    public Response modifyPassword(PasswordModifyVo pwdModifyVo) {
        if ("sso".equals(this.getSession().getAttribute("user.login.mode"))) {
            LOG.error((Object)"ModifyPassword error. sso user can't modifyPassword");
            throw new LegoCheckedException(1073947400L);
        }
        String password = pwdModifyVo.getNewPassword();
        String confirmPassword = pwdModifyVo.getConfirmPassword();
        String oldPassword = pwdModifyVo.getOldPassword();
        User currentUser = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        User nowUser = mgr.getUserBaseInfo(currentUser.getUserId().longValue());
        Context.Variable.set((String)"user", (Object)nowUser);
        try {
            CommUtils.checkParamEmpty(password, confirmPassword);
            if (!password.equals(confirmPassword)) {
                throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
            }
            this.doModifyPassword(password, oldPassword, currentUser, mgr, nowUser);
            HttpSession currentSession = this.getSession();
            if (currentSession != null) {
                LOG.info((Object)"Logout after modify password. User: %s", new Object[]{currentUser.getUserName()});
                mgr.logout(currentUser.getSession());
                currentSession.invalidate();
                SysOptLog sysOptLog = SysOpLogBuilder.buildeSuccussSysOptLog("user_logout_operateName", currentUser.getUserName(), 1, null, nowUser.getUserName(), UserRestServiceImpl.getRemoteAddr(this.getRequest()));
                SysOpLogBuilder.writeOperateLog(sysOptLog);
            }
        }
        finally {
            password = null;
            confirmPassword = null;
            oldPassword = null;
            pwdModifyVo.setNewPassword(null);
            pwdModifyVo.setConfirmPassword(null);
            pwdModifyVo.setOldPassword(null);
        }
        return Response.ok().build();
    }

    private void doModifyPassword(String password, String oldPassword, User currentUser, IUserMgr mgr, User nowUser) {
        if (UserRestServiceValidator.checkComman(nowUser.getUserName(), password).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
        this.checkPasswordComplex(password, mgr);
        UserSecPolicy usrPolicy = mgr.getUserSecPolicy();
        Date currentDate = new Date();
        User userInDB = mgr.getUserBaseInfo(currentUser.getUserId().longValue());
        Date passChangeDate = new Date(userInDB.getSetTime());
        int defaultMiniLifetime = 3;
        if (null != usrPolicy.getMinlifetime()) {
            defaultMiniLifetime = usrPolicy.getMinlifetime();
        }
        long betweenDate = (currentDate.getTime() - passChangeDate.getTime()) / 60000L - (long)defaultMiniLifetime;
        if (currentDate.getTime() - passChangeDate.getTime() > 0L && usrPolicy.getUnseal() == 1 && !nowUser.isMustModifyPwd() && betweenDate < 0L) {
            throw new LegoCheckedException(253L);
        }
        mgr.modifyPassword(oldPassword, password, nowUser.getUserId().longValue());
        currentUser.setMustModifyPwd(false);
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.edit"})
    @Logging(name="user_modifyUser_operateName", rank=3, object="$1?.userName")
    public Response modifyUser(UserVo user, Long userId) {
        IUserMgr mgr = this.getUserService();
        User oldUser = mgr.getUserBaseInfo(userId.longValue());
        if (oldUser == null) {
            LOG.error((Object)"Old user is null: %s", new Object[]{String.valueOf(userId)});
            throw new LegoCheckedException(250L);
        }
        UserRestServiceValidator.restoreUserCommonData(user, oldUser, userId);
        boolean isValidate = this.validateSaveUser(user, mgr, false);
        if (!isValidate) {
            throw new LegoCheckedException(250L);
        }
        IBizScopeManager scope = this.getBizScopeManager();
        UserRestServiceValidator.restoreUserData(user, oldUser, scope);
        Set roleSet = user.getRolesIdsSet();
        User currentuser = this.getCurrentUser();
        UserRestServiceValidator.checkUserParam(user, userId, mgr, roleSet, currentuser);
        if (roleSet.contains(-1L)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserAcl(user, mgr);
        String projectName = "";
        Object object = ServiceLocator.getBundleService((String)"discover", (String)"ProductsCustomizeServiceImpl");
        IProductsCustomizeService pcs = (IProductsCustomizeService)object;
        if (pcs.getProductsCustomizeInfo().getCustomizeParameters().containsKey("projectname")) {
            projectName = (String)pcs.getProductsCustomizeInfo().getCustomizeParameters().get("projectname");
        }
        Set<Long> resIds = user.getResIds();
        List<Long> resourcesIds = this.dealResourceIds(user, currentuser, resIds, USER_MODIFY);
        this.doModifyUser(projectName, resourcesIds, oldUser, user, userId);
        return Response.ok().build();
    }

    private IBizScopeManager getBizScopeManager() {
        Object object = ServiceLocator.getBundleService((String)"DRM_Base", (String)"IBizScopeManager");
        return Optional.of(object).filter(IBizScopeManager.class::isInstance).map(IBizScopeManager.class::cast).orElse(null);
    }

    private void doModifyUser(String projectName, List<Long> resourcesIds, User oldUser, UserVo user, Long userId) {
        Set<Long> resIds = user.getResIds();
        User currentUser = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        this.updateUserInfo(user, mgr, oldUser);
        if (!user.isSyncAdmin()) {
            boolean flag;
            LOG.info((Object)"User is not syncAdmin: %s", new Object[]{String.valueOf(userId)});
            boolean bl = flag = null != projectName && projectName.equalsIgnoreCase(ASG);
            if (flag && !VerifyUtil.isEmpty(resIds)) {
                IThirdPartResourcesService tprService = (IThirdPartResourcesService)ServiceLocator.getBundleService((String)"asgResource", (String)"thirdPartResources");
                tprService.grandResourcesToUser(userId.longValue(), resourcesIds);
            }
            this.forceLogout(user, mgr, currentUser, userId);
            this.dealScopeManager(user, mgr);
        }
    }

    private void updateUserInfo(UserVo user, IUserMgr mgr, User oldUser) {
        if (!user.getUserName().equals(oldUser.getUserName())) {
            throw new LegoCheckedException(250L);
        }
        if (0 == oldUser.getPasswordModel()) {
            user.setMustModifyPwd(oldUser.isMustModifyPwd());
        }
        try {
            User newUser = UserRestServiceValidator.convertUserVoToUser(user);
            mgr.updateUser(newUser);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Update User error!", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            int paramLong = -1;
            ExceptionUtil.rethrowException((Throwable)e, (String)"update User error!", (long)-1L, null, (Log)LOG);
        }
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.delete"})
    @Logging(name="user_deleteUser_operateName", rank=2)
    public BatchOperationResult deleteUsers(Set<Long> ids) {
        User currentUser = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        CommUtils.isNullCollection(ids);
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        StringBuilder sbf = new StringBuilder();
        ArrayList<BatchOperation> errorList = new ArrayList<BatchOperation>();
        User defaultUser = new User();
        for (Long id : ids) {
            User oldUser;
            defaultUser.setUserName("");
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id.longValue());
            try {
                oldUser = mgr.getUserBaseInfo(id.longValue());
                defaultUser = Optional.ofNullable(oldUser).orElse(defaultUser);
                String userName = defaultUser.getUserName();
                tempBatch.setTargetName(userName);
            }
            catch (LegoCheckedException e) {
                errorList.add(tempBatch);
                tempBatch.setErrorCode(e.getErrorCode());
                tempBatch.setDetailParam(e.getParameters());
                continue;
            }
            if (!this.checkAdminForbidden(tempBatch, id, errorList, oldUser).booleanValue()) continue;
            bathOprLst.add(tempBatch);
            sbf.append(id).append(',');
        }
        LOG.warn((Object)"Delete users: %s", new Object[]{sbf.toString()});
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.batchDeleteUser(bathOprLst, currentUser.getUserId().longValue());
            }
            this.dealBatchOperation(errorList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOG.error((Object)"Delete users error!", (Throwable)e);
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, errorCode);
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOG.error((Object)"Delete users error!: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, -1L);
        }
        UserRestServiceImpl.dealWithRandCode(batchOperationResult);
        this.delBizObjs(batchOperationResult);
        return batchOperationResult;
    }

    private static void dealWithRandCode(BatchOperationResult batchOperationResult) {
        List result = batchOperationResult.getResult();
        for (BatchOperation operation : result) {
            if (operation.getErrorCode() != 0L) continue;
            RandCodeCheck.removeUserName(operation.getTargetName());
        }
    }

    private Boolean checkAdminForbidden(BatchOperation tempBatch, Long id, List<BatchOperation> errorList, User oldUser) {
        if (UserRestServiceValidator.checkIsAdministrator(id) && UserRestServiceValidator.checkIsAdministrator(this.getCurrentUserId())) {
            LOG.error((Object)"Can not delete the user of administrator.");
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        if (null != oldUser && "true".equals(oldUser.getIsAdmin())) {
            LOG.error((Object)"Can not delete the user:admin.");
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        if (null != oldUser && SITE_TREE_ROOT_ID.equals(oldUser.getDefaultUser())) {
            LOG.error((Object)"Can not delete the default user.");
            tempBatch.setErrorCode(250L);
            errorList.add(tempBatch);
            return false;
        }
        return true;
    }

    private void dealBatchOperation(List<BatchOperation> errorList, BatchOperationResult batchOperationResult) {
        List resultList = batchOperationResult.getResult();
        if (Objects.isNull(resultList)) {
            batchOperationResult.setResult(errorList);
            batchOperationResult.setFailCount(errorList.size());
            batchOperationResult.setTotalCount(errorList.size());
        } else {
            resultList.addAll(errorList);
            batchOperationResult.setFailCount(batchOperationResult.getFailCount() + errorList.size());
            batchOperationResult.setTotalCount(batchOperationResult.getTotalCount() + errorList.size());
        }
    }

    private void dealBatchOperationForException(List<BatchOperation> bathOprLst, List<BatchOperation> errorList, BatchOperationResult batchOperationResult, long errorCode) {
        for (BatchOperation batchOperation : bathOprLst) {
            batchOperation.setErrorCode(errorCode);
        }
        errorList.addAll(bathOprLst);
        batchOperationResult.setResult(errorList);
        batchOperationResult.setFailCount(errorList.size());
        batchOperationResult.setTotalCount(errorList.size());
    }

    private void delBizObjs(BatchOperationResult batchOperationResult) {
        if (batchOperationResult != null) {
            List batchResult = batchOperationResult.getResult();
            IBizScopeManager scope = this.getBizScopeManager();
            for (BatchOperation bop : batchResult) {
                long userId = bop.getTargetId();
                long errorCode = bop.getErrorCode();
                if (0L != errorCode) continue;
                try {
                    scope.deleteUserGrantedObject(Long.valueOf(userId));
                }
                catch (LegoCheckedException e) {
                    LOG.warn((Object)"Save user business object error");
                }
            }
        }
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.lock"})
    @Logging(name="user_lockUser_operateName", rank=2, ward=true)
    public BatchOperationResult lockUsers(Set<Long> ids) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        CommUtils.isNullCollection(ids);
        StringBuilder sbf = new StringBuilder();
        for (long strTemp : ids) {
            sbf.append(strTemp).append(',');
        }
        LOG.warn((Object)"Lock users: %s", new Object[]{sbf.toString()});
        User currentUser = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        ArrayList<BatchOperation> errList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            BatchOperation tempBatch = this.buildBatchOperation(currentUser, mgr, errList, id);
            if (tempBatch == null) continue;
            bathOprLst.add(tempBatch);
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.lockUser(bathOprLst);
            }
            this.dealBatchOperation(errList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOG.error((Object)"Delete users error!", (Throwable)e);
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, errorCode);
            this.writeFailedOperationLog("user_lockUser_operateName", 2, "", (Exception)((Object)e));
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOG.error((Object)"Delete users error!: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, -1L);
            this.writeFailedOperationLog("user_lockUser_operateName", 2, "", (Exception)((Object)new LegoCheckedException(-1L, (Throwable)e)));
        }
        this.batchOptLog(batchOperationResult, "user_lockUser_operateName", 2);
        return batchOperationResult;
    }

    private BatchOperation buildBatchOperation(User currentUser, IUserMgr mgr, List<BatchOperation> errList, Long id) {
        User oldUser;
        BatchOperation tempBatch = new BatchOperation();
        tempBatch.setTargetId(id.longValue());
        try {
            oldUser = mgr.getUserBaseInfo(id.longValue());
            String userName = "";
            if (oldUser != null) {
                userName = oldUser.getUserName();
            }
            tempBatch.setTargetName(userName);
        }
        catch (LegoCheckedException e) {
            errList.add(tempBatch);
            tempBatch.setErrorCode(e.getErrorCode());
            tempBatch.setDetailParam(e.getParameters());
            return null;
        }
        if (UserRestServiceValidator.checkIsAdministrator(id) && UserRestServiceValidator.checkIsAdministrator(currentUser.getUserId())) {
            LOG.error((Object)"Can not lock the user of administrator.");
            errList.add(tempBatch);
            tempBatch.setErrorCode(250L);
            return null;
        }
        if (null != oldUser && "true".equals(oldUser.getIsAdmin()) && !oldUser.isSyncAdmin()) {
            LOG.error((Object)"Can not lock the user:admin.");
            errList.add(tempBatch);
            tempBatch.setErrorCode(250L);
            return null;
        }
        return tempBatch;
    }

    @Override
    @Permission(name={"lego.sys.operatorMgr.operator.lock"})
    @Logging(name="user_unlockUser_operateName", rank=3, ward=true)
    public BatchOperationResult unlockUsers(Set<Long> ids) {
        CommUtils.isNullCollection(ids);
        StringBuilder sbf = new StringBuilder();
        for (long strTemp : ids) {
            sbf.append(strTemp).append(',');
        }
        LOG.info((Object)"Lock users: %s", new Object[]{sbf.toString()});
        User currentUser = this.getCurrentUser();
        IUserMgr mgr = this.getUserService();
        ArrayList<BatchOperation> errList = new ArrayList<BatchOperation>();
        List<BatchOperation> bathOprLst = this.getBatchOperations(ids, currentUser, mgr, errList);
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            if (!bathOprLst.isEmpty()) {
                batchOperationResult = mgr.unLockUser(bathOprLst);
            }
            this.dealBatchOperation(errList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            LOG.error((Object)"Delete users error!", (Throwable)e);
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, errorCode);
            this.writeFailedOperationLog("user_unlockUser_operateName", 3, "", (Exception)((Object)new LegoCheckedException(errorCode, (Throwable)e)));
        }
        catch (Exception e) {
            long errorCode = -1L;
            LOG.error((Object)"Delete users error!: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            this.dealBatchOperationForException(bathOprLst, errList, batchOperationResult, -1L);
            this.writeFailedOperationLog("user_unlockUser_operateName", 3, "", (Exception)((Object)new LegoCheckedException(-1L, (Throwable)e)));
        }
        this.batchOptLog(batchOperationResult, "user_unlockUser_operateName", 3);
        return batchOperationResult;
    }

    private List<BatchOperation> getBatchOperations(Set<Long> ids, User currentUser, IUserMgr mgr, List<BatchOperation> errList) {
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            User oldUser;
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id.longValue());
            try {
                String userName = "";
                oldUser = mgr.getUserBaseInfo(id.longValue());
                if (oldUser != null) {
                    userName = oldUser.getUserName();
                }
                tempBatch.setTargetName(userName);
            }
            catch (LegoCheckedException e) {
                errList.add(tempBatch);
                tempBatch.setErrorCode(e.getErrorCode());
                tempBatch.setDetailParam(e.getParameters());
                continue;
            }
            if (UserRestServiceValidator.checkIsAdministrator(id) && UserRestServiceValidator.checkIsAdministrator(currentUser.getUserId())) {
                LOG.error((Object)"Can not unlock the user of administrator.");
                errList.add(tempBatch);
                tempBatch.setErrorCode(250L);
                continue;
            }
            if (null != oldUser && "true".equals(oldUser.getIsAdmin()) && !oldUser.isSyncAdmin()) {
                LOG.error((Object)"Can not unlock the user:admin.");
                errList.add(tempBatch);
                tempBatch.setErrorCode(250L);
                continue;
            }
            bathOprLst.add(tempBatch);
        }
        return bathOprLst;
    }

    @Override
    public List<TreeNodeVo> getUserBizObjectTree() {
        TreeNodeVo rootNode = new TreeNodeVo(BIZ_OBJECT_TREE_ROOT_ID, "-1", "ism.drm.user.security.bizobj.tree.root", true);
        ArrayList<TreeNodeVo> treeNodes = new ArrayList<TreeNodeVo>();
        treeNodes.add(rootNode);
        Long newUserId = this.getCurrentUserId();
        this.createSiteTree(treeNodes, newUserId);
        this.createProtectGroupTree(treeNodes, newUserId);
        this.createDrpTree(treeNodes, newUserId);
        if (treeNodes.size() == 1) {
            treeNodes = new ArrayList();
        } else {
            treeNodes.sort((Comparator<TreeNodeVo>)new CommonComparator("name", true));
        }
        return treeNodes;
    }

    private void createSiteTree(List<TreeNodeVo> treeNodes, Long userId) {
        ISiteService siteService = (ISiteService)ServiceLocator.getBundleService((String)"DRM_Base", (String)ISiteService.class.getName());
        String eleName = "ism.drm.protect.element.site";
        TreeNodeVo siteRootNode = new TreeNodeVo(SITE_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        List siteList = siteService.getAllSites(userId);
        if (VerifyUtil.isEmpty((Collection)siteList)) {
            LOG.info((Object)"User id: %s", new Object[]{String.valueOf(userId)});
            return;
        }
        treeNodes.add(siteRootNode);
        for (Site site : siteList) {
            String name = site.getName();
            String sitId = site.getSiteId();
            TreeNodeVo childNode = new TreeNodeVo(sitId, SITE_TREE_ROOT_ID, name, true);
            treeNodes.add(childNode);
        }
    }

    private void createProtectGroupTree(List<TreeNodeVo> treeNodes, Long userId) {
        String serviceName = IProtectGroupService.class.getName();
        IProtectGroupService service = (IProtectGroupService)ServiceLocator.getBundleService((String)"DRM_Base", (String)serviceName);
        String eleName = "ism.drm.protect.group";
        TreeNodeVo pgRootNode = new TreeNodeVo(PROTECTGROUP_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        List pgList = service.getAllProtectGroupBasicInfo(userId, false, false, false);
        if (VerifyUtil.isEmpty((Collection)pgList)) {
            LOG.info((Object)"Pg list is empty: %s", new Object[]{String.valueOf(userId)});
            return;
        }
        treeNodes.add(pgRootNode);
        for (ProtectGroup pg : pgList) {
            String name = pg.getName();
            String id = pg.getUuid();
            TreeNodeVo childNode = new TreeNodeVo(id, PROTECTGROUP_TREE_ROOT_ID, name, true);
            treeNodes.add(childNode);
        }
    }

    private void createDrpTree(List<TreeNodeVo> treeNodes, Long userId) {
        LOG.debug((Object)"Enter createDrpTree");
        String serviceName = IRecoveryPlanService.class.getSimpleName();
        IRecoveryPlanService service = (IRecoveryPlanService)ServiceLocator.getBundleService((String)"DRM_Base", (String)serviceName);
        String eleName = "ism.drm.drp.menuname";
        TreeNodeVo remoteRpRootNode = new TreeNodeVo(REMOTE_RECOVERYPLAN_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        eleName = "ism.drm.drp.local.recovery.menuname";
        TreeNodeVo localRpRootNode = new TreeNodeVo(LOCAL_RECOVERYPLAN_TREE_ROOT_ID, BIZ_OBJECT_TREE_ROOT_ID, eleName, true);
        if (null == userId) {
            return;
        }
        List drpList = service.getAllRecoveryPlan(userId.longValue());
        if (null == drpList || drpList.isEmpty()) {
            return;
        }
        boolean isRemoteRpExisted = false;
        boolean isLocalRpExisted = false;
        for (RecoveryPlan plan : drpList) {
            TreeNodeVo childNode;
            String name = plan.getName();
            String id = plan.getPlanId();
            if (DrmEnumDefine.RECOVERY_PLAN_TYPE_E.REMOTE.getValue() == plan.getPlanType()) {
                childNode = new TreeNodeVo(id, REMOTE_RECOVERYPLAN_TREE_ROOT_ID, name, true);
                isRemoteRpExisted = true;
            } else {
                childNode = new TreeNodeVo(id, LOCAL_RECOVERYPLAN_TREE_ROOT_ID, name, true);
                isLocalRpExisted = true;
            }
            treeNodes.add(childNode);
        }
        if (isRemoteRpExisted) {
            treeNodes.add(remoteRpRootNode);
        }
        if (isLocalRpExisted) {
            treeNodes.add(localRpRootNode);
        }
    }

    @Override
    @Context(name="user")
    @Permission(name={"lego.sys.onlineUserMgr.down"})
    @Logging(name="user_forceOffline_operateName", rank=2, object="$user?.userName ?: $1?.userId")
    public Response forceLogout(Map<String, String> jsonMap) {
        String userid = jsonMap.get("userId");
        String sessionid = jsonMap.get("sessionId");
        BaseRestUtils.checkParamCommon(userid, sessionid);
        String userIdInSession = StringUtils.substringBetween((String)sessionid, (String)"userId=", (String)",");
        if (!userid.equals(userIdInSession)) {
            throw new LegoCheckedException(1073947393L);
        }
        IUserMgr mgr = this.getUserService();
        Validator.isIntergral(userid);
        User downUser = mgr.getUserBaseInfo(Long.parseLong(userid));
        Context.Variable.set((String)"user", (Object)downUser);
        if (SITE_TREE_ROOT_ID.equals(userid)) {
            throw new LegoCheckedException(250L);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (UserRestServiceValidator.checkIsAdministrator(Long.parseLong(userid)) && UserRestServiceValidator.checkIsAdministrator(currentUser.getUserId())) {
            throw new LegoCheckedException(250L);
        }
        CommUtils.checkObjectExists(downUser);
        String tarName = downUser != null ? downUser.getUserName() : "";
        LOG.warn((Object)"Down user: %s", new Object[]{tarName});
        mgr.forceLogout(sessionid);
        return Response.ok().build();
    }

    @Override
    public Response getAllPrivilegeOfCurrentUser() {
        if (this.getCurrentUserId() <= 0L) {
            LOG.info((Object)"Current user id: %s", new Object[]{String.valueOf(this.getCurrentUserId())});
            return this.getAllPrivilegeOfCurrentSSOUser();
        }
        IUserMgr userService = this.getUserService();
        User user = userService.getUserBaseInfo(this.getCurrentUserId().longValue());
        Set roleSet = user.getRolesSet();
        HashSet privilegeIdSet = new HashSet();
        if (roleSet != null && !roleSet.isEmpty()) {
            for (Role role : roleSet) {
                if ((role = userService.getRoleInf(role.getRoleId().longValue())) == null) continue;
                privilegeIdSet.addAll(role.getOptIdsSet());
            }
        }
        return Response.ok(privilegeIdSet).build();
    }

    private Response getAllPrivilegeOfCurrentSSOUser() {
        IUserMgr userService = this.getUserService();
        Role role = userService.getRoleInf(-1L);
        HashSet privileges = new HashSet();
        if (role != null && role.getOptIdsSet() != null) {
            privileges.addAll(role.getOptIdsSet());
        }
        return Response.ok(privileges).build();
    }

    private boolean checkIsAdministrator(long currentUserId) {
        IUserMgr mgr = this.getUserService();
        Set curRoleSet = mgr.getUserBaseInfo(currentUserId).getRolesSet();
        curRoleSet = Optional.ofNullable(curRoleSet).orElseGet(Collections::emptySet);
        for (Role tempRole : curRoleSet) {
            if (!SITE_TREE_ROOT_ID.equals(String.valueOf(tempRole.getRoleId())) && !"administrator".equals(tempRole.getRoleName())) continue;
            return true;
        }
        return false;
    }
}

