/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.user.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserVo;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.user.sdk.model.Role;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.cbb.user.sdk.model.UserAcl;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.cbb.user.thirdauth.sdk.UserAuthorityType;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class UserRestServiceValidator {
    private static final Long ADMIN_ID = 1L;
    private static final long CONERR = 51L;
    private static transient Log log = LogFactory.getInstance(UserRestServiceValidator.class);
    private static final Integer MAX_USERNAME = 64;
    private static final String ADMIN_NAME = "admin";
    private static final String CHINESE_STR = "[^\\x00-\\xff]";
    private static final String CHAR_STR_LOWER = "[a-z]+";
    private static final String CHAR_STR_UPPER = "[A-Z]+";
    private static final String NUM_STR = "[0-9]+";
    private static final String SPECIAL_STR = "[\\`|\\~|!|@|#|$|%|\\^|&|\\*|\\(|\\)|\\-|_|=|+|\\\\|\\||\\{|\\}|\\[|\\]|;|:|\\'|\\\"|\\,|\\.|\\<|\\>|\\/|\\s|?]+";
    private static final String COMPLEX_TWO = "2";
    private static final String COMPLEX_FOUR = "4";
    private static final String REPEAT_CHAR_REGEX = "(.)\\1{2,}";

    public static void checkUserParam(UserVo user, Long userId, IUserMgr mgr, Set<Long> roleSet, User currentuser) {
        if (currentuser == null || UserRestServiceValidator.checkAdmin(currentuser, userId)) {
            throw new LegoCheckedException(250L);
        }
        UserRestServiceValidator.checkIsAdmin(user);
        if (!user.isSyncAdmin()) {
            if (!VerifyUtil.isEmpty(roleSet)) {
                UserRestServiceValidator.checkRoleSet(roleSet, currentuser, userId);
            } else if (!userId.equals(ADMIN_ID)) {
                if ("1".equals(user.getDefaultUser())) {
                    User tempUsrInfo = mgr.getUserBaseInfo(userId.longValue());
                    Set currole = tempUsrInfo.getRolesSet();
                    UserRestServiceValidator.addRoleIds(roleSet, currole);
                } else if (UserRestServiceValidator.checkIsAdministrator(currentuser.getUserId()) && currentuser.getUserId().equals(userId)) {
                    User tempUsrInfo = mgr.getUserBaseInfo(currentuser.getUserId().longValue());
                    Set currole = tempUsrInfo.getRolesSet();
                    UserRestServiceValidator.addRoleIds(roleSet, currole);
                    user.setMoAuthIdsSet(tempUsrInfo.getMoAuthIdsSet());
                } else {
                    throw new LegoCheckedException(250L);
                }
            }
        }
    }

    private static void addRoleIds(Set<Long> roleSet, Set<Role> currole) {
        for (Role temprole : currole) {
            roleSet.add(temprole.getRoleId());
        }
    }

    public static void checkCreateUserParam(UserVo user, IUserMgr mgr, Set<Long> roleSet, User currentuser) {
        UserRestServiceValidator.checkIsAdmin(user);
        if (VerifyUtil.isEmpty(roleSet)) {
            return;
        }
        for (Long roleId : roleSet) {
            if (1L != roleId || !UserRestServiceValidator.checkIsAdministrator(currentuser.getUserId()) || !"false".equals(currentuser.getIsAdmin())) continue;
            throw new LegoCheckedException(250L);
        }
    }

    private static boolean checkAdmin(User currentuser, Long userId) {
        return UserRestServiceValidator.checkIsAdministrator(currentuser.getUserId()) && null != userId && UserRestServiceValidator.checkIsAdministrator(userId) && !currentuser.getUserId().equals(userId);
    }

    private static void checkRoleSet(Set<Long> roleSet, User currentuser, Long userId) {
        for (Long roleId : roleSet) {
            if (1L != roleId || !UserRestServiceValidator.checkIsAdministrator(currentuser.getUserId()) || currentuser.getUserId().equals(userId)) continue;
            throw new LegoCheckedException(250L);
        }
    }

    public static boolean checkIsAdministrator(long currentuserid) {
        IUserMgr mgr = (IUserMgr)ServiceLocator.getBundleService((String)"user", (String)"usermgr");
        Set curroleset = mgr.getUserBaseInfo(currentuserid).getRolesSet();
        if (null != curroleset) {
            for (Role temprole : curroleset) {
                if (!"1".equals(temprole.getRoleId().toString()) && !"administrator".equals(temprole.getRoleName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkIsAdmin(UserVo user) {
        if (!(null == user.getIsAdmin() || user.getIsAdmin().isEmpty() || "true".equals(user.getIsAdmin()) || "false".equals(user.getIsAdmin()))) {
            throw new LegoCheckedException(250L);
        }
    }

    public static boolean checkPasswordLenth(String password, Integer minLength) {
        return HtmlStringConverter.decodeByLength(password).length() < minLength || HtmlStringConverter.decodeByLength(password).length() > 64;
    }

    public static boolean checkPasswordEmpty(UserVo user, String password) {
        return Validator.stringNullTrim(password) || Validator.stringNullTrim(user.getConfirmPassword()) || password.isEmpty() || user.getConfirmPassword().isEmpty();
    }

    public static boolean checkUserEmpty(String username) {
        return Validator.stringNullTrim(username) || "".equalsIgnoreCase(username) || username.length() > MAX_USERNAME;
    }

    public static void checkUserLenth(UserVo user) {
        if (!UserRestServiceValidator.checkUserName(user.getUserName()).booleanValue()) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.checkStringLength(user.getDescription(), 100)) {
            throw new LegoCheckedException(250L);
        }
    }

    public static Boolean checkUserName(String userName) {
        Boolean flag;
        try {
            Validator.regExpCheck(userName, "^[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$");
            flag = Validator.checkStringLength(userName, 64);
        }
        catch (LegoCheckedException e) {
            flag = false;
        }
        return flag;
    }

    public static Boolean checkPassword(String password) {
        if (null == password || password.trim().isEmpty() || password.trim().length() > 64) {
            return false;
        }
        return true;
    }

    public static Boolean checkIp(String ip) {
        Boolean flag;
        try {
            flag = AddressUtil.isIpAddress((String)ip);
        }
        catch (LegoCheckedException e) {
            flag = false;
        }
        return flag;
    }

    public static Boolean checkComman(String usrName, String usrPass) {
        StringBuffer usrNameReverse = new StringBuffer(usrName).reverse();
        if (usrPass.equalsIgnoreCase(usrName) || usrPass.equalsIgnoreCase(usrNameReverse.toString())) {
            return true;
        }
        return false;
    }

    public static boolean isPwdMatchComplex(String password, String complex) {
        log.info((Object)"enter isPwdMatchComplex");
        password = Normalizer.normalize(password, Normalizer.Form.NFKC);
        if (Validator.stringNullTrim(password)) {
            return false;
        }
        if (Pattern.compile(CHINESE_STR).matcher(password).find()) {
            return false;
        }
        if (Pattern.compile(REPEAT_CHAR_REGEX).matcher(password).find()) {
            return false;
        }
        switch (complex.trim()) {
            case "2": {
                return UserRestServiceValidator.isPwdMatchComplexSecond(password);
            }
            case "4": {
                return Pattern.compile(SPECIAL_STR).matcher(password).find() && Pattern.compile(CHAR_STR_LOWER).matcher(password).find() && Pattern.compile(CHAR_STR_UPPER).matcher(password).find() && Pattern.compile(NUM_STR).matcher(password).find();
            }
        }
        log.error((Object)"complex type: %s is not support.", new Object[]{complex});
        return false;
    }

    private static boolean isPwdMatchComplexSecond(String password) {
        boolean flag3;
        boolean flag1 = !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean flag2 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(NUM_STR).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        boolean bl = flag3 = !Pattern.compile(CHAR_STR_UPPER).matcher(password).find() || !Pattern.compile(CHAR_STR_LOWER).matcher(password).find() || !Pattern.compile(SPECIAL_STR).matcher(password).find();
        return !flag1 || !flag2 || !flag3;
    }

    public static boolean compareIp(String beginIp, String endIp) {
        String[] endArr;
        String[] beginArr;
        if (beginIp.contains(":")) {
            beginArr = Ipv6AddressUtil.fillIpv6((String)beginIp, (String)":").split(":");
            endArr = Ipv6AddressUtil.fillIpv6((String)endIp, (String)":").split(":");
        } else {
            beginArr = beginIp.split("\\.");
            endArr = endIp.split("\\.");
        }
        if (beginArr.length != 4 && beginArr.length != 8 || endArr.length != 4 && endArr.length != 8) {
            log.error((Object)("ip length error, beginIp:" + beginIp + ",endIp:" + endIp), 653110170615808L);
            return true;
        }
        try {
            for (int i = 0; i < beginArr.length; ++i) {
                if (NumberUtil.convertToInteger((Object)endArr[i], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN) > NumberUtil.convertToInteger((Object)beginArr[i], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN)) {
                    return false;
                }
                if (NumberUtil.convertToInteger((Object)endArr[i], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN) >= NumberUtil.convertToInteger((Object)beginArr[i], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN)) continue;
                return true;
            }
            int k = beginArr.length - 1;
            if (NumberUtil.convertToInteger((Object)endArr[k], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN).intValue() == NumberUtil.convertToInteger((Object)beginArr[k], (NumberUtil.RADIX)NumberUtil.RADIX.SIXTEEN).intValue()) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)"ip parse error!", 653110170615808L);
            return false;
        }
        return true;
    }

    public static void restoreUserCommonData(UserVo newUserInfo, User oldUser, Long userId) {
        newUserInfo.setUserId(userId);
        newUserInfo.setUserName(oldUser.getUserName());
        newUserInfo.setPasswordModel(oldUser.getPasswordModel());
        newUserInfo.setUserPasswordSalt(oldUser.getUserPasswordSalt());
        newUserInfo.setIsAdmin(oldUser.getIsAdmin());
        newUserInfo.setDefaultUser(oldUser.getDefaultUser());
        newUserInfo.setIpAdr(oldUser.getIpAdr());
        newUserInfo.setIsAdministrator(oldUser.getIsAdministrator());
        newUserInfo.setIsLock(oldUser.getIsLock());
        newUserInfo.setLoginDate(oldUser.getLoginDate());
        newUserInfo.setLoginTime(oldUser.getLoginTime());
        newUserInfo.setMoAutSeth(oldUser.getMoAutSeth());
        newUserInfo.setMoGroupIdsSet(oldUser.getMoGroupIdsSet());
        newUserInfo.setSelectType(oldUser.getSelectType());
        newUserInfo.setSession(oldUser.getSession());
        newUserInfo.setSetTime(oldUser.getSetTime());
        newUserInfo.setStayTime(oldUser.getStayTime());
        newUserInfo.setUserPassword(oldUser.getUserPassword());
        newUserInfo.setRolesSet(oldUser.getRolesSet());
        newUserInfo.setMustModifyPwd(oldUser.isMustModifyPwd());
    }

    public static void restoreUserData(UserVo newUserInfo, User oldUser, IBizScopeManager scope) {
        if (!ADMIN_ID.equals(newUserInfo.getUserId()) && !newUserInfo.isSyncAdmin()) {
            return;
        }
        if (ADMIN_ID.equals(newUserInfo.getUserId())) {
            newUserInfo.setUserAclSet(oldUser.getUserAclSet());
        } else {
            newUserInfo.setSessionControl(oldUser.getSessionControl());
            newUserInfo.setSessionLimit(oldUser.getSessionLimit());
        }
        newUserInfo.setRolesIdsSet(oldUser.getRolesIdsSet());
        newUserInfo.setMoAuthIdsSet(oldUser.getMoAuthIdsSet());
        newUserInfo.setResIds(oldUser.getMoAuthIdsSet());
        List bizAuth = scope.getUserGrantObject(oldUser.getUserId());
        if (!VerifyUtil.isEmpty((Collection)bizAuth)) {
            String[] bizList = new String[bizAuth.size()];
            for (int iter = 0; iter < bizAuth.size(); ++iter) {
                bizList[iter] = ((DRMObject)bizAuth.get(iter)).getUuid();
            }
            newUserInfo.setBizObjs(bizList);
        }
    }

    public static User convertUserVoToUser(UserVo userVo) {
        User user = new User();
        user.setUserName(userVo.getUserName());
        user.setPasswordModel(userVo.getPasswordModel());
        user.setDescription(userVo.getDescription());
        user.setIpAdr(userVo.getIpAdr());
        user.setIsAdmin(userVo.getIsAdmin());
        user.setIsLock(userVo.getIsLock());
        user.setLoginDate(userVo.getLoginDate());
        user.setLoginTime(userVo.getLoginTime());
        user.setMoAuthIdsSet(userVo.getMoAuthIdsSet());
        user.setMoAutSeth(userVo.getMoAutSeth());
        user.setMoGroupIdsSet(userVo.getMoGroupIdsSet());
        user.setMustModifyPwd(userVo.isMustModifyPwd());
        user.setRolesIdsSet(userVo.getRolesIdsSet());
        user.setSelectType(userVo.getSelectType());
        user.setSetTime(userVo.getSetTime());
        user.setStayTime(userVo.getStayTime());
        user.setUserAclSet(userVo.getUserAclSet());
        user.setUserId(userVo.getUserId() == 0L ? null : userVo.getUserId());
        user.setUserPassword(userVo.getUserPassword());
        user.setUserPasswordSalt(userVo.getUserPasswordSalt());
        if (null == userVo.getSessionControl()) {
            user.setSessionControl(Boolean.valueOf(false));
        } else {
            user.setSessionControl(userVo.getSessionControl());
        }
        user.setSessionLimit(userVo.getSessionLimit());
        return user;
    }

    public static void checkNewUserParam(UserVo user, IUserMgr mgr) {
        String username = user.getUserName();
        String password = user.getUserPassword();
        String complex = mgr.getSystemSecPolicy().getUserSecPolicy().getComplex();
        Integer minLength = mgr.getSystemSecPolicy().getUserSecPolicy().getPswLenth();
        if (UserRestServiceValidator.checkUserEmpty(username)) {
            throw new LegoCheckedException(250L);
        }
        if (UserRestServiceValidator.checkPasswordEmpty(user, password)) {
            throw new LegoCheckedException(250L);
        }
        if (UserRestServiceValidator.checkComman(username, password).booleanValue()) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_SAMETOUSER.intValue());
        }
        if (!password.equals(user.getConfirmPassword())) {
            throw new LegoCheckedException((long)UserConstant.ERR_PASSWORD_INCONSISTENT.intValue());
        }
        if (UserRestServiceValidator.checkPasswordLenth(password, minLength)) {
            throw new LegoCheckedException(250L);
        }
        if (!UserRestServiceValidator.isPwdMatchComplex(password, complex)) {
            throw new LegoCheckedException(250L);
        }
        if (!"".equalsIgnoreCase(user.getIsAdmin()) && null != user.getUserId()) {
            throw new LegoCheckedException(250L);
        }
    }

    public static void subCheckUserAcl(UserVo user, Iterator<UserAcl> iteracl) {
        Set userAclSet = user.getUserAclSet();
        Iterator iterator = userAclSet.iterator();
        HashSet<UserAcl> tmpListAcl = new HashSet<UserAcl>();
        while (iterator.hasNext()) {
            UserAcl tempUsrAcl = (UserAcl)iterator.next();
            String startIpStr = tempUsrAcl.getStartIpStr();
            String endIpStr = tempUsrAcl.getEndIpStr();
            String desc = tempUsrAcl.getDes();
            CommUtils.checkParamEmpty(startIpStr, endIpStr);
            if (!Ipv4AddressUtil.isIPv4Address((String)startIpStr) && !Ipv6AddressUtil.isIPv6Address((String)startIpStr)) {
                throw new LegoCheckedException(250L);
            }
            if (!Ipv4AddressUtil.isIPv4Address((String)endIpStr) && !Ipv6AddressUtil.isIPv6Address((String)endIpStr)) {
                throw new LegoCheckedException(250L);
            }
            if (UserRestServiceValidator.compareIp(startIpStr, endIpStr)) {
                throw new LegoCheckedException(250L);
            }
            if (null != iteracl && iteracl.hasNext()) {
                long aclid = iteracl.next().getUserAclId();
                tempUsrAcl.setUserAclId(aclid);
            }
            tempUsrAcl.setStartIpStr(startIpStr);
            tempUsrAcl.setEndIpStr(endIpStr);
            tempUsrAcl.setDes(desc);
            tmpListAcl.add(tempUsrAcl);
        }
        user.setUserAclSet(tmpListAcl);
    }

    public static void checkPwdModel(UserVo user, IUserMgr mgr, Boolean isNewUser) {
        Integer passwordModle = user.getPasswordModel();
        ArrayList<Integer> listPassType = new ArrayList<Integer>();
        Set authTypeSet = mgr.getThirdUserAuthType();
        for (Integer tempI : authTypeSet) {
            listPassType.add(tempI);
        }
        if (passwordModle == null || !listPassType.contains(passwordModle)) {
            throw new LegoCheckedException(250L);
        }
        if (passwordModle.intValue() == UserAuthorityType.local.getValue()) {
            if (isNewUser.booleanValue()) {
                UserRestServiceValidator.checkNewUserParam(user, mgr);
            } else {
                UserRestServiceValidator.checkModifyUserParam(user, mgr);
            }
        }
    }

    public static void checkModifyUserParam(UserVo user, IUserMgr mgr) {
        if (null == user.getUserId()) {
            throw new LegoCheckedException(250L);
        }
        if (!(!ADMIN_NAME.equals(user.getUserName()) || ADMIN_ID.equals(user.getUserId()) && "true".equalsIgnoreCase(user.getIsAdmin()))) {
            throw new LegoCheckedException(250L);
        }
        if (!(ADMIN_NAME.equals(user.getUserName()) || "false".equalsIgnoreCase(user.getIsAdmin()) || "SyncAdmin".equals(user.getUserName()))) {
            throw new LegoCheckedException(250L);
        }
        User userInfo = mgr.getUserBaseInfo(user.getUserId().longValue());
        if ("1".equals(userInfo.getDefaultUser())) {
            user.setDefaultUser("1");
        }
    }
}

