/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.user.util;

import com.huawei.ism.drm.rest.service.framework.resource.model.TreeNodeVo;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.tree.RootDataElement;
import com.huawei.lego.nem.topo.sdk.model.ITreeElements;
import com.huawei.lego.nem.topo.sdk.model.UIElement;
import com.huawei.lego.nem.topo.sdk.model.UIStyle;
import java.util.List;
import java.util.Set;

public final class TreeNodeUtil {
    private static final Log log = LogFactory.getInstance(TreeNodeUtil.class);

    private TreeNodeUtil() {
    }

    public static void constructNodeList(RootDataElement root, List<TreeNodeVo> nodeList) {
        if (null == root || null == nodeList) {
            log.warn((Object)"root or nodeList is null.", 653110169894912L);
            return;
        }
        Set childEles = root.getChildEleUI();
        TreeNodeVo rootNode = new TreeNodeVo("0", "-1", "role_term_right_label", true);
        nodeList.add(rootNode);
        for (UIElement child : childEles) {
            TreeNodeUtil.processDeviceTypeBase((ITreeElements)child, nodeList);
        }
    }

    private static void processDeviceTypeBase(ITreeElements parentEle, List<TreeNodeVo> nodeList) {
        UIElement curEle = (UIElement)parentEle;
        if (curEle == null) {
            return;
        }
        curEle.setDisName(HtmlStringConverter.escapeFlexXml(curEle.getDisName()));
        String id = curEle.getEntityId();
        UIElement parentUIElement = curEle.getParentUIElement();
        String pId = parentUIElement != null ? parentUIElement.getEntityId() : "0";
        String disName = curEle.getDisName();
        TreeNodeVo node = new TreeNodeVo(id, pId, disName, true);
        int sortId = TreeNodeUtil.getInt("sortId", curEle);
        node.setSortId(sortId);
        nodeList.add(node);
        Set childEles = parentEle.getChildEleUI();
        for (UIElement child : childEles) {
            TreeNodeUtil.processDeviceTypeBase((ITreeElements)child, nodeList);
        }
    }

    private static int getInt(String key, UIElement curEle) {
        int result = -1;
        try {
            if (null == curEle) {
                return result;
            }
            String sortIdStr = ((UIStyle)curEle.getStyleSet().get(key)).getStyleValue();
            result = Integer.parseInt(sortIdStr);
        }
        catch (Exception e) {
            log.error((Object)("getInt failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110169894912L);
        }
        return result;
    }
}

