/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.template;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.protection.template.IPolicyTemplateRestService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class PolicyTemplateRestServiceImpl
extends AbstractRestService
implements IPolicyTemplateRestService {
    private static final Log log = LogFactory.getInstance(PolicyTemplateRestServiceImpl.class);
    private IPolicyTemplateManager policyTemplateManager;

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getAvailablePolicyTemplateList(int poType, int replicationType, List<ProtectObject> pos) {
        if (poType == -1) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty(pos)) {
            return "[]";
        }
        IProtectObjectProviderDelegate protectObjectService = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        for (ProtectObject po : pos) {
            if (po.getPoType() != 0) continue;
            po.setPoType(poType);
        }
        List templates = protectObjectService.getAvailablePolicyTemplate(poType, pos, replicationType);
        return this.policyTemplateListToJsonStr(templates);
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getScheduleSiteInfo(int poType, String ptUuid, List<ProtectObject> poList) {
        if (VerifyUtil.isEmpty(poList)) {
            throw new LegoCheckedException(1073947393L);
        }
        IProtectObjectProviderDelegate protectObjectService = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class);
        for (ProtectObject po : poList) {
            po.setPoType(poType);
        }
        List paths = protectObjectService.getScheduleSiteInfo(poType, ptUuid, poList);
        return this.protectLocationPathToJsonStr(paths);
    }

    private String protectLocationPathToJsonStr(List<ProtectLocationPath> paths) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(paths)) {
            return jsonArray.toString();
        }
        for (ProtectLocationPath path : paths) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"protectLocation", (Object)path.getProtectLocation());
            JSONObject subObject = new JSONObject();
            subObject.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            subObject.put((Object)"protectedSiteId", (Object)path.getProtectedSiteId());
            subObject.put((Object)"protectedStorageSN", (Object)path.getProtectedStorageSN());
            subObject.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            subObject.put((Object)"recoverySiteId", (Object)path.getRecoverySiteId());
            subObject.put((Object)"recoveryStorageSN", (Object)path.getRecoveryStorageSN());
            subObject.put((Object)"replicationMode", (Object)path.getReplicationMode());
            jsonObject.put((Object)"detail", (Object)subObject);
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    private String policyTemplateListToJsonStr(List<PolicyTemplate> templates) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(templates)) {
            return jsonArray.toString();
        }
        for (PolicyTemplate pt : templates) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"uuid", (Object)pt.getUuid());
            jsonObject.put((Object)"ptId", (Object)pt.getPtId());
            jsonObject.put((Object)"name", (Object)pt.getName());
            jsonObject.put((Object)"description", (Object)pt.getDescription());
            jsonObject.put((Object)"type", (Object)pt.getType());
            jsonObject.put((Object)"sketch", (Object)pt.getSketch());
            jsonObject.put((Object)"viewTemplateUrl", (Object)pt.getViewTemplateUrl());
            jsonObject.put((Object)"editTemplateUrl", (Object)pt.getEditTemplateUrl());
            jsonObject.put((Object)"isSystemDefine", (Object)pt.getIsSystemDefine());
            jsonObject.put((Object)"replicationType", (Object)pt.getReplicationType());
            jsonObject.put((Object)"props", (Object)pt.getProps());
            jsonObject.put((Object)"isAvailable", (Object)pt.isAvailable());
            jsonObject.put((Object)"errorCode", (Object)pt.getErrorCode());
            jsonObject.put((Object)"parameters", (Object)pt.getParameters());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getPolicyTemplate(String uuid) {
        this.getPolicyTemplateMgr();
        PolicyTemplate pt = this.policyTemplateManager.getPtByUuid(uuid);
        return this.policyTemplateToJsonStr(pt);
    }

    private String policyTemplateToJsonStr(PolicyTemplate pt) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)pt)) {
            return jsonObject.toString();
        }
        jsonObject.put((Object)"uuid", (Object)pt.getUuid());
        jsonObject.put((Object)"ptId", (Object)pt.getPtId());
        jsonObject.put((Object)"name", (Object)pt.getName());
        jsonObject.put((Object)"description", (Object)pt.getDescription());
        jsonObject.put((Object)"type", (Object)pt.getType());
        jsonObject.put((Object)"sketch", (Object)pt.getSketch());
        jsonObject.put((Object)"viewTemplateUrl", (Object)pt.getViewTemplateUrl());
        jsonObject.put((Object)"editTemplateUrl", (Object)pt.getEditTemplateUrl());
        jsonObject.put((Object)"isSystemDefine", (Object)pt.getIsSystemDefine());
        jsonObject.put((Object)"replicationType", (Object)pt.getReplicationType());
        jsonObject.put((Object)"props", (Object)pt.getProps());
        jsonObject.put((Object)"schedules", this.scheduleListToJsonStr(pt.getSchedules()));
        return jsonObject.toString();
    }

    private Object scheduleListToJsonStr(Set<Schedule> schedules) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(schedules)) {
            return jsonArray;
        }
        ArrayList<Schedule> schedulesList = new ArrayList<Schedule>();
        schedulesList.addAll(schedules);
        Collections.sort(schedulesList, new Comparator<Schedule>(){

            @Override
            public int compare(Schedule schedule1, Schedule schedule2) {
                if (schedule1 == null || schedule2 == null) {
                    return 1;
                }
                return schedule1.getProtectLocation() - schedule2.getProtectLocation();
            }
        });
        for (Schedule schedule : schedulesList) {
            jsonArray.add(this.scheduleTojsonStr(schedule));
        }
        return jsonArray;
    }

    private Object scheduleTojsonStr(Schedule schedule) {
        String targetSiteId;
        JSONObject object = new JSONObject();
        if (VerifyUtil.isEmpty((Object)schedule)) {
            return object;
        }
        object.put((Object)"name", (Object)schedule.getName());
        object.put((Object)"daysOfMonth", (Object)schedule.getDaysOfMonth());
        object.put((Object)"daysOfWeek", (Object)schedule.getDaysOfWeek());
        object.put((Object)"lastDayOfMonth", (Object)schedule.getLastDayOfMonth());
        try {
            String startTime = this.formatDate(schedule.getStartTime());
            object.put((Object)"startTime", (Object)startTime);
        }
        catch (Exception e) {
            log.error((Object)("scheduleTojsonStr error." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            object.put((Object)"startTime", (Object)schedule.getStartTime());
        }
        try {
            String endTime = this.formatDate(schedule.getEndTime());
            object.put((Object)"endTime", (Object)endTime);
        }
        catch (Exception e) {
            log.error((Object)("scheduleTojsonStr error." + ExceptionUtil.getErrorMessage((Throwable)e)), 653110170615808L);
            object.put((Object)"endTime", (Object)schedule.getStartTime());
        }
        object.put((Object)"periodInterval", (Object)schedule.getPeriodInterval());
        object.put((Object)"periodType", (Object)schedule.getPeriodType());
        object.put((Object)"protectLocation", (Object)schedule.getProtectLocation());
        object.put((Object)"scheduleId", (Object)schedule.getScheduleId());
        object.put((Object)"scheduleMode", (Object)schedule.getScheduleMode());
        object.put((Object)"scheduleRanges", this.scheduleRangesToJsonStr(schedule.getScheduleRanges()));
        ISiteService siteService = (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
        String sourceSiteId = schedule.getSourceSiteId();
        if (!VerifyUtil.isEmpty((String)sourceSiteId)) {
            Site site = siteService.getCombinaSiteById(sourceSiteId, ":");
            object.put((Object)"protectedSiteName", (Object)site.getName());
        }
        if (!VerifyUtil.isEmpty((String)(targetSiteId = schedule.getTargetSiteId()))) {
            Site site = siteService.getCombinaSiteById(targetSiteId, ":");
            object.put((Object)"recoverySiteName", (Object)site.getName());
        }
        String abortTaskTime = schedule.getAbortTaskTime();
        String minutes = schedule.getMinutes();
        String hours = schedule.getHours();
        String seconds = schedule.getSeconds();
        object.put((Object)"abortTaskTime", this.dealNullStr(abortTaskTime));
        object.put((Object)"hours", this.dealNullStr(hours));
        object.put((Object)"minutes", this.dealNullStr(minutes));
        object.put((Object)"seconds", this.dealNullStr(seconds));
        object.put((Object)"protectedType", (Object)schedule.getProtectedType());
        return object;
    }

    private Object dealNullStr(String str) {
        return str == null ? "" : str;
    }

    private Object scheduleRangesToJsonStr(Set<ScheduleRangeTime> scheduleRanges) {
        JSONArray jsonArray = new JSONArray();
        if (VerifyUtil.isEmpty(scheduleRanges)) {
            return jsonArray;
        }
        for (ScheduleRangeTime time : scheduleRanges) {
            jsonArray.add(this.scheduleRangeTimeToJsonStr(time));
        }
        return jsonArray;
    }

    private Object scheduleRangeTimeToJsonStr(ScheduleRangeTime time) {
        JSONObject jsonObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)time)) {
            return jsonObject;
        }
        jsonObject.put((Object)"scheduleRangeId", (Object)time.getScheduleRangeId());
        jsonObject.put((Object)"startTime", (Object)CommUtils.formatDate(time.getStartTime()));
        jsonObject.put((Object)"endTime", (Object)CommUtils.formatDate(time.getEndTime()));
        return jsonObject;
    }

    private String formatDate(String startTime) {
        String startTimeFormat = "--";
        if (!VerifyUtil.isEmpty((String)startTime)) {
            long parseLong = Long.parseLong(startTime);
            startTimeFormat = CommUtils.formatDate(new Date(parseLong));
        }
        return startTimeFormat;
    }

    private void getPolicyTemplateMgr() {
        this.policyTemplateManager = this.getBundleService(IPolicyTemplateManager.class);
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getPolicyTemplateUUID(int type) {
        this.getPolicyTemplateMgr();
        String policyTemplate = this.policyTemplateManager.getPtByTemplateType(type);
        if (VerifyUtil.isEmpty((String)policyTemplate)) {
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"policyTemplateUUID", (Object)policyTemplate);
        return jsonObject.toString();
    }
}

