/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery.util;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.rest.service.framework.alarm.util.ExcelFileUtil;
import com.huawei.ism.drm.rest.service.platform.recovery.AbstractRecoveryPlanRestService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class RecoveryPlanLogExcelOperator {
    private static Log log = FELogFactory.getInstance((String)"ui");
    private static final int FIVE_COL_WIDTH = 10000;
    private static final Color BACK_GROUND = new Color(255, 0, 0);
    private static final Map<Integer, String> LOGTYPE = new HashMap<Integer, String>();
    private static final Map<Integer, String> EXECUTERESULT = new HashMap<Integer, String>();
    private AbstractRecoveryPlanRestService recoveryPlanService;
    private BatchOperationResult result = null;

    public RecoveryPlanLogExcelOperator(AbstractRecoveryPlanRestService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public Workbook createExportExcel(List<RecoveryLog> recoveryLogs, BatchOperationResult results) {
        log.debug((Object)"to create Export Excel..");
        this.result = results;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        this.createHeader(sheet);
        this.createDataArea(sheet, recoveryLogs);
        sheet.setColumnWidth(0, 10000);
        sheet.setColumnWidth(1, 10000);
        sheet.setColumnWidth(2, 10000);
        sheet.setColumnWidth(3, 10000);
        sheet.setColumnWidth(4, 10000);
        return wb;
    }

    private void createHeader(XSSFSheet sheet) {
        log.debug((Object)"Create excel header.");
        XSSFFont font = sheet.getWorkbook().createFont();
        font.setBold(true);
        XSSFCellStyle cs = RecoveryPlanLogExcelOperator.createHeaderStyle(sheet, (Font)font);
        XSSFRow row0 = sheet.createRow(0);
        Cell cell = row0.createCell(0);
        cell.setCellValue(this.getText("ism.drm.recovery.term.history.colum.runType.title"));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(0, 1, 0, 0);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(1);
        cell.setCellValue(this.getText("ism.drm.recovery.term.history.colum.runResult.title"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 1, 1);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(2);
        cell.setCellValue(this.getText("ism.drm.recovery.term.history.colum.startTime.title"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 2, 2);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(3);
        cell.setCellValue(this.getText("ism.drm.recovery.term.history.colum.endTime.title"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 3, 3);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
        cell = row0.createCell(4);
        cell.setCellValue(this.getText("ism.drm.recovery.term.history.colum.executeTime.title"));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(0, 1, 4, 4);
        this.setRangeBorder(sheet, cra);
        sheet.addMergedRegion(cra);
    }

    private static XSSFCellStyle createHeaderStyle(XSSFSheet sheet, Font font) {
        XSSFCellStyle cs = sheet.getWorkbook().createCellStyle();
        cs.setAlignment(HorizontalAlignment.CENTER);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
        cs.setFillForegroundColor(new XSSFColor(BACK_GROUND, (IndexedColorMap)new DefaultIndexedColorMap()));
        cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs.setBorderLeft(BorderStyle.THIN);
        cs.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderTop(BorderStyle.THIN);
        cs.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderBottom(BorderStyle.THIN);
        cs.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cs.setBorderRight(BorderStyle.THIN);
        cs.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cs.setFont(font);
        cs.setDataFormat(BuiltinFormats.getBuiltinFormat((String)"text"));
        return cs;
    }

    private String getText(String string) {
        return this.recoveryPlanService.getText(string);
    }

    private void setRangeBorder(XSSFSheet sheet, CellRangeAddress cra) {
        log.debug((Object)"to set range border..");
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setTopBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setLeftBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBottomBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setRightBorderColor((int)IndexedColors.BLACK.getIndex(), (CellRangeAddress)cra, (Sheet)sheet);
    }

    private void createDataArea(XSSFSheet sheet, List<RecoveryLog> recoveryLogs) {
        int rowIndex = 2;
        XSSFCellStyle cs = ExcelFileUtil.formatLogCellStyle(sheet);
        ArrayList<BatchOperation> counterror = new ArrayList<BatchOperation>();
        for (RecoveryLog recoveryLog : recoveryLogs) {
            this.addBatchOperation(counterror, recoveryLog, sheet, cs, rowIndex++);
        }
        this.result.setResult(counterror);
        this.result.setFailCount(counterror.size());
        this.result.setTotalCount(recoveryLogs.size());
    }

    private void addBatchOperation(List<BatchOperation> counterror, RecoveryLog recoveryLog, XSSFSheet sheet, XSSFCellStyle cs, int rowIndex) {
        BatchOperation batchOperation = new BatchOperation();
        XSSFRow mergeRow = sheet.createRow(rowIndex);
        Cell cell = mergeRow.createCell(0);
        cell.setCellValue(this.getText(LOGTYPE.get(recoveryLog.getLogType())));
        cell.setCellStyle((CellStyle)cs);
        CellRangeAddress cra = new CellRangeAddress(rowIndex, rowIndex, 0, 0);
        this.setRangeBorder(sheet, cra);
        cell = mergeRow.createCell(1);
        cell.setCellValue(this.getText(EXECUTERESULT.get(recoveryLog.getLogStatus())));
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowIndex, 1, 1);
        this.setRangeBorder(sheet, cra);
        cell = mergeRow.createCell(2);
        String startTime = recoveryLog.getStartTime();
        cell.setCellValue(startTime != null ? CommUtils.formatData(startTime) : "--");
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowIndex, 2, 2);
        this.setRangeBorder(sheet, cra);
        cell = mergeRow.createCell(3);
        String endTime = recoveryLog.getEndTime();
        cell.setCellValue(endTime != null ? CommUtils.formatData(endTime) : "--");
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowIndex, 3, 3);
        this.setRangeBorder(sheet, cra);
        cell = mergeRow.createCell(4);
        String executeTime = this.recoveryPlanService.calcExecuteTime(recoveryLog.getStartTime(), recoveryLog.getEndTime());
        cell.setCellValue(executeTime);
        cs.setAlignment(HorizontalAlignment.LEFT);
        cell.setCellStyle((CellStyle)cs);
        cra = new CellRangeAddress(rowIndex, rowIndex, 4, 4);
        this.setRangeBorder(sheet, cra);
        if (!VerifyUtil.isEmpty((String)batchOperation.getTargetName())) {
            counterror.add(batchOperation);
        }
    }

    static {
        LOGTYPE.put(0, "recovery.term.history.runType.faultRecovery");
        LOGTYPE.put(1, "recovery.term.history.runType.planMove");
        LOGTYPE.put(2, "recovery.term.history.runType.drillingTest");
        LOGTYPE.put(3, "recovery.term.history.runType.clear");
        LOGTYPE.put(4, "recovery.term.history.runType.lunRollback");
        LOGTYPE.put(7, "recovery.term.history.runType.protect");
        LOGTYPE.put(8, "recovery.term.history.runType.swap");
        LOGTYPE.put(9, "recovery.term.history.runType.mount");
        LOGTYPE.put(10, "recovery.term.history.runType.unmount");
        LOGTYPE.put(12, "recovery.term.history.runType.vmRollback");
        EXECUTERESULT.put(0, "ism.drm.report.run.success.excel.column");
        EXECUTERESULT.put(1, "ism.drm.report.run.faild.excel.column");
    }
}

