/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.IManagementServerRestService;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.List;
import javax.ws.rs.core.Response;

public class ManagementServerRestServiceImpl
extends AbstractRestService
implements IManagementServerRestService {
    private static final Log LOG = LogFactory.getInstance(ManagementServerRestServiceImpl.class);

    @Override
    @Permission(name={"ism.drm.servers.auth.modify"}, moid={"$1"})
    @Context(name="oldInfo")
    @Logging(name="server_modifyServer_operateName", rank=3, object="$oldInfo?.name", detail="server_modifyLocalServerName_operateDetail", parameters={"$oldInfo?.name", "$2?.name"})
    public Response updateServer(String uuid, ManagementServer server) {
        if (VerifyUtil.isEmpty((String)uuid) || VerifyUtil.isEmpty((Object)server)) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagementServer replica = this.getServerService().getServer(uuid);
        Context.Variable.set((String)"oldInfo", (Object)replica);
        if (VerifyUtil.isEmpty((Object)replica)) {
            throw new LegoCheckedException(2117645L);
        }
        String user = HtmlStringConverter.decodeByLength(server.getUser());
        if (!VerifyUtil.isEmpty((String)user) && !"SyncAdmin".equals(user)) {
            LOG.error((Object)"UpdateServer user is error: %s", new Object[]{user});
            throw new LegoCheckedException(1073947393L);
        }
        String pwd = HtmlStringConverter.decodeByLength(server.getPwd());
        if (!pwd.isEmpty()) {
            ValidateUtil.validate((String)"^.{1,64}$", (String)pwd);
            INorthNmsService nmsService = (INorthNmsService)ServiceLocator.getBundleService((String)"slave", (String)"northNmsService", INorthNmsService.class);
            server.setPwd(nmsService.encrypt(pwd));
        } else {
            server.setPwd(null);
        }
        server.setUuid(uuid);
        this.getServerService().updateServer(server);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.servers.auth.scan"})
    public String getServerInfo() {
        ManagementServer serverInfo = this.getServerService().getServerInfo();
        return this.beanToJson(serverInfo).toString();
    }

    private JSONObject beanToJson(ManagementServer bean) {
        JSONObject json = new JSONObject();
        json.put((Object)"uuid", (Object)bean.getUuid());
        json.put((Object)"name", (Object)bean.getName());
        json.put((Object)"devAlias", (Object)bean.getDevAlias());
        json.put((Object)"status", (Object)bean.getStatus());
        json.put((Object)"ip", (Object)bean.getIp());
        json.put((Object)"port", (Object)bean.getPort());
        json.put((Object)"serverType", (Object)bean.getServerType());
        json.put((Object)"version", (Object)bean.getVersion());
        json.put((Object)"user", (Object)bean.getUser());
        return json;
    }

    @Override
    @Permission(name={"ism.drm.servers.auth.scan"})
    public String getServers() {
        List servers = this.getServerService().getServers();
        JSONArray array = new JSONArray();
        for (ManagementServer server : servers) {
            array.add((Object)this.beanToJson(server));
        }
        return array.toString();
    }

    private IManagementServerService getServerService() {
        return (IManagementServerService)ServiceLocator.getBundleService((String)"DRM_Base", (String)IManagementServerService.class.getName(), IManagementServerService.class);
    }
}

