/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.site;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.site.ISiteRestService;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.moment.bedstone.shield.annotation.Context;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class SiteRestServiceImpl
extends AbstractRestService
implements ISiteRestService {
    private static Log logger = LogFactory.getInstance(SiteRestServiceImpl.class);
    private static final int SITE_ID_MAX_LENGTH = 64;
    private static final String SITE = "site";

    @Override
    @Permission(name={"ism.drm.site.auth.add"})
    @Logging(name="site_createSite_operateName", object="$1?.name")
    public String createSite(Site site) {
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947393L);
        }
        String serverUuid = site.getServerUuid();
        String siteName = site.getName();
        String siteDesc = HtmlStringConverter.decodeByLength(site.getDescription());
        if (VerifyUtil.isEmpty((String)serverUuid) || serverUuid.length() > 64) {
            logger.error((Object)"Enter createSite.uuid: %s", new Object[]{serverUuid});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkNameDescParam(siteName, siteDesc);
        JSONObject json = new JSONObject();
        String siteId = this.getSiteService().createSite(site, this.getCurrentUserId());
        json.put((Object)"siteId", (Object)siteId);
        return json.toString();
    }

    @Override
    @Context(name="site", required=true)
    @Permission(name={"ism.drm.site.auth.delete"}, uuid={"$1"})
    @Logging(name="site_deleteSite_operateName", rank=2, object="$site?.name")
    public Response deleteSite(String siteId) {
        Site site = this.getSiteService().getSiteById(siteId);
        Context.Variable.set((String)SITE, (Object)site);
        this.getSiteService().deleteSite(siteId);
        return Response.ok().build();
    }

    @Override
    @Context(name="site", required=true)
    @Permission(name={"ism.drm.site.auth.delete"}, uuid={"$1"})
    @Logging(name="site_modifyLocalSite_operateName", rank=3, object="$site", detail="site_modifySite_operateDetail", parameters={"$2?.name"})
    public Response modifySite(String siteId, Site site) {
        if (VerifyUtil.isEmpty((String)siteId) || siteId.length() > 64) {
            logger.error((Object)"Enter modifySite.siteId: %s", new Object[]{siteId});
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)site)) {
            throw new LegoCheckedException(1073947393L);
        }
        Site replica = this.getSiteService().getSiteById(siteId);
        if (null == replica) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)SITE, (Object)replica.getName());
        String siteDesc = HtmlStringConverter.decodeByLength(site.getDescription());
        if (!CommUtil.checkDrmDescParam((String)siteDesc)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.updateLocalSite(replica, site);
        return Response.ok().build();
    }

    private void updateLocalSite(Site replica, Site newSite) {
        String oldName = replica.getName();
        String oldDesc = replica.getDescription();
        String newName = newSite.getName();
        String newDesc = newSite.getDescription();
        if (!CommUtil.checkDrmNameParam((String)newName)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (!newName.equals(oldName)) {
            replica.setName(newName);
        }
        if (null != newDesc && !newDesc.equals(oldDesc)) {
            replica.setDescription(newDesc);
        }
        this.getSiteService().updateSite(replica, newName, this.getCurrentUserId());
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getSites(String serverUuid, String cloudServiceProvider) {
        List sites;
        if (VerifyUtil.isEmpty((String)serverUuid)) {
            sites = this.getSiteService().getAllSites(this.getCurrentUserId());
        } else {
            sites = this.getSiteService().getSites(serverUuid);
            IBizScopeManager manager = (IBizScopeManager)this.getBundleService("DRM_Base", "IBizScopeManager");
            sites = manager.filterObject(this.getCurrentUserId(), sites);
        }
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            Site site = (Site)iter.next();
            if (VerifyUtil.isEmpty((String)cloudServiceProvider) || VerifyUtil.isEmpty((Object)site.getIsCloudSite()) || site.getIsCloudSite().booleanValue() && cloudServiceProvider.equals(site.getCloudServiceProvider())) continue;
            iter.remove();
        }
        JSONArray array = new JSONArray();
        for (DRMObject site : sites) {
            if (site instanceof Site) {
                array.add((Object)this.siteToJsonStr((Site)site));
                continue;
            }
            logger.info((Object)("Converting failed.DRMObject:" + site));
        }
        return array.toString();
    }

    @Deprecated
    public String getSites(Integer type, String name) {
        List sites = this.getSiteService().getAllSites(this.getCurrentUserId());
        JSONArray resultArray = new JSONArray();
        for (Site site : sites) {
            if (type != null && (type == 0 || type == 1) && site.getSiteType() != type.intValue() || StringUtils.isNotBlank((CharSequence)name) && !site.getName().toLowerCase(Locale.US).contains(name.toLowerCase(Locale.US))) continue;
            JSONObject jsonObject = this.siteToJsonStr(site);
            resultArray.add((Object)jsonObject);
        }
        return resultArray.toString();
    }

    private JSONObject siteToJsonStr(Site site) {
        if (site == null) {
            return new JSONObject();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"siteId", (Object)site.getSiteId());
        jsonObject.put((Object)"name", (Object)site.getName());
        jsonObject.put((Object)"siteAlias", (Object)site.getSiteAlias());
        jsonObject.put((Object)"description", (Object)site.getDescription());
        jsonObject.put((Object)"siteType", (Object)site.getSiteType());
        jsonObject.put((Object)"serverUuid", (Object)site.getServerUuid());
        jsonObject.put((Object)"isCloudSite", (Object)site.getIsCloudSite());
        jsonObject.put((Object)"isAirGapSite", (Object)site.getIsAirGapSite());
        jsonObject.put((Object)"cloudServiceProvider", (Object)site.getCloudServiceProvider());
        jsonObject.put((Object)"domainName", (Object)site.getDomainName());
        jsonObject.put((Object)"regionId", (Object)site.getRegionId());
        jsonObject.put((Object)"projectId", (Object)site.getProjectId());
        jsonObject.put((Object)"proxyId", (Object)site.getProxyId());
        return jsonObject;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, uuid={"$1"})
    public String getSiteById(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        Site site = this.getSiteService().getSiteById(siteId);
        return this.siteToJsonStr(site).toString();
    }

    private void localSuccessLog(String siteName) {
        this.writeSucOperationLog("site_modifyLocalSite_operateName", 3, siteName, "site_modifySite_operateDetail", new String[]{siteName});
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, uuid={"$1"})
    public String statSiteResource(String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            logger.error((Object)("enter modifySite.siteId:" + siteId));
            throw new LegoCheckedException(1073947393L);
        }
        Map resStatistics = this.getSiteService().sum(siteId, this.getCurrentUserId());
        JSONObject resultObj = new JSONObject();
        resultObj.put((Object)"result", (Object)resStatistics);
        return resultObj.toString();
    }

    private void checkNameDescParam(String siteName, String checkSiteDesc) {
        if (!CommUtil.checkDrmNameParam((String)siteName) || !CommUtil.checkDrmDescParam((String)checkSiteDesc)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ISiteService getSiteService() {
        return (ISiteService)this.getBundleService("DRM_Base", ISiteService.class.getName());
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String showSitesRelationTopo() {
        IProtectGroupService ipgs = this.getBundleService("DRM_Base", IProtectGroupService.class.getName(), IProtectGroupService.class);
        List protectGroups = ipgs.getAllProtectGroupBasicInfo(this.getCurrentUserId(), false, true, true);
        JSONObject resultObejct = new JSONObject();
        if (VerifyUtil.isEmpty((Collection)protectGroups)) {
            logger.info((Object)("The ProtectGroup search result is null,  getCurrentUserId():" + this.getCurrentUserId()));
            return resultObejct.toString();
        }
        IDrmTopoService topoService = this.getBundleService("DRM_Base", IDrmTopoService.class.getName(), IDrmTopoService.class);
        List allPgSitesRelation = topoService.getSiteLinks(protectGroups);
        JSONArray jsonLinks = new JSONArray();
        allPgSitesRelation.forEach(link -> {
            JSONObject siteRelationJsonObject = JSONObject.fromObject((Object)link);
            jsonLinks.add((Object)siteRelationJsonObject);
        });
        resultObejct.put((Object)"links", (Object)jsonLinks);
        return resultObejct.toString();
    }
}

