/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.storage;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.DeleteLunRequest;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.array.sdk.model.QuorumServerLink;
import com.huawei.ism.array.sdk.model.RemoteDevice;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.resource.model.ResourceTimeWindowVo;
import com.huawei.ism.drm.rest.service.platform.storage.IStorageRestService;
import com.huawei.ism.drm.rest.util.BaseRestUtils;
import com.huawei.ism.drm.rest.util.DrmStorageUtil;
import com.huawei.ism.drm.rest.util.ManualRefreshManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindowRange;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.storage.sdk.model.StoragePortOperateLog;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourcePoolService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageRestServiceImpl
extends AbstractRestService
implements IStorageRestService {
    private static final String STORAGE = "storage";
    private static final transient Log LOGGER = LogFactory.getInstance(StorageRestServiceImpl.class);
    private static final String STORAGE_SERVICE_NAME = IStorageService.class.getName();
    private static final String RESULT_NAME = "name";
    private static final String RESULT_STATUS = "status";
    private static final String RESULT_CAPACITY = "capacity";
    @Autowired
    private PermissionService permissionService;

    private IStorageService getStorageService() {
        return (IStorageService)this.getBundleService("DRM_Base", IStorageService.class.getName());
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getStorageList(String siteId, String deviceSn) {
        if (!VerifyUtil.isEmpty((String)siteId)) {
            this.permissionService.checkUserGrantedObject(siteId);
            List storages = this.getStorageService().getStorageListBySiteId(siteId, this.getCurrentUserId());
            if (storages == null) {
                return "[]";
            }
            List<DrStorage> storagesBySn = BaseRestUtils.filterBySn(deviceSn, storages);
            return this.toJsonStr(storagesBySn);
        }
        List storageList = this.getStorageService().getStorageList(deviceSn.split(";"));
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)storageList)) {
            return array.toString();
        }
        for (StorageNE storageNE : storageList) {
            try {
                this.checkUserAuthorityByMoIds(storageNE.getMoId());
                JSONObject object = new JSONObject();
                object.put((Object)"deviceSn", (Object)storageNE.getSn());
                object.put((Object)RESULT_NAME, (Object)storageNE.getName());
                object.put((Object)"IpAddress", (Object)storageNE.getIpAddress());
                object.put((Object)"productModel", (Object)storageNE.getProductModel());
                object.put((Object)RESULT_STATUS, (Object)storageNE.getStatus());
                object.put((Object)"version", (Object)storageNE.getVersion());
                array.add((Object)object);
            }
            catch (LegoCheckedException ex) {
                LOGGER.info((Object)("sn=" + storageNE.getSn() + " checkUserAuthority failed."), 90160758784000L);
            }
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getLunByIds(String devSn, String lunIds, boolean isFromDevice) {
        List list;
        if (VerifyUtil.isEmpty((String)StringUtil.trim((String)lunIds))) {
            throw new LegoCheckedException(1073947393L);
        }
        if (isFromDevice) {
            list = this.getStorageService().queryLunByDevSnAndLunIds(devSn, Arrays.asList(lunIds.split(";")));
        } else {
            ArrayList<QueryCondition> queryCondition = new ArrayList<QueryCondition>();
            QueryCondition cond = new QueryCondition("lunId", (Object)lunIds.split(";"));
            queryCondition.add(cond);
            list = this.getStorageService().queryLunByStorageSn(devSn, null, true, queryCondition);
        }
        if (!VerifyUtil.isEmpty((Collection)list)) {
            return this.lunListToJsonArray(list);
        }
        throw new LegoCheckedException(1073947394L);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getStorageResourceByWwn(String wwn) {
        if (VerifyUtil.isEmpty((String)wwn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService service = this.getBundleService(STORAGE_SERVICE_NAME, IStorageService.class);
        List resource = service.getStorageResourceByWwn(wwn.split(";"));
        if (VerifyUtil.isEmpty((Collection)resource)) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray array = new JSONArray();
        for (StorageResource each : resource) {
            try {
                this.permissionService.checkUserMoAuthority(each.getDevSn());
            }
            catch (Exception e) {
                LOGGER.info((Object)("StorageResource(" + each.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            if (!(each instanceof Lun)) continue;
            Lun lun = (Lun)each;
            JSONObject object = BaseRestUtils.convertLunToJsonObj(lun);
            object.put((Object)"moId", (Object)lun.getMoId());
            object.put((Object)"resourceType", (Object)DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    private String lunListToJsonArray(List<Lun> lunList) {
        JSONArray array = new JSONArray();
        for (Lun lun : lunList) {
            JSONObject object = BaseRestUtils.convertLunToJsonObj(lun);
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getReplicationPairBySrcLunIds(String devSn, String lunIds, boolean isFromDevice) {
        if (VerifyUtil.isEmpty((String)lunIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        String[] strLunArray = lunIds.split(";");
        ArrayList<String> listSrcLunIds = new ArrayList<String>(Arrays.asList(strLunArray));
        List listPairs = this.getStorageService().queryReplicationPairsByMasterLunId(devSn, listSrcLunIds, isFromDevice, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        return this.replicationPairListToJsonArray(listPairs);
    }

    private String replicationPairListToJsonArray(List<ReplicationPair> listPairs) {
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty(listPairs)) {
            return array.toString();
        }
        for (ReplicationPair rpPair : listPairs) {
            JSONObject object = new JSONObject();
            object.put((Object)"consistentGroupId", (Object)rpPair.getConsistentGroupId());
            object.put((Object)"srcLunId", (Object)rpPair.getSrcLunId());
            object.put((Object)"srcLunName", (Object)rpPair.getSrcLunName());
            object.put((Object)"srcLunStatus", (Object)rpPair.getSrcLunStatus());
            object.put((Object)"tgtDevName", (Object)rpPair.getTgtDevName());
            object.put((Object)"srcDevSN", (Object)rpPair.getSrcDevSN());
            object.put((Object)"replicationMode", (Object)rpPair.getReplicationMode());
            object.put((Object)"replicationId", (Object)rpPair.getReplicationId());
            object.put((Object)"replicationName", (Object)rpPair.getReplicationName());
            object.put((Object)"repStatus", (Object)rpPair.getRepStatus());
            object.put((Object)"devSn", (Object)rpPair.getDevSn());
            object.put((Object)"srcLocation", (Object)rpPair.getSrcLocation());
            object.put((Object)"localResType", (Object)rpPair.getLocalResType());
            object.put((Object)"isPrimary", (Object)rpPair.getIsPrimary());
            object.put((Object)"drRingId", (Object)rpPair.getDrRingId());
            JSONArray repTgtLunArray = this.replicationTargetLunListToJsonArray(rpPair);
            object.put((Object)"repTgtLuns", (Object)repTgtLunArray);
            array.add((Object)object);
        }
        return array.toString();
    }

    private JSONArray replicationTargetLunListToJsonArray(ReplicationPair rpPair) {
        List repTgtLuns = rpPair.getRepTgtLuns();
        JSONArray repTgtLunArray = new JSONArray();
        for (ReplicationTargetLun oneRepTgtLun : repTgtLuns) {
            JSONObject repTgtLunJson = new JSONObject();
            repTgtLunJson.put((Object)"dataStatus", (Object)oneRepTgtLun.getDataStatus());
            repTgtLunJson.put((Object)"devSn", (Object)oneRepTgtLun.getDevSn());
            repTgtLunJson.put((Object)"isNeedInitSync", (Object)oneRepTgtLun.getIsNeedInitSync());
            repTgtLunJson.put((Object)"isPrimary", (Object)oneRepTgtLun.getIsPrimary());
            repTgtLunJson.put((Object)"pairStatus", (Object)oneRepTgtLun.getPairStatus());
            repTgtLunJson.put((Object)"replicationPairId", (Object)oneRepTgtLun.getReplicationPairId());
            repTgtLunJson.put((Object)"syncMode", (Object)oneRepTgtLun.getSyncMode());
            repTgtLunJson.put((Object)"tgtDeviceName", (Object)oneRepTgtLun.getTgtDeviceName());
            repTgtLunJson.put((Object)"tgtDevSN", (Object)oneRepTgtLun.getTgtDevSN());
            repTgtLunJson.put((Object)"tgtLunId", (Object)oneRepTgtLun.getTgtLunId());
            repTgtLunJson.put((Object)"tgtLunName", (Object)oneRepTgtLun.getTgtLunName());
            repTgtLunArray.add((Object)repTgtLunJson);
        }
        return repTgtLunArray;
    }

    private String toJsonStr(List<DrStorage> resultList) {
        JSONArray resultArray = new JSONArray();
        for (DrStorage ds : resultList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)RESULT_NAME, (Object)ds.getName());
            jsonObject.put((Object)"deviceSn", (Object)ds.getDeviceSn());
            jsonObject.put((Object)"ipAddress", (Object)ds.getIpAddress());
            jsonObject.put((Object)"productModel", (Object)ds.getProductModel());
            jsonObject.put((Object)RESULT_STATUS, (Object)ds.getStatus());
            jsonObject.put((Object)"isAirGapResource", (Object)ds.getIsAirGapResource());
            jsonObject.put((Object)"enabledAntiBlackmailFeature", (Object)ds.getEnabledAntiBlackmail());
            resultArray.add((Object)jsonObject);
        }
        return resultArray.toString();
    }

    @Override
    @Context(name="storage")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_refresh_operateName", rank=3, object="$storage?.name", parameters={"$storage?.name", "$storage?.linkIp"}, detail="resource_refresh_operateDetail")
    public Response refreshStorage(String devSn) {
        StorageNE storage = this.getStorageService().getStorageBySn(devSn, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)storage)) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)STORAGE, (Object)storage);
        ManualRefreshManager.getInstance().refresh((NetworkEntity)storage, this.refreshCall(storage));
        return Response.ok().build();
    }

    private Callable<Boolean> refreshCall(final StorageNE arrayMo) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() {
                IStorageService storageService = StorageRestServiceImpl.this.getStorageService();
                storageService.refreshStorage(arrayMo.getMoId(), StorageRestServiceImpl.this.getCurrentUser().getUserName());
                return true;
            }
        };
    }

    @Override
    @Context(name="storage")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="site_redirectToStorage_operateName", rank=3, object="$storage?.name", parameters={"$storage?.ipAddress"}, detail="site_redirectToStorage_operateDetail")
    public String getStorageUnitInfo(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        DrResource drResource = this.getBundleService(IResourceService.class).getDrResourceBySn(devSn);
        if (null == drResource) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)STORAGE, (Object)drResource);
        JSONObject json = new JSONObject();
        Map info = this.getBundleService(IStorageService.class).getStorageAddressInfo(devSn);
        if (info.containsKey("linkIp")) {
            json.put((Object)"linkIp", info.get("linkIp"));
            LOGGER.info((Object)("linkIp: " + info.get("linkIp")));
        }
        if (info.containsKey("linkPort")) {
            json.put((Object)"linkPort", info.get("linkPort"));
            LOGGER.info((Object)("linkPort: " + info.get("linkPort")));
        }
        return json.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getSrcLunByReplicationUUID(String replicationId) {
        if (VerifyUtil.isEmpty((String)replicationId)) {
            throw new LegoCheckedException(1073947393L);
        }
        List lunList = this.getStorageService().getSrcLunByReplicasionUuid(replicationId);
        JSONArray array = new JSONArray();
        if (null == lunList || lunList.isEmpty()) {
            return array.toString();
        }
        for (Lun lun : lunList) {
            try {
                this.permissionService.checkUserMoAuthority(lun.getDevSn());
            }
            catch (Exception e) {
                LOGGER.info((Object)("StorageResource(" + lun.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)lun.getName());
            object.put((Object)RESULT_STATUS, (Object)lun.getStatus());
            object.put((Object)RESULT_CAPACITY, (Object)lun.getTotalCapacityAndUnit());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getStorageResources(String devSn, String ids, boolean isFromDevice) {
        if (VerifyUtil.isEmpty((String)ids)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService service = this.getBundleService(IStorageResourceService.class);
        List<String> idList = Arrays.asList(ids.split(";"));
        List resources = service.getStorageResources(devSn, idList, StorageResource.class);
        JSONArray array = new JSONArray();
        for (StorageResource resource : resources) {
            JSONObject obj = this.convertStorageResourceToJsonObject(resource);
            array.add((Object)obj);
        }
        return array.toString();
    }

    private JSONObject convertStorageResourceToJsonObject(StorageResource resource) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"id", (Object)resource.getResourceId());
        obj.put((Object)"resourceId", (Object)resource.getResourceId());
        obj.put((Object)RESULT_NAME, (Object)resource.getName());
        obj.put((Object)"totalCapacity", (Object)resource.getTotalCapacity());
        obj.put((Object)"totalCapacityUnit", (Object)resource.getTotalCapacityUnit());
        obj.put((Object)"usedCapacity", (Object)resource.getUsedCapacity());
        obj.put((Object)"usedCapacityUnit", (Object)resource.getUsedCapacityUnit());
        obj.put((Object)"devSn", (Object)resource.getDevSn());
        obj.put((Object)"healthStatus", (Object)NumberUtil.convertToInteger((Object)resource.getHealthStatus()));
        obj.put((Object)"runningStatus", (Object)NumberUtil.convertToInteger((Object)resource.getRunningStatus()));
        if (resource instanceof Lun) {
            obj.put((Object)"mapped", (Object)((Lun)resource).getMapped());
            obj.put((Object)"wwn", (Object)((Lun)resource).getWwn());
            obj.put((Object)"resourceType", (Object)DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue());
        } else if (resource instanceof NasFileSystem) {
            obj.put((Object)"resourceType", (Object)DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue());
            obj.put((Object)"vstoreId", (Object)((NasFileSystem)resource).getVstoreId());
        }
        return obj;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getStorageResourcesStatistic(String deviceSn, int templateType, List<StorageResource> excludedResources) {
        if (PolicyTemplateType.POLICY_TEMPLATE_E.getType((int)templateType) == null) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourcePoolService storagePoolService = (IStorageResourcePoolService)this.getBundleService("DRM_Base", IStorageResourcePoolService.class.getName());
        List storageResources = storagePoolService.getMatchedStorageResources(deviceSn, DrmEnumDefine.RESOURCE_TYPE_E.LUN);
        HashMap<String, StorageResource> excludedResourceMap = new HashMap<String, StorageResource>();
        if (!VerifyUtil.isEmpty(excludedResources)) {
            for (StorageResource resource : excludedResources) {
                excludedResourceMap.put(resource.getUuid(), resource);
            }
        }
        ArrayList<StorageResource> filteredStorageResources = new ArrayList<StorageResource>();
        for (StorageResource storageResource : storageResources) {
            if (excludedResourceMap.get(storageResource.getUuid()) != null) continue;
            filteredStorageResources.add(storageResource);
        }
        return DrmStorageUtil.getStorageResourceStatisticByLun(filteredStorageResources, templateType);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getInitiatorsByDevsn(String devSn) {
        IStorageResourceService service = this.getBundleService(IStorageResourceService.class);
        List initiators = service.getArrayInitiators(devSn, null);
        JSONArray array = new JSONArray();
        for (Initiator initiator : initiators) {
            JSONObject obj = this.buildInitiatorInfo(initiator);
            obj.put((Object)"initiatorIp", (Object)initiator.getInitiatorIp());
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1", "$2"})
    public String getHostInitiators(String devSn, String hostSn) {
        JSONArray array = new JSONArray();
        IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
        List filtInitiators = topoService.getConnectInitiators(devSn, hostSn);
        for (Initiator initiator : filtInitiators) {
            JSONObject obj = this.buildInitiatorInfo(initiator);
            array.add((Object)obj);
        }
        return array.toString();
    }

    private JSONObject buildInitiatorInfo(Initiator initiator) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"uuid", (Object)initiator.getUuid());
        obj.put((Object)RESULT_NAME, (Object)initiator.getName());
        obj.put((Object)"identity", (Object)initiator.getIdentity());
        obj.put((Object)"healthStatus", (Object)initiator.getHealthStatus());
        obj.put((Object)"runningStatus", (Object)initiator.getRunningStatus());
        obj.put((Object)"hbaType", (Object)initiator.getHbaType());
        obj.put((Object)"model", (Object)initiator.getModel());
        return obj;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getQuorumServerlinks(String devSn, String quorumServerId) {
        if (VerifyUtil.isEmpty((String)quorumServerId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService service = this.getBundleService(IStorageResourceService.class);
        List quorumServerLinks = service.getQuorumServerLink(devSn, quorumServerId);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)quorumServerLinks)) {
            return array.toString();
        }
        for (QuorumServerLink eachLink : quorumServerLinks) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachLink.getId());
            obj.put((Object)"localControllerId", (Object)eachLink.getLocalControllerId());
            obj.put((Object)"localPortId", (Object)eachLink.getLocalPortId());
            obj.put((Object)"localControllerName", (Object)eachLink.getLocalControllerName());
            obj.put((Object)"localPortName", (Object)eachLink.getLocalPortName());
            obj.put((Object)"quorumServerId", (Object)eachLink.getQuorumServerId());
            obj.put((Object)"quorumServerIp", (Object)eachLink.getQuorumServerIp());
            obj.put((Object)"runningState", (Object)eachLink.getRunningState());
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getSupportedCapabilities(String devSn) {
        ArrayUnit arrayUnit = this.getStorageService().getStorageBySn(devSn);
        if (null == arrayUnit) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray array = new JSONArray();
        if (arrayUnit instanceof HvsUnit) {
            array.add((Object)DrmEnumDefine.DEVICE_CAPABILITY_E.HYPER_CLONE.getValue());
            array.add((Object)DrmEnumDefine.DEVICE_CAPABILITY_E.HYPER_REPLIATION_RATE.getValue());
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getRemoteDevices(String devSn, String siteId) {
        IStorageService storageService = this.getBundleService(IStorageService.class);
        List remoteDevices = storageService.queryRemoteDevices(devSn);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)remoteDevices)) {
            return array.toString();
        }
        this.filterRemoteDeviceBySite(remoteDevices, siteId);
        for (RemoteDevice remoteDevice : remoteDevices) {
            try {
                this.checkUserAuthorityByMoSN(remoteDevice.getSn());
            }
            catch (LegoCheckedException ex) {
                LOGGER.debug((Object)("current user has no right, sn=" + remoteDevice.getSn() + " " + (Object)((Object)ex)));
                continue;
            }
            JSONObject json = new JSONObject();
            json.put((Object)"id", (Object)remoteDevice.getId());
            json.put((Object)RESULT_NAME, (Object)remoteDevice.getName());
            json.put((Object)"sn", (Object)remoteDevice.getSn());
            json.put((Object)"arrayType", (Object)remoteDevice.getArrayType());
            array.add((Object)json);
        }
        return array.toString();
    }

    private void filterRemoteDeviceBySite(List<RemoteDevice> remoteDevices, String siteId) {
        if (VerifyUtil.isEmpty((String)siteId)) {
            return;
        }
        IStorageService storageService = this.getBundleService(IStorageService.class);
        List storageListBySiteId = storageService.getStorageListBySiteId(siteId, this.getCurrentUserId());
        Iterator<RemoteDevice> iterator = remoteDevices.iterator();
        while (iterator.hasNext()) {
            RemoteDevice temp = iterator.next();
            boolean find = false;
            for (DrStorage drStorage : storageListBySiteId) {
                if (!drStorage.getDeviceSn().equals(temp.getSn())) continue;
                find = true;
                break;
            }
            if (find) continue;
            iterator.remove();
        }
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1", "$3"})
    public String getHyperVaultCandidateTargetFs(String devSn, String srcFileSystemId, String remoteDeviceSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, srcFileSystemId, remoteDeviceSn});
        IStorageResourceService storageResourceService = this.getBundleService(IStorageResourceService.class);
        List list = storageResourceService.queryHyperVaultCandidateTargetFs(devSn, srcFileSystemId, remoteDeviceSn);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)list)) {
            return array.toString();
        }
        for (NasFileSystem fs : list) {
            JSONObject obj = this.convertStorageResourceToJsonObject((StorageResource)fs);
            array.add((Object)obj);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getHyperMetroConsistentGroup(String devSn, String cgId, boolean isRealTime) {
        LOGGER.debug((Object)("Enter getHyperMetroConsistentGroup, sn=" + devSn + ", cgId=" + cgId + ", isRealTime=" + isRealTime));
        VerifyUtil.checkStrs((String[])new String[]{devSn, cgId});
        IStorageResourceService storageResourceService = this.getBundleService(IStorageResourceService.class);
        HyperMetroConsistentGroup cg = storageResourceService.getHyperMetroConsistentGroup(devSn, cgId, isRealTime);
        LOGGER.debug((Object)cg);
        JSONObject obj = this.hmCgToJsonObject(cg);
        LOGGER.debug((Object)"Exit getHyperMetroConsistentGroup.");
        return obj.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$3"})
    public String getHyperMetroPairsByWwns(String wwns, int roleType, String devSn, boolean isRealtime) {
        LOGGER.debug((Object)("Enter getHyperMetroPairsByWwns, wwns=" + wwns + ", roleType=" + roleType + ", isRealTime=" + isRealtime + ", devSn = " + devSn));
        return this.getAllHyperMetroPairs(wwns, roleType, devSn, null, isRealtime, false);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$3"})
    public String getHyperMetroPairsBySystem(String fileIds, int roleType, String devSn, String vstoreId, boolean isRealtime) {
        LOGGER.debug((Object)("Enter getHyperMetroPairsBySystem, fileIds=" + fileIds + ", roleType=" + roleType + ", isRealTime=" + isRealtime + ", devSn = " + devSn));
        return this.getAllHyperMetroPairs(fileIds, roleType, devSn, vstoreId, isRealtime, true);
    }

    private String getAllHyperMetroPairs(String resourceIds, int roleType, String devSn, String vstoreId, boolean isRealtime, boolean isNas) {
        IStorageResourceService storageResourceService = this.getBundleService(IStorageResourceService.class);
        if (!VerifyUtil.isEmpty((String)vstoreId) && !VerifyUtil.isEmpty((String)devSn) && isNas) {
            List pairs = storageResourceService.getHyperMetroPairByVstore(devSn, vstoreId);
            return this.getJsonArrayAfterPairUserAuthority(pairs);
        }
        if (VerifyUtil.isEmpty((String)resourceIds)) {
            LOGGER.error((Object)"resourceIds is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String[] splits = resourceIds.split(";");
        List<String> list = Arrays.asList(splits);
        Boolean isPrimary = null;
        if (roleType == 0) {
            isPrimary = true;
        } else if (roleType == 1) {
            isPrimary = false;
        }
        List pairs = isNas ? storageResourceService.getHyperMetroPairByFileSystems(devSn, list, isPrimary, Boolean.valueOf(isRealtime)) : storageResourceService.getHyperMetroPairByWwn(list, isPrimary, devSn, isRealtime);
        return this.getJsonArrayAfterPairUserAuthority(pairs);
    }

    private JSONObject hmCgToJsonObject(HyperMetroConsistentGroup cg) {
        JSONObject obj = new JSONObject();
        if (null != cg) {
            obj.put((Object)"uuid", (Object)cg.getUuid());
            obj.put((Object)"devSn", (Object)cg.getDevSn());
            obj.put((Object)"id", (Object)cg.getId());
            obj.put((Object)RESULT_NAME, (Object)cg.getName());
            obj.put((Object)"healthState", (Object)cg.getHealthState());
            obj.put((Object)"runningState", (Object)cg.getRunningState());
            obj.put((Object)"priorityStationType", (Object)cg.getPriorityStationType());
            obj.put((Object)"domainId", (Object)cg.getDomainId());
            obj.put((Object)"resourceType", (Object)cg.getResourceType());
            obj.put((Object)"isEmpty", (Object)cg.getIsEmpty());
            obj.put((Object)"syncDirection", (Object)cg.getSyncDirection());
        }
        LOGGER.debug((Object)obj);
        return obj;
    }

    private JSONObject hmPairToJsonObject(HyperMetroPair pair) {
        JSONObject obj = new JSONObject();
        obj.put((Object)"uuid", (Object)pair.getUuid());
        obj.put((Object)"devSn", (Object)pair.getDevSn());
        obj.put((Object)"id", (Object)pair.getId());
        obj.put((Object)RESULT_NAME, (Object)pair.getName());
        obj.put((Object)"healthState", (Object)pair.getHealthState());
        obj.put((Object)"runningState", (Object)pair.getRunningState());
        obj.put((Object)"domainId", (Object)pair.getDomainId());
        obj.put((Object)"resourceType", (Object)pair.getResourceType());
        obj.put((Object)"localObjId", (Object)pair.getLocalObjId());
        obj.put((Object)"remoteObjId", (Object)pair.getRemoteObjId());
        obj.put((Object)"isPrimary", (Object)pair.getIsPrimary());
        obj.put((Object)"resourceWwn", (Object)pair.getResourceWwn());
        obj.put((Object)"syncDirection", (Object)pair.getSyncDirection());
        obj.put((Object)"cgId", (Object)pair.getCgId());
        obj.put((Object)"vstorePairId", (Object)pair.getVstorePairId());
        LOGGER.debug((Object)obj);
        return obj;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getQuorumDomains(String devSn) {
        LOGGER.debug((Object)("Enter getQuorumDomains, devSn=" + devSn));
        IStorageResourceService service = this.getBundleService(IStorageResourceService.class);
        List domainList = service.getHyperMetroDomains(devSn);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)domainList)) {
            LOGGER.debug((Object)"domainList is empty.");
            return array.toString();
        }
        for (HyperMetroDomain eachDomain : domainList) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachDomain.getId());
            obj.put((Object)"domainType", (Object)eachDomain.getDomainType());
            obj.put((Object)"cpsId", (Object)eachDomain.getCpsId());
            obj.put((Object)"cpsName", (Object)eachDomain.getCpsName());
            obj.put((Object)"cpType", (Object)eachDomain.getCpType());
            obj.put((Object)"devSn", (Object)eachDomain.getDevSn());
            LOGGER.debug((Object)obj);
            array.add((Object)obj);
        }
        LOGGER.debug((Object)("Exit getQuorumDomains, devSn=" + devSn));
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getQuorumServers(String devSn) {
        LOGGER.debug((Object)("Enter getQuorumServers, devSn=" + devSn));
        IStorageResourceService service = this.getBundleService(IStorageResourceService.class);
        List serverList = service.getQuorumServers(devSn);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)serverList)) {
            LOGGER.debug((Object)"serverList is empty.");
            return array.toString();
        }
        for (QuorumServer eachServer : serverList) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", (Object)eachServer.getId());
            obj.put((Object)"serverIpA", (Object)eachServer.getServerIpA());
            obj.put((Object)"serverIpB", (Object)eachServer.getServerIpB());
            obj.put((Object)"sn", (Object)eachServer.getSn());
            obj.put((Object)"serverPortA", (Object)eachServer.getServerPortA());
            obj.put((Object)"serverPortB", (Object)eachServer.getServerPortB());
            obj.put((Object)"runningState", (Object)eachServer.getRunningState());
            obj.put((Object)"healthState", (Object)eachServer.getHealthState());
            obj.put((Object)"devSn", (Object)eachServer.getDevSn());
            LOGGER.debug((Object)obj);
            array.add((Object)obj);
        }
        LOGGER.debug((Object)"Exit getQuorumServers.");
        return array.toString();
    }

    @Override
    @Context(name="type")
    @Permission(name={"ism.drm.drp.auth.planed.motion"}, moid={"$1"})
    @Logging(name="recoveryPlan_syncHyperMetor_operateName", rank=3, object="$2", parameters={"$2", "$1", "$type"}, detail="recoveryPlan_syncHyperMetor_operateDetail")
    public Response synchronize(String devSn, String hyperMetroId, boolean isCg, String vstoreId) {
        LOGGER.debug((Object)("Enter synchronize, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, hyperMetroId});
        ManagedObject mo = this.getHyperMetroInfo(devSn, hyperMetroId, isCg, vstoreId);
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        srSvc.synchronize(devSn, hyperMetroId, isCg, vstoreId);
        Context.Variable.set((String)"type", (Object)mo.getClass().getSimpleName());
        LOGGER.debug((Object)"Exit synchronize.");
        return Response.ok().build();
    }

    private ManagedObject getHyperMetroInfo(String devSn, String hyperMetroId, boolean isCg, String vstoreId) {
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        Object mo = isCg ? srSvc.getHyperMetroConsistentGroup(devSn, hyperMetroId, true) : srSvc.getHyperMetroPair(devSn, hyperMetroId, true, vstoreId);
        if (null == mo) {
            LOGGER.error((Object)("hyperMetro not exist, devSn=" + devSn + ", id=" + hyperMetroId + ", isCg=" + isCg));
            throw new LegoCheckedException(2117645L);
        }
        return mo;
    }

    @Override
    @Contexts(value={@Context(name="type"), @Context(name="role")})
    @Permission(name={"ism.drm.drp.auth.planed.motion"}, moid={"$1"})
    @Logging(name="recoveryPlan_pauseHyperMetor_operateName", rank=3, object="$2", parameters={"$2", "$1", "$type", "$role"}, detail="recoveryPlan_pauseHyperMetor_operateDetail")
    public Response disable(String devSn, String hyperMetroId, Integer role, boolean isCg, String vstoreId) {
        LOGGER.debug((Object)("Enter disable, devSn=" + devSn + ", id=" + hyperMetroId + ", role=" + role + ", isCg=" + isCg));
        VerifyUtil.checkStrs((String[])new String[]{devSn, hyperMetroId});
        ManagedObject mo = this.getHyperMetroInfo(devSn, hyperMetroId, isCg, vstoreId);
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        DrmEnumDefine.ROLE_TYPE roleType = null == role ? DrmEnumDefine.ROLE_TYPE.DEFAULT : DrmEnumDefine.ROLE_TYPE.getType((int)role);
        srSvc.disable(devSn, hyperMetroId, roleType, isCg, vstoreId);
        Context.Variable.set((String)"type", (Object)mo.getClass().getSimpleName());
        Context.Variable.set((String)"role", (Object)roleType.name());
        LOGGER.debug((Object)"Exit disable.");
        return Response.ok().build();
    }

    private String getJsonArrayAfterPairUserAuthority(List<HyperMetroPair> pairs) {
        JSONArray arr = new JSONArray();
        if (VerifyUtil.isEmpty(pairs)) {
            LOGGER.debug((Object)"pairs is empty.");
            return arr.toString();
        }
        for (HyperMetroPair next : pairs) {
            LOGGER.debug((Object)("sn=" + next.getDevSn() + ", id=" + next.getId()));
            try {
                this.checkUserAuthorityByMoSN(next.getDevSn());
            }
            catch (LegoCheckedException ex) {
                LOGGER.debug((Object)ex);
                continue;
            }
            arr.add((Object)this.hmPairToJsonObject(next));
        }
        LOGGER.debug((Object)"Exit getHyperMetroPairsByWwns.");
        return arr.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getFileSystemByVstoreUUID(String vstoreuuid) {
        if (VerifyUtil.isEmpty((String)vstoreuuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        List nasFileSystemList = this.getStorageService().getFileSystemByVstoreUuid(vstoreuuid);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)nasFileSystemList)) {
            return array.toString();
        }
        VstoreInfo vstoreInfo = this.getStorageService().getVstoreInfoByVstoreUuid(vstoreuuid);
        if (VerifyUtil.isEmpty((Object)vstoreInfo)) {
            LOGGER.error((Object)"VstoreInfo is not exists!");
            throw new LegoCheckedException(1073947394L);
        }
        DrResource resource = this.getResourceService().getDrResourceBySn(vstoreInfo.getDevSn());
        if (!VerifyUtil.isEmpty((Object)resource) && resource.getIsAirGapResource().booleanValue()) {
            LOGGER.info((Object)"Filter out the file system that meets the requirements of air gap networking.");
            nasFileSystemList = this.getBundleService(IProtectObjectProviderDelegate.class.getName(), IProtectObjectProviderDelegate.class).filterAirGapNas(vstoreInfo.getDevSn(), nasFileSystemList, true);
        }
        for (NasFileSystem fileSystem : nasFileSystemList) {
            try {
                this.permissionService.checkUserMoAuthority(fileSystem.getDevSn());
            }
            catch (LegoCheckedException e) {
                LOGGER.info((Object)String.format("StorageResource(%s) checkUserAuthority failed.", fileSystem.getName()), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)fileSystem.getName());
            object.put((Object)RESULT_STATUS, (Object)fileSystem.getStatus());
            object.put((Object)RESULT_CAPACITY, (Object)fileSystem.getTotalCapacityAndUnit());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getFileSystemByVstoreId(String devSn, String vstoreId) {
        if (VerifyUtil.isEmpty((String)vstoreId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        List nasFileSystemList = srSvc.getFileSystemsByVstore(devSn, vstoreId);
        JSONArray array = new JSONArray();
        if (VerifyUtil.isEmpty((Collection)nasFileSystemList)) {
            return array.toString();
        }
        for (NasFileSystem fileSystem : nasFileSystemList) {
            try {
                this.permissionService.checkUserMoAuthority(fileSystem.getDevSn());
            }
            catch (LegoCheckedException e) {
                LOGGER.info((Object)("StorageResource(" + fileSystem.getName() + ") checkUserAuthority failed."), 90160758784000L);
                continue;
            }
            JSONObject object = new JSONObject();
            object.put((Object)RESULT_NAME, (Object)fileSystem.getName());
            object.put((Object)RESULT_STATUS, (Object)fileSystem.getStatus());
            object.put((Object)"devSn", (Object)fileSystem.getDevSn());
            object.put((Object)"resourceId", (Object)fileSystem.getResourceId());
            object.put((Object)"vstoreId", (Object)fileSystem.getVstoreId());
            object.put((Object)"resourceType", (Object)fileSystem.getResourceType());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getVstoreHyperMetroPair(String devSn, Boolean isAssociate, String id) {
        if (VerifyUtil.isEmpty((Object)isAssociate) || VerifyUtil.isEmpty((String)id)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        VstoreHyperMetroPair vstoreHyperMetroPair = srSvc.getVstoreHyperMetroPairById(devSn, id, isAssociate);
        JSONObject obj = this.constructVstoreHyperMetroPair(vstoreHyperMetroPair);
        LOGGER.debug((Object)obj);
        return obj.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"})
    public String getRemoteVstoreHyperMetroPair(String vstorePairId, String localVstoreId, String remoteVstoreId) {
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        List list = srSvc.getRemoteVstoreHyperMetroPair(vstorePairId, localVstoreId, remoteVstoreId);
        JSONArray array = new JSONArray();
        if (!VerifyUtil.isEmpty((Collection)list)) {
            for (VstoreHyperMetroPair pair : list) {
                JSONObject obj = this.constructVstoreHyperMetroPair(pair);
                array.add((Object)obj);
            }
        }
        return array.toString();
    }

    private JSONObject constructVstoreHyperMetroPair(VstoreHyperMetroPair vstoreHyperMetroPair) {
        JSONObject obj = new JSONObject();
        if (null != vstoreHyperMetroPair) {
            obj.put((Object)"localVstoreId", (Object)vstoreHyperMetroPair.getLocalVstoreId());
            obj.put((Object)"vstorePairId", (Object)vstoreHyperMetroPair.getVstorePairId());
            obj.put((Object)"remoteVstoreId", (Object)vstoreHyperMetroPair.getRemoteVstoreId());
            obj.put((Object)"healthStatus", (Object)vstoreHyperMetroPair.getHealthStatus());
            obj.put((Object)"activeOrPassive", (Object)vstoreHyperMetroPair.getActiveOrPassive());
            obj.put((Object)"runningStatus", (Object)vstoreHyperMetroPair.getRunningStatus());
            obj.put((Object)"linkStatus", (Object)vstoreHyperMetroPair.getLinkStatus());
            obj.put((Object)"configStatus", (Object)vstoreHyperMetroPair.getConfigStatus());
            ManagedObject managedObject = vstoreHyperMetroPair.getParentMo();
            if (managedObject instanceof HvsUnit) {
                HvsUnit hvsUnit = (HvsUnit)managedObject;
                obj.put((Object)"expendField", (Object)hvsUnit.getDevSn());
            }
        }
        return obj;
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.planed.motion"}, moid={"$1"})
    @Logging(name="recoveryPlan_swapVstorePair_operateName", rank=3, object="$2")
    public Response swapVstoreHyperMetroPair(String devSn, String vstorePairId) {
        LOGGER.debug((Object)("Enter swapVstorePair, devSn=" + devSn + ", id=" + vstorePairId));
        VerifyUtil.checkStrs((String[])new String[]{vstorePairId});
        IStorageResourceService srSvc = this.getBundleService(IStorageResourceService.class);
        srSvc.swapVstoreHyperMetroPair(devSn, vstorePairId);
        LOGGER.debug((Object)"Exit swapVstorePair.");
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getVstoreById(String devSn, String vstoreId) {
        if (VerifyUtil.isEmpty((String)vstoreId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageService storageService = this.getBundleService(IStorageService.class);
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("vstoreId", (Object)vstoreId);
        condition.setCoType(1);
        condition.setWholeWorld(true);
        conditions.add(condition);
        List vstoreInfos = storageService.queryVstoreInfoByStorageSn(devSn, null, Boolean.TRUE.booleanValue(), conditions);
        JSONObject object = new JSONObject();
        if (VerifyUtil.isEmpty((Collection)vstoreInfos)) {
            return object.toString();
        }
        VstoreInfo info = (VstoreInfo)vstoreInfos.iterator().next();
        object.put((Object)RESULT_NAME, (Object)info.getName());
        object.put((Object)"vstoreId", (Object)info.getVstoreId());
        object.put((Object)"devSn", (Object)info.getDevSn());
        return object.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getReplicationPairsByResourceIds(String devSn, String resIds, boolean isPrimary) {
        if (VerifyUtil.isEmpty((String)resIds)) {
            throw new LegoCheckedException(1073947393L);
        }
        String[] strResArray = resIds.split(";");
        ArrayList<String> listSrcResIds = new ArrayList<String>(Arrays.asList(strResArray));
        List listPairs = this.getStorageService().getReplicationPairsByResourceIds(devSn, listSrcResIds, isPrimary, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        return this.replicationPairListToJsonArray(listPairs);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public StorageLicense getStorageAllLicense(String storageSn) {
        return this.getBundleService(IStorageService.class).getStorageAllLicense(storageSn);
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String queryTargetStorages(String devSn) {
        JSONObject jSONObject = this.getStorageService().queryTargetStorages(devSn);
        return jSONObject.toString();
    }

    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="site_storage_createlun_operateName", rank=2, object="$2?.name")
    public Response createLun(String devSn, Lun lun) {
        VerifyUtil.checkObject((Object)lun);
        IStorageService storageService = this.getBundleService(IStorageService.class);
        Lun rtnLun = storageService.createLun(devSn, lun);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)RESULT_NAME, (Object)rtnLun.getName());
        jSONObject.put((Object)RESULT_CAPACITY, (Object)rtnLun.getCapacity());
        jSONObject.put((Object)RESULT_STATUS, (Object)rtnLun.getStatus());
        jSONObject.put((Object)"storagePoolId", (Object)rtnLun.getStoragePoolId());
        jSONObject.put((Object)"lunId", (Object)rtnLun.getLunId());
        jSONObject.put((Object)"wwn", (Object)rtnLun.getWwn());
        return Response.ok((Object)jSONObject.toString()).build();
    }

    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="site_storage_expandlun_operateName", rank=2, object="$3?.name")
    public Response updateLun(String devSn, String lunName, Lun lun) {
        VerifyUtil.checkObject((Object)lun);
        IStorageService storageService = this.getBundleService(IStorageService.class);
        storageService.expandLun(devSn, lun);
        this.writeSucOperationLog("site_storage_expandlun_operateName", 2, lun.getName(), "", new String[0]);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="site_storage_deletelun_operateName", rank=2, object="$2?.volNames?.toString()")
    public Response deleteLun(String devSn, DeleteLunRequest request) {
        VerifyUtil.checkObject((Object)request);
        IStorageService storageService = this.getBundleService(IStorageService.class);
        storageService.deleteLun(devSn, request.getVolIds(), request.getVolNames());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, uuid={"$1"})
    public String queryStoragePools(String siteId) {
        List pools = this.getStorageService().queryStoragePools();
        JSONArray array = new JSONArray();
        for (StoragePool storagePool : pools) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"neSN", (Object)storagePool.getNeSN());
            jSONObject.put((Object)"poolId", (Object)storagePool.getPoolId());
            jSONObject.put((Object)RESULT_NAME, (Object)storagePool.getName());
            array.add((Object)jSONObject);
        }
        return array.toString();
    }

    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    public String queryLunByName(String devSn, String lunName) {
        VerifyUtil.checkStrs((String[])new String[]{lunName});
        IStorageService storageService = this.getBundleService(IStorageService.class);
        Lun lun = storageService.queryLunByName(devSn, lunName);
        JSONObject jSONObject = new JSONObject();
        if (VerifyUtil.isEmpty((Object)lun)) {
            return jSONObject.toString();
        }
        jSONObject.put((Object)RESULT_NAME, (Object)lun.getName());
        jSONObject.put((Object)RESULT_CAPACITY, (Object)lun.getCapacity());
        jSONObject.put((Object)RESULT_STATUS, (Object)lun.getStatus());
        jSONObject.put((Object)"storagePoolId", (Object)lun.getStoragePoolId());
        jSONObject.put((Object)"lunId", (Object)lun.getLunId());
        jSONObject.put((Object)"wwn", (Object)lun.getWwn());
        return jSONObject.toString();
    }

    @Override
    @Context(name="storage")
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_refresh_operateName", rank=3, object="$storage?.name", parameters={"$storage?.name", "$storage?.linkIp"}, detail="resource_refresh_operateDetail")
    public Response refreshStorageResource(String devSn, int type, String id) {
        LOGGER.info((Object)"enter refreshStorageResource devSn=%s, resourceType=%s, resourceID=%s", new Object[]{devSn, type, id});
        StorageNE storage = this.getStorageService().getStorageBySn(devSn, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)storage)) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)STORAGE, (Object)storage);
        IStorageService storageService = this.getStorageService();
        String taskID = storageService.refreshSpecifyResource(storage.getMoId(), this.getCurrentUser().getUserName(), type, id);
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskID);
        return Response.ok((Object)obj.toString()).build();
    }

    private IResourceService getResourceService() {
        return (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
    }

    @Override
    @Contexts(value={@Context(name="storage"), @Context(name="timeWindow")})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_modifyTimeWindow_operateName", rank=3, object="$storage?.name", parameters={"$storage?.name", "$2.windowId", "$timeWindow"}, detail="resource_modifyTimeWindow_operateDetail")
    public void modifyStorageTimeWindow(String devSn, ResourceTimeWindowVo timeWindowVo) {
        LOGGER.info((Object)"Enter updateResourceTimeWindow");
        this.checkParamAndTime(devSn, timeWindowVo);
        ResourceTimeWindow timeWindow = CommUtils.genTimeWindowObject(devSn, timeWindowVo);
        StorageNE storage = this.getStorageService().getStorageBySn(devSn, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)storage)) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)STORAGE, (Object)storage);
        Set<ResourceTimeWindowRange> ranges = timeWindowVo.getTimeWindowRanges();
        String timeWindowStr = BaseRestUtils.getRangesStr(ranges);
        Context.Variable.set((String)"timeWindow", (Object)timeWindowStr);
        this.getResourceService().updateResourceTimeWindow(timeWindow);
    }

    private void checkParamAndTime(String devSn, ResourceTimeWindowVo timeWindowVo) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((Object)timeWindowVo)) {
            LOGGER.error((Object)"Param is null or empty.resourceId: %s.", new Object[]{devSn});
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Contexts(value={@Context(name="storage"), @Context(name="mode")})
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="resource_switchoverTimeWindow_operateName", rank=3, object="$storage?.name", parameters={"$storage?.name", "$2", "$mode"}, detail="resource_switchoverTimeWindow_operateDetail")
    public Response switchOverStorageLinkPort(String devSn, String windowId, boolean isManualTunnel) {
        if (VerifyUtil.isEmpty((String)devSn) || VerifyUtil.isEmpty((String)windowId) || VerifyUtil.isEmpty((Object)isManualTunnel)) {
            LOGGER.error((Object)"Illegal request params, devSn or windowId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        StorageNE storage = this.getStorageService().getStorageBySn(devSn, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)storage)) {
            throw new LegoCheckedException(1073947394L);
        }
        String switchType = isManualTunnel ? "Maintenance Mode" : "Security Mode";
        Context.Variable.set((String)STORAGE, (Object)storage);
        Context.Variable.set((String)"mode", (Object)switchType);
        this.getResourceService().switchoverTimeWindows(devSn, windowId, isManualTunnel, false);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<ResourceTimeWindowVo> getStorageTimeWindow(String devSn) {
        List timeWindows = this.getResourceService().getResourceTimeWindow(devSn);
        ArrayList<ResourceTimeWindowVo> res = new ArrayList<ResourceTimeWindowVo>();
        for (ResourceTimeWindow timeWindow : timeWindows) {
            ResourceTimeWindowVo timeWindowVo = CommUtils.genTimeWindowVo(timeWindow);
            res.add(timeWindowVo);
        }
        res.sort((o1, o2) -> o2.getWindowId().compareTo(o1.getWindowId()));
        return res;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<StorageLinkPort> getStorageLinkPort(String devSn) {
        List linkPorts = this.getResourceService().getResourceLinkPorts(devSn);
        if (CollectionUtils.isEmpty((Collection)linkPorts)) {
            return Collections.emptyList();
        }
        return linkPorts;
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public List<StoragePortOperateLog> getStorageLinkPortOperateLog(String devSn, String portId) {
        if (VerifyUtil.isEmpty((String)portId)) {
            LOGGER.error((Object)"illegal devSn or portId");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getResourceService().getResourcePortOperateLog(devSn, portId);
    }
}

