/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadFileUtil {
    private static Log logger = FELogFactory.getInstance((String)"ui");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void downloadFile(HttpServletResponse response, HttpServletRequest request, File downloadFile) {
        if (VerifyUtil.isEmpty((Object)downloadFile)) {
            return;
        }
        displayName = downloadFile.getName();
        displayName = DownloadFileUtil.checkBrower(request, displayName);
        response.setContentType("application/x-download;");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.setHeader("Content-disposition", "attachment;filename=\"" + displayName + "\"");
        bis = null;
        bos = null;
        fileInput = null;
        hasDeleted = true;
        filePath = null;
        try {
            fileInput = new FileInputStream(downloadFile);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            filePath = downloadFile.getCanonicalPath();
        }
        catch (Exception e) {
            try {
                DownloadFileUtil.logger.error((Object)("Download File error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            catch (Throwable var11_12) {
                DownloadFileUtil.close(bis, bos, fileInput);
                if (!downloadFile.delete()) {
                    DownloadFileUtil.logger.error((Object)"Delete file error", 653110170615808L);
                    hasDeleted = false;
                }
                throw var11_12;
            }
            DownloadFileUtil.close(bis, bos, fileInput);
            if (!downloadFile.delete()) {
                DownloadFileUtil.logger.error((Object)"Delete file error", 653110170615808L);
                hasDeleted = false;
            } else {
                ** GOTO lbl43
            }
        }
        DownloadFileUtil.close(bis, bos, fileInput);
        if (!downloadFile.delete()) {
            DownloadFileUtil.logger.error((Object)"Delete file error", 653110170615808L);
            hasDeleted = false;
        }
        if (!hasDeleted) {
            throw new LegoCheckedException(1073948484L, new String[]{filePath});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadLogFile(HttpServletResponse response, HttpServletRequest request, File downloadLogFile) {
        if (downloadLogFile == null) {
            logger.error((Object)"recoveryplan downloadFile not exist", 653110170615808L);
            return;
        }
        String displayName = downloadLogFile.getName().substring(0, downloadLogFile.getName().lastIndexOf("_")) + ".csv";
        displayName = DownloadFileUtil.checkBrower(request, displayName);
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store, must-revalidate");
        response.setHeader("Content-disposition", "attachment;filename=\"" + displayName + "\"");
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadLogFile);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("downloadFile error:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            catch (Throwable throwable) {
                DownloadFileUtil.close(bis, bos, fileInput);
                if (!downloadLogFile.delete()) {
                    logger.error((Object)"delete file error", 653110170615808L);
                }
                throw throwable;
            }
            DownloadFileUtil.close(bis, bos, fileInput);
            if (!downloadLogFile.delete()) {
                logger.error((Object)"delete file error", 653110170615808L);
            }
        }
        DownloadFileUtil.close(bis, bos, fileInput);
        if (!downloadLogFile.delete()) {
            logger.error((Object)"delete file error", 653110170615808L);
        }
    }

    private static String checkBrower(HttpServletRequest request, String displayName) {
        String agent = request.getHeader("USER-AGENT").toLowerCase(Locale.getDefault());
        try {
            displayName = agent.indexOf("msie") > -1 || agent.indexOf("chrome") > -1 ? URLEncoder.encode(displayName, "UTF-8") : new String(displayName.getBytes("UTF-8"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("cover filename fail" + displayName));
        }
        return displayName.replaceAll("\\+", "%20");
    }

    private static void close(BufferedInputStream bis, BufferedOutputStream bos, FileInputStream fileInput) {
        if (null != fileInput) {
            try {
                fileInput.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bis != null) {
            try {
                bis.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                logger.error((Object)"downloadFile", 653110170615808L);
            }
        }
    }
}

