/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.util;

import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.system.syslog.sdk.model.SysOptLog;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.util.Date;

public final class SysOpLogBuilder {
    public static final String ERROR_KEY = "lego.err.";
    public static final int SUCCESS = 1;
    public static final int FAILURE = 0;
    private static final Log logger = LogFactory.getInstance(SysOpLogBuilder.class);

    private SysOpLogBuilder() {
    }

    public static void writeOperateLog(SysOptLog optLog) {
        ServiceContext context = ServiceContext.getInstance();
        try {
            ISysOptLog sysOptLog = (ISysOptLog)context.lookup("system/sysLogService");
            if (null == sysOptLog) {
                logger.error((Object)"sysOptLog RMI service is null", 90160758784001L);
                return;
            }
            sysOptLog.writeOptLog(optLog);
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L);
        }
    }

    public static SysOptLog buildeSuccussSysOptLog(String operationName, String operator, Integer level, String detail, String targetName, String operatorIpaddress) {
        SysOptLog optLog = new SysOptLog();
        optLog.setOperation(operationName);
        optLog.setOperator(operator);
        optLog.setLevel(level.intValue());
        optLog.setDate(new Date(System.currentTimeMillis()));
        optLog.setModule("--");
        optLog.setDetail(detail);
        optLog.setTarget(targetName);
        optLog.setTargetLocal(Boolean.TRUE);
        optLog.setResult(1);
        optLog.setTerminalIp(operatorIpaddress);
        optLog.setLogType("administratorlog");
        return optLog;
    }

    public static SysOptLog buildeFailureSysOptLog(String operationName, String operator, Integer level, String detail, String targetName, String operatorIpaddress) {
        SysOptLog optLog = new SysOptLog();
        optLog.setOperation(operationName);
        optLog.setOperator(operator);
        optLog.setLevel(level.intValue());
        optLog.setDate(new Date(System.currentTimeMillis()));
        optLog.setModule("--");
        optLog.setDetail(detail);
        optLog.setTarget(targetName);
        optLog.setTargetLocal(Boolean.TRUE);
        optLog.setResult(0);
        optLog.setTerminalIp(operatorIpaddress);
        optLog.setLogType("administratorlog");
        return optLog;
    }
}

