/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.filter.ParameterizedFilterConfig;
import com.huawei.ism.drm.web.filter.SystemSecurityFilter;
import com.huawei.ism.drm.web.util.CookieUtil;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.SessionUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.ReflectUtils;

public class SSOIntegrateFilter
implements Filter {
    public static final String PAGE_INDEX = "/src/index.html";
    public static final String WRAPPED_FILTER_CLASS = "wrappedFilterClass";
    public static final String SESSION_LANGUAGE = "WW_TRANS_I18N_LOCALE";
    public static final long FORBIDDEN = 403L;
    public static final String TINY_LANGUAGE = "tiny_language";
    private static final String SSO_ERROR = "SSO-Error: ";
    private static final String EN = "en";
    private static final String ZH = "zh";
    private static final Log log = LogFactory.getInstance(SSOIntegrateFilter.class);
    private Map<String, String> loginMap = null;
    private Filter filter = null;

    public void destroy() {
        this.loginMap = null;
        if (this.filter != null) {
            this.filter.destroy();
            this.filter = null;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        uri = UriUtil.canonicalPath(uri);
        String method = httpRequest.getMethod();
        if ("/".equals(uri) || "/src".equals(uri) && "get".equalsIgnoreCase(method)) {
            this.setLanguage(httpRequest, httpResponse);
            this.redirectToHomePage(httpResponse);
            return;
        }
        if ("/ws/systemPrivileges".equals(uri)) {
            this.setLanguage(httpRequest, httpResponse);
        }
        if (!SessionUtil.isLocalLoginMode(httpRequest)) {
            boolean miVisited;
            boolean login = SystemSecurityFilter.checkUriAndMethod(this.loginMap, uri, method);
            boolean cloud = SystemSecurityFilter.isCloudRestService(uri);
            boolean bl = miVisited = SystemSecurityFilter.getMachineInterfaceVisitorName(httpRequest, uri) != null;
            if (SystemSecurityFilter.isRestRequest(uri) && !login && !cloud && !miVisited) {
                UriUtil.writeLocalRedirect(httpRequest, httpResponse);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void setLanguage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String language = httpRequest.getParameter("locale");
        if (VerifyUtil.isEmpty((String)language)) {
            return;
        }
        log.debug((Object)("get language is " + language));
        HttpSession session = httpRequest.getSession();
        if ("zh-cn".equalsIgnoreCase(language)) {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.SIMPLIFIED_CHINESE);
            CookieUtil.addCookie(httpResponse, "rd_language", ZH);
            CookieUtil.addCookie(httpResponse, TINY_LANGUAGE, ZH);
        } else {
            session.setAttribute(SESSION_LANGUAGE, (Object)Locale.ENGLISH);
            CookieUtil.addCookie(httpResponse, "rd_language", EN);
            CookieUtil.addCookie(httpResponse, TINY_LANGUAGE, EN);
        }
    }

    private void redirectToHomePage(HttpServletResponse response) throws IOException {
        response.sendRedirect(PAGE_INDEX);
    }

    public void init(FilterConfig config) throws ServletException {
        String validUris = FilterUtil.getInitParameter(config, SystemSecurityFilter.class, "validUris");
        this.loginMap = FilterUtil.initSpecialUriMap(validUris, new HashMap<String, String>());
        String clazz = config.getInitParameter(WRAPPED_FILTER_CLASS);
        this.filter = (Filter)ReflectUtils.newInstance((String)clazz, (Object[])new Object[0]);
        this.filter.init((FilterConfig)new ParameterizedFilterConfig(config));
    }
}

