/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.drm.web.util.SessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;

public class SSOSessionMappingStorage
implements SessionMappingStorage {
    private static final Logger log = Logger.getLogger(SSOSessionMappingStorage.class);
    private SessionMappingStorage storage = new HashMapBackedSessionMappingStorage();

    public HttpSession removeSessionByMappingId(String mappingId) {
        log.debug((Object)("remove mappingId : " + mappingId));
        HttpSession session = this.storage.removeSessionByMappingId(mappingId);
        if (SessionUtil.isSSOLoginMode(session)) {
            log.debug((Object)"login mode is sso");
            return session;
        }
        return null;
    }

    public void removeBySessionById(String sessionId) {
        this.storage.removeBySessionById(sessionId);
    }

    public void addSessionById(String mappingId, HttpSession session) {
        log.debug((Object)("add mappingId : " + mappingId));
        this.storage.addSessionById(mappingId, session);
    }
}

