/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.filter;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.web.filter.ParameterizedConfiguration;
import com.huawei.ism.drm.web.filter.SystemSecurityFilter;
import com.huawei.ism.drm.web.filter.TicketTouchAction;
import com.huawei.ism.drm.web.util.FilterUtil;
import com.huawei.ism.drm.web.util.UriUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;

public class TicketTouchFilter
extends AbstractCasFilter {
    private String encoding;
    private String casServerUrlPrefix;
    private String casServerTouchUrl;
    private String artifactParameterName = "ticket";
    private Map<String, String> refreshMap;

    public TicketTouchFilter() {
        super(Protocol.CAS3);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public void setCasServerTouchUrl(String casServerTouchUrl) {
        this.casServerTouchUrl = casServerTouchUrl;
    }

    public void setRefreshMap(Map<String, String> refreshMap) {
        this.refreshMap = refreshMap;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (this.isIgnoreInitConfiguration()) {
            return;
        }
        super.initInternal(filterConfig);
        this.initialize(filterConfig);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private String getPropertyFromInitParams(FilterConfig filterConfig, String propertyName, String defaultValue) {
        String value = filterConfig.getInitParameter(propertyName);
        if (CommonUtils.isNotBlank((String)value)) {
            if ("renew".equals(propertyName)) {
                throw new IllegalArgumentException("Renew MUST be specified via context parameter or JNDI environment to avoid misconfiguration.");
            }
            this.logger.info("Property [{}] loaded from FilterConfig.getInitParameter with value [{}]", (Object)propertyName, (Object)value);
            return value;
        }
        String value2 = filterConfig.getServletContext().getInitParameter(propertyName);
        if (CommonUtils.isNotBlank((String)value2)) {
            this.logger.info("Property [{}] loaded from ServletContext.getInitParameter with value [{}]", (Object)propertyName, (Object)value2);
            return value2;
        }
        this.logger.info("Property [{}] not found.  Using default value [{}]", (Object)propertyName, (Object)defaultValue);
        return defaultValue;
    }

    private void initialize(FilterConfig filterConfig) {
        this.setEncoding(this.getPropertyFromInitParams(filterConfig, "encoding", null));
        this.setCasServerUrlPrefix(this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", null));
        CommonUtils.assertNotNull((Object)this.casServerUrlPrefix, (String)"casServerUrlPrefix cannot be null.");
        this.setCasServerTouchUrl(this.getPropertyFromInitParams(filterConfig, "casServerTouchUrl", "/unisso/touch"));
        CommonUtils.assertNotNull((Object)this.casServerTouchUrl, (String)"casServerTouchUrl cannot be null.");
        String validRefreshUris = FilterUtil.getInitParameter(filterConfig, SystemSecurityFilter.class, "validRefreshUris");
        this.setRefreshMap(FilterUtil.initSpecialUriMap(validRefreshUris, new HashMap<String, String>()));
        this.artifactParameterName = this.getPropertyFromInitParams(filterConfig, "artifactParameterName", "ticket");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.touchTicket((HttpServletRequest)request);
        chain.doFilter(request, response);
    }

    private void touchTicket(HttpServletRequest request) {
        String method;
        HttpSession session = request.getSession(false);
        if (session == null) {
            this.getLogger().debug("No need touch ticket when not found session");
            return;
        }
        AbstractMap.SimpleEntry ticket = (AbstractMap.SimpleEntry)session.getAttribute("SSO_TICKET");
        if (ticket == null) {
            this.getLogger().debug("No need touch ticket when not found ticket or ticket lock");
            return;
        }
        String uri = UriUtil.getNormalizeRequestServletUri(request);
        boolean refresh = SystemSecurityFilter.checkUriAndMethod(this.refreshMap, uri, method = request.getMethod());
        if (refresh) {
            boolean touch;
            Integer sessionTime = (Integer)session.getAttribute("SSOSessionTime");
            Integer refreashTouchNum = (Integer)session.getAttribute("SSORefreashTouchNum");
            if (VerifyUtil.isEmpty((Object)sessionTime) || VerifyUtil.isEmpty((Object)refreashTouchNum)) {
                this.getLogger().debug("No need touch ticket when usrLogPolicy empty");
                return;
            }
            int tempNum = sessionTime / 5;
            if (refreashTouchNum <= tempNum && (touch = this.doTouch(request, ticket))) {
                refreashTouchNum = refreashTouchNum + 1;
                session.setAttribute("SSORefreashTouchNum", (Object)refreashTouchNum);
            }
            return;
        }
        this.doTouch(request, ticket);
        session.setAttribute("SSORefreashTouchNum", (Object)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTouch(HttpServletRequest request, AbstractMap.SimpleEntry<String, Long> ticket) {
        AbstractMap.SimpleEntry<String, Long> simpleEntry = ticket;
        synchronized (simpleEntry) {
            long tick = ticket.getValue();
            long millis = System.currentTimeMillis();
            long active = TimeUnit.MINUTES.toMillis(5L);
            if (millis - tick > active) {
                this.touchTicket(request, ticket);
                return true;
            }
        }
        return false;
    }

    private void touchTicket(HttpServletRequest request, AbstractMap.SimpleEntry<String, Long> ticket) {
        URL url;
        ServletContext context = request.getServletContext();
        ServletContext proxyContext = ParameterizedConfiguration.get(context).getProxy();
        String ssoServer = proxyContext.getInitParameter("sso.address.server");
        String requestUrl = UriUtil.constructURL(ssoServer, this.casServerTouchUrl) + '?' + this.artifactParameterName + '=' + ticket.getKey();
        try {
            url = new URL(requestUrl);
        }
        catch (MalformedURLException e) {
            this.getLogger().error("construct touch request url failed. {}", (Object)e.getMessage());
            return;
        }
        new TicketTouchAction(url, ticket, this.getEncoding()).run();
    }
}

