/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.service.permission;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.service.permission.Authentication;
import com.huawei.ism.drm.web.service.permission.PermissionService;
import com.huawei.ism.drm.web.service.session.SessionService;
import com.huawei.ism.drm.web.service.tunnel.BundleService;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.moment.bedstone.shield.framework.context.ContextService;
import com.huawei.moment.bedstone.shield.framework.util.ProceedingJoinPointUtil;
import com.huawei.moment.bedstone.shield.service.validate.ValidateService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Component
public class DefaultPermissionService
implements ValidateService<Authentication>,
PermissionService {
    private static final Log LOG = LogFactory.getInstance(DefaultPermissionService.class);
    private final ContextService contextService;
    private final BundleService bundleService;
    private final SessionService sessionService;

    public DefaultPermissionService(ContextService contextService, BundleService bundleService, SessionService sessionService) {
        this.contextService = contextService;
        this.bundleService = bundleService;
        this.sessionService = sessionService;
    }

    public List<Authentication> load(ProceedingJoinPoint joinPoint) {
        Set permissions = ProceedingJoinPointUtil.getMergedRepeatableAnnotations((ProceedingJoinPoint)joinPoint, Permission.class);
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        MethodSignature signature = ProceedingJoinPointUtil.getMethodSignature((ProceedingJoinPoint)joinPoint);
        LOG.debug((Object)("load permission config for method " + signature.getMethod()));
        return permissions.stream().map(this::buildAuthenticationContext).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Authentication> buildAuthenticationContext(Permission permission) {
        Object result;
        String when = permission.when();
        if (!when.isEmpty() && !Boolean.TRUE.equals(result = this.contextService.eval(when))) {
            return Optional.empty();
        }
        List<String> nameList = Arrays.asList(permission.name());
        List<String> uuidList = Stream.of(permission.uuid()).flatMap(this::eval).map(this::checkValidUuid).collect(Collectors.toList());
        List<Object> moidList = Stream.of(permission.moid()).flatMap(this::eval).collect(Collectors.toList());
        return Optional.of(new Authentication(nameList, uuidList, moidList));
    }

    private Stream<Object> eval(String expr) {
        Object result = this.contextService.eval(expr);
        if (result == null) {
            return Arrays.stream(new Object[]{null});
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            return collection.stream();
        }
        if (result.getClass().isArray()) {
            return Arrays.stream((Object[])result);
        }
        return Stream.of(result);
    }

    public void validate(ProceedingJoinPoint joinPoint, Authentication authentication) {
        Long currentUserId = this.sessionService.getCurrentUser().getUserId();
        this.checkUserRight(currentUserId, authentication.getNameList());
        this.checkUserGrantedObject(currentUserId, authentication.getUuidList());
        this.checkUserMoAuthority(currentUserId, authentication.getMoidList());
    }

    @Override
    public void checkUserMoAuthority(List<?> resources) {
        Long currentUserId = this.sessionService.getCurrentUser().getUserId();
        this.checkUserMoAuthority(currentUserId, resources);
    }

    private void checkUserMoAuthority(Long currentUserId, List<?> resources) {
        if (resources.stream().anyMatch(resource -> !this.checkValidMoid(resource))) {
            throw new LegoCheckedException(1073947393L);
        }
        String[] uuids = (String[])resources.stream().filter(String.class::isInstance).map(String.class::cast).toArray(String[]::new);
        this.checkUserMoAuthority(currentUserId, uuids);
        long[] moIds = resources.stream().filter(Number.class::isInstance).map(Number.class::cast).mapToLong(Number::longValue).toArray();
        this.checkUserMoAuthority(currentUserId, moIds);
    }

    private boolean checkValidMoid(Object moid) {
        return moid instanceof String || moid instanceof Number;
    }

    private String checkValidUuid(Object uuid) {
        if (uuid instanceof String) {
            return (String)uuid;
        }
        if (VerifyUtil.isEmpty((Object)uuid)) {
            return "";
        }
        throw new LegoCheckedException(1073947393L);
    }

    private void checkUserRight(Long currentUserId, List<String> i18nKeys) {
        IUserMgr mgr = this.bundleService.getUserMgr();
        boolean hasRight = i18nKeys.stream().anyMatch(i18nKey -> mgr.checkUserRight(currentUserId.longValue(), i18nKey));
        if (!hasRight) {
            throw new LegoCheckedException(1073947400L);
        }
    }

    private void checkUserMoAuthority(Long currentUserId, String[] resources) {
        IBizScopeManager scope = this.getBizScopeManager();
        Stream.of(resources).distinct().forEach(resource -> scope.checkUserGrantedMOObject(currentUserId, resource));
    }

    @Override
    public void checkUserGrantedObject(List<String> uuidList) {
        Long currentUserId = this.sessionService.getCurrentUser().getUserId();
        this.checkUserGrantedObject(currentUserId, uuidList);
    }

    private void checkUserGrantedObject(Long currentUserId, List<String> uuidList) {
        IBizScopeManager scope = this.getBizScopeManager();
        uuidList.stream().distinct().forEach(uuid -> scope.checkUserGrantedObject(currentUserId, uuid));
    }

    private void checkUserMoAuthority(Long currentUserId, long[] moIds) {
        IBizScopeManager scope = this.getBizScopeManager();
        LongStream.of(moIds).distinct().forEach(moId -> scope.checkUserGrantedMOObject(currentUserId, new long[]{moId}));
    }

    private IBizScopeManager getBizScopeManager() {
        return this.bundleService.getBundleService("IBizScopeManager", IBizScopeManager.class);
    }
}

