/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;

public class ClassLoaderUtil {
    private static final Logger log = Logger.getLogger((String)ClassLoaderUtil.class.getName());

    public static Iterator<URL> getResources(String resourceName, Class callingClass, boolean aggregate) throws IOException {
        ClassLoader cl;
        ClassLoader classLoader;
        AggregateIterator<URL> iterator = new AggregateIterator<URL>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            iterator.addEnumeration(contextClassLoader.getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (classLoader = ClassLoaderUtil.class.getClassLoader()) != null) {
            iterator.addEnumeration(classLoader.getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (cl = callingClass.getClassLoader()) != null) {
            iterator.addEnumeration(cl.getResources(resourceName));
        }
        if (!iterator.hasNext() && ClassLoaderUtil.verifyResourceName(resourceName)) {
            return ClassLoaderUtil.getResources('/' + resourceName, callingClass, aggregate);
        }
        return iterator;
    }

    public static URL getResource(String resourceName, Class callingClass) {
        ClassLoader cl;
        ClassLoader classLoader;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && (classLoader = ClassLoaderUtil.class.getClassLoader()) != null) {
            url = classLoader.getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && ClassLoaderUtil.verifyResourceName(resourceName)) {
            return ClassLoaderUtil.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = ClassLoaderUtil.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            log.error((Object)"Cannot get stream for resource");
            return null;
        }
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader cl = ClassLoaderUtil.class.getClassLoader();
                try {
                    if (cl != null) {
                        return cl.loadClass(className);
                    }
                }
                catch (ClassNotFoundException exc) {
                    log.error((Object)("Cannot find class : " + className));
                }
                if (callingClass == null) {
                    return null;
                }
                ClassLoader cl2 = callingClass.getClassLoader();
                if (cl2 != null) {
                    return cl2.loadClass(className);
                }
                return null;
            }
        }
    }

    public static void printClassLoader() {
        log.error((Object)"ClassLoaderUtils.printClassLoader");
        ClassLoaderUtil.printClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void printClassLoader(ClassLoader cl) {
        log.error((Object)("ClassLoaderUtils.printClassLoader(cl = " + cl + ")"));
        if (cl != null) {
            ClassLoaderUtil.printClassLoader(cl.getParent());
        }
    }

    private static boolean verifyResourceName(String resourceName) {
        return resourceName != null && (resourceName.length() == 0 || resourceName.charAt(0) != '/');
    }

    static class AggregateIterator<E>
    implements Iterator<E> {
        private List<Enumeration<E>> enums = new LinkedList<Enumeration<E>>();
        private Enumeration<E> cur = null;
        private E nextNode = null;
        private Set<E> loaded = new HashSet();

        AggregateIterator() {
        }

        public AggregateIterator<E> addEnumeration(Enumeration<E> e) {
            if (e.hasMoreElements()) {
                if (this.cur == null) {
                    this.cur = e;
                    this.nextNode = e.nextElement();
                    this.loaded.add(this.nextNode);
                } else {
                    this.enums.add(e);
                }
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode != null) {
                E prev = this.nextNode;
                this.nextNode = this.loadNext();
                return prev;
            }
            throw new NoSuchElementException();
        }

        private Enumeration<E> determineCurrentEnumeration() {
            if (this.cur != null && !this.cur.hasMoreElements()) {
                this.cur = this.enums.size() > 0 ? (Enumeration)((LinkedList)this.enums).removeLast() : null;
            }
            return this.cur;
        }

        private E loadNext() {
            if (this.determineCurrentEnumeration() != null) {
                E tmp = this.cur.nextElement();
                int loadedSize = this.loaded.size();
                while (this.loaded.contains(tmp) && (tmp = this.loadNext()) != null && this.loaded.size() <= loadedSize) {
                }
                if (tmp != null) {
                    this.loaded.add(tmp);
                }
                return tmp;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

