/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.framework.resource.model.ResourceTimeWindowVo;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.FELogFactory;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommUtils {
    private static final Log logger = LogFactory.getInstance(CommUtils.class);
    private static final int APM_NAME_PARAM_MIN_SIZE = 4;
    private static final int APM_NAME_PARAM_MAX_SIZE = 256;
    private static final int APM_DESC_PARAM_MAX_SIZE = 255;
    private static final int APM_PORT_PARAM_MAX_SZIE = 65535;
    private static Log log = FELogFactory.getInstance((String)"ui");

    private CommUtils() {
    }

    public static boolean isNullStr(String str) {
        return null == str || str.length() < 1;
    }

    public static boolean checkStr(String str, String regex) {
        if (CommUtils.isNullStr(str)) {
            return false;
        }
        if (null == regex) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(Normalizer.normalize(str, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    public static void isNullCollection(Collection<?> collection) {
        if (null == collection || collection.size() < 1) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeContent = dateFormat.format(date);
        String timeZoneStr = " " + TimeUtil.getDefaultTimeZone((Date)date);
        timeContent = timeContent + timeZoneStr;
        return timeContent;
    }

    public static String formatDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (VerifyUtil.isEmpty((String)date)) {
            return null;
        }
        try {
            Date date1 = format.parse(date);
            return format.format(date1);
        }
        catch (ParseException e) {
            return format.format(new Date(NumberUtil.convertToLong((Object)date)));
        }
    }

    public static Date parseDate(String str) {
        Date result;
        if (CommUtils.isNullStr(str)) {
            return null;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            result = format.parse(str);
        }
        catch (ParseException e) {
            logger.error((Object)"ParseException", 90160758786989L);
            return null;
        }
        return result;
    }

    public static boolean containIp(String matcherStr) {
        if (VerifyUtil.isEmpty((String)matcherStr)) {
            return false;
        }
        String matchIp = "\\d*((2[5][0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2}))";
        return Pattern.compile(matchIp).matcher(Normalizer.normalize(matcherStr, Normalizer.Form.NFKC)).find();
    }

    public static int valueOfInt(String intStr) {
        if (VerifyUtil.isEmpty((String)intStr)) {
            throw new LegoCheckedException(1073947393L);
        }
        try {
            return Integer.parseInt(intStr);
        }
        catch (Exception e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
    }

    public static String[] parseJsonStr2Array(String jsonStr, String fieldName) {
        String[] restIdArray;
        try {
            JSONArray jsonArray = JSONArray.fromObject((Object)jsonStr);
            int size = jsonArray.size();
            restIdArray = new String[size];
            for (int i = 0; i < size; ++i) {
                JSONObject object = JSONObject.fromObject((Object)jsonArray.get(i));
                restIdArray[i] = object.getString(fieldName);
            }
        }
        catch (Exception e) {
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return restIdArray;
    }

    public static boolean checkParamEmpty(Object ... params) {
        return CommUtil.checkParamEmpty((Object[])params);
    }

    public static boolean checkArrayEmpty(Object[] params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (Object param : params) {
            String pString;
            if (VerifyUtil.isEmpty((Object)param)) {
                throw new LegoCheckedException(1073947393L);
            }
            if (!(param instanceof String) || !VerifyUtil.isEmpty((String)(pString = (String)param))) continue;
            throw new LegoCheckedException(1073947393L);
        }
        return true;
    }

    public static void verifyParameterList(List<String> verifyList) {
        if (VerifyUtil.isEmpty(verifyList)) {
            return;
        }
        for (String param : verifyList) {
            if (!VerifyUtil.isEmpty((String)param)) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void verifyParameterMap(Map verifyMap) {
        if (VerifyUtil.isEmpty((Map)verifyMap)) {
            return;
        }
        for (Map.Entry entry : verifyMap.entrySet()) {
            if (!VerifyUtil.isEmpty(entry.getKey())) continue;
            logger.error((Object)"Map param key is null");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static boolean checkObjectExists(Object ... params) {
        return CommUtil.checkObjectExists((Object[])params);
    }

    public static void verifyParameterSet(Set<Object> sets) {
        if (VerifyUtil.isEmpty(sets)) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator<Object> iterator = sets.iterator();
        while (iterator.hasNext()) {
            if (!VerifyUtil.isEmpty((Object)iterator.next())) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static int valueOfInt(int val, int minVal, int maxVal) {
        if (val < minVal || val > maxVal) {
            logger.error((Object)("val:" + val + ", minVal:" + minVal + ", maxVal:" + maxVal));
            throw new LegoCheckedException(1073947393L);
        }
        return val;
    }

    public static String responseJsonResult(Object object) {
        return JSONObject.fromObject((Object)object).toString();
    }

    public static String responseJsonResult(Object object, String[] excludes) {
        return JSONObject.fromObject((Object)object, (String[])excludes).toString();
    }

    public static String responseJsonArrayResult(List<?> objects) {
        return JSONArray.fromObject(objects).toString();
    }

    public static String responseJsonArrayResult(Collection<?> objects, String[] excludes) {
        JSONArray array = new JSONArray();
        for (Object obj : objects) {
            JSONObject json = JSONObject.fromObject(obj, (String[])excludes);
            array.add((Object)json);
        }
        return array.toString();
    }

    public static boolean checkParam(String param, String match, int minSize, int maxSize) {
        if (VerifyUtil.isEmpty((String)param) || VerifyUtil.isEmpty((String)match) || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (minSize > param.length() || maxSize < param.length()) {
            return false;
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    public static boolean checkParam(String param, String match) {
        if (VerifyUtil.isEmpty((String)param) || VerifyUtil.isEmpty((String)match)) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" regEx :");
            sb.append(match);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        Pattern pat = Pattern.compile(match);
        Matcher mat = pat.matcher(Normalizer.normalize(param, Normalizer.Form.NFKC));
        return mat.matches() && mat.find(0) && 0 <= mat.groupCount();
    }

    public static boolean checkParam(String param, int minSize, int maxSize) {
        if (VerifyUtil.isEmpty((String)param) || 0 > minSize || 0 > maxSize || minSize > maxSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" minSize :");
            sb.append(minSize);
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return minSize <= param.length() && maxSize >= param.length();
    }

    public static boolean checkParam(String param, int maxSize) {
        if (VerifyUtil.isEmpty((String)param)) {
            StringBuilder sb = new StringBuilder();
            sb.append("check param is error.");
            sb.append(" maxSize :");
            sb.append(maxSize);
            sb.append(" is error.");
            logger.error((Object)sb.toString(), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        return maxSize >= param.length();
    }

    public static boolean checkDrmNameParam(String name) {
        String match = "^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*$";
        return CommUtils.checkParam(name, match, 4, 256);
    }

    public static boolean checkDrmIpParam(String ip) {
        if (VerifyUtil.isEmpty((String)ip) || ip.startsWith("127.") || ip.endsWith(".0") || ip.startsWith("0")) {
            return false;
        }
        String matchIp = "(2[2][0-3]|2[0-1]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})\\.(25[0-5]|2[0-4]\\d|1\\d{2}|\\d{1,2})";
        return CommUtils.checkParam(ip, matchIp);
    }

    public static boolean checkDrmPortParam(String portStr) {
        int port;
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("check port is error . parm:" + portStr), (Throwable)e, 90160758786989L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return port > 0 && 65535 >= port;
    }

    public static boolean checkDrmDescParam(String description) {
        return VerifyUtil.isEmpty((String)description) || CommUtils.checkParam(description, 255);
    }

    public static void closeInputStream(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"Closing input stream failed.", 90160758784001L);
            }
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)"Closing output stream failed.", 90160758784001L);
            }
        }
    }

    public static String formatData(String data) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            sdf.parse(data);
            return data;
        }
        catch (ParseException ex) {
            log.debug((Object)("time Parse failed:" + data + ex.getMessage()), 653110170615808L);
            try {
                Long convertTime = NumberUtil.convertToLong((Object)data);
                return CommUtils.formatDate(new Date(convertTime));
            }
            catch (NumberFormatException e) {
                return "--";
            }
        }
    }

    public static ResourceTimeWindow genTimeWindowObject(String devSn, ResourceTimeWindowVo timeWindowVo) {
        ResourceTimeWindow timeWindow = new ResourceTimeWindow();
        String tmpStr = timeWindowVo.getPortId().toString();
        String portId = tmpStr.substring(1, tmpStr.length() - 1);
        timeWindow.setPortId(portId);
        timeWindow.setResourceId(devSn);
        timeWindow.setRemoteName(timeWindowVo.getRemoteName());
        timeWindow.setEsn(timeWindowVo.getEsn());
        timeWindow.setResourceId(timeWindow.getResourceId());
        timeWindow.setRemoteWwn(timeWindowVo.getRemoteWwn());
        timeWindow.setTime(System.currentTimeMillis());
        timeWindow.setTimeWindowRanges(timeWindowVo.getTimeWindowRanges());
        String windowId = timeWindowVo.getWindowId();
        if (!VerifyUtil.isEmpty((String)windowId)) {
            timeWindow.setWindowId(windowId);
        }
        return timeWindow;
    }

    public static ResourceTimeWindowVo genTimeWindowVo(ResourceTimeWindow timeWindow) {
        ResourceTimeWindowVo timeWindowVo = new ResourceTimeWindowVo();
        String portIds = timeWindow.getPortId();
        if (VerifyUtil.isEmpty((String)portIds)) {
            timeWindowVo.setPortId(new ArrayList<String>());
        } else {
            String[] array = portIds.split(",");
            ArrayList<String> portIdList = new ArrayList<String>();
            for (String portId : array) {
                portIdList.add(portId.trim());
            }
            timeWindowVo.setPortId(portIdList);
        }
        timeWindowVo.setResourceId(timeWindow.getResourceId());
        timeWindowVo.setWindowId(timeWindow.getWindowId());
        timeWindowVo.setRemoteName(timeWindow.getRemoteName());
        timeWindowVo.setEsn(timeWindow.getEsn());
        timeWindowVo.setRemoteWwn(timeWindow.getRemoteWwn());
        timeWindowVo.setSwitchMode(timeWindow.getSwitchoverEnum().getType());
        timeWindowVo.setLastSwitchOnTime(timeWindow.getLastSwitchOnTime());
        timeWindowVo.setEndSwitchOnTime(timeWindow.getEndSwitchOnTime());
        timeWindowVo.setTimeWindowRanges(timeWindow.getTimeWindowRanges());
        return timeWindowVo;
    }
}

