/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.web.util;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.rest.service.framework.user.service.model.UserConstant;
import com.huawei.ism.drm.web.util.FileUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class FileExcelUtil
extends FileUtil {
    private static Log log = LogFactory.getInstance(FileExcelUtil.class);
    private static final short COL_COLOR = 13;
    private Workbook workbook = new XSSFWorkbook();

    private List<List<String>> getDataRows() {
        if (this.getFormatDataList() != null) {
            return this.getFormatDataList();
        }
        return this.constructDataRows();
    }

    protected abstract List<List<String>> constructDataRows();

    @Override
    public void writeFile(FileOutputStream fileOutputStream) throws IOException {
        if (null == fileOutputStream) {
            return;
        }
        this.writeExcelString(this.getDataRows());
        this.workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.flush();
    }

    private void writeExcelString(List<List<String>> dataLst) {
        Sheet sheet = this.workbook.createSheet();
        this.createExcelHeader(sheet);
        this.createExcelContent(sheet, dataLst);
    }

    private void createExcelContent(Sheet sheet, List<List<String>> dataLst) {
        int rowIndex = 1;
        int size = dataLst.size();
        int len = size;
        for (int i = 0; i < len; ++i) {
            List<String> rowData = dataLst.get(i);
            Row row = sheet.createRow(i + rowIndex);
            this.setExcelRowData(row, rowData, sheet);
        }
    }

    private void setExcelRowData(Row row, List<String> rowData, Sheet sheet) {
        CellStyle cellStyle = this.setDataRowStyle(sheet);
        int size = rowData.size();
        int len = size;
        for (int i = 0; i < len; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(rowData.get(i));
            cell.setCellStyle(cellStyle);
        }
    }

    protected CellStyle setDataRowStyle(Sheet sheet) {
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
        return cellStyle;
    }

    private void createExcelHeader(Sheet sheetTab) {
        CellStyle cellStyle = this.setHeaderStyle(sheetTab);
        Row headerRow = sheetTab.createRow(0);
        List<String> colTitle = this.getColTitle();
        if (null == colTitle) {
            throw new LegoCheckedException(2117645L);
        }
        int size = colTitle.size();
        int len = size;
        for (int i = 0; i < len; ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellValue(colTitle.get(i));
            cell.setCellStyle(cellStyle);
        }
    }

    protected CellStyle setHeaderStyle(Sheet sheetTab) {
        CellStyle cellStyle = sheetTab.getWorkbook().createCellStyle();
        Font font = sheetTab.getWorkbook().createFont();
        font.setBold(true);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor((short)13);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"text"));
        this.setColumnWidth(sheetTab);
        return cellStyle;
    }

    protected void setColumnWidth(Sheet sheetTab) {
    }

    private static String getDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        try {
            Long l = Long.parseLong(date);
            return sdf.format(new Date(l));
        }
        catch (NumberFormatException e) {
            log.debug((Object)("date Parse failed." + e.getMessage()));
            if (date.length() <= 10) {
                return sdf.format(new Date());
            }
            return date.substring(0, date.length() - 10);
        }
    }

    private static String getEnd(List<ProtectGroupLogDetail> pgList) {
        String end = "--";
        for (ProtectGroupLogDetail pgLog : pgList) {
            if (null == pgLog.getEndTime() || "".equals(pgLog.getEndTime()) || "--".equals(pgLog.getEndTime())) break;
            end = pgLog.getEndTime();
        }
        return end;
    }

    private static void mkdir(String dir) {
        boolean ret;
        File file = new File(dir);
        if (!file.exists() && !(ret = file.mkdir())) {
            log.error((Object)"to creat dir failed.");
            throw new LegoCheckedException(-1L);
        }
    }

    public static String getExportCSVFilePath(HttpSession session, String pgName, List<ProtectGroupLogDetail> pgList) {
        String fileName = FileExcelUtil.getDate(pgList.get(0).getStartTime()) + "_" + FileExcelUtil.getDate(FileExcelUtil.getEnd(pgList));
        return FileExcelUtil.createTempDownloadPath(session, pgName, fileName, "csv");
    }

    public static String createTempDownloadPath(HttpSession session, String filePrefix, String fileName, String fileType) {
        if (null == fileName) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            fileName = df.format(new Date());
        }
        if (null == filePrefix) {
            filePrefix = "ExportProtectGroup";
        }
        String exportExcelName = filePrefix + "_" + fileName + "." + fileType;
        String downloadPath = session.getServletContext().getRealPath("") + File.separator + UserConstant.FILEPATH_EXPORT_DIR;
        FileExcelUtil.mkdir(downloadPath);
        downloadPath = downloadPath + File.separator + exportExcelName;
        return downloadPath;
    }
}

